/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.softwaremanager;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.InstallScenario;
import com.tridium.install.PartSpec;
import com.tridium.install.SolutionParameters;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.softwaremanager.InstallCommand;
import com.tridium.platDaemon.ui.softwaremanager.InstallerTableModel;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.CommandUtil;
import java.util.TreeMap;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class InstallVersionCommand
extends AsyncCommand {
    public static Lexicon lex = Lexicon.make((String)"platDaemon");
    protected InstallerTableModel tableModel;
    protected BInstallable installable;

    public InstallVersionCommand(InstallerTableModel installerTableModel, BInstallable bInstallable) {
        super((BWidget)installerTableModel.getTable(), lex.getText("SoftwareManager.status.install", new Object[]{bInstallable.getVersion()}), null, null, null);
        this.tableModel = installerTableModel;
        this.installable = bInstallable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doInvokeAsync() {
        try {
            BWbShell bWbShell = BWbShell.getWbShell((BWidget)this.getOwner());
            try {
                boolean bl = true;
                if (bWbShell != null) {
                    bWbShell.enterBusy();
                }
                TreeMap<PartSpec, BInstallable> treeMap = new TreeMap<PartSpec, BInstallable>();
                BInstallable[] bInstallableArray = this.tableModel.getScenario().getToInstall();
                for (int i = 0; i < bInstallableArray.length; ++i) {
                    treeMap.put(bInstallableArray[i].getPart().getPartSpec(), bInstallableArray[i]);
                }
                treeMap.put(this.installable.getPart().getPartSpec(), this.installable);
                bInstallableArray = new BInstallable[treeMap.size()];
                treeMap.values().toArray(bInstallableArray);
                SolutionParameters solutionParameters = this.tableModel.getScenario().getSolutionParameters().newCopy();
                solutionParameters.latestOnly = false;
                InstallScenario installScenario = InstallScenario.solve((BDaemonPlatform)this.tableModel.getScenario().getTargetPlatform(), (String[])this.tableModel.getScenario().getModulesToUninstall(), null, (BInstallable[])bInstallableArray, (SolutionParameters)solutionParameters, (InstallableRegistry)LocalInstallableRegistry.getInstance());
                if (installScenario.getExcludedInstallables().length > 0) {
                    if (bl) {
                        BDialog.error((BWidget)this.getOwner(), (String)lex.getText("InstallCommand.excluded.title"), (Object)lex.getText("InstallCommand.excluded.message"));
                    }
                } else if (installScenario.getUnmeetableDependencies().length > 0) {
                    UnmeetableDependency[] unmeetableDependencyArray = installScenario.getUnmeetableDependencies();
                    boolean bl2 = false;
                    for (int i = 0; i < unmeetableDependencyArray.length; ++i) {
                        if (!unmeetableDependencyArray[i].isUnsolvable) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl2) {
                        if (bl) {
                            if (4 == BDialog.confirm((BWidget)this.getOwner(), (String)lex.getText("InstallCommand.mustCommission.title"), (Object)lex.getText("InstallCommand.mustCommission.prompt"), (int)12)) {
                                BWizard.open((BWidget)this.getOwner(), (WizardModel)new CommissioningWizardModel(this.getOwner(), this.tableModel.getScenario().getTargetPlatform().getDaemonSession(), true));
                            }
                        } else {
                            installScenario.getSolutionParameters().latestOnly = true;
                            this.tableModel.setScenario(installScenario);
                        }
                    } else if (bl) {
                        BDialog.error((BWidget)this.getOwner(), (String)lex.getText("InstallCommand.unmet.title"), (Object)InstallCommand.makeUnmetDialog(installScenario));
                    }
                } else if (bl) {
                    BWidget bWidget = InstallCommand.makeAlsoInstallDialog(treeMap, installScenario);
                    if (bWidget == null || 1 == BDialog.confirm((BWidget)this.getOwner(), (String)lex.getText("InstallCommand.alsoInstall.title"), (Object)bWidget, (int)3)) {
                        installScenario.getSolutionParameters().latestOnly = true;
                        this.tableModel.setScenario(installScenario);
                    }
                } else {
                    installScenario.getSolutionParameters().latestOnly = true;
                    this.tableModel.setScenario(installScenario);
                }
            }
            finally {
                if (bWbShell != null) {
                    bWbShell.exitBusy();
                }
            }
        }
        catch (Throwable throwable) {
            CommandUtil.error((Command)this, (Throwable)throwable);
        }
    }
}

