/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.r2tools.r2commissioningwizard;

import com.tridium.platDaemon.ui.r2tools.r2commissioningwizard.R2CommissioningWizardModel;
import com.tridium.platDaemon.ui.r2tools.r2commissioningwizard.R2CommissioningWizardStep;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.ui.theme.Theme;
import java.io.File;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.nre.util.Array;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

public class R2SoftwareStep
extends R2CommissioningWizardStep {
    private BTable table;
    private R2ModuleTableModel tableModel = new R2ModuleTableModel();
    private FilePath localFilePath;
    private BDirectory localDir;
    private long currentFreeSpace;
    private BLabel currentSpaceLabel;
    private BLabel spaceDeltaLabel;
    private BLabel afterSpaceLabel;
    public static final int PART_NAME_COL = 0;
    public static final int AVAIL_VER_COL = 1;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$r2tools$r2commissioningwizard$R2SoftwareStep$R2ModuleRow;
    static /* synthetic */ Class class$javax$baja$file$BIFile;

    public R2SoftwareStep(R2CommissioningWizardModel r2CommissioningWizardModel) {
        super(r2CommissioningWizardModel);
        this.table = new BTable((TableModel)this.tableModel);
        this.table.setController((TableController)new ModuleTableController());
        this.table.setMultipleSelection(false);
        this.table.setCellRenderer((TableCellRenderer)new ModuleCellRenderer());
        BButtonPane bButtonPane = new BButtonPane();
        BInsets bInsets = BInsets.make((double)4.0, (double)3.0, (double)4.0, (double)3.0);
        BButton bButton = new BButton((Command)new SelectAllCommand(r2CommissioningWizardModel.owner, this.tableModel));
        bButtonPane.add((BWidget)bButton);
        bButton.setPadding(bInsets);
        bButton = new BButton((Command)new ResetCommand(r2CommissioningWizardModel.owner, this.tableModel));
        bButtonPane.add((BWidget)bButton);
        bButton.setPadding(bInsets);
        BGridPane bGridPane = new BGridPane(6);
        BLabel bLabel = new BLabel(DaemonFileUtil.kbFormat.format(88888888L));
        bLabel.computePreferredSize();
        BLabel bLabel2 = new BLabel(DaemonFileUtil.kbFormat.format(88888L));
        bLabel2.computePreferredSize();
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BBox((double)((int)bLabel.getPreferredWidth() + 5), 0.0));
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BBox((double)((int)bLabel2.getPreferredWidth() + 5), 0.0));
        bGridPane.add(null, (BValue)new BNullWidget());
        bGridPane.add(null, (BValue)new BBox((double)((int)bLabel.getPreferredWidth() + 5), 0.0));
        bGridPane.setHalign(BHalign.left);
        this.currentSpaceLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"SoftwareManager.currentSpaceLabel"), (BWidget)this.currentSpaceLabel);
        this.spaceDeltaLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"SoftwareManager.spaceDeltaLabel"), (BWidget)this.spaceDeltaLabel);
        this.afterSpaceLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"SoftwareManager.afterSpaceLabel"), (BWidget)this.afterSpaceLabel);
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.setHalign(BHalign.left);
        bGridPane2.setValign(BValign.top);
        bGridPane2.add(null, (BValue)new BLabel(lex.getText("R2CommissioningWizard.moduleUpgrades.header.standard"), BHalign.left));
        this.setContent((BWidget)new BEdgePane((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)bGridPane, 3.0, 0.0, 7.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)bGridPane2, BBorder.make((String)"bottom(groove)"), BInsets.make((double)4.0, (double)0.0, (double)8.0, (double)0.0))), (BWidget)new BBorderPane((BWidget)bButtonPane, 4.0, 0.0, 4.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.DEFAULT)));
    }

    public String getStepName() {
        return "software";
    }

    public String getSectionName() {
        return "install";
    }

    public void enter() {
        this.initStep();
        if (this.wizardModel.modulesToInstall.isEmpty()) {
            this.tableModel.clearSelectedModules();
        }
        if (this.localDir == null) {
            String string = lex.getText("R2CommissioningWizard.embNotFound", new Object[]{this.localFilePath.toString()});
            BDialog.warning((BWidget)this.getWidget().getParentWidget(), (String)lex.getText("R2CommissioningWizard.embNotFound.title"), (Object)string);
        }
    }

    public boolean exit(int n) {
        this.wizardModel.modulesToInstall = this.tableModel.getInstallables();
        return true;
    }

    public int getMode() {
        return 3;
    }

    public boolean isSkipped() {
        return this.wizardModel.skipSoftwareInstall;
    }

    public boolean cancel() {
        return true;
    }

    private void initStep() {
        try {
            this.currentFreeSpace = DaemonFileUtil.getFilesystemAttributes((BDaemonSession)this.wizardModel.daemonSession, (FilePath)new FilePath("!niagara/niagaraR2/modules")).getFreeSpace();
            if (this.currentSpaceLabel != null) {
                this.currentSpaceLabel.setText(DaemonFileUtil.kbFormat.format(this.currentFreeSpace));
            }
            File file = BFileSystem.INSTANCE.pathToLocalFile(new FilePath(r2ToolOptions.getLocalR2Installation()));
            file = new File(file, File.separatorChar + "emb");
            this.localFilePath = BFileSystem.INSTANCE.localFileToPath(file);
            this.localDir = (BDirectory)BFileSystem.INSTANCE.findFile(this.localFilePath);
            if (this.localDir != null) {
                BIFile[] bIFileArray = this.localDir.listFiles();
                BIFile bIFile = null;
                for (int i = 0; i < bIFileArray.length; ++i) {
                    bIFile = bIFileArray[i];
                    if (bIFile.getExtension() == null || !bIFile.getExtension().equalsIgnoreCase("jar")) continue;
                    this.tableModel.addR2ModuleRow(new R2ModuleRow(bIFile));
                }
            }
            this.tableModel.updateTable();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SelectAllCommand
    extends Command {
        private R2ModuleTableModel tableModel = null;

        public SelectAllCommand(BWidget bWidget, R2ModuleTableModel r2ModuleTableModel) {
            super(bWidget, Lexicon.make((String)"platDaemon"), "SoftwareManager.command.selectAll");
            this.tableModel = r2ModuleTableModel;
        }

        public CommandArtifact doInvoke() {
            this.tableModel.selectAllModules();
            return null;
        }
    }

    class ResetCommand
    extends Command {
        private R2ModuleTableModel tableModel = null;

        public ResetCommand(BWidget bWidget, R2ModuleTableModel r2ModuleTableModel) {
            super(bWidget, Lexicon.make((String)"platDaemon"), "SoftwareManager.command.reset");
            this.tableModel = r2ModuleTableModel;
        }

        public CommandArtifact doInvoke() {
            this.tableModel.clearSelectedModules();
            return null;
        }
    }

    private class ModuleTableController
    extends TableController {
        private ModuleTableController() {
        }

        public void focusGained(BFocusEvent bFocusEvent) {
        }

        public void keyPressed(BKeyEvent bKeyEvent) {
        }

        protected void backgroundPressed(BMouseEvent bMouseEvent) {
        }

        protected void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
            R2ModuleRow r2ModuleRow;
            if (n2 != 0 || bMouseEvent.getX() > 14.0) {
                return;
            }
            r2ModuleRow.setSelected(!(r2ModuleRow = R2SoftwareStep.this.tableModel.getR2ModuleRow(n)).isSelected());
            R2SoftwareStep.this.tableModel.rowModified(n);
            R2SoftwareStep.this.tableModel.updateTable();
        }
    }

    public class ModuleCellRenderer
    extends TableCellRenderer {
        public R2ModuleTableModel getR2ModuleTableModel() {
            return (R2ModuleTableModel)this.getTable().getModel();
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                String string = this.getCellText(cell);
                return Theme.table().getCellFont().width(string) + 14.0;
            }
            return super.getPreferredCellWidth(cell);
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                R2ModuleTableModel r2ModuleTableModel = this.getR2ModuleTableModel();
                R2ModuleRow r2ModuleRow = r2ModuleTableModel.getR2ModuleRow(cell.row);
                this.paintCellBackground(graphics, cell);
                double d = 2.0;
                double d2 = (cell.height - 16.0) / 2.0;
                double d3 = d;
                double d4 = d2 + cell.height / 2.0 - 5.0;
                double d5 = 10.0;
                double d6 = 10.0;
                graphics.setBrush(BColor.black.toBrush());
                graphics.strokeRect(d3, d4, d5, d6);
                if (r2ModuleRow.isSelected()) {
                    graphics.strokeLine(d3, d4, d3 + d5, d4 + d6);
                    graphics.strokeLine(d3, d4 + d5, d3 + d5, d4);
                }
                if (cell.selected) {
                    graphics.setBrush(this.getSelectionForeground(cell));
                } else {
                    graphics.setBrush(this.getForeground(cell));
                }
                String string = this.getCellText(cell);
                BFont bFont = Theme.table().getCellFont();
                switch (r2ModuleTableModel.getColumnAlignment(cell.column).getOrdinal()) {
                    case 2: {
                        d = cell.width - 2.0 - bFont.width(string);
                        break;
                    }
                    case 1: {
                        d = (cell.width - bFont.width(string)) / 2.0;
                    }
                }
                graphics.setFont(bFont);
                graphics.drawString(string, d + 14.0, bFont.getAscent() + 2.0);
            } else {
                super.paintCell(graphics, cell);
            }
        }
    }

    class R2ModuleTableModel
    extends TableModel {
        private Array r2ModuleRows = new Array(class$com$tridium$platDaemon$ui$r2tools$r2commissioningwizard$R2SoftwareStep$R2ModuleRow == null ? (class$com$tridium$platDaemon$ui$r2tools$r2commissioningwizard$R2SoftwareStep$R2ModuleRow = R2SoftwareStep.class$("com.tridium.platDaemon.ui.r2tools.r2commissioningwizard.R2SoftwareStep$R2ModuleRow")) : class$com$tridium$platDaemon$ui$r2tools$r2commissioningwizard$R2SoftwareStep$R2ModuleRow);
        long selectedFileSize = 0L;

        public void updateTable(boolean bl) {
            super.updateTable(bl);
            if (R2SoftwareStep.this.spaceDeltaLabel != null) {
                long l = this.selectedFileSize / 1024L;
                R2SoftwareStep.this.spaceDeltaLabel.setText(DaemonFileUtil.kbFormat.format(l));
                if (R2SoftwareStep.this.afterSpaceLabel != null) {
                    long l2 = R2SoftwareStep.this.currentFreeSpace - l;
                    R2SoftwareStep.this.afterSpaceLabel.setText(DaemonFileUtil.kbFormat.format(l2));
                }
            }
        }

        public void addR2ModuleRow(R2ModuleRow r2ModuleRow) {
            this.r2ModuleRows.add((Object)r2ModuleRow);
        }

        public R2ModuleRow getR2ModuleRow(int n) {
            return (R2ModuleRow)this.r2ModuleRows.get(n);
        }

        public int getColumnCount() {
            return 2;
        }

        public void sortByColumn(int n, boolean bl) {
            super.sortByColumn(n, bl);
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return R2CommissioningWizardStep.lex.getText("R2CommissioningWizard.moduleTable.column.partName");
                }
                case 1: {
                    return R2CommissioningWizardStep.lex.getText("SoftwareManager.column.availableVersion");
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public BImage getCellIcon(int n, int n2) {
            return null;
        }

        public int getRowCount() {
            return this.r2ModuleRows.size();
        }

        public Object getValueAt(int n, int n2) {
            R2ModuleRow r2ModuleRow = (R2ModuleRow)this.r2ModuleRows.get(n);
            switch (n2) {
                case 0: {
                    return r2ModuleRow.getModuleName();
                }
                case 1: {
                    return r2ModuleRow.getModuleVersion();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Array getInstallables() {
            Array array = new Array(class$javax$baja$file$BIFile == null ? (class$javax$baja$file$BIFile = R2SoftwareStep.class$("javax.baja.file.BIFile")) : class$javax$baja$file$BIFile);
            R2ModuleRow r2ModuleRow = null;
            for (int i = 0; i < this.r2ModuleRows.size(); ++i) {
                r2ModuleRow = (R2ModuleRow)this.r2ModuleRows.get(i);
                if (!r2ModuleRow.isSelected()) continue;
                array.add((Object)r2ModuleRow.getR2Module());
            }
            return array;
        }

        public void clearSelectedModules() {
            for (int i = 0; i < this.r2ModuleRows.size(); ++i) {
                ((R2ModuleRow)this.r2ModuleRows.get(i)).setSelected(false);
            }
            this.selectedFileSize = 0L;
            this.updateTable();
        }

        public void selectAllModules() {
            this.selectedFileSize = 0L;
            for (int i = 0; i < this.r2ModuleRows.size(); ++i) {
                ((R2ModuleRow)this.r2ModuleRows.get(i)).setSelected(true);
                this.selectedFileSize += ((R2ModuleRow)this.r2ModuleRows.get(i)).getR2Module().getSize();
            }
            this.updateTable();
        }

        public void rowModified(int n) {
            R2ModuleRow r2ModuleRow = (R2ModuleRow)this.r2ModuleRows.get(n);
            this.selectedFileSize = r2ModuleRow.isSelected() ? (this.selectedFileSize += r2ModuleRow.getR2Module().getSize()) : (this.selectedFileSize -= r2ModuleRow.getR2Module().getSize());
        }
    }

    class R2ModuleRow {
        private boolean selected = false;
        private BIFile r2Module = null;
        private String moduleName = null;
        private String moduleVersion = null;

        public R2ModuleRow(BIFile bIFile) {
            this.r2Module = bIFile;
            String string = bIFile.getFileName();
            this.moduleName = string.substring(0, string.indexOf(45));
            this.moduleVersion = string.substring(string.indexOf(45) + 1, string.indexOf(".jar"));
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setR2Module(BIFile bIFile) {
            this.r2Module = bIFile;
        }

        public BIFile getR2Module() {
            return this.r2Module;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public String getModuleVersion() {
            return this.moduleVersion;
        }
    }
}

