/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.r2tools.r2commissioningwizard;

import com.tridium.platDaemon.ui.r2tools.BR2PlatformToolOptions;
import com.tridium.platDaemon.ui.r2tools.r2commissioningwizard.R2CommissioningWizardModel;
import com.tridium.platDaemon.ui.r2tools.r2commissioningwizard.R2CommissioningWizardStep;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.BFileChooserDialog;
import com.tridium.platform.ui.util.BFileChooserListView;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.Array;
import javax.baja.sys.BValue;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;

public class R2LicenseStep
extends R2CommissioningWizardStep {
    private R2LicenseFileTableModel tableModel;
    private Command addCommand;
    private Command removeCommand;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$r2tools$r2commissioningwizard$R2LicenseStep$LicenseFileRow;

    public R2LicenseStep(R2CommissioningWizardModel r2CommissioningWizardModel) {
        super(r2CommissioningWizardModel);
        this.tableModel = new R2LicenseFileTableModel(r2CommissioningWizardModel);
        BTable bTable = new BTable((TableModel)this.tableModel);
        BButtonPane bButtonPane = new BButtonPane();
        CommandBindings commandBindings = new CommandBindings();
        this.addCommand = new AddR2LicenseFileCommand(r2CommissioningWizardModel.owner, this.tableModel);
        commandBindings.addCommand(this.addCommand, BCommandEnablePolicy.always);
        bButtonPane.add(this.addCommand);
        this.removeCommand = new RemoveR2LicenseCommand(r2CommissioningWizardModel.owner, this.tableModel);
        commandBindings.addCommand(this.removeCommand, BCommandEnablePolicy.anySelection);
        bButtonPane.add(this.removeCommand);
        bTable.setController((TableController)new LicenseTableController());
        bTable.setSelection((TableSelection)new CommandBindings.TableSelection(commandBindings));
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.left);
        String string = r2CommissioningWizardModel.daemonSession.getHostProperties().getHostId();
        bGridPane.add(null, (BValue)new BLabel(lex.getText("R2CommissioningWizard.license.headerHostID") + " " + string));
        bGridPane.add(null, (BValue)new BLabel(lex.getText("R2CommissioningWizard.license.header")));
        this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bGridPane, 0.0, 0.0, 4.0, 0.0), (BWidget)new BBorderPane((BWidget)bButtonPane, 5.0, 0.0, 0.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)bTable, BBorder.inset, BInsets.DEFAULT)));
    }

    public String getStepName() {
        return "license";
    }

    public String getSectionName() {
        return "install";
    }

    public void enter() {
        this.tableModel.load();
        this.tableModel.updateTable(true);
    }

    public boolean exit(int n) {
        this.tableModel.save();
        return true;
    }

    public int getMode() {
        return this.calculateMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int calculateMode() {
        if (this.tableModel.getRowCount() > 1) {
            return 1;
        }
        if (this.tableModel.getRowCount() == 1) {
            BufferedReader bufferedReader = null;
            try {
                BIFile bIFile = this.tableModel.getFile(0);
                bufferedReader = new BufferedReader(new InputStreamReader(bIFile.getInputStream()));
                String string = bufferedReader.readLine();
                while (true) {
                    if (string == null) break;
                    if (string.indexOf("hostId=") != -1) {
                        if ((string = string.substring(string.indexOf(61) + 1)).equals(this.wizardModel.daemonSession.getHostProperties().getHostId())) {
                            break;
                        }
                        int n = 1;
                        return n;
                    }
                    string = bufferedReader.readLine();
                }
            }
            catch (Exception exception) {
                int n = 1;
                return n;
            }
            finally {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
        return 3;
    }

    public boolean isSkipped() {
        return this.wizardModel.skipLicenseInstall;
    }

    public boolean cancel() {
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class R2LicenseFileTableModel
    extends TableModel {
        private Array rows = new Array(class$com$tridium$platDaemon$ui$r2tools$r2commissioningwizard$R2LicenseStep$LicenseFileRow == null ? (class$com$tridium$platDaemon$ui$r2tools$r2commissioningwizard$R2LicenseStep$LicenseFileRow = R2LicenseStep.class$("com.tridium.platDaemon.ui.r2tools.r2commissioningwizard.R2LicenseStep$LicenseFileRow")) : class$com$tridium$platDaemon$ui$r2tools$r2commissioningwizard$R2LicenseStep$LicenseFileRow);
        private R2CommissioningWizardModel wizardModel;

        public R2LicenseFileTableModel(R2CommissioningWizardModel r2CommissioningWizardModel) {
            this.wizardModel = r2CommissioningWizardModel;
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public void add(BIFile bIFile) {
            for (int i = this.rows.size() - 1; i >= 0; --i) {
                if (!this.getFile(i).equals((Object)bIFile)) continue;
                return;
            }
            this.rows.add((Object)new LicenseFileRow(bIFile));
        }

        public void remove(BIFile bIFile) {
            for (int i = this.rows.size() - 1; i >= 0; --i) {
                if (!this.getFile(i).equals((Object)bIFile)) continue;
                this.rows.remove(i);
            }
        }

        public void load() {
            this.rows.clear();
            for (int i = 0; i < this.wizardModel.licensesToInstall.size(); ++i) {
                this.rows.add((Object)new LicenseFileRow((BIFile)this.wizardModel.licensesToInstall.get(i)));
            }
        }

        public void save() {
            this.wizardModel.licensesToInstall.clear();
            for (int i = 0; i < this.rows.size(); ++i) {
                this.wizardModel.licensesToInstall.add((Object)((LicenseFileRow)this.rows.get(i)).getLicenseFile());
            }
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return R2CommissioningWizardStep.lex.getText("R2CommissioningWizard.licenseTable.column.licenseFile");
                }
                case 1: {
                    return R2CommissioningWizardStep.lex.getText("R2CommissioningWizard.licenseTable.column.hostId");
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int n, int n2) {
            if (this.rows == null || n > this.rows.size() || n < 0) {
                return null;
            }
            LicenseFileRow licenseFileRow = (LicenseFileRow)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return licenseFileRow.getLicenseFile().getFileName();
                }
                case 1: {
                    return licenseFileRow.getLicenseHostId();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public BIFile getFile(int n) {
            if (this.rows == null || n > this.rows.size() || n < 0) {
                return null;
            }
            LicenseFileRow licenseFileRow = (LicenseFileRow)this.rows.get(n);
            return licenseFileRow.getLicenseFile();
        }
    }

    private class LicenseTableController
    extends TableController {
        private LicenseTableController() {
        }

        protected void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
            super.cellPressed(bMouseEvent, n, n2);
            if (bMouseEvent.getClickCount() != 2) {
                return;
            }
            BIFile bIFile = R2LicenseStep.this.tableModel.getFile(n);
            if (bIFile == null) {
                return;
            }
            BTextEditorPane bTextEditorPane = new BTextEditorPane();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[8192];
            int n3 = 0;
            InputStream inputStream = null;
            try {
                inputStream = bIFile.getInputStream();
                if (inputStream != null) {
                    n3 = 0;
                    byteArrayOutputStream.reset();
                    while ((n3 = inputStream.read(byArray, 0, 8192)) > 0) {
                        byteArrayOutputStream.write(byArray, 0, n3);
                    }
                    inputStream.close();
                    bTextEditorPane.setText(byteArrayOutputStream.toString());
                    bTextEditorPane.getEditor().setEditable(false);
                    bTextEditorPane.computePreferredSize();
                    BDialog.open((BWidget)R2LicenseStep.this.getWidget(), (String)R2CommissioningWizardStep.lex.getText("R2CommissioningWizard.licenseTable.column.licenseFile"), (Object)bTextEditorPane, (int)1);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class LicenseFileRow {
        private boolean selected = false;
        private BIFile r2License = null;
        private String hostId = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LicenseFileRow(BIFile bIFile) {
            this.r2License = bIFile;
            this.hostId = "";
            Properties properties = new Properties();
            InputStream inputStream = null;
            try {
                inputStream = bIFile.getInputStream();
                properties.load(inputStream);
                if (properties.containsKey("hostId")) {
                    this.hostId = new String(properties.getProperty("hostId"));
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public BIFile getLicenseFile() {
            return this.r2License;
        }

        public String getLicenseHostId() {
            return this.hostId;
        }
    }

    public static class R2LicenseDialogModel
    extends BFileChooserListView.ListModel {
        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return UiLexicon.bajaui.getText("fileChooser.name");
                }
                case 1: {
                    return R2CommissioningWizardStep.lex.getText("LicenseManager.hostIDLabel");
                }
            }
            return "";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValueAt(int n, int n2) {
            BIFile bIFile = (BIFile)this.kids[n];
            switch (n2) {
                case 0: {
                    return super.getValueAt(n, n2);
                }
                case 1: {
                    String string = "";
                    if (bIFile.getExtension() == null || !bIFile.getExtension().equals("properties")) {
                        return "";
                    }
                    Properties properties = new Properties();
                    InputStream inputStream = null;
                    try {
                        inputStream = bIFile.getInputStream();
                        properties.load(inputStream);
                        if (properties.containsKey("hostId")) {
                            string = new String(properties.getProperty("hostId"));
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    this.updateTable(true);
                    return string;
                }
            }
            return null;
        }
    }

    private static class R2LicenseFileFilter
    extends ExtFileFilter {
        public R2LicenseFileFilter() {
            super("R2 License Files", "properties");
        }

        public boolean accept(BIFile bIFile) {
            return super.accept(bIFile);
        }
    }

    private class AddR2LicenseFileCommand
    extends Command {
        private R2LicenseFileTableModel tableModel;

        public AddR2LicenseFileCommand(BWidget bWidget, R2LicenseFileTableModel r2LicenseFileTableModel) {
            super(bWidget, R2CommissioningWizardModel.lex.getText("R2CommissioningWizard.license.add"), null, null, null);
            this.tableModel = r2LicenseFileTableModel;
        }

        public CommandArtifact doInvoke() {
            try {
                String string = BR2PlatformToolOptions.make().getLocalR2Installation();
                BDirectory bDirectory = (BDirectory)BFileSystem.INSTANCE.findFile(new FilePath(string));
                ExtFileFilter extFileFilter = new ExtFileFilter("R2 License Files", "properties");
                BIFile[] bIFileArray = BFileChooserDialog.chooseFiles((BWidget)this.getOwner(), (BImage)BImage.make((String)R2CommissioningWizardStep.lex.getText("LicenseManager.importFileDialog.icon")), (String)R2CommissioningWizardStep.lex.getText("LicenseManager.importFileDialog.title"), (String)R2CommissioningWizardStep.lex.getText("LicenseManager.importFileDialog.message", new Object[]{((R2LicenseFileTableModel)this.tableModel).wizardModel.daemonSession.getRemoteAddressString()}), (BIFile)bDirectory, (IFileFilter)extFileFilter, (IFileFilter)new R2LicenseFileFilter(), (BFileChooserListView.ListModel)new R2LicenseDialogModel());
                if (bIFileArray != null) {
                    for (int i = 0; i < bIFileArray.length; ++i) {
                        this.tableModel.add(bIFileArray[i]);
                    }
                }
                this.tableModel.updateTable(true);
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            R2LicenseStep.this.wizardModel.update(R2LicenseStep.this.calculateMode());
            return null;
        }
    }

    private class RemoveR2LicenseCommand
    extends Command {
        private R2LicenseFileTableModel tableModel;

        public RemoveR2LicenseCommand(BWidget bWidget, R2LicenseFileTableModel r2LicenseFileTableModel) {
            super(bWidget, R2CommissioningWizardModel.lex.getText("R2CommissioningWizard.license.remove"), null, null, null);
            this.tableModel = r2LicenseFileTableModel;
        }

        public CommandArtifact doInvoke() {
            try {
                int n;
                int[] nArray = this.tableModel.getSelection().getRows();
                if (nArray == null) {
                    return null;
                }
                BIFile[] bIFileArray = new BIFile[nArray.length];
                for (n = 0; n < nArray.length; ++n) {
                    bIFileArray[n] = this.tableModel.getFile(nArray[n]);
                }
                for (n = 0; n < bIFileArray.length; ++n) {
                    this.tableModel.remove(bIFileArray[n]);
                }
                this.tableModel.updateTable(true);
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            R2LicenseStep.this.wizardModel.update(R2LicenseStep.this.calculateMode());
            return null;
        }
    }
}

