/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.r2tools.r2commissioningwizard;

import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.r2tools.r2commissioningwizard.R2CommissioningWizardModel;
import com.tridium.platDaemon.ui.widget.TaskDetailDialog;
import com.tridium.platDaemon.ui.widget.TaskDetailPane;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DeleteFileTransferMessageElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.net.SocketException;
import java.util.HashMap;
import java.util.HashSet;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.job.BJobState;
import javax.baja.nre.util.Array;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.util.Lexicon;

public class R2DecommissioningFinishPane
extends TaskDetailDialog
implements DaemonSessionTaskListener {
    private String lastText = null;
    private R2CommissioningWizardModel wizardModel;
    private TaskDetailPane.TaskItem stopAppsItem;
    private TaskDetailPane.TaskItem deleteNiagaraR2Item;
    private TaskDetailPane.TaskItem rebootItem;
    private TaskDetailPane.TaskItem reconnectItem;
    private Array items = null;
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem;

    private R2DecommissioningFinishPane(R2CommissioningWizardModel r2CommissioningWizardModel) {
        this.wizardModel = r2CommissioningWizardModel;
        this.stopAppsItem = new TaskDetailPane.TaskItem(lex.getText("R2CommissioningWizard.finish.item.stopApps"));
        this.deleteNiagaraR2Item = new TaskDetailPane.TaskItem(lex.getText("R2CommissioningWizard.finish.item.deleteNiagaraR2"));
        this.rebootItem = new TaskDetailPane.TaskItem(lex.getText("R2CommissioningWizard.finish.item.reboot"));
        this.reconnectItem = new TaskDetailPane.TaskItem(lex.getText("R2CommissioningWizard.finish.item.reconnect"));
        this.init(r2CommissioningWizardModel.owner);
    }

    public static void openDialog(R2CommissioningWizardModel r2CommissioningWizardModel) {
        new R2DecommissioningFinishPane(r2CommissioningWizardModel).open();
    }

    public String getDialogTitle() {
        return lex.getText("R2CommissioningWizard.delete.title", new Object[]{this.wizardModel.daemonSession.getRemoteHost().getNavDisplayName(null)});
    }

    public String getHeadingTitle() {
        return lex.getText("R2CommissioningWizard.delete.finish.mainHeading");
    }

    public BImage getHeadingIcon() {
        return BImage.make((String)lex.getText("R2CommissioningWizard.wizard.sectionIcon"));
    }

    public String getItemListHeading() {
        return lex.getText("R2CommissioningWizard.finish.itemHeading");
    }

    public TaskDetailPane.TaskItem[] makeTaskItems() {
        this.items = new Array(class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem == null ? (class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem = R2DecommissioningFinishPane.class$("com.tridium.platDaemon.ui.widget.TaskDetailPane$TaskItem")) : class$com$tridium$platDaemon$ui$widget$TaskDetailPane$TaskItem);
        this.items.add((Object)this.stopAppsItem);
        this.items.add((Object)this.deleteNiagaraR2Item);
        this.items.add((Object)this.rebootItem);
        return (TaskDetailPane.TaskItem[])this.items.trim();
    }

    public void taskStarted(DaemonSessionTask daemonSessionTask) {
        if (this.lastText == null || !daemonSessionTask.getMessage().equals(this.lastText)) {
            this.getLog().append(daemonSessionTask.getMessage() + "\n");
            this.lastText = daemonSessionTask.getMessage();
        }
    }

    public void taskUpdated(DaemonSessionTask daemonSessionTask) {
        if (this.lastText == null || !daemonSessionTask.getMessage().equals(this.lastText)) {
            this.getLog().append(daemonSessionTask.getMessage() + "\n");
            this.lastText = daemonSessionTask.getMessage();
        }
        if (daemonSessionTask instanceof CancelableDaemonSessionTask && !((CancelableDaemonSessionTask)daemonSessionTask).isCancelEnabled()) {
            this.setCancelEnabled(false);
        }
    }

    public void taskFinished(DaemonSessionTask daemonSessionTask) {
    }

    public void updateFileTransferStatus(FileTransferMessageElement fileTransferMessageElement, int n, int n2) {
        this.updateStatusMessage(fileTransferMessageElement.getProgressText());
    }

    public void updateStatusMessage(String string) {
        if (this.lastText == null || !string.equals(this.lastText)) {
            this.getLog().append(string + "\n");
            this.lastText = string;
        }
    }

    public void run() {
        try {
            FileTransferMessage fileTransferMessage;
            HashMap<Type, HashSet<String>> hashMap = new HashMap<Type, HashSet<String>>();
            if (this.items.contains((Object)this.stopAppsItem)) {
                this.setCurrentItem(this.stopAppsItem, BJobState.running);
                this.getLog().append(lex.getText("R2CommissioningWizard.finish.stopApps"));
                this.getLog().append("\n");
                fileTransferMessage = BAppSurrogate.stopAllApps((BDaemonSession)this.wizardModel.daemonSession, null, null, (DaemonSessionTaskListener)new DaemonSessionTaskHandler((BWidget)this.getDialog()));
                if (((BAppSurrogate[])fileTransferMessage).length == 0) {
                    this.getLog().append(lex.getText("R2CommissioningWizard.finish.stopApps.noneRunning"));
                    this.getLog().append("\n");
                } else {
                    for (int i = 0; i < ((FileTransferMessage)fileTransferMessage).length; ++i) {
                        HashSet<String> hashSet = (HashSet<String>)hashMap.get(fileTransferMessage[i].getType());
                        if (hashSet == null) {
                            hashSet = new HashSet<String>();
                            hashMap.put(fileTransferMessage[i].getType(), hashSet);
                        }
                        hashSet.add(fileTransferMessage[i].getAppName());
                        this.getLog().append(lex.getText("R2CommissioningWizard.finish.item.stopApps", new Object[]{fileTransferMessage[i].toString(null)}));
                        this.getLog().append("\n");
                    }
                }
                this.updateCurrentItemState(BJobState.success);
            }
            if (this.items.contains((Object)this.deleteNiagaraR2Item)) {
                this.setCurrentItem(this.deleteNiagaraR2Item, BJobState.running);
                this.checkCanceled();
                this.getLog().append(lex.getText("R2CommissioningWizard.finish.deleteNiagaraR2"));
                this.getLog().append("\n");
                fileTransferMessage = new FileTransferMessage((BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace());
                fileTransferMessage.addElement((FileTransferMessageElement)new DeleteFileTransferMessageElement(new FilePath("!niagaraR2"), (BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace()));
                DaemonFileUtil.transfer((BDaemonSession)this.wizardModel.daemonSession, (FileTransferMessage)fileTransferMessage, (ICancelHint)this, (DaemonSessionTaskListener)this);
                this.updateCurrentItemState(BJobState.success);
            }
            this.wizardModel.daemonSession.sendMessage((DaemonMessage)new R2CommissioningWizardModel.SetR2EnabledMessage(false), 20000);
            if (this.items.contains((Object)this.rebootItem)) {
                this.setCurrentItem(this.rebootItem, BJobState.running);
                this.getLog().append(lex.getText("CommissioningWizard.finish.reboot"));
                this.getLog().append("\n");
                this.wizardModel.daemonSession.sendRebootRequest();
                this.wizardModel.reconnectOnFinish = false;
                this.updateCurrentItemState(BJobState.success);
            }
            this.checkCanceled();
            this.getLog().append(lex.getText("R2CommissioningWizard.finish.done"));
            this.getLog().append("\n");
            this.setBottomLabelText(lex.getText("R2CommissioningWizard.finish.done"));
        }
        catch (ICancelHint.CanceledException canceledException) {
            this.updateCurrentItemState(BJobState.canceled);
            this.getLog().append(lex.getText("R2CommissioningWizard.finish.canceled"));
            this.getLog().append("\n");
            this.setBottomLabelText(lex.getText("R2CommissioningWizard.finish.canceled"));
        }
        catch (Throwable throwable) {
            this.setCancelEnabled(true);
            this.cancel(false);
            this.updateCurrentItemState(BJobState.failed);
            throwable.printStackTrace();
            this.getLog().append(throwable);
            this.setBottomLabelText(lex.getText("R2CommissioningWizard.finish.failed"));
        }
    }

    public void reconnect() throws Exception {
        this.updateCurrentItemState(BJobState.success);
        this.setCurrentItem(this.reconnectItem, BJobState.running);
        this.getLog().append(lex.getText("R2CommissioningWizard.finish.reconnect"));
        this.getLog().append("\n");
        String string = this.wizardModel.daemonSession.getHostProperties().getSessionTimestamp();
        Dots dots = new Dots();
        dots.start();
        while (!this.isCanceled()) {
            try {
                this.wizardModel.daemonSession.reloadHostProperties(15000);
                if (this.wizardModel.daemonSession.getHostProperties().getSessionTimestamp().equals(string)) continue;
                dots.cancel();
                this.getLog().append(lex.getText("R2CommissioningWizard.finish.reconnected"));
                this.getLog().append("\n");
                this.updateCurrentItemState(BJobState.success);
                Thread.sleep(5000L);
                break;
            }
            catch (SocketException socketException) {
            }
        }
        dots.cancel();
        this.updateCurrentItemState(BJobState.success);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Dots
    extends Thread {
        private boolean dotCanceled = false;
        private boolean dotRunning = true;
        private int i = 0;

        private Dots() {
        }

        public void run() {
            while (!this.dotCanceled) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.i++ > 60) {
                    R2DecommissioningFinishPane.this.getLog().append("\n");
                    this.i = 0;
                }
                R2DecommissioningFinishPane.this.getLog().append(".");
            }
            R2DecommissioningFinishPane.this.getLog().append("\n");
            this.dotRunning = false;
        }

        public synchronized void cancel() {
            this.dotCanceled = true;
            while (this.dotRunning) {
                try {
                    Thread.sleep(300L);
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

