/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.licenseinstall;

import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.licenseinstall.BCertList;
import com.tridium.platDaemon.ui.licenseinstall.BLicenseList;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.BLicenseArchiveFile;
import com.tridium.platform.license.CertificateInfo;
import com.tridium.platform.license.IFileInfo;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.platform.ui.license.UiUtil;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.BFileChooserDialog;
import com.tridium.platform.ui.util.BFileChooserListView;
import com.tridium.platform.ui.util.BIBeamPane;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.IFilePathFilter;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorLicense;
import com.tridium.workbench.tools.BRequestLicenseTool;
import java.io.InputStream;
import java.util.HashSet;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class BLicenseManager
extends BDaemonSessionView
implements CommandBindings.Support {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$licenseinstall$BLicenseManager == null ? (class$com$tridium$platDaemon$ui$licenseinstall$BLicenseManager = BLicenseManager.class$("com.tridium.platDaemon.ui.licenseinstall.BLicenseManager")) : class$com$tridium$platDaemon$ui$licenseinstall$BLicenseManager));
    public static final Lexicon lex = Lexicon.make((String)"platDaemon");
    private BCertList certs;
    private BLicenseList licenses;
    private BLabel hostNameLabel;
    private BLabel hostIDLabel;
    private BLabel brandLabel;
    private BDaemonSession session = null;
    private CommandBindings.ListSelection licensesSelection;
    private CommandBindings.ListSelection certsSelection;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$licenseinstall$BLicenseManager;
    static /* synthetic */ Class class$com$tridium$platform$license$LicenseInfo;
    static /* synthetic */ Class class$com$tridium$platform$license$IFileInfo;
    static /* synthetic */ Class class$com$tridium$platform$license$CertificateInfo;

    public Type getType() {
        return TYPE;
    }

    public BLicenseManager() {
        BIBeamPane bIBeamPane = new BIBeamPane();
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setValign(BValign.top);
        bGridPane.setColumnGap(10.0);
        bGridPane.setRowGap(6.0);
        BLabel bLabel = LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"LicenseManager.hostNameLabel"), (boolean)true);
        bGridPane.add(null, (BValue)bLabel);
        this.hostNameLabel = new BLabel();
        bGridPane.add(null, (BValue)this.hostNameLabel);
        bLabel = LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"LicenseManager.hostIDLabel"), (boolean)true);
        bGridPane.add(null, (BValue)bLabel);
        this.hostIDLabel = new BLabel();
        bGridPane.add(null, (BValue)this.hostIDLabel);
        bLabel = LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"LicenseManager.brandLabel"), (boolean)true);
        bGridPane.add(null, (BValue)bLabel);
        this.brandLabel = new BLabel();
        bGridPane.add(null, (BValue)this.brandLabel);
        bIBeamPane.setTop((BWidget)new BBorderPane((BWidget)bGridPane, 0.0, 0.0, 6.0, 0.0));
        this.licenses = new BLicenseList();
        CommandBindings commandBindings = new CommandBindings();
        ImportLicenseCommand importLicenseCommand = new ImportLicenseCommand(this.licenses);
        ExportLicenseCommand exportLicenseCommand = new ExportLicenseCommand(this.licenses);
        commandBindings.addCommand((Command)importLicenseCommand, BCommandEnablePolicy.always);
        commandBindings.addCommand((Command)exportLicenseCommand, BCommandEnablePolicy.anySelection);
        commandBindings.addCommand(this.licenses.getViewCommand(), BCommandEnablePolicy.singleSelection);
        commandBindings.addCommand(this.licenses.getDeleteCommand(), BCommandEnablePolicy.anySelection);
        commandBindings.setDoubleClickCommand(this.licenses.getViewCommand());
        commandBindings.setSupport((CommandBindings.Support)this);
        this.licenses.setController((ListController)new FileListController(commandBindings));
        this.licensesSelection = new CommandBindings.ListSelection(commandBindings);
        this.licenses.setSelection((ListSelection)this.licensesSelection);
        this.licenses.setMultipleSelection(true);
        BButtonPane bButtonPane = new BButtonPane();
        bButtonPane.setUniformColumnWidth(false);
        bButtonPane.add((Command)importLicenseCommand);
        bButtonPane.add((Command)exportLicenseCommand);
        bButtonPane.add(this.licenses.getViewCommand());
        bButtonPane.add(this.licenses.getDeleteCommand());
        bLabel = new BLabel(this.getLexicon().getText("LicenseManager.licenseList.header"));
        bIBeamPane.setLeft((BWidget)new BEdgePane((BWidget)bLabel, (BWidget)bButtonPane, null, null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)this.licenses, BBorder.inset, BInsets.DEFAULT), 4.0, 0.0, 10.0, 0.0)));
        bLabel.setHalign(BHalign.left);
        this.certs = new BCertList();
        AddCertCommand addCertCommand = new AddCertCommand(this.certs);
        commandBindings = new CommandBindings();
        commandBindings.addCommand((Command)addCertCommand, BCommandEnablePolicy.always);
        commandBindings.addCommand(this.certs.getViewCommand(), BCommandEnablePolicy.singleSelection);
        commandBindings.addCommand(this.certs.getDeleteCommand(), BCommandEnablePolicy.anySelection);
        commandBindings.setDoubleClickCommand(this.certs.getViewCommand());
        commandBindings.setSupport((CommandBindings.Support)this);
        this.certs.setController((ListController)new FileListController(commandBindings));
        this.certsSelection = new CommandBindings.ListSelection(commandBindings);
        this.certs.setSelection((ListSelection)this.certsSelection);
        this.certs.setMultipleSelection(true);
        bButtonPane = new BButtonPane();
        bButtonPane.setUniformColumnWidth(false);
        bButtonPane.add((Command)addCertCommand);
        bButtonPane.add(this.certs.getViewCommand());
        bButtonPane.add(this.certs.getDeleteCommand());
        bLabel = new BLabel(this.getLexicon().getText("LicenseManager.certList.header"));
        bIBeamPane.setRight((BWidget)new BEdgePane((BWidget)bLabel, (BWidget)bButtonPane, null, null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)this.certs, BBorder.inset, BInsets.DEFAULT), 4.0, 0.0, 10.0, 0.0)));
        bLabel.setHalign(BHalign.left);
        bIBeamPane.setCenter((BWidget)new BBox(20.0, 0.0));
        this.setContent((BWidget)bIBeamPane);
    }

    protected final void doLoadSession(BDaemonSession bDaemonSession, Context context) throws AuthenticationException {
        this.session = bDaemonSession;
        this.certs.loadValue(bDaemonSession, this);
        this.licenses.loadValue(bDaemonSession, this);
        this.hostNameLabel.setText(bDaemonSession.getRemoteAddressString());
        this.hostIDLabel.setText(this.getHostId());
        this.brandLabel.setText(this.licenses.getBrandId() == null ? "" : this.licenses.getBrandId());
        this.licensesSelection.setCommandEnabledStates();
        this.certsSelection.setCommandEnabledStates();
    }

    public void setBoundCommandEnabled(Command command, boolean bl) {
        if (this.session == null) {
            command.setEnabled(false);
        } else {
            command.setEnabled(bl);
        }
    }

    protected LicenseInfo[] getDatabaseLicenses() throws Exception {
        Array array = new Array(class$com$tridium$platform$license$LicenseInfo == null ? (class$com$tridium$platform$license$LicenseInfo = BLicenseManager.class$("com.tridium.platform.license.LicenseInfo")) : class$com$tridium$platform$license$LicenseInfo);
        VendorLicense[] vendorLicenseArray = LicenseDatabase.LOCAL_INSTANCE.getLicenses(this.getHostId());
        String string = this.getBrandId();
        for (int i = 0; i < vendorLicenseArray.length; ++i) {
            if (vendorLicenseArray[i].getBrandId() != null && string != null && !string.equals(vendorLicenseArray[i].getBrandId())) continue;
            array.add((Object)new LicenseInfo(vendorLicenseArray[i], null));
            string = vendorLicenseArray[i].getBrandId();
        }
        return (LicenseInfo[])array.trim();
    }

    public String getHostId() {
        return this.session.getHostProperties().getHostId();
    }

    public String getBrandId() {
        return this.licenses.getBrandId();
    }

    public void sync(LicenseSync licenseSync, LicenseSync licenseSync2) throws Exception {
        IFileInfo iFileInfo;
        int n;
        int n2;
        FileTransferMessage fileTransferMessage = new FileTransferMessage((BDaemonFileSpace)this.session.getFileSpace());
        Array array = new Array(class$com$tridium$platform$license$IFileInfo == null ? (class$com$tridium$platform$license$IFileInfo = BLicenseManager.class$("com.tridium.platform.license.IFileInfo")) : class$com$tridium$platform$license$IFileInfo);
        Array array2 = new Array(class$com$tridium$platform$license$IFileInfo == null ? (class$com$tridium$platform$license$IFileInfo = BLicenseManager.class$("com.tridium.platform.license.IFileInfo")) : class$com$tridium$platform$license$IFileInfo);
        Array array3 = new Array(class$com$tridium$platform$license$IFileInfo == null ? (class$com$tridium$platform$license$IFileInfo = BLicenseManager.class$("com.tridium.platform.license.IFileInfo")) : class$com$tridium$platform$license$IFileInfo);
        boolean bl = false;
        boolean bl2 = false;
        if (licenseSync != null) {
            n2 = licenseSync.toRemove.size();
            array3.addAll(licenseSync.toRemove);
            for (n = 0; n < n2; ++n) {
                iFileInfo = (IFileInfo)licenseSync.toRemove.get(n);
                fileTransferMessage.addDelete(iFileInfo.getFile().getFilePath());
                bl2 = true;
            }
            n2 = licenseSync.toAdd.size();
            array.addAll(licenseSync.toAdd);
            for (n = 0; n < n2; ++n) {
                iFileInfo = (IFileInfo)licenseSync.toAdd.get(n);
                PortalLicenseUtil.addFile((FileTransferMessage)fileTransferMessage, (IFileInfo)iFileInfo);
                bl = true;
                bl2 = true;
            }
            n2 = licenseSync.toUpdate.size();
            array2.addAll(licenseSync.toUpdate);
            for (n = 0; n < n2; ++n) {
                iFileInfo = (IFileInfo)licenseSync.toUpdate.get(n);
                PortalLicenseUtil.addFile((FileTransferMessage)fileTransferMessage, (IFileInfo)iFileInfo);
                bl = true;
                bl2 = true;
            }
        }
        if (licenseSync2 != null) {
            n2 = licenseSync2.toAdd.size();
            array.addAll(licenseSync2.toAdd);
            for (n = 0; n < n2; ++n) {
                iFileInfo = (IFileInfo)licenseSync2.toAdd.get(n);
                PortalLicenseUtil.addFile((FileTransferMessage)fileTransferMessage, (IFileInfo)iFileInfo);
                bl2 = true;
            }
            n2 = licenseSync2.toUpdate.size();
            array2.addAll(licenseSync2.toUpdate);
            for (n = 0; n < n2; ++n) {
                iFileInfo = (IFileInfo)licenseSync2.toUpdate.get(n);
                PortalLicenseUtil.addFile((FileTransferMessage)fileTransferMessage, (IFileInfo)iFileInfo);
                bl2 = true;
            }
        }
        if (!bl2) {
            BDialog.message((BWidget)this, (String)this.getLexicon().getText("LicenseManager.sync.currentTitle"), (Object)this.getLexicon().getText("LicenseManager.sync.currentMessage"));
        } else {
            DaemonFileUtil.transfer((BDaemonSession)this.session, (FileTransferMessage)fileTransferMessage, null, (DaemonSessionTaskListener)this);
            String string = this.getLexicon().getText("LicenseManager.sync.successMessage");
            if (bl && this.areAppsRunning()) {
                String string2 = null;
                string2 = this.session.getHostProperties().getAllowStationRestart() ? this.getLexicon().getText("LicenseManager.sync.promptRestart") : this.getLexicon().getText("LicenseManager.sync.promptReboot");
                iFileInfo = UiUtil.buildUpdateDescription((String)string, (String)string2, (IFileInfo[])((IFileInfo[])array.trim()), (IFileInfo[])((IFileInfo[])array2.trim()), (IFileInfo[])((IFileInfo[])array3.trim()));
                if (4 == BDialog.confirm((BWidget)this, (String)this.getLexicon().getText("LicenseManager.sync.successTitle"), (Object)iFileInfo, (int)12)) {
                    if (this.session.getHostProperties().getAllowStationRestart()) {
                        BAppSurrogate[] bAppSurrogateArray = this.getAppSurrogates();
                        for (int i = 0; i < bAppSurrogateArray.length; ++i) {
                            if (!bAppSurrogateArray[i].isAppRunning()) continue;
                            bAppSurrogateArray[i].restartAppAsync();
                        }
                        this.session.sendMessage((DaemonMessage)new ReloadLicenseMessage());
                        BRemoteDaemonPlatform.make((BDaemonSession)this.session, null).requestReload();
                    } else {
                        this.session.sendRebootRequest();
                    }
                }
            } else {
                BWidget bWidget = UiUtil.buildUpdateDescription((String)string, (IFileInfo[])((IFileInfo[])array.trim()), (IFileInfo[])((IFileInfo[])array2.trim()), (IFileInfo[])((IFileInfo[])array3.trim()));
                BDialog.message((BWidget)this, (String)this.getLexicon().getText("LicenseManager.sync.successTitle"), (Object)bWidget);
                this.session.sendMessage((DaemonMessage)new ReloadLicenseMessage());
                BRemoteDaemonPlatform.make((BDaemonSession)this.session, null).requestReload();
            }
            this.certs.loadValue(this.session, this);
            this.licenses.loadValue(this.session, this);
            this.brandLabel.setText(this.licenses.getBrandId() == null ? "" : this.licenses.getBrandId());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ReloadLicenseMessage
    extends XmlResponseMessage {
        ReloadLicenseMessage() {
        }

        public String getMessageString() {
            return "updatedaemon?reloadLicenses=true";
        }
    }

    public static class LicenseListModel
    extends BFileChooserListView.ListModel {
        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return UiLexicon.bajaui.getText("fileChooser.name");
                }
                case 1: {
                    return lex.getText("LicenseManager.hostIDLabel");
                }
            }
            return "";
        }

        public Object getValueAt(int n, int n2) {
            BIFile bIFile = (BIFile)this.kids[n];
            switch (n2) {
                case 0: {
                    return super.getValueAt(n, n2);
                }
                case 1: {
                    try {
                        if (bIFile.getExtension() == null || !bIFile.getExtension().equals("license")) {
                            return "";
                        }
                        XElem xElem = XParser.make((InputStream)bIFile.getInputStream()).parse(true);
                        return xElem.get("hostId", "");
                    }
                    catch (Exception exception) {
                        return "";
                    }
                }
            }
            return null;
        }
    }

    private class AddCertCommand
    extends AsyncCommand {
        public AddCertCommand(BList bList) {
            super((BWidget)bList, TYPE.getModule(), "LicenseManager.addCert");
        }

        public void doInvokeAsync() {
            block6: {
                try {
                    BIFile[] bIFileArray;
                    BIFile bIFile = BFileSystem.INSTANCE.findFile(BCertList.CERTIFICATE_HOME_PATH);
                    if (bIFile == null) {
                        bIFile = BFileSystem.INSTANCE.getSysHome();
                    }
                    if ((bIFileArray = BFileChooserDialog.chooseFiles((BWidget)this.getOwner(), (BImage)BImage.make((String)BLicenseManager.this.getLexicon().getText("LicenseManager.addCertDialog.icon")), (String)BLicenseManager.this.getLexicon().getText("LicenseManager.addCertDialog.title"), (String)BLicenseManager.this.getLexicon().getText("LicenseManager.addCertDialog.message", new Object[]{BLicenseManager.this.getDaemonSession().getRemoteAddressString()}), (BIFile)bIFile, (IFileFilter)BCertList.filter, (IFileFilter)BCertList.filter)).length <= 0) break block6;
                    try {
                        Array array = new Array(class$com$tridium$platform$license$CertificateInfo == null ? (class$com$tridium$platform$license$CertificateInfo = BLicenseManager.class$("com.tridium.platform.license.CertificateInfo")) : class$com$tridium$platform$license$CertificateInfo);
                        for (int i = 0; i < bIFileArray.length; ++i) {
                            array.add((Object)new CertificateInfo(bIFileArray[i]));
                        }
                        CertificateInfo[] certificateInfoArray = BLicenseManager.this.certs.getCertificates();
                        LicenseSync licenseSync = PortalLicenseUtil.syncCertificates((CertificateInfo[])certificateInfoArray, (CertificateInfo[])((CertificateInfo[])array.trim()));
                        BLicenseManager.this.sync(null, licenseSync);
                    }
                    catch (Exception exception) {
                        throw new LocalizableRuntimeException("platDaemon", "LicenseManager.addCertException", (Throwable)exception);
                    }
                }
                catch (Throwable throwable) {
                    CommandUtil.error((Command)this, (Throwable)throwable);
                }
            }
        }
    }

    private class ImportLicenseCommand
    extends AsyncCommand {
        public ImportLicenseCommand(BList bList) {
            super((BWidget)bList, TYPE.getModule(), "LicenseManager.importLicense");
            this.setEnabled(false);
        }

        private void importFile() throws Exception {
            BDirectory bDirectory = BFileSystem.INSTANCE.getSysHome();
            BIFile[] bIFileArray = BFileChooserDialog.chooseFiles((BWidget)this.getOwner(), (BImage)BImage.make((String)BLicenseManager.this.getLexicon().getText("LicenseManager.importFileDialog.icon")), (String)BLicenseManager.this.getLexicon().getText("LicenseManager.importFileDialog.title"), (String)BLicenseManager.this.getLexicon().getText("LicenseManager.importFileDialog.message", new Object[]{BLicenseManager.this.getDaemonSession().getRemoteAddressString()}), (BIFile)bDirectory, (IFileFilter)BLicenseList.importFilter, (IFileFilter)BLicenseList.importFilter, (BFileChooserListView.ListModel)new LicenseListModel());
            if (bIFileArray.length > 0) {
                Array array = new Array(class$com$tridium$platform$license$LicenseInfo == null ? (class$com$tridium$platform$license$LicenseInfo = BLicenseManager.class$("com.tridium.platform.license.LicenseInfo")) : class$com$tridium$platform$license$LicenseInfo);
                for (int i = 0; i < bIFileArray.length; ++i) {
                    if (!BLicenseManager.this.licenses.getValidator().accept(bIFileArray[i])) continue;
                    array.addAll((Object[])PortalLicenseUtil.getLicenseInfo((BIFile)bIFileArray[i], (String)BLicenseManager.this.getHostId(), (String)BLicenseManager.this.getBrandId()));
                }
                if (array.size() > 0) {
                    LicenseInfo[] licenseInfoArray = BLicenseManager.this.licenses.getLicenses();
                    LicenseSync licenseSync = PortalLicenseUtil.syncLicenses((String)BLicenseManager.this.getHostId(), (LicenseInfo[])licenseInfoArray, (LicenseInfo[])((LicenseInfo[])array.trim()));
                    BLicenseManager.this.sync(licenseSync, null);
                }
            }
        }

        public void getOnline() throws Exception {
            int n;
            LicenseInfo[] licenseInfoArray = BLicenseManager.this.licenses.getLicenses();
            CertificateInfo[] certificateInfoArray = BLicenseManager.this.certs.getCertificates();
            HashSet<String> hashSet = new HashSet<String>();
            for (n = 0; n < licenseInfoArray.length; ++n) {
                hashSet.add(licenseInfoArray[n].vendorLicense.getVendor());
            }
            for (n = 0; n < certificateInfoArray.length; ++n) {
                hashSet.add(certificateInfoArray[n].vendorCertificate.getVendor());
            }
            LicenseInfo[] licenseInfoArray2 = null;
            CertificateInfo[] certificateInfoArray2 = null;
            boolean bl = true;
            LicenseSync licenseSync = null;
            LicenseSync licenseSync2 = null;
            try {
                licenseInfoArray2 = LicenseInfo.make((XElem[])PortalLicenseUtil.getExistingLicenses((String)BLicenseManager.this.getHostId(), null));
                licenseSync = PortalLicenseUtil.syncLicenses((String)BLicenseManager.this.getHostId(), (LicenseInfo[])licenseInfoArray, (LicenseInfo[])licenseInfoArray2);
                for (int i = 0; i < licenseInfoArray2.length; ++i) {
                    hashSet.add(licenseInfoArray2[i].vendorLicense.getVendor());
                }
                bl = licenseSync.unchanged() && LicenseInfo.countActiveLicenses((LicenseInfo[])licenseInfoArray, (BAbsTime)BAbsTime.now()) == 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String[] stringArray = new String[hashSet.size()];
                hashSet.toArray(stringArray);
                certificateInfoArray2 = CertificateInfo.make((XElem[])PortalLicenseUtil.getCertificates((String[])stringArray));
                licenseSync2 = PortalLicenseUtil.syncCertificates((CertificateInfo[])certificateInfoArray, (CertificateInfo[])certificateInfoArray2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (licenseSync != null || licenseSync2 != null) {
                BLicenseManager.this.sync(licenseSync, licenseSync2);
            }
            if (bl) {
                BRequestLicenseTool.requestLicense((BWidget)BLicenseManager.this.getWbShell(), (String)BLicenseManager.this.getHostId());
            }
        }

        public void requestLicense() throws Exception {
            UiUtil.requestLicense((BWidgetShell)this.getOwner().getShell(), (String)BLicenseManager.this.getHostId());
        }

        public void doInvokeAsync() {
            try {
                BGridPane bGridPane = new BGridPane(1);
                ToggleCommandGroup toggleCommandGroup = new ToggleCommandGroup();
                BRadioButton bRadioButton = new BRadioButton(toggleCommandGroup, BLicenseManager.this.getLexicon().getText("LicenseManager.importType.file"), true);
                bGridPane.add(null, (BValue)bRadioButton);
                BRadioButton bRadioButton2 = new BRadioButton(toggleCommandGroup, BLicenseManager.this.getLexicon().getText("LicenseManager.importType.localDb"), false);
                bGridPane.add(null, (BValue)bRadioButton2);
                LicenseInfo[] licenseInfoArray = BLicenseManager.this.licenses.getLicenses();
                LicenseInfo[] licenseInfoArray2 = BLicenseManager.this.getDatabaseLicenses();
                LicenseSync licenseSync = PortalLicenseUtil.syncLicenses((String)BLicenseManager.this.getHostId(), (LicenseInfo[])licenseInfoArray, (LicenseInfo[])licenseInfoArray2);
                if (licenseSync.unchanged()) {
                    bRadioButton2.setEnabled(false);
                }
                BRadioButton bRadioButton3 = new BRadioButton(toggleCommandGroup, BLicenseManager.this.getLexicon().getText("LicenseManager.importType.getOnline"), false);
                BRadioButton bRadioButton4 = new BRadioButton(toggleCommandGroup, lex.getText("LicenseManager.importType.requestLicense"), false);
                if (PortalLicenseUtil.isApiAvailable()) {
                    if (PortalLicenseUtil.requestLicensesOnline()) {
                        bGridPane.add(null, (BValue)bRadioButton3);
                    } else {
                        bGridPane.add(null, (BValue)bRadioButton4);
                    }
                }
                if (1 == BDialog.open((BWidget)this.getOwner(), (String)BLicenseManager.this.getLexicon().getText("LicenseManager.importType.dlgTitle"), (Object)new BBorderPane((BWidget)bGridPane, 10.0, 10.0, 10.0, 10.0), (int)3)) {
                    if (bRadioButton.isSelected()) {
                        this.importFile();
                    } else if (bRadioButton2.isSelected()) {
                        BLicenseManager.this.sync(licenseSync, null);
                    } else if (bRadioButton3.isSelected()) {
                        this.getOnline();
                    } else if (bRadioButton4.isSelected()) {
                        this.requestLicense();
                    }
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
        }
    }

    private class ExportLicenseCommand
    extends AsyncCommand {
        public ExportLicenseCommand(BList bList) {
            super((BWidget)bList, TYPE.getModule(), "LicenseManager.exportLicense");
        }

        public void doInvokeAsync() {
            try {
                BDirectory bDirectory = BFileSystem.INSTANCE.getSysHome();
                FilePath filePath = BFileChooserDialog.chooseFilePath((BWidget)this.getOwner(), (BImage)BImage.make((String)BLicenseManager.this.getLexicon().getText("LicenseManager.exportLicenseDialog.icon")), (String)BLicenseManager.this.getLexicon().getText("LicenseManager.exportLicenseDialog.title"), (String)BLicenseManager.this.getLexicon().getText("LicenseManager.exportLicenseDialog.message", new Object[]{BLicenseManager.this.getDaemonSession().getRemoteAddressString()}), (BIFile)bDirectory, (IFileFilter)BLicenseList.larFilter, (IFilePathFilter)BLicenseList.larPathFilter, (BFileChooserListView.ListModel)new LicenseListModel(), (String)"licenses.lar");
                if (filePath != null) {
                    BLicenseArchiveFile bLicenseArchiveFile = (BLicenseArchiveFile)BFileSystem.INSTANCE.findFile(filePath);
                    if (bLicenseArchiveFile == null) {
                        bLicenseArchiveFile = (BLicenseArchiveFile)BFileSystem.INSTANCE.makeFile(filePath);
                    } else if (8 == BDialog.confirm((BWidget)this.getOwner(), (String)BLicenseManager.this.getLexicon().getText("LicenseManager.replaceFileDialog.title"), (Object)BLicenseManager.this.getLexicon().getText("LicenseManager.replaceFileDialog.message", new Object[]{filePath.getName()}))) {
                        return;
                    }
                    int[] nArray = BLicenseManager.this.licenses.getSelection().getItems();
                    VendorLicense[] vendorLicenseArray = new VendorLicense[nArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        vendorLicenseArray[i] = ((BLicenseManager)BLicenseManager.this).licenses.getLicenseInfo((int)nArray[i]).vendorLicense;
                    }
                    bLicenseArchiveFile.writeLicenses(vendorLicenseArray);
                    BDialog.message((BWidget)this.getOwner(), (String)BLicenseManager.this.getLexicon().getText("LicenseManager.fileWrittenDialog.title"), (Object)BLicenseManager.this.getLexicon().getText("LicenseManager.fileWrittenDialog.message", new Object[]{filePath.getName()}));
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
        }
    }

    private class FileListController
    extends CommandBindings.ListController {
        public FileListController(CommandBindings commandBindings) {
            super(commandBindings);
        }

        public void focusGained(BFocusEvent bFocusEvent) {
            BLicenseManager.this.setTransferWidget((BTransferWidget)this.getList());
            if (this.getList() == BLicenseManager.this.certs) {
                BLicenseManager.this.licenses.getSelection().deselectAll();
            } else {
                BLicenseManager.this.certs.getSelection().deselectAll();
            }
        }
    }
}

