/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.licenseinstall;

import com.tridium.file.types.text.BLicenseFile;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.licenseinstall.BLicenseManager;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.BLicenseArchiveFile;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.ExtPathFilter;
import com.tridium.platform.ui.util.IFilePathFilter;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.Properties;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.nre.util.Array;
import javax.baja.security.AuthenticationException;
import javax.baja.space.Mark;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.util.Lexicon;

public class BLicenseList
extends BList {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$licenseinstall$BLicenseList == null ? (class$com$tridium$platDaemon$ui$licenseinstall$BLicenseList = BLicenseList.class$("com.tridium.platDaemon.ui.licenseinstall.BLicenseList")) : class$com$tridium$platDaemon$ui$licenseinstall$BLicenseList));
    public static final FilePath LICENSE_HOME_PATH = new FilePath("!licenses");
    public static final IFileFilter importFilter = new ExtFileFilter("TODO", "license,lar");
    public static final IFileFilter filter = new ExtFileFilter("TODO", "license");
    public static final IFileFilter larFilter = new ExtFileFilter("TODO", "lar");
    public static final IFilePathFilter larPathFilter = new ExtPathFilter("lar");
    private Validator validator;
    private Command deleteCommand;
    private Command viewCommand;
    private BLicenseManager manager;
    private BDaemonSession session;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$licenseinstall$BLicenseList;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$licenseinstall$BLicenseList$Row;

    public BLicenseList() {
        this.setModel(new Model());
        this.validator = new Validator();
        this.setPasteEnabled(true);
        this.deleteCommand = new DeleteFileCommand();
        this.viewCommand = new ViewFileCommand();
    }

    public CommandArtifact doDelete() throws Exception {
        this.deleteCommand.invoke();
        return null;
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        BObject[] bObjectArray;
        Mark mark = Mark.getCurrent();
        if (mark != null && (bObjectArray = mark.getValues())[0] instanceof BIFile && importFilter.accept((BIFile)bObjectArray[0]) && this.validator.accept((BIFile)bObjectArray[0])) {
            this.transferFile((BIFile)bObjectArray[0]);
        }
        return null;
    }

    public IFileFilter getValidator() {
        return this.validator;
    }

    public int dragOver(TransferContext transferContext) {
        Mark mark;
        if (transferContext.getEnvelope().supports(TransferFormat.mark) && (mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark)).getValues()[0] instanceof BIFile && importFilter.accept((BIFile)mark.getValues()[0])) {
            return 16;
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
        if (mark.getValues()[0] instanceof BIFile && importFilter.accept((BIFile)mark.getValues()[0]) && this.validator.accept((BIFile)mark.getValues()[0])) {
            this.transferFile((BIFile)mark.getValues()[0]);
        }
        return null;
    }

    public Command getDeleteCommand() {
        return this.deleteCommand;
    }

    public Command getViewCommand() {
        return this.viewCommand;
    }

    public void loadValue(BDaemonSession bDaemonSession, BLicenseManager bLicenseManager) throws AuthenticationException {
        this.manager = bLicenseManager;
        this.session = bDaemonSession;
        ((Model)this.getModel()).loadValue();
    }

    public LicenseInfo getLicenseInfo(int n) {
        return ((Model)this.getModel()).getLicenseInfo(n);
    }

    public FilePath getFilePath(int n) {
        return ((Model)this.getModel()).getFilePath(n);
    }

    public String getFileName(int n) {
        return ((Model)this.getModel()).getFileName(n);
    }

    public String getFileContents(int n) {
        return ((Model)this.getModel()).getFileContents(n);
    }

    public BDaemonSession getDaemonSession() {
        return this.session;
    }

    public String getHostId() {
        return this.getDaemonSession().getHostProperties().getHostId();
    }

    public String getBrandId() {
        return ((Model)this.getModel()).getBrandId();
    }

    public synchronized LicenseInfo[] getLicenses() throws Exception {
        Model model = (Model)this.getModel();
        LicenseInfo[] licenseInfoArray = new LicenseInfo[model.getItemCount()];
        for (int i = 0; i < licenseInfoArray.length; ++i) {
            licenseInfoArray[i] = model.getLicenseInfo(i);
        }
        return licenseInfoArray;
    }

    public void transferFile(BIFile bIFile) throws Exception {
        LicenseInfo[] licenseInfoArray = PortalLicenseUtil.getLicenseInfo((BIFile)bIFile, (String)this.getHostId(), (String)this.getBrandId());
        LicenseInfo[] licenseInfoArray2 = this.getLicenses();
        LicenseSync licenseSync = PortalLicenseUtil.syncLicenses((String)this.getHostId(), (LicenseInfo[])licenseInfoArray2, (LicenseInfo[])licenseInfoArray);
        this.manager.sync(licenseSync, null);
    }

    public boolean deleteFiles(int[] nArray) throws AuthenticationException {
        try {
            if (this.session == null) {
                return false;
            }
            FileTransferMessage fileTransferMessage = new FileTransferMessage((BDaemonFileSpace)this.session.getFileSpace());
            for (int i = 0; i < nArray.length; ++i) {
                fileTransferMessage.addDelete(((Model)this.getModel()).getFilePath(nArray[i]));
            }
            if (DaemonFileUtil.transfer((BDaemonSession)this.session, (FileTransferMessage)fileTransferMessage, null, (DaemonSessionTaskListener)this.manager)) {
                this.loadValue(this.session, this.manager);
                this.getSelection().deselectAll();
                this.session.sendMessage((DaemonMessage)new BLicenseManager.ReloadLicenseMessage());
                BRemoteDaemonPlatform.make((BDaemonSession)this.session, null).requestReload();
                return true;
            }
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
        return false;
    }

    public boolean deleteFile(int n) throws AuthenticationException {
        try {
            if (this.session == null) {
                return false;
            }
            if (DaemonFileUtil.transfer((BDaemonSession)this.session, (FileTransferMessage)FileTransferMessage.makeDelete((FilePath)((Model)this.getModel()).getFilePath(n), (BDaemonFileSpace)this.session.getFileSpace()), null, (DaemonSessionTaskListener)this.manager)) {
                this.loadValue(this.session, this.manager);
                this.getSelection().deselectAll();
                this.session.sendMessage((DaemonMessage)new BLicenseManager.ReloadLicenseMessage());
                BRemoteDaemonPlatform.make((BDaemonSession)this.session, null).requestReload();
                return true;
            }
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
        return false;
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Validator
    implements IFileFilter {
        private Validator() {
        }

        public boolean accept(BIFile bIFile) {
            try {
                if (bIFile instanceof BLicenseFile) {
                    LicenseInfo licenseInfo = new LicenseInfo(bIFile);
                    if (BLicenseList.this.getHostId().equals(licenseInfo.vendorLicense.getHostId())) {
                        if (BLicenseList.this.getBrandId() != null && licenseInfo.vendorLicense.getBrandId() != null && !BLicenseList.this.getBrandId().equals(licenseInfo.vendorLicense.getBrandId())) {
                            BDialog.error((BWidget)BLicenseList.this, (String)BLicenseList.this.getLexicon().getText("LicenseManager.cantChangeBrand.title"), (Object)BLicenseList.this.getLexicon().getText("LicenseManager.cantChangeBrand.message", new Object[]{licenseInfo}));
                            return false;
                        }
                        if (licenseInfo.allowsLocalWbAccess()) {
                            return true;
                        }
                        BDialog.error((BWidget)BLicenseList.this, (String)BLicenseList.this.getLexicon().getText("LicenseManager.noAccess.title"), (Object)BLicenseList.this.getLexicon().getText("LicenseManager.noAccess.message", new Object[]{bIFile.getFilePath().getBody()}));
                        return false;
                    }
                    BDialog.error((BWidget)BLicenseList.this, (String)BLicenseList.this.getLexicon().getText("LicenseManager.badHostId.title"), (Object)BLicenseList.this.getLexicon().getText("LicenseManager.badHostId.message"));
                    return false;
                }
                if (bIFile instanceof BLicenseArchiveFile) {
                    VendorLicense[] vendorLicenseArray = ((BLicenseArchiveFile)bIFile).getLicenses(BLicenseList.this.getHostId());
                    int n = 0;
                    for (int i = 0; i < vendorLicenseArray.length; ++i) {
                        if (BLicenseList.this.getBrandId() != null && vendorLicenseArray[i].getBrandId() != null && !BLicenseList.this.getBrandId().equals(vendorLicenseArray[i].getBrandId())) continue;
                        LicenseInfo licenseInfo = new LicenseInfo(vendorLicenseArray[i], bIFile);
                        if (!licenseInfo.allowsLocalWbAccess()) {
                            BDialog.error((BWidget)BLicenseList.this, (String)BLicenseList.this.getLexicon().getText("LicenseManager.noAccess.title"), (Object)BLicenseList.this.getLexicon().getText("LicenseManager.noAccess.message", new Object[]{licenseInfo}));
                            return false;
                        }
                        ++n;
                    }
                    if (n == 0) {
                        BDialog.error((BWidget)BLicenseList.this, (String)BLicenseList.this.getLexicon().getText("LicenseManager.noHostLicenses.title"), (Object)BLicenseList.this.getLexicon().getText("LicenseManager.noHostLicenses.message"));
                        return false;
                    }
                    return true;
                }
                return false;
            }
            catch (Exception exception) {
                throw new LocalizableRuntimeException("platDaemon", "LicenseManager.addLicenseException", (Throwable)exception);
            }
        }

        public String getDescription(Context context) {
            return "TODO";
        }
    }

    private static class Row {
        public LicenseInfo licenseInfo;

        public Row(VendorLicense vendorLicense, BIFile bIFile) throws Exception {
            this.licenseInfo = new LicenseInfo(vendorLicense, bIFile);
            LicenseDatabase.LOCAL_INSTANCE.add(vendorLicense);
        }
    }

    public class Model
    extends ListModel {
        private Array rows = new Array(class$com$tridium$platDaemon$ui$licenseinstall$BLicenseList$Row == null ? (class$com$tridium$platDaemon$ui$licenseinstall$BLicenseList$Row = BLicenseList.class$("com.tridium.platDaemon.ui.licenseinstall.BLicenseList$Row")) : class$com$tridium$platDaemon$ui$licenseinstall$BLicenseList$Row);
        private String brandId = null;

        public int getItemCount() {
            return this.rows.size();
        }

        public Object getItem(int n) {
            if (this.getLicenseInfo((int)n).vendorLicense.getHostId().equals(BLicenseList.this.getHostId())) {
                return this.getLicenseInfo(n).toString();
            }
            return this.getLexicon().getText("LicenseManager.badHostId.label", new Object[]{this.getLicenseInfo((int)n).vendorLicense.getVendor()});
        }

        public Row getRow(int n) {
            return (Row)this.rows.get(n);
        }

        public BIFile getFile(int n) {
            return this.getRow((int)n).licenseInfo.file;
        }

        public String getFileName(int n) {
            return this.getFile(n).getFileName();
        }

        public FilePath getFilePath(int n) {
            return this.getFile(n).getFilePath();
        }

        public LicenseInfo getLicenseInfo(int n) {
            return this.getRow((int)n).licenseInfo;
        }

        public String getFileContents(int n) {
            if (BLicenseList.this.session == null) {
                return "";
            }
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                this.getLicenseInfo((int)n).vendorLicense.save((OutputStream)byteArrayOutputStream);
                return byteArrayOutputStream.toString();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void loadValue() throws AuthenticationException {
            block12: {
                try {
                    Object object;
                    BIFile bIFile;
                    this.rows.clear();
                    this.brandId = null;
                    BDirectory bDirectory = (BDirectory)BLicenseList.this.session.getFileSpace().findFile(LicenseInfo.LICENSES_PATH);
                    if (bDirectory != null) {
                        bIFile = bDirectory.listFiles();
                        for (int i = 0; i < ((BIFile[])bIFile).length; ++i) {
                            if (!(bIFile[i] instanceof BLicenseFile) || !(object = VendorLicense.make((BIFile)bIFile[i])).getHostId().equals(BLicenseList.this.getHostId()) || object.getBrandId() != null && this.brandId != null && !object.getBrandId().equals(this.brandId)) continue;
                            this.rows.add((Object)new Row((VendorLicense)object, bIFile[i]));
                            if (this.brandId != null) continue;
                            this.brandId = object.getBrandId();
                        }
                    }
                    if (this.brandId != null || (bIFile = BLicenseList.this.session.getFileSpace().findFile(new FilePath("!lib/brand.properties"))) == null) break block12;
                    Properties properties = new Properties();
                    object = bIFile.getInputStream();
                    try {
                        properties.load((InputStream)object);
                        this.brandId = properties.getProperty("brand.id", null);
                    }
                    finally {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (AuthenticationException authenticationException) {
                    throw authenticationException;
                }
                catch (Exception exception) {
                    BDaemonSessionView.log.error("error loading file list", (Throwable)exception);
                }
            }
            this.updateList();
        }

        public String getBrandId() {
            return this.brandId;
        }

        private Lexicon getLexicon() {
            return BDaemonSessionView.TYPE.getModule().getLexicon();
        }
    }

    private class ViewFileCommand
    extends Command {
        public ViewFileCommand() {
            super((BWidget)BLicenseList.this, TYPE.getModule(), "LicenseManager.view");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                int n = BLicenseList.this.getSelectedIndex();
                BDialog.message((BWidget)BLicenseList.this, (String)BLicenseList.this.getFileName(n), (Object)new BTextEditorPane(BLicenseList.this.getFileContents(n), 20, 80, false));
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class DeleteFileCommand
    extends Command {
        public DeleteFileCommand() {
            super((BWidget)BLicenseList.this, TYPE.getModule(), "LicenseManager.delete");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                int[] nArray = BLicenseList.this.getSelectedIndices();
                if (4 == BDialog.confirm((BWidget)BLicenseList.this, (String)BLicenseList.this.getLexicon().getText("LicenseManager.delete.confirmTitle"), (Object)BLicenseList.this.getLexicon().getText("LicenseManager.delete.confirmMessage"))) {
                    BLicenseList.this.deleteFiles(nArray);
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }
}

