/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.lexiconinstall;

import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.lexiconinstall.BLexiconInstaller;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.GetDirectoryMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.security.AuthenticationException;
import javax.baja.ui.list.ListModel;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class LexiconDirListModel
extends ListModel {
    private XElem[] items = new XElem[0];
    private FilePath directoryPath;
    protected BDaemonSession session = null;
    protected DaemonSessionTaskListener listener;

    public LexiconDirListModel(FilePath filePath) {
        this.directoryPath = filePath;
    }

    public int getItemCount() {
        return this.items.length;
    }

    public Object getItem(int n) {
        return this.getFileName(n);
    }

    public String getFileName(int n) {
        return this.items[n].get("name");
    }

    public FilePath getFilePath(int n) {
        return this.directoryPath.merge(this.getFileName(n));
    }

    public boolean deleteFile(int n) throws AuthenticationException {
        try {
            if (this.session != null && DaemonFileUtil.transfer((BDaemonSession)this.session, (FileTransferMessage)FileTransferMessage.makeDelete((FilePath)this.getFilePath(n), (BDaemonFileSpace)this.session.getFileSpace()), null, (DaemonSessionTaskListener)this.listener)) {
                this.loadValue(this.session, this.listener);
                return true;
            }
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
        return false;
    }

    public void transferDirectory(BIDirectory bIDirectory) throws IOException {
        if (this.session == null) {
            return;
        }
        boolean bl = false;
        BIFile[] bIFileArray = bIDirectory.listFiles();
        FilePath filePath = BLexiconInstaller.LEXICON_HOME_PATH.merge(((BIFile)bIDirectory).getFileName());
        FileTransferMessage fileTransferMessage = new FileTransferMessage((BDaemonFileSpace)this.session.getFileSpace());
        for (int i = 0; i < bIFileArray.length; ++i) {
            if (bIFileArray[i].isDirectory() || bIFileArray[i].getExtension() == null || !bIFileArray[i].getExtension().equals("lexicon")) continue;
            fileTransferMessage.addFile(bIFileArray[i], filePath.merge(bIFileArray[i].getFileName()));
            bl = true;
        }
        if (bl) {
            DaemonFileUtil.transfer((BDaemonSession)this.session, (FileTransferMessage)fileTransferMessage, null, (DaemonSessionTaskListener)this.listener);
            this.loadValue(this.session, this.listener);
        }
    }

    public void loadValue(BDaemonSession bDaemonSession, DaemonSessionTaskListener daemonSessionTaskListener) throws AuthenticationException {
        this.session = bDaemonSession;
        this.listener = daemonSessionTaskListener;
        try {
            InputStream inputStream = bDaemonSession.getInputStream((DaemonMessage)new GetDirectoryMessage(this.directoryPath, (BDaemonFileSpace)bDaemonSession.getFileSpace()));
            if (inputStream == null) {
                this.items = new XElem[0];
            } else {
                XElem xElem = XParser.make((InputStream)inputStream).parse();
                this.items = xElem.elems("directory");
            }
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (Exception exception) {
            BDaemonSessionView.log.error("error listing lexicons", (Throwable)exception);
        }
        this.updateList();
    }
}

