/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.filetransfer;

import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.filetransfer.BDirectoryTable;
import com.tridium.platDaemon.ui.widget.BDirectoryChoice;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.AsyncGroup;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.BIBeamPane;
import com.tridium.platform.ui.util.BStringPromptDialog;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import java.net.ConnectException;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.util.BFolder;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

public class BFileTransferClient
extends BDaemonSessionView
implements CommandBindings.Support {
    public static final Action handleLocalDirChanged = BFileTransferClient.newAction((int)4, null);
    public static final Action handleRemoteDirChanged = BFileTransferClient.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$filetransfer$BFileTransferClient == null ? (class$com$tridium$platDaemon$ui$filetransfer$BFileTransferClient = BFileTransferClient.class$("com.tridium.platDaemon.ui.filetransfer.BFileTransferClient")) : class$com$tridium$platDaemon$ui$filetransfer$BFileTransferClient));
    BDirectoryTable localTable;
    BDirectoryTable remoteTable;
    private AsyncCommand uploadCommand;
    private AsyncCommand downloadCommand;
    private AsyncCommand deleteCommand;
    private UpLocalCommand upLocalCommand;
    private AsyncCommand changeLocalDirCommand;
    private AsyncCommand changeRemoteDirCommand;
    private UpRemoteCommand upRemoteCommand;
    private BDirectoryChoice localDirChoice;
    private BDirectoryChoice remoteDirChoice;
    private BLabel localLabel;
    private BLabel remoteLabel;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$filetransfer$BFileTransferClient;

    public void handleLocalDirChanged() {
        this.invoke(handleLocalDirChanged, null, null);
    }

    public void handleRemoteDirChanged() {
        this.invoke(handleRemoteDirChanged, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BFileTransferClient() {
        BIBeamPane bIBeamPane = new BIBeamPane();
        BFlowPane bFlowPane = new BFlowPane(BHalign.left);
        AsyncGroup asyncGroup = new AsyncGroup();
        this.upLocalCommand = new UpLocalCommand();
        BButton bButton = new BButton((Command)this.upLocalCommand, false, true);
        bFlowPane.add(null, (BValue)bButton);
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.upLocalCommand);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        this.localDirChoice = new BDirectoryChoice();
        bFlowPane.add(null, (BValue)this.localDirChoice);
        this.linkTo((BComponent)this.localDirChoice, (Slot)BDirectoryChoice.dirModified, (Slot)handleLocalDirChanged);
        this.localTable = new BDirectoryTable((BWbView)this);
        BBorderPane bBorderPane = new BBorderPane((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bFlowPane, 6.0, 0.0, 2.0, 0.0), null, null, null, (BWidget)new BBorderPane((BWidget)this.localTable, BBorder.inset, BInsets.DEFAULT)), 4.0, 2.0, 0.0, 2.0);
        bIBeamPane.setLeft((BWidget)bBorderPane);
        this.localLabel = new BLabel();
        bBorderPane.setLabel((BWidget)this.localLabel);
        bFlowPane = new BFlowPane(BHalign.left);
        this.upRemoteCommand = new UpRemoteCommand();
        bButton = new BButton((Command)this.upRemoteCommand, false, true);
        bFlowPane.add(null, (BValue)bButton);
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.upRemoteCommand);
        bButton.setButtonStyle(BButtonStyle.toolBar);
        this.remoteDirChoice = new BDirectoryChoice();
        bFlowPane.add(null, (BValue)this.remoteDirChoice);
        this.linkTo((BComponent)this.remoteDirChoice, (Slot)BDirectoryChoice.dirModified, (Slot)handleRemoteDirChanged);
        this.remoteTable = new BDirectoryTable((BWbView)this);
        bBorderPane = new BBorderPane((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bFlowPane, 6.0, 0.0, 2.0, 0.0), null, null, null, (BWidget)new BBorderPane((BWidget)this.remoteTable, BBorder.inset, BInsets.DEFAULT)), 4.0, 2.0, 0.0, 2.0);
        bIBeamPane.setRight((BWidget)bBorderPane);
        this.remoteLabel = new BLabel();
        bBorderPane.setLabel((BWidget)this.remoteLabel);
        this.remoteTable.setOtherTable((BTable)this.localTable);
        this.remoteTable.setController((TableController)new DirectoryTableController(this.remoteTable.getCommandBindings()));
        this.localTable.setOtherTable((BTable)this.remoteTable);
        this.localTable.setController((TableController)new DirectoryTableController(this.localTable.getCommandBindings()));
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setColumnAlign(BHalign.fill);
        this.uploadCommand = new TransferCommand(this.localTable, this.remoteTable, "FileTransferClient.upload");
        bGridPane.add(null, (BValue)new BButton((Command)this.uploadCommand, false, true));
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.uploadCommand);
        this.downloadCommand = new TransferCommand(this.remoteTable, this.localTable, "FileTransferClient.download");
        bGridPane.add(null, (BValue)new BButton((Command)this.downloadCommand, false, true));
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.downloadCommand);
        this.deleteCommand = new DeleteCommand();
        bGridPane.add(null, (BValue)new BButton((Command)this.deleteCommand, false, true));
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.deleteCommand);
        bIBeamPane.setCenter((BWidget)new BBorderPane((BWidget)bGridPane, 0.0, 4.0, 0.0, 4.0));
        this.changeLocalDirCommand = new ChangeDirectoryCommand(this.localTable);
        this.localTable.addCommand((Command)this.changeLocalDirCommand, BCommandEnablePolicy.singleSelection);
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.changeLocalDirCommand);
        this.localTable.addCommand((Command)this.uploadCommand, BCommandEnablePolicy.anySelection);
        this.localTable.addCommand((Command)this.deleteCommand, BCommandEnablePolicy.anySelection);
        this.localTable.addCommand((Command)new MakeSubDirectoryCommand(this.localTable), BCommandEnablePolicy.empty);
        this.localTable.addCommand((Command)new RefreshCommand(this.localTable), BCommandEnablePolicy.always);
        this.localTable.setCommandSupport(this);
        this.localTable.setCommandEnabledStates();
        this.changeRemoteDirCommand = new ChangeDirectoryCommand(this.remoteTable);
        this.remoteTable.addCommand((Command)this.changeRemoteDirCommand, BCommandEnablePolicy.singleSelection);
        asyncGroup.add((AsyncGroup.AsyncGroupMember)this.changeRemoteDirCommand);
        this.remoteTable.addCommand((Command)this.downloadCommand, BCommandEnablePolicy.anySelection);
        this.remoteTable.addCommand((Command)this.deleteCommand, BCommandEnablePolicy.anySelection);
        this.remoteTable.addCommand((Command)new MakeSubDirectoryCommand(this.remoteTable), BCommandEnablePolicy.empty);
        this.remoteTable.addCommand((Command)new RefreshCommand(this.remoteTable), BCommandEnablePolicy.always);
        this.remoteTable.setCommandSupport(this);
        this.remoteTable.setCommandEnabledStates();
        this.setContent((BWidget)bIBeamPane);
    }

    public void deactivated() {
        super.deactivated();
        this.localTable.deactivated();
    }

    protected FilePath loadPreferredDir(String string) {
        BOptions bOptions = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
        StringBuffer stringBuffer = new StringBuffer(this.getDaemonSession().getHost().getHostname());
        stringBuffer.append(':');
        stringBuffer.append(String.valueOf(this.getDaemonSession().getPort()));
        BComponent bComponent = (BComponent)bOptions.get(SlotPath.escape((String)stringBuffer.toString()));
        if (bComponent == null) {
            return null;
        }
        BString bString = (BString)bComponent.get(string);
        return bString == null ? null : new FilePath(bString.toString());
    }

    protected void savePreferredDir(String string, BDirectory bDirectory) {
        BOptions bOptions = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
        StringBuffer stringBuffer = new StringBuffer(this.getDaemonSession().getHost().getHostname());
        stringBuffer.append(':');
        stringBuffer.append(String.valueOf(this.getDaemonSession().getPort()));
        BComponent bComponent = (BComponent)bOptions.get(SlotPath.escape((String)stringBuffer.toString()));
        if (bComponent == null) {
            bComponent = new BFolder();
            bOptions.add(SlotPath.escape((String)stringBuffer.toString()), (BValue)bComponent);
        }
        if (bComponent.get(string) == null) {
            bComponent.add(string, (BValue)BString.make((String)bDirectory.getFilePath().getBody()));
        } else {
            bComponent.set(string, (BValue)BString.make((String)bDirectory.getFilePath().getBody()));
        }
        bOptions.save();
    }

    protected void doLoadSession(BDaemonSession bDaemonSession, Context context) throws AuthenticationException {
        try {
            BDirectory bDirectory;
            bDaemonSession.reloadHostProperties();
            FilePath filePath = this.loadPreferredDir("localPath");
            if (filePath == null) {
                filePath = new FilePath("!");
            }
            if ((bDirectory = (BDirectory)BFileSystem.INSTANCE.findFile(filePath)) == null) {
                bDirectory = BFileSystem.INSTANCE.getSysHome();
            }
            this.localDirChoice.setDirectory(bDirectory);
            this.localLabel.setText(this.getLexicon().getText("FileTransferClient.local.heading"));
            this.localLabel.setImage(BImage.make((BIcon)BLocalHost.INSTANCE.getIcon()));
            FilePath filePath2 = this.loadPreferredDir("remotePath");
            if (filePath2 == null) {
                filePath2 = new FilePath("!");
            }
            bDaemonSession.getFileSpace().listFiles();
            BDaemonDirectoryStore bDaemonDirectoryStore = BDaemonDirectoryStore.make((BDaemonFileSpace)bDaemonSession.getFileSpace(), (FilePath)filePath2, (boolean)false, (boolean)true, (boolean)true, null);
            if (bDaemonDirectoryStore == null) {
                filePath2 = new FilePath("!");
                bDaemonDirectoryStore = BDaemonDirectoryStore.make((BDaemonFileSpace)bDaemonSession.getFileSpace(), (FilePath)filePath2, (boolean)false, (boolean)true, (boolean)true, null);
            }
            BDirectory bDirectory2 = new BDirectory((BIFileStore)bDaemonDirectoryStore);
            this.remoteDirChoice.setDirectory(bDirectory2);
            this.remoteLabel.setText(this.getLexicon().getText("FileTransferClient.remote.heading", new Object[]{bDaemonSession.getRemoteAddressString()}));
            this.remoteLabel.setImage(BImage.make((BIcon)bDaemonSession.getIcon()));
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandleLocalDirChanged() {
        BDirectory bDirectory = this.localDirChoice.getDirectory();
        BWbShell bWbShell = this.getWbShell();
        try {
            bWbShell.enterBusy();
            this.localTable.load(bDirectory, this);
            this.upLocalCommand.checkEnabled(bDirectory);
            this.savePreferredDir("localPath", bDirectory);
        }
        finally {
            bWbShell.exitBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandleRemoteDirChanged() {
        BDirectory bDirectory = this.remoteDirChoice.getDirectory();
        BWbShell bWbShell = this.getWbShell();
        try {
            bWbShell.enterBusy();
            this.remoteTable.load(bDirectory, this);
            this.upRemoteCommand.checkEnabled((BDaemonDirectoryStore)bDirectory.getStore());
            this.savePreferredDir("remotePath", bDirectory);
        }
        finally {
            bWbShell.exitBusy();
        }
    }

    public void setBoundCommandEnabled(Command command, boolean bl) {
        if (command == this.deleteCommand) {
            this.deleteCommand.setEnabled(!this.localTable.getSelection().isEmpty() || !this.remoteTable.getSelection().isEmpty());
        } else if (!bl) {
            command.setEnabled(bl);
        } else if (command == this.changeLocalDirCommand) {
            command.setEnabled(this.localTable.getSelectedFiles()[0] instanceof BDirectory);
        } else if (command == this.changeRemoteDirCommand) {
            command.setEnabled(this.remoteTable.getSelectedFiles()[0] instanceof BDirectory);
        } else {
            command.setEnabled(bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MakeSubDirectoryCommand
    extends AsyncCommand {
        private BDirectoryTable table;

        public MakeSubDirectoryCommand(BDirectoryTable bDirectoryTable) {
            super((BWidget)BFileTransferClient.this, TYPE.getModule(), "FileTransferClient.mkdir");
            this.table = bDirectoryTable;
        }

        public void doInvokeAsync() {
            try {
                String string = BStringPromptDialog.getString((BWidget)this.table, null, (String)BFileTransferClient.this.getLexicon().getText("FileTransferClient.mkdir.dlgTitle"), (String)BFileTransferClient.this.getLexicon().getText("FileTransferClient.mkdir.dlgMessage"));
                if (string != null && string.trim().length() > 0) {
                    this.table.makeSubDirectory(string);
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
        }
    }

    class ChangeDirectoryCommand
    extends AsyncCommand {
        private BDirectoryTable table;

        public ChangeDirectoryCommand(BDirectoryTable bDirectoryTable) {
            super((BWidget)BFileTransferClient.this, TYPE.getModule(), "FileTransferClient.changeDir");
            this.table = bDirectoryTable;
            this.setEnabled(false);
        }

        public void doInvokeAsync() {
            BIFile bIFile = this.table.getSelectedFiles()[0];
            if (this.table == BFileTransferClient.this.localTable) {
                BFileTransferClient.this.localDirChoice.setDirectory((BDirectory)bIFile);
            } else {
                BFileTransferClient.this.remoteDirChoice.setDirectory((BDirectory)bIFile);
            }
        }
    }

    class RefreshCommand
    extends AsyncCommand {
        private BDirectoryTable table;

        public RefreshCommand(BDirectoryTable bDirectoryTable) {
            super((BWidget)BFileTransferClient.this, TYPE.getModule(), "FileTransferClient.refresh");
            this.table = bDirectoryTable;
        }

        public void doInvokeAsync() {
            try {
                this.table.refresh();
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
        }
    }

    class DeleteCommand
    extends AsyncCommand {
        public DeleteCommand() {
            super((BWidget)BFileTransferClient.this, TYPE.getModule(), "FileTransferClient.delete");
            this.setEnabled(false);
        }

        public void doInvokeAsync() {
            try {
                if (BFileTransferClient.this.localTable.getSelection().getRows().length > 0) {
                    BFileTransferClient.this.localTable.doDelete();
                } else {
                    BFileTransferClient.this.remoteTable.doDelete();
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
        }
    }

    class TransferCommand
    extends AsyncCommand {
        private BDirectoryTable sourceTable;
        private BDirectoryTable targetTable;

        public TransferCommand(BDirectoryTable bDirectoryTable, BDirectoryTable bDirectoryTable2, String string) {
            super((BWidget)BFileTransferClient.this, TYPE.getModule(), string);
            this.sourceTable = bDirectoryTable;
            this.targetTable = bDirectoryTable2;
            this.setEnabled(false);
        }

        public void doInvokeAsync() {
            try {
                this.targetTable.insertTransferData(this.sourceTable.getSelectedFilesAsMark());
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
        }
    }

    private class UpLocalCommand
    extends AsyncCommand {
        public UpLocalCommand() {
            super((BWidget)BFileTransferClient.this, TYPE.getModule(), "FileTransferClient.upLocal");
        }

        public void checkEnabled(BDirectory bDirectory) {
            Object object;
            String string = ((BLocalFileStore)bDirectory.getStore()).getLocalFile().getAbsolutePath();
            Object object2 = bDirectory.getNavParent();
            if (object2 == null || !(object2 instanceof BDirectory)) {
                object = BFileTransferClient.this.localDirChoice.getDirectory();
                FilePath filePath = DaemonFileUtil.getNormalizedFilePath((BIFileStore)object.getStore()).getParent();
                object2 = filePath == null ? null : BFileSystem.INSTANCE.findFile(filePath);
            }
            if (object2 != null && object2 instanceof BDirectory) {
                object = ((BLocalFileStore)((BDirectory)object2).getStore()).getLocalFile().getAbsolutePath();
                this.setEnabled(!string.equals(object));
            } else {
                this.setEnabled(false);
            }
        }

        public void doInvokeAsync() {
            try {
                FilePath filePath;
                BDirectory bDirectory = BFileTransferClient.this.localDirChoice.getDirectory();
                BINavNode bINavNode = bDirectory.getNavParent();
                if (!(bINavNode != null && bINavNode instanceof BDirectory || (filePath = DaemonFileUtil.getNormalizedFilePath((BIFileStore)bDirectory.getStore()).getParent()) == null)) {
                    bINavNode = BFileSystem.INSTANCE.findFile(filePath);
                }
                if (bINavNode != null && bINavNode instanceof BDirectory) {
                    BFileTransferClient.this.localTable.getSelection().deselectAll();
                    BFileTransferClient.this.localDirChoice.setDirectory((BDirectory)bINavNode);
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
        }
    }

    private class UpRemoteCommand
    extends AsyncCommand {
        public UpRemoteCommand() {
            super((BWidget)BFileTransferClient.this, TYPE.getModule(), "FileTransferClient.upRemote");
        }

        public void checkEnabled(BDaemonDirectoryStore bDaemonDirectoryStore) {
            FilePath filePath = DaemonFileUtil.getNormalizedFilePath((BIFileStore)bDaemonDirectoryStore);
            if (filePath.depth() == 0) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        }

        public void doInvokeAsync() {
            try {
                BFileTransferClient.this.remoteTable.getSelection().deselectAll();
                BDirectory bDirectory = BFileTransferClient.this.remoteDirChoice.getDirectory();
                FilePath filePath = DaemonFileUtil.getNormalizedFilePath((BIFileStore)bDirectory.getStore()).getParent();
                if (filePath != null) {
                    BDaemonDirectoryStore bDaemonDirectoryStore = BDaemonDirectoryStore.make((BDaemonFileSpace)BFileTransferClient.this.getDaemonSession().getFileSpace(), (FilePath)filePath, (boolean)false, (boolean)true, (boolean)true, null);
                    BFileTransferClient.this.remoteDirChoice.setDirectory(new BDirectory((BIFileStore)bDaemonDirectoryStore));
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
        }
    }

    private class DirectoryTableController
    extends CommandBindings.TableController {
        public DirectoryTableController(CommandBindings commandBindings) {
            super(commandBindings);
        }

        protected void backgroundPressed(BMouseEvent bMouseEvent) {
            BFileTransferClient.this.remoteTable.getSelection().deselectAll();
            BFileTransferClient.this.localTable.getSelection().deselectAll();
            super.backgroundPressed(bMouseEvent);
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            BDirectoryTable bDirectoryTable = (BDirectoryTable)this.getTable();
            if (bDirectoryTable.isDirectory(n)) {
                if (bDirectoryTable == BFileTransferClient.this.localTable) {
                    BFileTransferClient.this.localDirChoice.setDirectory(bDirectoryTable.getDirectory(n));
                } else {
                    BFileTransferClient.this.remoteDirChoice.setDirectory(bDirectoryTable.getDirectory(n));
                }
            }
        }

        public int getTextSearchColumn() {
            return 0;
        }
    }
}

