/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.distinstall;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platDaemon.SessionSurrogates;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.distinstall.DependenciesStep;
import com.tridium.platDaemon.ui.distinstall.DistInstallWizardStep;
import com.tridium.platDaemon.ui.distinstall.FinishDistInstall;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import java.net.ConnectException;
import javax.baja.file.BDirectory;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.Size;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;

public class DistInstallWizardModel
extends WizardModel {
    private DistInstallWizardStep currentStep;
    private DependenciesStep depStep;
    private boolean canFinish = false;
    private BDaemonSession session;
    private BDistribution dist;
    private InstallScenario requiredScenario;
    private InstallScenario upgradeScenario;
    private BInstallable[] availableUpgrades;
    private boolean installUpgrades = false;
    private SessionSurrogates surrogates;
    private BWidget owner;
    private BDirectory distDir = null;
    private boolean useWorkbenchPaths = true;
    private DaemonSessionTaskHandler sessionTaskHandler;
    private boolean updateTcpIp = false;
    private boolean isCanceled = false;
    public static final FilePath DEFAULT_MODULE_PATH = new FilePath("!modules");
    public static final FilePath DEFAULT_DIST_PATH = new FilePath("!sw");
    public static final BImage wizImage = BImage.make((String)"module://icons/x32/modules.png");

    public DistInstallWizardModel(BWidget bWidget, BDistribution bDistribution, BDaemonSession bDaemonSession) throws Exception {
        this.owner = bWidget;
        this.session = bDaemonSession;
        this.surrogates = new SessionSurrogates(bDaemonSession);
        this.sessionTaskHandler = new DaemonSessionTaskHandler(this.owner);
        this.setDistribution(bDistribution);
        this.depStep = new DependenciesStep(this);
        this.currentStep = this.depStep;
    }

    public String getTitle() {
        return BDaemonSessionView.lexicon.getText("DistInstallerWizard.title");
    }

    public boolean cancel() {
        this.isCanceled = BDialog.confirm((BWidget)this.getWizard(), (String)BDaemonSessionView.lexicon.getText("DistInstallerWizard.cancel.title"), (Object)BDaemonSessionView.lexicon.getText("DistInstallerWizard.cancel.message")) == 4 && this.getCurrentStep().cancel();
        return this.isCanceled;
    }

    public boolean hasNoSteps() {
        DistInstallWizardStep distInstallWizardStep;
        for (distInstallWizardStep = this.currentStep; distInstallWizardStep != null && distInstallWizardStep.isSkipped(); distInstallWizardStep = distInstallWizardStep.getNextStep()) {
        }
        return distInstallWizardStep == null;
    }

    public void init() {
        try {
            DistInstallWizardStep distInstallWizardStep;
            LocalInstallableRegistry.getInstance().init((DaemonSessionTaskListener)this.sessionTaskHandler);
            for (distInstallWizardStep = this.currentStep; distInstallWizardStep != null && distInstallWizardStep.isSkipped(); distInstallWizardStep = distInstallWizardStep.getNextStep()) {
            }
            this.update(distInstallWizardStep);
            distInstallWizardStep.enter();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void back() {
        DistInstallWizardStep distInstallWizardStep = this.getCurrentStep().getPriorStep();
        if (distInstallWizardStep != null && this.getCurrentStep().exit()) {
            while (distInstallWizardStep != null && distInstallWizardStep.isSkipped()) {
                distInstallWizardStep = distInstallWizardStep.getPriorStep();
            }
            if (distInstallWizardStep != null) {
                this.update(distInstallWizardStep);
                distInstallWizardStep.enter();
            }
        }
    }

    public void next() {
        DistInstallWizardStep distInstallWizardStep = this.getCurrentStep().getNextStep();
        if (distInstallWizardStep != null && this.getCurrentStep().exit()) {
            while (distInstallWizardStep != null && distInstallWizardStep.isSkipped()) {
                distInstallWizardStep = distInstallWizardStep.getNextStep();
            }
            if (distInstallWizardStep != null) {
                this.update(distInstallWizardStep);
                distInstallWizardStep.enter();
            }
        }
    }

    public boolean finish() {
        if (this.getCurrentStep().exit() && this.canFinish()) {
            try {
                new FinishDistInstall(this).open();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
        return true;
    }

    private DistInstallWizardStep getCurrentStep() {
        return this.currentStep;
    }

    public void update(DistInstallWizardStep distInstallWizardStep) {
        this.currentStep = distInstallWizardStep;
        this.update(distInstallWizardStep.getWidget(), distInstallWizardStep.getMode());
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(450.0, 300.0);
    }

    public void setWizard(BWizard bWizard) {
        super.setWizard(bWizard);
        this.sessionTaskHandler.setOwner((BWidget)bWizard);
        this.owner = bWizard;
    }

    public BWidget getOwner() {
        return this.owner;
    }

    public DependenciesStep getDependenciesStep() {
        return this.depStep;
    }

    public DaemonSessionTaskHandler getTaskHandler() {
        return this.sessionTaskHandler;
    }

    public BDaemonSession getSession() {
        return this.session;
    }

    public BDaemonPlatform getPlatform() {
        try {
            return BRemoteDaemonPlatform.make((BDaemonSession)this.session, (DaemonSessionTaskListener)this.getTaskHandler());
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public BDirectory getDistDir() {
        return this.distDir;
    }

    public void setDistDir(BDirectory bDirectory) {
        this.distDir = bDirectory;
    }

    public boolean useWorkbenchPaths() {
        return this.useWorkbenchPaths;
    }

    public void setUseWorkbenchPaths(boolean bl) {
        this.useWorkbenchPaths = bl;
    }

    public BDistribution getDistribution() {
        return this.dist;
    }

    public void setDistribution(BDistribution bDistribution) {
        this.dist = bDistribution;
    }

    public void setRequiredScenario(InstallScenario installScenario) {
        this.requiredScenario = installScenario;
    }

    public InstallScenario getRequiredScenario() {
        return this.requiredScenario;
    }

    public void setUpgradeScenario(InstallScenario installScenario) {
        this.upgradeScenario = installScenario;
    }

    public void setAvailableUpgrades(BInstallable[] bInstallableArray) {
        this.availableUpgrades = bInstallableArray;
    }

    public BInstallable[] getAvailableUpgrades() {
        return this.availableUpgrades;
    }

    public InstallScenario getUpgradeScenario() {
        return this.upgradeScenario;
    }

    public InstallScenario getInstallScenario() {
        return this.installUpgrades() ? this.getUpgradeScenario() : this.getRequiredScenario();
    }

    public void setInstallUpgrades(boolean bl) {
        this.installUpgrades = bl;
    }

    public boolean installUpgrades() {
        return this.installUpgrades;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setUpdateTcpIp(boolean bl) {
        this.updateTcpIp = bl;
    }

    public boolean updateTcpIp() {
        return this.updateTcpIp;
    }

    public long getProcessingFlags() {
        return this.getInstallScenario().getProcessingFlags();
    }

    public void setCanFinish(boolean bl) {
        this.canFinish = bl;
    }

    public boolean canFinish() {
        return this.canFinish;
    }

    public BAppSurrogate[] getAppSurrogates() throws AuthenticationException {
        try {
            return this.surrogates.getAll();
        }
        catch (ConnectException connectException) {
            return null;
        }
    }
}

