/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.distinstall;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.DependencyUtil;
import com.tridium.install.InstallScenario;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platDaemon.ui.distinstall.DistInstallWizardModel;
import com.tridium.platDaemon.ui.distinstall.DistInstallWizardStep;
import com.tridium.platDaemon.ui.distinstall.StopAppsStep;
import com.tridium.platDaemon.ui.distinstall.TcpIpStep;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.BTextOutputPane;
import com.tridium.ui.theme.Theme;
import java.util.Comparator;
import java.util.ListIterator;
import javax.baja.gx.BImage;
import javax.baja.nre.util.Array;
import javax.baja.sys.BIcon;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.xml.XElem;

public class DependenciesStep
extends DistInstallWizardStep {
    private int mode = 0;
    private boolean skipped = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DependenciesStep(DistInstallWizardModel distInstallWizardModel) {
        super(distInstallWizardModel);
        BDialog bDialog = new BDialog(distInstallWizardModel.getOwner(), this.getLexicon().getText("DependenciesStep.analyzing.title"), false, (BWidget)new BBorderPane((BWidget)new BLabel(this.getLexicon().getText("DependenciesStep.analyzing.message"), BHalign.left), 10.0, 10.0, 10.0, 10.0));
        BWidgetShell bWidgetShell = distInstallWizardModel.getOwner().getShell();
        try {
            StopAppsStep stopAppsStep;
            XElem xElem;
            this.mode = 0;
            if (bWidgetShell != null) {
                bWidgetShell.enterBusy();
            }
            bDialog.setBoundsCenteredOnOwner();
            bDialog.open();
            BDistribution bDistribution = this.getWizardModel().getDistribution();
            BDaemonPlatform bDaemonPlatform = distInstallWizardModel.getPlatform();
            BModuleContent bModuleContent = bDistribution.getUpdateModuleContent() ? bDistribution.getNewModuleContent() : bDaemonPlatform.getModuleContent();
            BDependency[] bDependencyArray = bDistribution.getIsStandalone() ? new BDependency[]{} : ((xElem = bDistribution.getUpdatedPlatformBog(bDaemonPlatform)) == null ? DependencyUtil.getPlatformDependencies((BDaemonPlatform)bDaemonPlatform, (BModuleContent)bModuleContent) : DependencyUtil.getBogModuleDeps((XElem)xElem));
            xElem = InstallScenario.solve((BDaemonPlatform)bDaemonPlatform, (DaemonSessionTaskListener)distInstallWizardModel.getTaskHandler(), null, (BDependency[])bDependencyArray, (BInstallable[])new BInstallable[]{distInstallWizardModel.getDistribution()}, (InstallableRegistry)LocalInstallableRegistry.getInstance());
            if (!xElem.canCommit()) {
                if (xElem.getExcludedInstallables().length > 0) {
                    this.formatExcluded((InstallScenario)xElem);
                    this.mode = 0;
                    distInstallWizardModel.setCanFinish(false);
                    return;
                }
                this.formatUnavailable((InstallScenario)xElem);
                this.mode = 0;
                distInstallWizardModel.setCanFinish(false);
                return;
            }
            distInstallWizardModel.setRequiredScenario((InstallScenario)xElem);
            this.mode = 4;
            distInstallWizardModel.setCanFinish(true);
            if (xElem.getToInstall().length == 1) {
                this.skipped = true;
            } else {
                this.formatRequiredSoftware((InstallScenario)xElem);
            }
            long l = xElem.getProcessingFlags();
            DistInstallWizardStep distInstallWizardStep = this;
            if ((l & 1L) > 0L || (l & 2L) > 0L || (l & 4L) > 0L) {
                stopAppsStep = new StopAppsStep(distInstallWizardModel, (l & 1L) > 0L);
                distInstallWizardStep.setNextStep(stopAppsStep);
                stopAppsStep.setPriorStep(distInstallWizardStep);
                distInstallWizardStep = stopAppsStep;
                this.mode = 2;
            }
            if ((l & 0x80000L) > 0L && (stopAppsStep = distInstallWizardModel.getDistribution().getTcpIpChanges()) != null && !stopAppsStep.getIsReadonly()) {
                TcpIpStep tcpIpStep = new TcpIpStep(distInstallWizardModel);
                distInstallWizardModel.setUpdateTcpIp(false);
                distInstallWizardStep.setNextStep(tcpIpStep);
                tcpIpStep.setPriorStep(distInstallWizardStep);
                distInstallWizardStep = tcpIpStep;
                this.mode = 2;
            }
        }
        catch (Throwable throwable) {
            this.setContent((BWidget)new BTextOutputPane(throwable));
            this.mode = 0;
        }
        finally {
            if (bWidgetShell != null) {
                bWidgetShell.exitBusy();
            }
            bDialog.close();
        }
    }

    public String getStepName() {
        return "DependenciesStep";
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public void enter() {
    }

    public boolean exit() {
        return true;
    }

    public int getMode() {
        if (this.mode == 2) {
            DistInstallWizardStep distInstallWizardStep;
            for (distInstallWizardStep = this.getNextStep(); distInstallWizardStep != null && distInstallWizardStep.isSkipped(); distInstallWizardStep = distInstallWizardStep.getNextStep()) {
            }
            if (distInstallWizardStep == null) {
                return 4;
            }
        }
        return this.mode;
    }

    private void formatExcluded(InstallScenario installScenario) {
        BIndentPane bIndentPane = new BIndentPane();
        bIndentPane.add(this.getLexiconText("DependenciesStep.excludedHeader"));
        BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)bIndentPane, 3.0, 3.0, 3.0, 3.0));
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        this.setContent((BWidget)bScrollPane);
    }

    private void formatUnavailable(InstallScenario installScenario) {
        UnmeetableDependency[] unmeetableDependencyArray = installScenario.getUnmeetableDependencies();
        BIndentPane bIndentPane = new BIndentPane();
        bIndentPane.add(this.getLexiconText("DependenciesStep.unavailableHeader"));
        bIndentPane.indent();
        for (int i = 0; i < unmeetableDependencyArray.length; ++i) {
            if (unmeetableDependencyArray[i].isUnsolvable) {
                bIndentPane.add((BWidget)new BLabel(unmeetableDependencyArray[i].getIcon(), unmeetableDependencyArray[i].toString(null)));
                continue;
            }
            bIndentPane.add((BWidget)new BLabel(unmeetableDependencyArray[i].getIcon(), unmeetableDependencyArray[i].toString(null)));
        }
        bIndentPane.unindent();
        bIndentPane.add(this.getLexiconText("DependenciesStep.unavailableFooter"));
        BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)bIndentPane, 3.0, 3.0, 3.0, 3.0));
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        this.setContent((BWidget)bScrollPane);
    }

    private void formatRequiredSoftware(InstallScenario installScenario) {
        Array array = new Array((Object[])installScenario.getToInstall());
        array = array.sort((Comparator)new InstallableNameComparator());
        BIndentPane bIndentPane = new BIndentPane();
        bIndentPane.add(this.getLexiconText("DependenciesStep.requiredHeader"));
        bIndentPane.indent();
        ListIterator listIterator = array.iterator();
        while (listIterator.hasNext()) {
            BInstallable bInstallable = (BInstallable)listIterator.next();
            if (bInstallable == this.getWizardModel().getDistribution()) continue;
            bIndentPane.add((BWidget)new BLabel(BImage.make((BIcon)bInstallable.getIcon()), bInstallable.toString(null)));
        }
        bIndentPane.unindent();
        listIterator = new BScrollPane((BWidget)new BBorderPane((BWidget)bIndentPane, 3.0, 3.0, 3.0, 3.0));
        listIterator.setBorderPolicy(BScrollBarPolicy.asNeeded);
        listIterator.setViewportBackground(Theme.scrollPane().getControlBackground());
        this.setContent((BWidget)listIterator);
    }

    private static class InstallableNameComparator
    implements Comparator {
        private InstallableNameComparator() {
        }

        public int compare(Object object, Object object2) {
            BInstallable bInstallable = (BInstallable)object;
            BInstallable bInstallable2 = (BInstallable)object2;
            return bInstallable.getInstallableName().compareTo(bInstallable2.getInstallableName());
        }
    }
}

