/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.ui.util.PortConfigController;
import com.tridium.ui.BOptionDialog;
import java.io.InputStream;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class QnxInetdPrompt {
    BOptionDialog dialog;
    BCheckBox telnetEnabledCheckBox;
    BCheckBox ftpEnabledCheckBox;
    BTextField telnetPortTextField;
    BTextField ftpPortTextField;
    OkCommand okCommand;
    static Lexicon lex = Lexicon.make((String)"platDaemon");

    public static void updateSettings(BWidget bWidget, BDaemonSession bDaemonSession) {
        try {
            XElem xElem = XParser.make((InputStream)bDaemonSession.getInputStream((DaemonMessage)new XmlResponseMessage(){

                public String getMessageString() {
                    return "qnxinetd";
                }
            }, 0)).parse();
            BOptionDialog bOptionDialog = new BOptionDialog(bWidget, lex.getText("QnxInetdPrompt.dlgTitle"), (BWidget)new BNullWidget(), 3, null, null);
            QnxInetdPrompt qnxInetdPrompt = new QnxInetdPrompt(bOptionDialog, xElem.geti("fp", 21), xElem.geti("tp", 23));
            bOptionDialog.setBoundsCenteredOnOwner();
            bOptionDialog.open();
            if (bOptionDialog.getResult() == 1) {
                bDaemonSession.sendMessage((DaemonMessage)new UpdateInetMessage(qnxInetdPrompt));
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    private QnxInetdPrompt(BOptionDialog bOptionDialog, int n, int n2) {
        this.dialog = bOptionDialog;
        this.okCommand = new OkCommand(this);
        bOptionDialog.getOkButton().setCommand((Command)this.okCommand, true, false);
        BGridPane bGridPane = new BGridPane(3);
        this.ftpPortTextField = new BTextField("", 4);
        this.telnetPortTextField = new BTextField("", 4);
        this.ftpEnabledCheckBox = new BCheckBox((ToggleCommand)new EnabledCommand(this, "QnxInetdPrompt.ftpEnabled", this.ftpPortTextField));
        bGridPane.add(null, (BValue)this.ftpEnabledCheckBox);
        bGridPane.add(null, (BValue)new BLabel(lex.getText("QnxInetdPrompt.port")));
        bGridPane.add(null, (BValue)this.ftpPortTextField);
        this.ftpPortTextField.setController((TextController)new PortConfigController());
        this.ftpPortTextField.setModel((TextModel)new NotNullModel(this.okCommand));
        this.telnetEnabledCheckBox = new BCheckBox((ToggleCommand)new EnabledCommand(this, "QnxInetdPrompt.telnetEnabled", this.telnetPortTextField));
        bGridPane.add(null, (BValue)this.telnetEnabledCheckBox);
        bGridPane.add(null, (BValue)new BLabel(lex.getText("QnxInetdPrompt.port")));
        bGridPane.add(null, (BValue)this.telnetPortTextField);
        this.telnetPortTextField.setController((TextController)new PortConfigController());
        this.telnetPortTextField.setModel((TextModel)new NotNullModel(this.okCommand));
        if (n < 0) {
            this.ftpEnabledCheckBox.setSelected(false);
            this.ftpPortTextField.setText("21");
            this.ftpPortTextField.setEnabled(false);
        } else {
            this.ftpEnabledCheckBox.setSelected(true);
            this.ftpPortTextField.setText(String.valueOf(n));
        }
        if (n2 < 0) {
            this.telnetEnabledCheckBox.setSelected(false);
            this.telnetPortTextField.setText("23");
            this.telnetPortTextField.setEnabled(false);
        } else {
            this.telnetEnabledCheckBox.setSelected(true);
            this.telnetPortTextField.setText(String.valueOf(n2));
        }
        bOptionDialog.setContent((BWidget)new BBorderPane((BWidget)bGridPane, 6.0, 6.0, 6.0, 6.0));
    }

    private static class NotNullModel
    extends TextModel {
        private OkCommand command;

        public NotNullModel(OkCommand okCommand) {
            this.command = okCommand;
        }

        protected void textModified() {
            this.command.check();
        }
    }

    static class EnabledCommand
    extends ToggleCommand {
        QnxInetdPrompt prompt;
        private BTextField textField;

        public EnabledCommand(QnxInetdPrompt qnxInetdPrompt, String string, BTextField bTextField) {
            super((BWidget)qnxInetdPrompt.dialog, lex.getText(string), null, null, null);
            this.textField = bTextField;
        }

        public CommandArtifact doInvoke() {
            this.textField.setEnabled(this.isSelected());
            return null;
        }
    }

    static class OkCommand
    extends Command {
        QnxInetdPrompt prompt;

        public OkCommand(QnxInetdPrompt qnxInetdPrompt) {
            super((BWidget)qnxInetdPrompt.dialog, UiLexicon.bajaui.getText("action.ok"), null, null, null);
            this.prompt = qnxInetdPrompt;
        }

        public CommandArtifact doInvoke() {
            return null;
        }

        public void check() {
            this.setEnabled(this.prompt.telnetPortTextField.getText().length() > 0 && this.prompt.ftpPortTextField.getText().length() > 0);
        }
    }

    private static class UpdateInetMessage
    extends DaemonMessage {
        private StringBuffer buf = new StringBuffer("qnxinetd?update=true&fp=");

        public UpdateInetMessage(QnxInetdPrompt qnxInetdPrompt) {
            if (qnxInetdPrompt.ftpEnabledCheckBox.isSelected()) {
                this.buf.append(qnxInetdPrompt.ftpPortTextField.getText());
            } else {
                this.buf.append("-1");
            }
            this.buf.append("&tp=");
            if (qnxInetdPrompt.telnetEnabledCheckBox.isSelected()) {
                this.buf.append(qnxInetdPrompt.telnetPortTextField.getText());
            } else {
                this.buf.append("-1");
            }
        }

        public String getMessageString() {
            return this.buf.toString();
        }
    }
}

