/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.DependencyUtil;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.widget.TaskDetailDialog;
import com.tridium.platDaemon.ui.widget.TaskDetailPane;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.EnumRadioGroup;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BImage;
import javax.baja.gx.Size;
import javax.baja.job.BJobState;
import javax.baja.nre.util.Array;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.BEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

public class ModuleContentWizardModel
extends WizardModel {
    private static final BImage wizImage = BImage.make((String)"module://icons/x32/flag.png");
    private static final Lexicon lex = Lexicon.make((String)"platDaemon");
    private BDaemonSession session;
    private WizardStep currentStep;
    private BModuleContent moduleContent;
    private BModuleContent originalModuleContent;
    private Array toInstall = new Array();
    private DaemonSessionTaskHandler sessionTaskHandler;
    private InstallScenario[] contentScenarios;

    public ModuleContentWizardModel(BWidget bWidget, BDaemonSession bDaemonSession) {
        this.session = bDaemonSession;
        this.sessionTaskHandler = new DaemonSessionTaskHandler(bWidget);
        this.originalModuleContent = this.moduleContent = this.getPlatform().getModuleContent();
        this.currentStep = new ChooseModuleContentStep();
        ReinstallStep reinstallStep = new ReinstallStep();
        this.getPlatform().getModuleList().init((DaemonSessionTaskListener)this.sessionTaskHandler);
        this.currentStep.setNextStep(reinstallStep);
        reinstallStep.setPriorStep(this.currentStep);
        this.contentScenarios = new InstallScenario[3];
        for (int i = 0; i < 3; ++i) {
            this.contentScenarios[i] = null;
        }
    }

    public BDaemonPlatform getPlatform() {
        try {
            return BRemoteDaemonPlatform.make((BDaemonSession)this.session, (DaemonSessionTaskListener)this.sessionTaskHandler);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public WizardStep getCurrentStep() {
        return this.currentStep;
    }

    public void setModuleContent(BModuleContent bModuleContent) {
        this.moduleContent = bModuleContent;
    }

    public BModuleContent getModuleContent() {
        return this.moduleContent;
    }

    public BModuleContent getOriginalModuleContent() {
        return this.originalModuleContent;
    }

    public void setToInstall(Array array) {
        this.toInstall = array;
    }

    public Array getToInstall() {
        return this.toInstall;
    }

    public String getTitle() {
        return lex.getText("ModuleContentWizard.title");
    }

    public boolean cancel() {
        if (this.getCurrentStep().getMode() == 0) {
            return true;
        }
        return BDialog.confirm((BWidget)this.getWizard(), (String)lex.getText("ModuleContentWizard.cancel.title"), (Object)lex.getText("ModuleContentWizard.cancel.message")) == 4 && this.getCurrentStep().cancel();
    }

    public void init() {
        WizardStep wizardStep;
        for (wizardStep = this.currentStep; wizardStep != null && wizardStep.isSkipped(); wizardStep = wizardStep.getNextStep()) {
        }
        this.update(wizardStep);
        wizardStep.enter();
    }

    public void back() {
        WizardStep wizardStep = this.getCurrentStep().getPriorStep();
        if (wizardStep != null && this.getCurrentStep().exit()) {
            this.update(wizardStep);
            wizardStep.enter();
        }
    }

    public void next() {
        WizardStep wizardStep = this.getCurrentStep().getNextStep();
        if (wizardStep != null && this.getCurrentStep().exit()) {
            while (wizardStep != null && wizardStep.isSkipped()) {
                wizardStep = wizardStep.getNextStep();
            }
            wizardStep.setPriorStep(this.getCurrentStep());
            this.update(wizardStep);
            wizardStep.enter();
        }
    }

    public boolean finish() {
        if (!this.getCurrentStep().exit()) {
            return false;
        }
        new FinishDialog().open();
        return true;
    }

    public void update(WizardStep wizardStep) {
        this.currentStep = wizardStep;
        this.update(wizardStep.getWidget(), wizardStep.getMode());
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(450.0, 300.0);
    }

    public void setWizard(BWizard bWizard) {
        super.setWizard(bWizard);
        this.sessionTaskHandler.setOwner((BWidget)bWizard);
    }

    public DaemonSessionTaskHandler getTaskHandler() {
        return this.sessionTaskHandler;
    }

    public InstallScenario getInstallScenario(BModuleContent bModuleContent) throws Exception {
        if (this.contentScenarios[bModuleContent.getOrdinal()] == null) {
            BDependency[] bDependencyArray = DependencyUtil.getPlatformDependencies((BDaemonPlatform)this.getPlatform(), (BModuleContent)bModuleContent);
            this.contentScenarios[bModuleContent.getOrdinal()] = new InstallScenario(this.getPlatform(), (DaemonSessionTaskListener)this.sessionTaskHandler, null, bDependencyArray, null, null, null, bModuleContent, (InstallableRegistry)LocalInstallableRegistry.getInstance()).solve();
        }
        return this.contentScenarios[bModuleContent.getOrdinal()];
    }

    private class FinishDialog
    extends TaskDetailDialog
    implements DaemonSessionTaskListener {
        private InstallScenario scenario;
        private String lastText = null;
        private TaskDetailPane.TaskItem stopStations = new TaskDetailPane.TaskItem(ModuleContentWizardModel.access$100().getText("ModuleContentWizard.FinishModuleContentChange.item.stopStations"));
        private TaskDetailPane.TaskItem installSoftware = new TaskDetailPane.TaskItem(ModuleContentWizardModel.access$100().getText("ModuleContentWizard.FinishModuleContentChange.item.installSoftware"));
        private TaskDetailPane.TaskItem startStations = new TaskDetailPane.TaskItem(ModuleContentWizardModel.access$100().getText("ModuleContentWizard.FinishModuleContentChange.item.startStations"));
        private TaskDetailPane.TaskItem reboot = new TaskDetailPane.TaskItem(ModuleContentWizardModel.access$100().getText("ModuleContentWizard.FinishModuleContentChange.item.reboot"));
        private TaskDetailPane.TaskItem[] items;

        public FinishDialog() {
            try {
                this.scenario = ModuleContentWizardModel.this.getInstallScenario(ModuleContentWizardModel.this.getModuleContent());
                this.items = ((this.scenario.getProcessingFlags() & 2L) > 0L || (this.scenario.getProcessingFlags() & 1L) > 0L || (this.scenario.getProcessingFlags() & 4L) > 0L) && BStationSurrogate.isAnyStationRunning((BDaemonSession)ModuleContentWizardModel.this.session) ? (ModuleContentWizardModel.this.session.getHostProperties().getAllowStationRestart() ? new TaskDetailPane.TaskItem[]{this.stopStations, this.installSoftware, this.startStations} : new TaskDetailPane.TaskItem[]{this.stopStations, this.installSoftware, this.reboot}) : new TaskDetailPane.TaskItem[]{this.installSoftware};
                this.init((BWidget)ModuleContentWizardModel.this.getWizard());
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public String getHeadingTitle() {
            return ModuleContentWizardModel.this.getTitle();
        }

        public String getDialogTitle() {
            return ModuleContentWizardModel.this.getTitle();
        }

        public BImage getHeadingIcon() {
            return wizImage;
        }

        public String getItemListHeading() {
            return lex.getText("ModuleContentWizard.FinishModuleContentChange.itemHeading");
        }

        public TaskDetailPane.TaskItem[] makeTaskItems() {
            return this.items;
        }

        public void taskStarted(DaemonSessionTask daemonSessionTask) {
            if (this.lastText == null || !daemonSessionTask.getMessage().equals(this.lastText)) {
                this.getLog().append(daemonSessionTask.getMessage() + "\n");
                this.lastText = daemonSessionTask.getMessage();
            }
        }

        public void taskUpdated(DaemonSessionTask daemonSessionTask) {
            if (this.lastText == null || !daemonSessionTask.getMessage().equals(this.lastText)) {
                this.getLog().append(daemonSessionTask.getMessage() + "\n");
                this.lastText = daemonSessionTask.getMessage();
            }
            if (daemonSessionTask instanceof CancelableDaemonSessionTask && !((CancelableDaemonSessionTask)daemonSessionTask).isCancelEnabled()) {
                this.setCancelEnabled(false);
            }
        }

        public void taskFinished(DaemonSessionTask daemonSessionTask) {
        }

        public void run() {
            try {
                BStationSurrogate[] bStationSurrogateArray = new BStationSurrogate[]{};
                if (((this.scenario.getProcessingFlags() & 2L) > 0L || (this.scenario.getProcessingFlags() & 4L) > 0L) && BStationSurrogate.isAnyStationRunning((BDaemonSession)ModuleContentWizardModel.this.session)) {
                    this.setCurrentItem(this.stopStations, BJobState.running);
                    this.getLog().append(lex.getText("ModuleContentWizard.FinishModuleContentChange.stoppingAllStations"));
                    this.getLog().append("\n");
                    bStationSurrogateArray = BStationSurrogate.stopAllStations((BDaemonSession)ModuleContentWizardModel.this.session, (ICancelHint)this, null);
                    this.checkCanceled();
                    this.updateCurrentItemState(BJobState.success);
                }
                this.setCurrentItem(this.installSoftware, BJobState.running);
                this.getLog().append(lex.getText("ModuleContentWizard.FinishModuleContentChange.installingSoftware"));
                this.getLog().append("\n");
                ModuleContentWizardModel.this.getInstallScenario(ModuleContentWizardModel.this.getModuleContent()).commit((DaemonSessionTaskListener)this, (ICancelHint)this);
                this.updateCurrentItemState(BJobState.success);
                if (bStationSurrogateArray.length > 0) {
                    if (ModuleContentWizardModel.this.session.getHostProperties().getAllowStationRestart()) {
                        this.setCurrentItem(this.startStations, BJobState.running);
                        for (int i = 0; i < bStationSurrogateArray.length; ++i) {
                            bStationSurrogateArray[i].startStationAsync();
                            this.getLog().append(lex.getText("ModuleContentWizard.FinishModuleContentChange.stationStarted", new Object[]{bStationSurrogateArray[i].getStationName()}));
                            this.getLog().append("\n");
                        }
                    } else {
                        this.setCurrentItem(this.reboot, BJobState.running);
                        this.getLog().append(lex.getText("ModuleContentWizard.FinishModuleContentChange.reboot"));
                        this.getLog().append("\n");
                        ModuleContentWizardModel.this.session.sendRebootRequest();
                    }
                }
                this.updateCurrentItemState(BJobState.success);
                this.getLog().append(lex.getText("ModuleContentWizard.FinishModuleContentChange.complete"));
                this.setBottomLabelText(lex.getText("ModuleContentWizard.FinishModuleContentChange.complete"));
            }
            catch (ICancelHint.CanceledException canceledException) {
                this.cancel(false);
                this.getLog().append(lex.getText("ModuleContentWizard.FinishModuleContentChange.canceled"));
                this.setBottomLabelText(lex.getText("ModuleContentWizard.FinishModuleContentChange.canceled"));
            }
            catch (Throwable throwable) {
                this.setCancelEnabled(true);
                this.updateCurrentItemState(BJobState.failed);
                throwable.printStackTrace();
                this.getLog().append(throwable);
                this.setBottomLabelText(lex.getText("ModuleContentWizard.FinishModuleContentChange.failed"));
            }
        }
    }

    private class ReinstallStep
    extends WizardStep {
        private int mode = 0;
        private BModuleContent lastFlag = null;
        private BIndentPane pane = new BIndentPane();

        public ReinstallStep() {
            BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.pane, 3.0, 3.0, 3.0, 3.0));
            bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
            bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
            this.setContent((BWidget)bScrollPane);
        }

        public String getStepName() {
            return "ReinstallStep";
        }

        public void enter() {
        }

        public boolean exit() {
            return true;
        }

        public boolean isSkipped() {
            try {
                int n;
                InstallScenario installScenario = ModuleContentWizardModel.this.getInstallScenario(ModuleContentWizardModel.this.getModuleContent());
                if (installScenario.getToInstall().length == 0 && installScenario.getUnmetDependencies().length == 0) {
                    return true;
                }
                if (ModuleContentWizardModel.this.getModuleContent() == this.lastFlag) {
                    return false;
                }
                this.pane.removeAll();
                this.pane.unindentAll();
                if (installScenario.getUnmetDependencies().length > 0) {
                    this.pane.add(LexiconText.make((String)"platDaemon", (String)"ModuleContentWizard.ReinstallStep.unavailableHeader"));
                    this.pane.indent();
                    for (n = 0; n < installScenario.getUnmetDependencies().length; ++n) {
                        this.pane.add(installScenario.getUnmetDependencies()[n].getPartName());
                    }
                    this.pane.unindent();
                }
                if (installScenario.getToInstall().length > 0) {
                    if (installScenario.getUnmetDependencies().length > 0) {
                        this.pane.add((BWidget)new BBox(0.0, 4.0));
                    }
                    this.pane.add(LexiconText.make((String)"platDaemon", (String)"ModuleContentWizard.ReinstallStep.reinstallHeader"));
                    this.pane.indent();
                    for (n = 0; n < installScenario.getToInstall().length; ++n) {
                        this.pane.add(installScenario.getToInstall()[n].getInstallableName());
                    }
                    this.pane.unindent();
                }
                this.mode = installScenario.getUnmetDependencies().length == 0 ? 5 : 1;
                this.lastFlag = ModuleContentWizardModel.this.getModuleContent();
                return false;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public int getMode() {
            return this.mode;
        }
    }

    private class ChooseModuleContentStep
    extends WizardStep
    implements EnumRadioGroup.EnumRadioGroupListener {
        private EnumRadioGroup group;
        private int mode = 0;

        public ChooseModuleContentStep() {
            BGridPane bGridPane = new BGridPane(1);
            bGridPane.setValign(BValign.top);
            bGridPane.setHalign(BHalign.left);
            bGridPane.add(null, (BValue)new BLabel(lex.getText("ModuleContentWizard.ChooseModuleContentStep.heading"), BHalign.left));
            this.group = new EnumRadioGroup((BWidget)bGridPane, new String[]{lex.getText("ModuleContent.doc"), lex.getText("ModuleContent.ui"), lex.getText("ModuleContent.runtime")}, (BEnum[])new BModuleContent[]{BModuleContent.doc, BModuleContent.ui, BModuleContent.runtime});
            this.group.addListener((EnumRadioGroup.EnumRadioGroupListener)this);
            BWidget[] bWidgetArray = this.group.getWidgets();
            for (int i = 0; i < bWidgetArray.length; ++i) {
                bGridPane.add(null, (BValue)bWidgetArray[i]);
            }
            this.setContent((BWidget)bGridPane);
        }

        public String getStepName() {
            return "ChooseModuleContentStep";
        }

        public void enter() {
            this.group.setValue((BEnum)ModuleContentWizardModel.this.getModuleContent());
        }

        public void enumSelected(BEnum bEnum) {
            try {
                InstallScenario installScenario = ModuleContentWizardModel.this.getInstallScenario((BModuleContent)bEnum);
                this.mode = installScenario.getToInstall().length > 0 || installScenario.getUnmetDependencies().length > 0 ? 2 : ((installScenario.getProcessingFlags() & 0x100000L) > 0L ? 4 : 0);
                ModuleContentWizardModel.this.update(this);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public int getMode() {
            return this.mode;
        }

        public boolean exit() {
            ModuleContentWizardModel.this.setModuleContent((BModuleContent)this.group.getValue());
            return true;
        }
    }

    public abstract class WizardStep {
        private BEdgePane contentPane = new BEdgePane(null, null, null, null, null);
        private BEdgePane widget = new BEdgePane((BWidget)new BWizardHeader(ModuleContentWizardModel.access$000(), ModuleContentWizardModel.access$100().getText("ModuleContentWizard.headerTitle"), ModuleContentWizardModel.access$100().getText("ModuleContentWizard." + this.getStepName() + ".desc")), null, null, null, (BWidget)new BBorderPane((BWidget)this.contentPane, 5.0, 10.0, 4.0, 10.0));
        private WizardStep priorStep = null;
        private WizardStep nextStep = null;

        public abstract String getStepName();

        public BWidget getWidget() {
            return this.widget;
        }

        protected void setContent(BWidget bWidget) {
            this.contentPane.setCenter(bWidget);
        }

        public int getMode() {
            return 0;
        }

        public int getNavMode() {
            WizardStep wizardStep;
            WizardStep wizardStep2;
            int n = 0;
            for (wizardStep2 = this.getPriorStep(); wizardStep2 != null && wizardStep2.isSkipped(); wizardStep2 = wizardStep2.getPriorStep()) {
            }
            if (wizardStep2 != null) {
                n |= 1;
            }
            for (wizardStep = this.getNextStep(); wizardStep != null && wizardStep.isSkipped(); wizardStep = wizardStep.getNextStep()) {
            }
            if (wizardStep != null) {
                n |= 2;
            }
            return n;
        }

        public WizardStep getPriorStep() {
            return this.priorStep;
        }

        public WizardStep getNextStep() {
            return this.nextStep;
        }

        public void setNextStep(WizardStep wizardStep) {
            this.nextStep = wizardStep;
        }

        public void enter() {
        }

        public boolean exit() {
            return true;
        }

        public void setPriorStep(WizardStep wizardStep) {
            this.priorStep = wizardStep;
        }

        public boolean cancel() {
            return true;
        }

        public boolean isSkipped() {
            return false;
        }
    }
}

