/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.platDaemon.ui.config.BDaemonBackupJob;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.platform.ui.util.LabelUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.job.BJobState;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BProgressBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;

public class DaemonBackupJobDialog
implements Runnable,
DaemonFileUtil.TransferStatus {
    private BDaemonBackupJob job;
    private InputStream in;
    private BCommandDialog dialog;
    private Context cx;
    private BIFile file;
    private BWidget owner;
    private BLabel jobStateLabel;
    private BLabel fileLabel;
    private DialogCommand detailsCommand;
    private JobWatcher watcher = null;
    private BProgressBar progress;
    private static final Lexicon lex = Lexicon.make((String)"platDaemon");
    public static final int DETAILS = 32;
    static final BImage messageIcon = BImage.make((String)"module://icons/x16/info.png");
    static final BImage unknownIcon = BImage.make((String)"module://icons/x16/job/unknown.png");
    static final BImage runningIcon = BImage.make((String)"module://icons/x16/job/running.png");
    static final BImage canceledIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    static final BImage successIcon = BImage.make((String)"module://icons/x16/job/success.png");
    static final BImage failedIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    static final String lexStatus = UiLexicon.bajaui.getText("status");
    static final String lexTimestamp = UiLexicon.bajaui.getText("timestamp");
    static final String lexMessage = UiLexicon.bajaui.getText("message");
    static final String lexDetails = UiLexicon.bajaui.getText("details");

    private DaemonBackupJobDialog(BWidget bWidget, BDaemonBackupJob bDaemonBackupJob, InputStream inputStream, BIFile bIFile, Context context) throws Exception {
        this.owner = bWidget;
        this.in = inputStream;
        this.job = bDaemonBackupJob;
        this.cx = context;
        this.file = bIFile;
        BEdgePane bEdgePane = new BEdgePane();
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setValign(BValign.top);
        bGridPane.setColumnGap(10.0);
        bGridPane.setRowGap(6.0);
        this.fileLabel = new BLabel(lex.getText("DaemonBackupJobDialog.file.text", new Object[]{bIFile.getFilePath().getBody(), DaemonFileUtil.fileSize((long)0L)}));
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"DaemonBackupJobDialog.file.label"), (BWidget)this.fileLabel, (boolean)true);
        this.jobStateLabel = new BLabel(DaemonBackupJobDialog.stateToIcon(bDaemonBackupJob.getJobState()), bDaemonBackupJob.getJobState().toString(context));
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((String)"platDaemon", (String)"DaemonBackupJobDialog.job.label"), (BWidget)this.jobStateLabel, (boolean)true);
        bEdgePane.setCenter((BWidget)bGridPane);
        BGridPane bGridPane2 = new BGridPane(1);
        bGridPane2.setColumnAlign(BHalign.fill);
        bGridPane2.setStretchColumn(0);
        this.progress = new BProgressBar();
        bGridPane2.add(null, (BValue)this.progress);
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bEdgePane);
        bConstrainedPane.setMinWidth(500.0);
        this.dialog = BCommandDialog.make((BWidget)bWidget, (String)lex.getText("DaemonBackupJobDialog.dlgTitle"), (boolean)true, (Object)new BBorderPane((BWidget)bConstrainedPane, 5.0, 5.0, 5.0, 5.0), (DialogCommand[])new DialogCommand[]{new CancelCommand(), this.detailsCommand = new DetailsCommand()}, null);
        this.dialog.setBoundsCenteredOnOwner();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void raise(BWidget bWidget, BRemoteDaemonPlatform bRemoteDaemonPlatform, BIFile bIFile, Context context) throws Exception {
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
        try {
            BDaemonBackupJob bDaemonBackupJob = new BDaemonBackupJob(bIFile, pipedOutputStream, bRemoteDaemonPlatform);
            DaemonBackupJobDialog daemonBackupJobDialog = new DaemonBackupJobDialog(bWidget, bDaemonBackupJob, pipedInputStream, bIFile, context);
            new Thread((Runnable)daemonBackupJobDialog, "DaemonBackupJobDialog").start();
            if (16 == daemonBackupJobDialog.open()) {
                if (daemonBackupJobDialog.watcher != null) {
                    daemonBackupJobDialog.watcher.stopWatcher();
                }
            } else {
                if (daemonBackupJobDialog.watcher != null) {
                    daemonBackupJobDialog.watcher.stopWatcher();
                }
                JobLog jobLog = JobLog.decode((String)bDaemonBackupJob.readLog().toString());
                BTable bTable = new BTable((TableModel)new JobLogTable(jobLog), (TableController)new JobLogController(jobLog));
                BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bTable);
                bConstrainedPane.setFixedSize(800.0, 400.0);
                BDialog.open((BWidget)bWidget, (String)lex.getText("DaemonBackupJobDialog.detailsCommand.dlgTitle"), (Object)bConstrainedPane, (int)1);
            }
        }
        finally {
            try {
                ((InputStream)pipedInputStream).close();
            }
            catch (Exception exception) {}
        }
    }

    public int open() {
        this.dialog.open();
        return this.dialog.getResult();
    }

    public void updateBytesWritten(long l) {
        this.fileLabel.setText(lex.getText("DaemonBackupJobDialog.file.text", new Object[]{this.file.getFilePath().getBody(), DaemonFileUtil.fileSize((long)l)}));
    }

    public boolean isCanceled() {
        try {
            BJobState bJobState = this.job.getJobState();
            return bJobState == BJobState.canceling || bJobState == BJobState.canceled || bJobState == BJobState.failed;
        }
        catch (Exception exception) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        OutputStream outputStream = null;
        this.watcher = null;
        try {
            outputStream = this.file.getOutputStream();
            this.job.submit(this.cx);
            this.watcher = new JobWatcher();
            this.watcher.start();
            DaemonFileUtil.pipe((InputStream)this.in, (OutputStream)outputStream, (DaemonFileUtil.TransferStatus)this);
            this.progress.setValue(100.0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
            this.dialog.replaceCommand(0, DialogCommand.makeClose((BWidget)this.owner));
        }
    }

    static BImage itemToIcon(JobLogItem jobLogItem) {
        switch (jobLogItem.getId()) {
            case 1: {
                return runningIcon;
            }
            case 2: {
                return canceledIcon;
            }
            case 3: {
                return successIcon;
            }
            case 4: {
                return failedIcon;
            }
        }
        return messageIcon;
    }

    static BImage stateToIcon(BJobState bJobState) {
        switch (bJobState.getOrdinal()) {
            case 1: {
                return runningIcon;
            }
            case 2: {
                return canceledIcon;
            }
            case 3: {
                return canceledIcon;
            }
            case 4: {
                return successIcon;
            }
            case 5: {
                return failedIcon;
            }
        }
        return unknownIcon;
    }

    private class JobWatcher
    extends Thread {
        private boolean stopped = false;

        private JobWatcher() {
        }

        public void run() {
            BJobState bJobState = null;
            try {
                while (!this.stopped) {
                    if (DaemonBackupJobDialog.this.job.getJobState() != bJobState) {
                        bJobState = DaemonBackupJobDialog.this.job.getJobState();
                        DaemonBackupJobDialog.this.jobStateLabel.setText(bJobState.toString(DaemonBackupJobDialog.this.cx));
                        DaemonBackupJobDialog.this.jobStateLabel.setImage(DaemonBackupJobDialog.stateToIcon(bJobState));
                    }
                    if (bJobState.isComplete()) {
                        DaemonBackupJobDialog.this.dialog.replaceCommand(0, DialogCommand.makeClose((BWidget)DaemonBackupJobDialog.this.owner));
                        DaemonBackupJobDialog.this.progress.setValue(100.0);
                        DaemonBackupJobDialog.this.detailsCommand.setEnabled(true);
                        this.stopWatcher();
                        return;
                    }
                    DaemonBackupJobDialog.this.progress.setValue((double)DaemonBackupJobDialog.this.job.getProgress());
                    Thread.sleep(500L);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void stopWatcher() {
            this.stopped = true;
        }
    }

    private static class JobLogController
    extends TableController {
        JobLog log;

        JobLogController(JobLog jobLog) {
            this.log = jobLog;
        }

        public void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            JobLogItem jobLogItem = this.log.getItem(n);
            BTextEditor bTextEditor = new BTextEditor(jobLogItem.toString(), false);
            BTextEditorPane bTextEditorPane = new BTextEditorPane(bTextEditor, 40, 80);
            BDialog.open((BWidget)this.getTable(), (String)lex.getText("DaemonBackupJobDialog.logDetails.dlgTitle"), (Object)bTextEditorPane, (int)1);
        }
    }

    private static class JobLogTable
    extends TableModel {
        JobLogItem[] items;
        String[] messages;
        String[] details;

        JobLogTable(JobLog jobLog) {
            this.items = jobLog.getItems();
            this.messages = new String[this.items.length];
            this.details = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                this.messages[i] = this.str(this.items[i].getMessage());
                this.details[i] = this.str(this.items[i].getDetails());
            }
        }

        String str(String string) {
            if (string == null) {
                return "";
            }
            int n = string.indexOf(10);
            if (n < 0) {
                return string;
            }
            return string.substring(0, n);
        }

        public int getRowCount() {
            return this.items.length;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return lexStatus;
                }
                case 1: {
                    return lexTimestamp;
                }
                case 2: {
                    return lexMessage;
                }
                case 3: {
                    return lexDetails;
                }
            }
            return "???";
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.items[n].getIdString();
                }
                case 1: {
                    return this.items[n].getTimestamp();
                }
                case 2: {
                    return this.messages[n];
                }
                case 3: {
                    return this.details[n];
                }
            }
            return "???";
        }

        public Object getSubject(int n) {
            return this.items[n];
        }

        public BObject export(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.export(this.items[n].getIdString());
                }
                case 1: {
                    return this.items[n].getTimestamp();
                }
                case 2: {
                    return this.export(this.items[n].getMessage());
                }
                case 3: {
                    return this.export(this.items[n].getDetails());
                }
            }
            return BString.DEFAULT;
        }

        BString export(String string) {
            if (string == null) {
                return BString.DEFAULT;
            }
            return BString.make((String)string);
        }

        public BImage getRowIcon(int n) {
            return DaemonBackupJobDialog.itemToIcon(this.items[n]);
        }
    }

    private class CancelCommand
    extends DialogCommand {
        public CancelCommand() {
            super(DaemonBackupJobDialog.this.owner, 2, UiLexicon.bajaui.getText("dialog.cancel"), null, null, null);
        }

        public CommandArtifact doInvoke() throws Exception {
            DaemonBackupJobDialog.this.job.cancel();
            return null;
        }
    }

    private class DetailsCommand
    extends DialogCommand {
        public DetailsCommand() {
            super(DaemonBackupJobDialog.this.owner, 32, lex.getText("DaemonBackupJobDialog.detailsCommand.label"), null, null, null);
            this.setEnabled(false);
        }
    }
}

