/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.config;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.installable.BDistributionFile;
import com.tridium.platDaemon.ui.config.DaemonBackupJobDialog;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.FavoriteDirectory;
import com.tridium.util.TimeFormat;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.util.Lexicon;

public class BackupDistCommand
extends Command {
    private BDaemonPlatform platform;
    private Context cx;
    private StringBuffer fileName;

    public BackupDistCommand(BWidget bWidget, BDaemonPlatform bDaemonPlatform, Context context) {
        super(bWidget, Lexicon.make((String)"platDaemon", (Context)context), "BackupDistCommand");
        this.cx = context;
        this.platform = bDaemonPlatform;
        this.fileName = new StringBuffer("backup_");
        this.fileName.append(bDaemonPlatform.getDaemonSession().getHost().getHostname());
        this.fileName.append("_");
        this.fileName.append(TimeFormat.format((BAbsTime)BAbsTime.now(), (String)"YYMMDD_HHmm"));
        this.fileName.append(".dist");
    }

    public CommandArtifact doInvoke() {
        try {
            BFileChooser bFileChooser = BFileChooser.makeSave((BWidget)this.getOwner());
            bFileChooser.setCurrentDirectory(this.loadDirectoryOrd());
            bFileChooser.setDefaultFileName(this.fileName.toString());
            bFileChooser.addFilter((IFileFilter)new ExtFileFilter(BDistributionFile.TYPE.getDisplayName(this.cx), "dist"));
            BOrd bOrd = bFileChooser.show();
            this.saveDirectoryOrd(bFileChooser.getCurrentDirectory());
            if (bOrd != null) {
                DaemonBackupJobDialog.raise(this.getOwner(), (BRemoteDaemonPlatform)this.platform, (BIFile)bOrd.get(), this.cx);
            }
        }
        catch (Exception exception) {
            CommandUtil.error((Command)this, (Throwable)exception);
        }
        return null;
    }

    protected BOrd loadDirectoryOrd() {
        return FavoriteDirectory.loadByOrd((String)"platDaemon", (String)"backupDistDirectory", (FilePath)new FilePath("!backups"));
    }

    protected void saveDirectoryOrd(BOrd bOrd) {
        FavoriteDirectory.saveOrd((String)"platDaemon", (String)"backupDistDirectory", (BOrd)bOrd);
    }
}

