/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.platform.ui.tcpip.BTcpIpHostEditor;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.ui.theme.Theme;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;

public class TcpIpStep
extends CommissioningWizardStep {
    private BTcpIpHostEditor editor = new BTcpIpHostEditor();
    static /* synthetic */ Class class$com$tridium$platform$tcpip$BTcpIpAdapterSettings;

    public TcpIpStep(CommissioningWizardModel commissioningWizardModel) {
        super(commissioningWizardModel);
        BScrollPane bScrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.editor));
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BButtonPane bButtonPane = new BButtonPane(new Command[]{new UndoChanges()});
        this.setContent((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)bButtonPane, 6.0, 0.0, 6.0, 0.0), null, null, (BWidget)bScrollPane));
        this.editor.setReadonly(false);
    }

    public String getStepName() {
        return "tcpip";
    }

    public String getSectionName() {
        return "tcpip";
    }

    public void enter() {
        if (this.wizardModel.tcpIpSettings == null) {
            try {
                this.wizardModel.originalTcpIpSettings = new BTcpIpHostSettings();
                TcpUtil.loadFromSession((BTcpIpHostSettings)this.wizardModel.originalTcpIpSettings, (BDaemonSession)this.wizardModel.daemonSession);
                this.wizardModel.tcpIpSettings = (BTcpIpHostSettings)this.wizardModel.originalTcpIpSettings.newCopy();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
        this.editor.loadValue((BObject)((BTcpIpHostSettings)this.wizardModel.tcpIpSettings.newCopy()));
    }

    public boolean exit(int n) {
        if (n == 2) {
            try {
                this.wizardModel.hostFileDirty = this.editor.isHostFileDirty();
                BTcpIpHostSettings bTcpIpHostSettings = (BTcpIpHostSettings)this.editor.saveValue();
                BHostProperties bHostProperties = this.wizardModel.daemonSession.getHostProperties();
                if (bHostProperties.getOsName().startsWith("win") && bTcpIpHostSettings.getHostName().length() > 15) {
                    throw new CannotSaveException(Lexicon.make((String)"platform").getText("TcpIpHostSettings.invalidHostName"));
                }
                if (bHostProperties.getVmVendor().equalsIgnoreCase("IBM Corporation") && bTcpIpHostSettings.getNiagaraUsesIpv6()) {
                    throw new CannotSaveException(Lexicon.make((String)"platform").getText("TcpIpHostSettings.cannotUseIPv6"));
                }
                if (bHostProperties.getOsName().startsWith("qnx")) {
                    int n2 = 0;
                    SlotCursor slotCursor = bTcpIpHostSettings.getAdapters().getProperties();
                    while (slotCursor.next(class$com$tridium$platform$tcpip$BTcpIpAdapterSettings == null ? TcpIpStep.class$("com.tridium.platform.tcpip.BTcpIpAdapterSettings") : class$com$tridium$platform$tcpip$BTcpIpAdapterSettings)) {
                        BTcpIpAdapterSettings bTcpIpAdapterSettings = (BTcpIpAdapterSettings)slotCursor.get();
                        if (!bTcpIpAdapterSettings.getIsDhcpEnabled()) continue;
                        ++n2;
                    }
                    if (n2 > 1) {
                        throw new CannotSaveException(Lexicon.make((String)"platform").getText("TcpIpHostSettings.multipleDhcpAdapters"));
                    }
                }
                this.wizardModel.tcpIpSettings = bTcpIpHostSettings;
                this.wizardModel.updateTcpIpSettings = true;
            }
            catch (CannotSaveException cannotSaveException) {
                if (!cannotSaveException.isSilent()) {
                    BDialog.error((BWidget)this.wizardModel.owner, (Object)((Object)cannotSaveException));
                }
                this.editor.setModified();
                return false;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
        return true;
    }

    public int getMode() {
        return 3;
    }

    public boolean isSkipped() {
        return this.wizardModel.skipTcp;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class UndoChanges
    extends Command {
        public UndoChanges() {
            super(TcpIpStep.this.wizardModel.owner, Lexicon.make((String)"platDaemon"), "CommissioningWizard.tcpStep.revert");
        }

        public CommandArtifact doInvoke() {
            TcpIpStep.this.editor.loadValue((BObject)TcpIpStep.this.wizardModel.originalTcpIpSettings);
            return null;
        }
    }
}

