/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platDaemon.ui.stationtransfer.BStationContentEnum;
import com.tridium.platDaemon.ui.stationtransfer.BStationDispositionEnum;
import com.tridium.platDaemon.ui.stationtransfer.StationNameController;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BDirectoryTree;
import com.tridium.platform.ui.util.BTreeCascadePolicy;
import com.tridium.platform.ui.util.EnumRadioGroup;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.ui.theme.Theme;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.gx.BInsets;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BBorder;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.tree.TreeModel;
import javax.baja.util.LexiconText;

public class StationStep
extends CommissioningWizardStep {
    private boolean stepInitialized = false;
    private StationListModel listModel;
    private BTextField targetNameTextField;
    private BCheckBox startStationCheckBox;
    private BCheckBox autoStartCheckBox;
    private BStationSurrogate remoteStation = null;
    static /* synthetic */ Class class$javax$baja$file$BDirectory;

    public StationStep(CommissioningWizardModel commissioningWizardModel) {
        super(commissioningWizardModel);
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setHalign(BHalign.left);
        bGridPane.setValign(BValign.top);
        BGridPane bGridPane2 = new BGridPane(2);
        bGridPane2.setValign(BValign.top);
        bGridPane2.setRowAlign(BValign.top);
        bGridPane2.setHalign(BHalign.left);
        BListDropDown bListDropDown = new BListDropDown();
        this.listModel = new StationListModel();
        bListDropDown.getList().setModel((ListModel)this.listModel);
        bListDropDown.getList().setMultipleSelection(false);
        bListDropDown.getList().setController((ListController)new StationListController(this));
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane2, (LexiconText)this.getLexiconText("CommissioningWizard.stationStep.chooseStation"), (BWidget)bListDropDown);
        this.targetNameTextField = new BTextField("", 30, false);
        LabelUtil.addLabelWidgetPair((BGridPane)bGridPane2, (LexiconText)this.getLexiconText("CommissioningWizard.stationStep.targetStationName"), (BWidget)this.targetNameTextField);
        bGridPane.add(null, (BValue)bGridPane2);
        bGridPane.add(null, (BValue)new BBox(0.0, 5.0));
        this.startStationCheckBox = new BCheckBox(lex.getText("StationCopier.StartStationStep.start.description"));
        bGridPane.add(null, (BValue)this.startStationCheckBox);
        this.autoStartCheckBox = new BCheckBox(lex.getText("StationCopier.StartStationStep.autoStart.description"));
        bGridPane.add(null, (BValue)this.autoStartCheckBox);
        this.autoStartCheckBox.setEnabled(false);
        this.startStationCheckBox.setEnabled(false);
        this.targetNameTextField.setModel((TextModel)new ModeControlModel(this));
        this.targetNameTextField.setController((TextController)new StationNameController());
        this.setContent((BWidget)new BEdgePane((BWidget)new BLabel(lex.getText("CommissioningWizard.stationStep.header"), BHalign.left), null, null, null, (BWidget)new BBorderPane((BWidget)bGridPane, 4.0, 0.0, 0.0, 0.0)));
        ContentStep contentStep = new ContentStep(commissioningWizardModel);
        this.nextStep = contentStep;
        contentStep.priorStep = this;
        DetailsStep detailsStep = new DetailsStep(commissioningWizardModel);
        contentStep.nextStep = detailsStep;
        detailsStep.priorStep = contentStep;
        DispositionStep dispositionStep = new DispositionStep(commissioningWizardModel);
        detailsStep.nextStep = dispositionStep;
        dispositionStep.priorStep = detailsStep;
        DeleteStep deleteStep = new DeleteStep(commissioningWizardModel);
        dispositionStep.nextStep = deleteStep;
        deleteStep.priorStep = dispositionStep;
        this.lastStep = deleteStep;
    }

    public String getStepName() {
        return "stationStep";
    }

    public String getSectionName() {
        return "station";
    }

    public void enter() {
        this.initStep();
        int n = this.listModel.indexOfDirectory(this.wizardModel.stationDir);
        if (n >= 0) {
            this.listModel.getList().setSelectedIndex(n);
        } else {
            this.listModel.getList().getSelection().deselectAll();
        }
        this.targetNameTextField.setEditable(n > 0);
        if (this.wizardModel.targetStationName == null) {
            this.targetNameTextField.setText("");
        } else {
            this.targetNameTextField.setText(this.wizardModel.targetStationName);
        }
        this.autoStartCheckBox.setSelected(this.wizardModel.autoStart);
        if (this.startStationCheckBox.isEnabled()) {
            this.startStationCheckBox.setSelected(this.wizardModel.startStation);
        } else {
            this.startStationCheckBox.setSelected(false);
        }
    }

    public void setStationName(String string) throws Exception {
        if (string == null) {
            this.remoteStation = null;
            this.targetNameTextField.setEditable(false);
            this.targetNameTextField.setText("");
            this.autoStartCheckBox.setEnabled(false);
            this.startStationCheckBox.setEnabled(false);
        } else {
            this.remoteStation = BStationSurrogate.make((BDaemonSession)this.wizardModel.daemonSession, (String)string);
            this.targetNameTextField.setText(string);
            this.targetNameTextField.setEditable(true);
            this.autoStartCheckBox.setEnabled(true);
            this.autoStartCheckBox.setSelected(this.wizardModel.autoStart);
            if (this.wizardModel.restartEnabled) {
                this.startStationCheckBox.setEnabled(true);
                this.startStationCheckBox.setSelected(this.wizardModel.startStation);
            } else {
                this.startStationCheckBox.setEnabled(false);
                this.startStationCheckBox.setSelected(false);
            }
        }
    }

    public boolean exit(int n) {
        try {
            BDirectoryTree.DirectoryTreeNode directoryTreeNode;
            BDirectoryTree.DirectoryTreeNode directoryTreeNode2;
            BDirectoryTree.DirectoryTreeNode directoryTreeNode3;
            if (this.listModel.getList().getSelectedIndex() <= 0) {
                this.wizardModel.stationDir = null;
                this.wizardModel.targetStationName = null;
                this.wizardModel.localStationBogLock = null;
                this.wizardModel.stationSurrogate = null;
                return true;
            }
            this.wizardModel.stationDir = this.listModel.getStationDirectory(this.listModel.getList().getSelectedIndex());
            this.wizardModel.targetStationName = this.targetNameTextField.getText();
            this.wizardModel.stationSurrogate = this.remoteStation;
            this.wizardModel.autoStart = this.autoStartCheckBox.isSelected();
            this.wizardModel.startStation = this.startStationCheckBox.isSelected();
            this.wizardModel.directoryTreeModel = new BDirectoryTree.DirectoryTreeModel();
            this.wizardModel.directoryTreeModel.setRootDirectory((BIDirectory)this.wizardModel.stationDir);
            BDirectoryTree.DirectoryTreeNode directoryTreeNode4 = (BDirectoryTree.DirectoryTreeNode)((BDirectoryTree.DirectoryTreeNode)this.wizardModel.directoryTreeModel.getRoot(0)).getChild("history");
            if (directoryTreeNode4 != null) {
                directoryTreeNode4.setChecked(false, BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
                directoryTreeNode4.setCheckEnabled(false, true);
                directoryTreeNode4.setExpanded(false);
            }
            if ((directoryTreeNode3 = (BDirectoryTree.DirectoryTreeNode)((BDirectoryTree.DirectoryTreeNode)this.wizardModel.directoryTreeModel.getRoot(0)).getChild("alarm")) != null) {
                directoryTreeNode3.setChecked(false, BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
                directoryTreeNode3.setCheckEnabled(false, true);
                directoryTreeNode3.setExpanded(false);
            }
            if ((directoryTreeNode2 = (BDirectoryTree.DirectoryTreeNode)((BDirectoryTree.DirectoryTreeNode)this.wizardModel.directoryTreeModel.getRoot(0)).getChild("jobs")) != null) {
                directoryTreeNode2.setChecked(false, BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
                directoryTreeNode2.setCheckEnabled(false, true);
                directoryTreeNode2.setExpanded(false);
            }
            if ((directoryTreeNode = (BDirectoryTree.DirectoryTreeNode)((BDirectoryTree.DirectoryTreeNode)this.wizardModel.directoryTreeModel.getRoot(0)).getChild("dataRecovery")) != null) {
                directoryTreeNode.setChecked(false, BTreeCascadePolicy.always, BTreeCascadePolicy.never, false);
                directoryTreeNode.setCheckEnabled(false, true);
                directoryTreeNode.setExpanded(false);
            }
            if (log.isTraceOn()) {
                int n2;
                StringBuffer stringBuffer = new StringBuffer();
                for (n2 = 0; n2 < this.fileExcludePatterns.length; ++n2) {
                    stringBuffer.append(this.fileExcludePatterns[n2].getPattern()).append(' ');
                }
                log.trace("Excluding file patterns: \"" + stringBuffer.toString() + "\" in commissioning wizard station step");
                stringBuffer = new StringBuffer();
                for (n2 = 0; n2 < this.directoryExcludePatterns.length; ++n2) {
                    stringBuffer.append(this.directoryExcludePatterns[n2].getPattern()).append(' ');
                }
                log.trace("Excluding directory patterns: \"" + stringBuffer.toString() + "\" in commissioning wizard station step");
            }
            this.wizardModel.directoryTreeModel.setDirectoryStates((BDirectoryTree.DirectoryTreeNode)this.wizardModel.directoryTreeModel.getRoot(0), this.directoryExcludePatterns, false, false, false);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        return true;
    }

    public int getMode() {
        if (this.listModel.getList().getSelectedIndex() == 0 || this.listModel.getList().getSelectedIndex() > 0 && this.targetNameTextField.getText().trim().length() > 0) {
            return 3;
        }
        return 1;
    }

    public boolean isSkipped() {
        return this.wizardModel.skipStation;
    }

    private void initStep() {
        if (!this.stepInitialized) {
            try {
                BDaemonDirectoryStore bDaemonDirectoryStore = BDaemonDirectoryStore.make((BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace(), (FilePath)new FilePath("!stations"));
                if (bDaemonDirectoryStore == null) {
                    DaemonFileUtil.transfer((BDaemonSession)this.wizardModel.daemonSession, (FileTransferMessage)FileTransferMessage.makeMkDir((FilePath)new FilePath("!stations"), (BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace()), null, null);
                    bDaemonDirectoryStore = BDaemonDirectoryStore.make((BDaemonFileSpace)this.wizardModel.daemonSession.getFileSpace(), (FilePath)new FilePath("!stations"));
                }
                this.wizardModel.targetStationsRoot = new BDirectory((BIFileStore)bDaemonDirectoryStore);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
            this.stepInitialized = true;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class RemoteStationListSelection
    extends ListSelection {
        private CommissioningWizardStep step;

        public RemoteStationListSelection(CommissioningWizardStep commissioningWizardStep) {
            this.step = commissioningWizardStep;
        }

        public void select(int n, boolean bl) {
            super.select(n, bl);
            this.step.wizardModel.update(this.step.getMode());
        }

        public void select(int n, int n2, boolean bl) {
            super.select(n, n2, bl);
            this.step.wizardModel.update(this.step.getMode());
        }

        public void select(int[] nArray) {
            super.select(nArray);
            this.step.wizardModel.update(this.step.getMode());
        }

        public void deselect(int n) {
            super.deselect(n);
            this.step.wizardModel.update(this.step.getMode());
        }

        public void deselectAll() {
            super.deselectAll();
            this.step.wizardModel.update(this.step.getMode());
        }
    }

    private static class RemoteStationListModel
    extends ListModel {
        BStationSurrogate[] stations;

        public RemoteStationListModel(CommissioningWizardModel commissioningWizardModel) {
            Array array = new Array((Object[])commissioningWizardModel.getSurrogates());
            array = array.filter(new IFilter(){

                public boolean accept(Object object) {
                    return object instanceof BStationSurrogate;
                }
            });
            this.stations = new BStationSurrogate[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                this.stations[i] = (BStationSurrogate)array.get(i);
            }
        }

        public Object getItem(int n) {
            return this.getStation(n).getStationName();
        }

        public BStationSurrogate getStation(int n) {
            return this.stations[n];
        }

        public int indexOfStation(BStationSurrogate bStationSurrogate) {
            if (bStationSurrogate == null) {
                return -1;
            }
            for (int i = 0; i < this.stations.length; ++i) {
                if (!bStationSurrogate.getStationName().equals(this.stations[i].getStationName())) continue;
                return i;
            }
            return -1;
        }

        public int getItemCount() {
            return this.stations.length;
        }
    }

    private static class DeleteStep
    extends CommissioningWizardStep {
        private RemoteStationListModel listModel = null;
        private boolean stepInitialized = false;

        public DeleteStep(CommissioningWizardModel commissioningWizardModel) {
            super(commissioningWizardModel);
        }

        public String getStepName() {
            return "stationDeleteStep";
        }

        public String getSectionName() {
            return "station";
        }

        public void enter() {
            this.initStep();
            if (this.listModel.getList() != null) {
                this.listModel.getSelection().deselectAll();
                for (int i = 0; i < this.wizardModel.stationsToDelete.size(); ++i) {
                    int n = this.listModel.indexOfStation((BStationSurrogate)this.wizardModel.stationsToDelete.get(i));
                    if (n < 0) continue;
                    this.listModel.getList().getSelection().select(n);
                }
            }
        }

        public boolean exit(int n) {
            this.wizardModel.stationsToDelete.clear();
            if (this.listModel.getItemCount() > 1) {
                int[] nArray = this.listModel.getList().getSelectedIndices();
                for (int i = 0; i < nArray.length; ++i) {
                    this.wizardModel.stationsToDelete.add((Object)this.listModel.getStation(nArray[i]));
                }
            } else if (this.listModel.getItemCount() == 1) {
                this.wizardModel.stationsToDelete.add((Object)this.listModel.getStation(0));
            }
            return true;
        }

        public int getMode() {
            this.initStep();
            if (this.listModel.getItemCount() < 2 || this.listModel.getList().getSelectedIndex() >= 0) {
                return 3;
            }
            return 1;
        }

        public boolean isSkipped() {
            if (this.wizardModel.skipStation || this.wizardModel.targetStationName == null) {
                this.wizardModel.stationsToDelete.clear();
                return true;
            }
            int n = this.wizardModel.getSurrogates().length;
            int n2 = this.wizardModel.daemonSession.getHostProperties().getMaxStations();
            BDirectory bDirectory = (BDirectory)this.wizardModel.targetStationsRoot.getNavChild(this.wizardModel.targetStationName);
            if (bDirectory == null) {
                ++n;
            }
            return n <= n2;
        }

        private void initStep() {
            if (!this.stepInitialized) {
                this.listModel = new RemoteStationListModel(this.wizardModel);
                if (this.listModel.getItemCount() > 1) {
                    BScrollPane bScrollPane = new BScrollPane((BWidget)new BList((ListModel)this.listModel));
                    this.listModel.getList().setSelection((ListSelection)new RemoteStationListSelection(this));
                    bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
                    bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                    BLabel bLabel = new BLabel(BDialog.WARNING_ICON, lex.getText("CommissioningWizard.stationDeleteStep.chooseHeader", new Object[]{String.valueOf(this.wizardModel.daemonSession.getHostProperties().getMaxStations())}));
                    bLabel.setHalign(BHalign.left);
                    this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bLabel, 0.0, 0.0, 5.0, 0.0), null, null, null, (BWidget)new BBorderPane((BWidget)bScrollPane, BBorder.inset, BInsets.DEFAULT)));
                } else if (this.listModel.getItemCount() == 1) {
                    BLabel bLabel = new BLabel(BDialog.WARNING_ICON, lex.getText("CommissioningWizard.stationDeleteStep.deleteHeader", new Object[]{this.listModel.getStation(0).getStationName()}));
                    bLabel.setHalign(BHalign.left);
                    this.setContent((BWidget)new BEdgePane((BWidget)bLabel, null, null, null, null));
                }
                this.stepInitialized = true;
            }
        }
    }

    private static class DispositionStep
    extends CommissioningWizardStep {
        private EnumRadioGroup group;

        public DispositionStep(CommissioningWizardModel commissioningWizardModel) {
            super(commissioningWizardModel);
        }

        public String getStepName() {
            return "stationDispositionStep";
        }

        public String getSectionName() {
            return "station";
        }

        public void enter() {
            BGridPane bGridPane = new BGridPane(1);
            bGridPane.setValign(BValign.top);
            bGridPane.setHalign(BHalign.left);
            this.group = new EnumRadioGroup(this.wizardModel.owner, new String[]{lex.getText("StationCopier.clean.fullDesc", new Object[]{this.wizardModel.targetStationName}), BStationDispositionEnum.replaceDuplicates.getDisplayTag(null)}, (BEnum[])new BFrozenEnum[]{BStationDispositionEnum.clean, BStationDispositionEnum.replaceDuplicates}, (BEnum)this.wizardModel.stationDisposition);
            BWidget[] bWidgetArray = this.group.getWidgets();
            for (int i = 0; i < bWidgetArray.length; ++i) {
                bGridPane.add(null, (BValue)bWidgetArray[i]);
            }
            this.setContent((BWidget)bGridPane);
        }

        public boolean exit(int n) {
            this.wizardModel.stationDisposition = (BStationDispositionEnum)this.group.getValue();
            return true;
        }

        public boolean isSkipped() {
            return this.wizardModel.skipStation || !this.targetDirectoryExists();
        }

        public int getMode() {
            return 3;
        }

        private boolean targetDirectoryExists() {
            try {
                BDirectory bDirectory = (BDirectory)this.wizardModel.targetStationsRoot.getNavChild(this.wizardModel.targetStationName);
                return bDirectory != null;
            }
            catch (Exception exception) {
                log.error("error checking for station directory existance", (Throwable)exception);
                return false;
            }
        }
    }

    private static class DetailsStep
    extends CommissioningWizardStep {
        private BEdgePane rightPane = new BEdgePane();
        private BDirectoryTree tree = null;

        public DetailsStep(CommissioningWizardModel commissioningWizardModel) {
            super(commissioningWizardModel);
            BLabel bLabel = new BLabel(lex.getText("StationCopier.DetailsStep.description"));
            bLabel.setHalign(BHalign.left);
            this.rightPane.setTop((BWidget)new BBorderPane((BWidget)bLabel, 0.0, 0.0, 8.0, 0.0));
            this.setContent((BWidget)this.rightPane);
        }

        public String getStepName() {
            return "stationDetailsStep";
        }

        public String getSectionName() {
            return "station";
        }

        public void enter() {
            if (this.tree == null) {
                this.tree = new BDirectoryTree((TreeModel)this.wizardModel.directoryTreeModel);
                this.rightPane.setCenter((BWidget)new BScrollPane((BWidget)this.tree));
            } else if (this.wizardModel.directoryTreeModel != this.tree.getModel()) {
                this.tree.setModel((TreeModel)this.wizardModel.directoryTreeModel);
            }
            this.getWidget().relayout();
        }

        public boolean exit(int n) {
            return true;
        }

        public boolean isSkipped() {
            if (this.wizardModel.skipStation) {
                return true;
            }
            if (this.wizardModel.stationContent != BStationContentEnum.selectedDirectories) {
                return true;
            }
            try {
                BIFile[] bIFileArray = this.wizardModel.stationDir.listFiles();
                for (int i = 0; i < bIFileArray.length; ++i) {
                    if (!bIFileArray[i].isDirectory()) continue;
                    return false;
                }
            }
            catch (Exception exception) {
                log.error("error checking for subdirectories", (Throwable)exception);
            }
            return true;
        }

        public int getMode() {
            return 3;
        }
    }

    private static class ContentStep
    extends CommissioningWizardStep {
        private EnumRadioGroup group;
        private boolean hasSetDispositionDefault = false;

        public ContentStep(CommissioningWizardModel commissioningWizardModel) {
            super(commissioningWizardModel);
        }

        public String getStepName() {
            return "stationContentStep";
        }

        public String getSectionName() {
            return "station";
        }

        public void enter() {
            BGridPane bGridPane = new BGridPane(1);
            bGridPane.setValign(BValign.top);
            bGridPane.setHalign(BHalign.left);
            BStationContentEnum bStationContentEnum = this.wizardModel.stationContent;
            if (this.sourceHasSubdirs()) {
                this.group = new EnumRadioGroup(this.wizardModel.owner, (BEnum[])new BFrozenEnum[]{BStationContentEnum.selectedDirectories, BStationContentEnum.everything, BStationContentEnum.configOnly}, (BEnum)bStationContentEnum, null);
            } else {
                if (bStationContentEnum == BStationContentEnum.selectedDirectories) {
                    bStationContentEnum = BStationContentEnum.everything;
                }
                this.group = new EnumRadioGroup(this.wizardModel.owner, (BEnum[])new BFrozenEnum[]{BStationContentEnum.everything, BStationContentEnum.configOnly}, (BEnum)bStationContentEnum, null);
            }
            BWidget[] bWidgetArray = this.group.getWidgets();
            for (int i = 0; i < bWidgetArray.length; ++i) {
                bGridPane.add(null, (BValue)bWidgetArray[i]);
            }
            this.setContent((BWidget)bGridPane);
            bGridPane.relayout();
        }

        public boolean exit(int n) {
            this.wizardModel.stationContent = (BStationContentEnum)this.group.getValue();
            if (!this.hasSetDispositionDefault) {
                this.hasSetDispositionDefault = true;
                if (this.group.getValue() == BStationContentEnum.everything) {
                    this.wizardModel.stationDisposition = BStationDispositionEnum.clean;
                }
            }
            return true;
        }

        public boolean isSkipped() {
            return this.wizardModel.skipStation || this.wizardModel.stationDir == null || this.configBogOnly();
        }

        public int getMode() {
            return 3;
        }

        private boolean configBogOnly() {
            try {
                BIFile[] bIFileArray = this.wizardModel.stationDir.listFiles();
                for (int i = 0; i < bIFileArray.length; ++i) {
                    if (!(bIFileArray[i].isDirectory() ? !this.ignoreDirectory((BDirectory)bIFileArray[i]) : !bIFileArray[i].getFileName().equals("config.bog") && !this.ignoreFile(bIFileArray[i]))) continue;
                    return false;
                }
            }
            catch (Exception exception) {
                log.error("error checking for station directory existance", (Throwable)exception);
            }
            return true;
        }

        private boolean ignoreFile(BIFile bIFile) {
            for (int i = 0; i < this.fileExcludePatterns.length; ++i) {
                if (!this.fileExcludePatterns[i].accept(bIFile)) continue;
                return true;
            }
            return false;
        }

        private boolean ignoreDirectory(BDirectory bDirectory) {
            for (int i = 0; i < this.directoryExcludePatterns.length; ++i) {
                if (!this.directoryExcludePatterns[i].accept((BIFile)bDirectory)) continue;
                return true;
            }
            return false;
        }

        private boolean sourceHasSubdirs() {
            try {
                BIFile[] bIFileArray = this.wizardModel.stationDir.listFiles();
                for (int i = 0; i < bIFileArray.length; ++i) {
                    if (!bIFileArray[i].isDirectory()) continue;
                    return true;
                }
                return false;
            }
            catch (Exception exception) {
                log.error("error checking for station directory existance", (Throwable)exception);
                return false;
            }
        }
    }

    private static class ModeControlModel
    extends TextModel {
        private CommissioningWizardStep step;

        public ModeControlModel(CommissioningWizardStep commissioningWizardStep) {
            this.step = commissioningWizardStep;
        }

        protected void textModified() {
            this.step.wizardModel.update(this.step.getMode());
        }
    }

    private static class StationListModel
    extends ListModel {
        private Array stationDirs;

        public StationListModel() {
            BDirectory bDirectory = (BDirectory)BFileSystem.INSTANCE.findFile(new FilePath("!stations"));
            this.stationDirs = new Array(class$javax$baja$file$BDirectory == null ? (class$javax$baja$file$BDirectory = StationStep.class$("javax.baja.file.BDirectory")) : class$javax$baja$file$BDirectory);
            if (bDirectory != null) {
                BIFile[] bIFileArray = bDirectory.listFiles();
                for (int i = 0; i < bIFileArray.length; ++i) {
                    BINavNode bINavNode;
                    if (!(bIFileArray[i] instanceof BDirectory) || (bINavNode = bIFileArray[i].getNavChild("config.bog")) == null) continue;
                    this.stationDirs.add((Object)bIFileArray[i]);
                }
            }
        }

        public int indexOfDirectory(BDirectory bDirectory) {
            if (bDirectory == null) {
                return 0;
            }
            int n = this.stationDirs.indexOf((Object)bDirectory);
            if (n >= 0) {
                return n + 1;
            }
            return -1;
        }

        public int getItemCount() {
            return this.stationDirs.size() + 1;
        }

        public BDirectory getStationDirectory(int n) {
            if (n == 0) {
                return null;
            }
            return (BDirectory)this.stationDirs.get(n - 1);
        }

        public Object getItem(int n) {
            if (n == 0) {
                return lex.getText("CommissioningWizard.stationStep.noStation");
            }
            return this.getStationDirectory(n).getFileName();
        }
    }

    private static class StationListController
    extends ListController {
        private StationStep step;

        StationListController(StationStep stationStep) {
            this.step = stationStep;
        }

        protected void handleEnter(BKeyEvent bKeyEvent) {
            super.handleEnter(bKeyEvent);
            this.updateEnabledStates(this.getList().getSelection().getItem());
        }

        protected void checkSelection(BMouseEvent bMouseEvent, int n) {
            super.checkSelection(bMouseEvent, n);
            this.updateEnabledStates(n);
        }

        public void itemEntered(BMouseEvent bMouseEvent, int n) {
            this.getSelection().deselectAll();
            this.getSelection().select(n);
        }

        public void updateEnabledStates(int n) {
            try {
                if (n < 1) {
                    this.step.setStationName(null);
                } else {
                    this.step.setStationName(this.step.listModel.getStationDirectory(n).getFileName());
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
    }
}

