/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardModel;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platDaemon.ui.licenseinstall.BLicenseList;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.license.PortalLicenseUtil;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.BFileChooserDialog;
import com.tridium.platform.ui.util.BFileChooserListView;
import com.tridium.platform.ui.util.BIndentPane;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.FavoriteDirectory;
import com.tridium.sys.license.dom.LicenseDatabase;
import com.tridium.sys.license.dom.VendorLicense;
import java.io.InputStream;
import java.util.Properties;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.file.IFileFilter;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nav.BINavNode;
import javax.baja.nre.util.Array;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class LicenseStep
extends CommissioningWizardStep {
    private NoInstallCommand noInstallCommand;
    private InstallFileCommand installFileCommand;
    private InstallOnlineCommand installOnline;
    private ChooseLicenseFileStep chooseFileStep;
    private InstallDbCommand installDb;
    private ToggleCommandGroup commandGroup;
    private Version wbBajaVersion = null;
    static /* synthetic */ Class class$com$tridium$platform$license$LicenseInfo;

    public LicenseStep(CommissioningWizardModel commissioningWizardModel) {
        super(commissioningWizardModel);
        this.chooseFileStep = new ChooseLicenseFileStep(commissioningWizardModel);
        this.nextStep = this.chooseFileStep;
        this.chooseFileStep.priorStep = this;
        this.lastStep = this.chooseFileStep;
        commissioningWizardModel.portalAvailable = PortalLicenseUtil.isApiAvailable() && PortalLicenseUtil.requestLicensesOnline();
        this.loadCurrentLicenses();
        Array array = this.loadPortalLicenses();
        Array array2 = this.loadDbLicenses();
        commissioningWizardModel.portalLicenseSync = LicenseStep.syncLicenses(commissioningWizardModel, array);
        commissioningWizardModel.dbLicenseSync = LicenseStep.syncLicenses(commissioningWizardModel, array2);
        BIndentPane bIndentPane = new BIndentPane();
        this.wbBajaVersion = Sys.getRegistry().getModule("baja").getVendorVersion();
        this.wbBajaVersion = new Version(new int[]{this.wbBajaVersion.major(), this.wbBajaVersion.minor()});
        int n = commissioningWizardModel.currentLicenses.size();
        if (n != 0) {
            bIndentPane.add(this.getLexiconText("CommissioningWizard.license.listHeader"));
            bIndentPane.indent();
            for (int i = 0; i < n; ++i) {
                LicenseInfo licenseInfo = (LicenseInfo)commissioningWizardModel.currentLicenses.get(i);
                bIndentPane.add(licenseInfo.toString());
            }
            bIndentPane.unindent();
            bIndentPane.add((BWidget)new BBox(0.0, 6.0));
            bIndentPane.add(this.getLexiconText("CommissioningWizard.license.choicesHeader"));
        } else {
            bIndentPane.add(this.getLexiconText("CommissioningWizard.license.noLicenses"));
        }
        bIndentPane.indent();
        this.commandGroup = new ToggleCommandGroup();
        if (commissioningWizardModel.currentLicenseVersion != null) {
            if (this.wbBajaVersion.compareTo((Object)commissioningWizardModel.currentLicenseVersion) > 0) {
                commissioningWizardModel.canSkipLicense = false;
            }
            this.noInstallCommand = new NoInstallCommand();
            bIndentPane.add((BWidget)new BRadioButton((ToggleCommand)this.noInstallCommand, true, false));
            this.commandGroup.add((ToggleCommand)this.noInstallCommand);
        }
        this.installFileCommand = new InstallFileCommand();
        bIndentPane.add((BWidget)new BRadioButton((ToggleCommand)this.installFileCommand, true, false));
        this.commandGroup.add((ToggleCommand)this.installFileCommand);
        if (commissioningWizardModel.portalAvailable && this.outOfSync(commissioningWizardModel.portalLicenseSync)) {
            commissioningWizardModel.setLicenseAction(2);
            commissioningWizardModel.canSkipLicense = false;
            this.installOnline = new InstallOnlineCommand();
            bIndentPane.add((BWidget)new BRadioButton((ToggleCommand)this.installOnline, true, false));
            this.addLicenseSummary(bIndentPane, commissioningWizardModel.portalLicenseSync);
            this.commandGroup.add((ToggleCommand)this.installOnline);
            this.installOnline.setSelected(true);
        }
        if (this.outOfSync(commissioningWizardModel.dbLicenseSync)) {
            this.installDb = new InstallDbCommand();
            bIndentPane.add((BWidget)new BRadioButton((ToggleCommand)this.installDb, true, false));
            this.addLicenseSummary(bIndentPane, commissioningWizardModel.dbLicenseSync);
            this.commandGroup.add((ToggleCommand)this.installDb);
            if (commissioningWizardModel.getLicenseAction() == 0) {
                commissioningWizardModel.setLicenseAction(3);
                commissioningWizardModel.canSkipLicense = false;
                this.installDb.setSelected(true);
            }
        }
        if (!commissioningWizardModel.canSkipLicense) {
            bIndentPane.add((BWidget)new BBox(0.0, 6.0));
            bIndentPane.add(this.getLexiconText("CommissioningWizard.license.versionNote"), new Object[]{this.wbBajaVersion});
        }
        this.setContent((BWidget)bIndentPane);
    }

    private void addLicenseSummary(BIndentPane bIndentPane, LicenseSync licenseSync) {
        int n;
        bIndentPane.indent(2);
        for (n = 0; n < licenseSync.toAdd.size(); ++n) {
            bIndentPane.add(licenseSync.toAdd.get(n).toString());
        }
        for (n = 0; n < licenseSync.toUpdate.size(); ++n) {
            bIndentPane.add(licenseSync.toUpdate.get(n).toString());
        }
        bIndentPane.unindent(2);
    }

    public String getStepName() {
        return "license";
    }

    public String getSectionName() {
        return "license";
    }

    public void enter() {
        switch (this.wizardModel.getLicenseAction()) {
            case 0: {
                if (this.wizardModel.currentLicenseVersion == null) {
                    if (this.wizardModel.portalAvailable && this.installOnline != null) {
                        this.installOnline.setSelected(true);
                        break;
                    }
                    this.installFileCommand.setSelected(true);
                    break;
                }
                this.noInstallCommand.setSelected(true);
                break;
            }
            case 1: {
                this.installFileCommand.setSelected(true);
                break;
            }
            case 2: {
                this.installOnline.setSelected(true);
            }
        }
    }

    public boolean exit(int n) {
        this.wizardModel.setLicenseAction(((InstallActionCommand)this.commandGroup.getSelected()).getAction());
        return true;
    }

    public boolean isSkipped() {
        return this.wizardModel.skipLicense;
    }

    public int getMode() {
        return 3;
    }

    private boolean outOfSync(LicenseSync licenseSync) {
        return licenseSync != null && !licenseSync.unchanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCurrentLicenses() {
        BIFile bIFile;
        Object object;
        Object object2;
        this.wizardModel.currentLicenses.clear();
        BDirectory bDirectory = (BDirectory)this.wizardModel.daemonSession.getFileSpace().findFile(new FilePath("!licenses"));
        if (bDirectory == null) {
            this.wizardModel.canSkipLicense = false;
            this.wizardModel.skipLicense = false;
            return;
        }
        String string = this.wizardModel.daemonSession.getHostProperties().getHostId();
        BINavNode[] bINavNodeArray = bDirectory.getNavChildren();
        if (bINavNodeArray == null) {
            this.wizardModel.canSkipLicense = false;
            this.wizardModel.skipLicense = false;
            return;
        }
        int n = bINavNodeArray.length;
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            if (!(bINavNodeArray[i] instanceof BIFile) || !"license".equalsIgnoreCase((object2 = (BIFile)bINavNodeArray[i]).getExtension())) continue;
            try {
                object = new LicenseInfo((BIFile)object2);
                if (!string.equals(((LicenseInfo)object).vendorLicense.getHostId())) continue;
                if (string2 == null) {
                    string2 = object.getBrand();
                }
                if (((LicenseInfo)object).vendorLicense.getVendor().equalsIgnoreCase("tridium") && !object.isExpired()) {
                    this.wizardModel.currentLicenseVersion = ((LicenseInfo)object).vendorLicense.getVersion();
                }
                this.wizardModel.currentLicenses.add(object);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string2 == null && (bIFile = this.wizardModel.daemonSession.getFileSpace().findFile(new FilePath("!brand.properties"))) != null) {
            try {
                object2 = new Properties();
                object = bIFile.getInputStream();
                try {
                    ((Properties)object2).load((InputStream)object);
                    string2 = ((Properties)object2).getProperty("brand.id", null);
                }
                finally {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                this.wizardModel.canSkipLicense = false;
                this.wizardModel.skipLicense = false;
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
        if (this.wizardModel.currentLicenseVersion == null) {
            this.wizardModel.canSkipLicense = false;
            this.wizardModel.skipLicense = false;
        } else {
            this.wizardModel.canSkipLicense = true;
        }
        this.wizardModel.brandId = string2;
    }

    private Array loadDbLicenses() {
        Array array = new Array(class$com$tridium$platform$license$LicenseInfo == null ? (class$com$tridium$platform$license$LicenseInfo = LicenseStep.class$("com.tridium.platform.license.LicenseInfo")) : class$com$tridium$platform$license$LicenseInfo);
        String string = this.wizardModel.daemonSession.getHostProperties().getHostId();
        VendorLicense[] vendorLicenseArray = LicenseDatabase.LOCAL_INSTANCE.getLicenses(string, this.wizardModel.brandId);
        for (int i = 0; i < vendorLicenseArray.length; ++i) {
            array.add((Object)new LicenseInfo(vendorLicenseArray[i], null));
        }
        return array;
    }

    private Array loadPortalLicenses() {
        Array array = new Array(class$com$tridium$platform$license$LicenseInfo == null ? (class$com$tridium$platform$license$LicenseInfo = LicenseStep.class$("com.tridium.platform.license.LicenseInfo")) : class$com$tridium$platform$license$LicenseInfo);
        if (!this.wizardModel.portalAvailable) {
            return array;
        }
        String string = this.wizardModel.daemonSession.getHostProperties().getHostId();
        XElem[] xElemArray = null;
        try {
            xElemArray = PortalLicenseUtil.getExistingLicenses((String)string, (String)this.wizardModel.brandId);
        }
        catch (Exception exception) {
            this.wizardModel.portalAvailable = false;
            return array;
        }
        if (xElemArray == null) {
            return array;
        }
        for (int i = 0; i < xElemArray.length; ++i) {
            try {
                LicenseInfo licenseInfo = new LicenseInfo(xElemArray[i]);
                array.add((Object)licenseInfo);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return array;
    }

    private static LicenseSync syncLicenses(CommissioningWizardModel commissioningWizardModel, Array array) {
        String string = commissioningWizardModel.daemonSession.getHostProperties().getHostId();
        LicenseInfo[] licenseInfoArray = (LicenseInfo[])commissioningWizardModel.currentLicenses.trim();
        LicenseInfo[] licenseInfoArray2 = (LicenseInfo[])array.trim();
        return PortalLicenseUtil.syncLicenses((String)string, (LicenseInfo[])licenseInfoArray, (LicenseInfo[])licenseInfoArray2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class LicenseFileModel
    extends ListModel {
        private Array items = new Array(class$com$tridium$platform$license$LicenseInfo == null ? (class$com$tridium$platform$license$LicenseInfo = LicenseStep.class$("com.tridium.platform.license.LicenseInfo")) : class$com$tridium$platform$license$LicenseInfo);
        private CommissioningWizardModel wizardModel;

        public LicenseFileModel(CommissioningWizardModel commissioningWizardModel) {
            this.wizardModel = commissioningWizardModel;
        }

        public int getItemCount() {
            return this.items.size();
        }

        public void load() {
            this.items.clear();
            if (this.wizardModel.getFileLicenseSync() != null) {
                this.items.addAll(this.wizardModel.getFileLicenseSync().toUpdate);
                this.items.addAll(this.wizardModel.getFileLicenseSync().toAdd);
            }
        }

        public void save() {
            this.wizardModel.setFileLicenseSync(LicenseStep.syncLicenses(this.wizardModel, this.items));
        }

        public LicenseInfo add(BIFile bIFile) {
            try {
                LicenseInfo licenseInfo = this.accept(bIFile);
                if (licenseInfo != null) {
                    this.items.add((Object)licenseInfo);
                    LicenseStep.this.chooseFileStep.checkMode();
                    this.updateList();
                }
                return licenseInfo;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public void remove(Object object) {
            this.items.remove(object);
            this.updateList();
        }

        private LicenseInfo accept(BIFile bIFile) {
            try {
                String string = this.wizardModel.daemonSession.getHostProperties().getHostId();
                LicenseInfo licenseInfo = new LicenseInfo(bIFile);
                if (string.equals(licenseInfo.vendorLicense.getHostId())) {
                    if (licenseInfo.allowsLocalWbAccess()) {
                        for (int i = 0; i < this.items.size(); ++i) {
                            LicenseInfo licenseInfo2 = this.getLicenseInfo(i);
                            if (!licenseInfo2.vendorLicense.getVendor().equals(licenseInfo.vendorLicense.getVendor())) continue;
                            return null;
                        }
                    } else {
                        BDialog.error((BWidget)this.wizardModel.owner, (String)CommissioningWizardModel.lex.getText("LicenseManager.noAccess.title"), (Object)CommissioningWizardModel.lex.getText("LicenseManager.noAccess.message", new Object[]{licenseInfo.file.getFilePath().getBody()}));
                        return null;
                    }
                    return licenseInfo;
                }
                BDialog.error((BWidget)this.wizardModel.owner, (String)CommissioningWizardModel.lex.getText("LicenseManager.badHostId.title"), (Object)CommissioningWizardModel.lex.getText("LicenseManager.badHostId.message"));
                return null;
            }
            catch (Exception exception) {
                throw new LocalizableRuntimeException("platDaemon", "LicenseManager.addLicenseException", (Throwable)exception);
            }
        }

        public LicenseInfo getLicenseInfo(int n) {
            return (LicenseInfo)this.items.get(n);
        }

        public Object getItem(int n) {
            return this.getLicenseInfo(n);
        }
    }

    public static class LicenseDialogModel
    extends BFileChooserListView.ListModel {
        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return UiLexicon.bajaui.getText("fileChooser.name");
                }
                case 1: {
                    return CommissioningWizardStep.lex.getText("CommissioningWizard.chooseLicenseFile.vendorLabel");
                }
                case 2: {
                    return CommissioningWizardStep.lex.getText("LicenseManager.hostIDLabel");
                }
            }
            return "";
        }

        public Object getValueAt(int n, int n2) {
            BIFile bIFile = (BIFile)this.kids[n];
            switch (n2) {
                case 0: {
                    return super.getValueAt(n, n2);
                }
                case 1: {
                    try {
                        if (bIFile.getExtension() == null || !bIFile.getExtension().equals("license")) {
                            return "";
                        }
                        XElem xElem = XParser.make((InputStream)bIFile.getInputStream()).parse(true);
                        return xElem.get("vendor", "");
                    }
                    catch (Exception exception) {
                        return "";
                    }
                }
                case 2: {
                    try {
                        if (bIFile.getExtension() == null || !bIFile.getExtension().equals("license")) {
                            return "";
                        }
                        XElem xElem = XParser.make((InputStream)bIFile.getInputStream()).parse(true);
                        return xElem.get("hostId", "");
                    }
                    catch (Exception exception) {
                        return "";
                    }
                }
            }
            return null;
        }
    }

    private static class LicenseFileFilter
    extends ExtFileFilter {
        private String hostId;

        public LicenseFileFilter(String string) {
            super("TODO", "license");
            this.hostId = string;
        }

        public boolean accept(BIFile bIFile) {
            if (!super.accept(bIFile)) {
                return false;
            }
            try {
                LicenseInfo licenseInfo = new LicenseInfo(bIFile);
                if (this.hostId.equals(licenseInfo.vendorLicense.getHostId())) {
                    return licenseInfo.allowsLocalWbAccess();
                }
                return false;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
    }

    private class AddLicenseFileCommand
    extends Command {
        private LicenseFileModel fileModel;

        public AddLicenseFileCommand(BWidget bWidget, LicenseFileModel licenseFileModel) {
            super(bWidget, CommissioningWizardModel.lex.getText("CommissioningWizard.chooseLicenseFile.add"), null, null, null);
            this.fileModel = licenseFileModel;
        }

        public CommandArtifact doInvoke() {
            try {
                BDirectory bDirectory = FavoriteDirectory.loadByPath((String)BLicenseList.TYPE.toString(), (String)"lastLicenseDirBrowsed", (FilePath)BLicenseList.LICENSE_HOME_PATH);
                ExtFileFilter extFileFilter = new ExtFileFilter("TODO", "license");
                BIFile[] bIFileArray = BFileChooserDialog.chooseFiles((BWidget)this.getOwner(), (BImage)BImage.make((String)CommissioningWizardStep.lex.getText("LicenseManager.importFileDialog.icon")), (String)CommissioningWizardStep.lex.getText("LicenseManager.importFileDialog.title"), (String)CommissioningWizardStep.lex.getText("LicenseManager.importFileDialog.message", new Object[]{((LicenseFileModel)this.fileModel).wizardModel.daemonSession.getRemoteAddressString()}), (BIFile)bDirectory, (IFileFilter)extFileFilter, (IFileFilter)new LicenseFileFilter(((LicenseFileModel)this.fileModel).wizardModel.daemonSession.getHostProperties().getHostId()), (BFileChooserListView.ListModel)new LicenseDialogModel());
                FilePath filePath = null;
                if (bIFileArray != null) {
                    for (int i = 0; i < bIFileArray.length; ++i) {
                        filePath = bIFileArray[i].getFilePath().getParent();
                        this.fileModel.add(bIFileArray[i]);
                    }
                }
                if (filePath != null) {
                    FavoriteDirectory.savePath((String)BLicenseList.TYPE.toString(), (String)"lastLicenseDirBrowsed", filePath);
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class RemoveLicenseCommand
    extends Command {
        private LicenseFileModel fileModel;

        public RemoveLicenseCommand(BWidget bWidget, LicenseFileModel licenseFileModel) {
            super(bWidget, CommissioningWizardModel.lex.getText("CommissioningWizard.chooseLicenseFile.remove"), null, null, null);
            this.fileModel = licenseFileModel;
        }

        public CommandArtifact doInvoke() {
            try {
                int n;
                int[] nArray = this.fileModel.getList().getSelection().getItems();
                if (nArray == null) {
                    return null;
                }
                Object[] objectArray = new Object[nArray.length];
                for (n = 0; n < nArray.length; ++n) {
                    objectArray[n] = this.fileModel.getLicenseInfo(nArray[n]);
                }
                for (n = 0; n < objectArray.length; ++n) {
                    this.fileModel.remove(objectArray[n]);
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class ChooseLicenseFileStep
    extends CommissioningWizardStep {
        private LicenseFileModel listModel;
        private Command addCommand;
        private Command removeCommand;
        private int mode = 1;

        public ChooseLicenseFileStep(CommissioningWizardModel commissioningWizardModel) {
            super(commissioningWizardModel);
            this.listModel = new LicenseFileModel(commissioningWizardModel);
            BList bList = new BList((ListModel)this.listModel);
            BButtonPane bButtonPane = new BButtonPane();
            CommandBindings commandBindings = new CommandBindings();
            this.addCommand = new AddLicenseFileCommand(commissioningWizardModel.owner, this.listModel);
            commandBindings.addCommand(this.addCommand, BCommandEnablePolicy.always);
            bButtonPane.add(this.addCommand);
            this.removeCommand = new RemoveLicenseCommand(commissioningWizardModel.owner, this.listModel);
            commandBindings.addCommand(this.removeCommand, BCommandEnablePolicy.anySelection);
            bButtonPane.add(this.removeCommand);
            bList.setController((ListController)new CommandBindings.ListController(commandBindings));
            bList.setSelection((ListSelection)new CommandBindings.ListSelection(commandBindings));
            BFlowPane bFlowPane = new BFlowPane(BHalign.left);
            bFlowPane.add(null, (BValue)new BLabel(lex.getText("CommissioningWizard.chooseLicenseFile.header")));
            this.setContent((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bFlowPane, 0.0, 0.0, 4.0, 0.0), (BWidget)new BBorderPane((BWidget)bButtonPane, 5.0, 0.0, 0.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)bList, BBorder.inset, BInsets.DEFAULT)));
        }

        public String getStepName() {
            return "chooseLicenseFile";
        }

        public String getSectionName() {
            return "license";
        }

        public void enter() {
            this.listModel.load();
        }

        public boolean exit(int n) {
            this.listModel.save();
            return true;
        }

        public int getMode() {
            return this.mode;
        }

        public boolean isSkipped() {
            return this.wizardModel.skipLicense || this.wizardModel.getLicenseAction() != 1;
        }

        private void setMode(int n) {
            if (this.mode != n) {
                this.mode = n;
                if (this.wizardModel.getCurrentStep() == this) {
                    this.wizardModel.update(this.mode);
                }
            }
        }

        public void checkMode() {
            int n = 1;
            if (this.wizardModel.currentLicenseVersion != null) {
                n |= 2;
            } else {
                for (int i = 0; i < this.listModel.getItemCount(); ++i) {
                    LicenseInfo licenseInfo = this.listModel.getLicenseInfo(i);
                    if (!"tridium".equalsIgnoreCase(licenseInfo.vendorLicense.getVendor())) continue;
                    n |= 2;
                    break;
                }
            }
            this.setMode(n);
        }
    }

    private class InstallDbCommand
    extends InstallActionCommand {
        public InstallDbCommand() {
            super("CommissioningWizard.license.installDb");
        }

        public CommandArtifact doInvoke() {
            return null;
        }

        public int getAction() {
            return 3;
        }
    }

    private class InstallOnlineCommand
    extends InstallActionCommand {
        public InstallOnlineCommand() {
            super("CommissioningWizard.license.installOnline");
        }

        public CommandArtifact doInvoke() {
            return null;
        }

        public int getAction() {
            return 2;
        }
    }

    private class InstallFileCommand
    extends InstallActionCommand {
        public InstallFileCommand() {
            super("CommissioningWizard.license.installFile");
        }

        public CommandArtifact doInvoke() {
            return null;
        }

        public int getAction() {
            return 1;
        }
    }

    private class NoInstallCommand
    extends InstallActionCommand {
        public NoInstallCommand() {
            super("CommissioningWizard.license.noInstall");
        }

        public CommandArtifact doInvoke() {
            return null;
        }

        public int getAction() {
            return 0;
        }
    }

    private abstract class InstallActionCommand
    extends ToggleCommand {
        public InstallActionCommand(String string) {
            super(LicenseStep.this.wizardModel.owner, CommissioningWizardStep.lex.getText(string), null, null, null);
        }

        public abstract int getAction();
    }
}

