/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.commissioningwizard;

import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.InstallScenario;
import com.tridium.install.InstallableFilter;
import com.tridium.install.SolutionParameters;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BPart;
import com.tridium.nre.util.FileLock;
import com.tridium.platDaemon.SessionSurrogates;
import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.acctmgt.WinNtAccount;
import com.tridium.platDaemon.ui.commissioningwizard.AuthStep;
import com.tridium.platDaemon.ui.commissioningwizard.CertificateStep;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningParameters;
import com.tridium.platDaemon.ui.commissioningwizard.CommissioningWizardStep;
import com.tridium.platDaemon.ui.commissioningwizard.DistStep;
import com.tridium.platDaemon.ui.commissioningwizard.FinishPane;
import com.tridium.platDaemon.ui.commissioningwizard.FirstStep;
import com.tridium.platDaemon.ui.commissioningwizard.LexiconStep;
import com.tridium.platDaemon.ui.commissioningwizard.LicenseStep;
import com.tridium.platDaemon.ui.commissioningwizard.ModuleContentStep;
import com.tridium.platDaemon.ui.commissioningwizard.ModuleStep;
import com.tridium.platDaemon.ui.commissioningwizard.ReviewStep;
import com.tridium.platDaemon.ui.commissioningwizard.StationStep;
import com.tridium.platDaemon.ui.commissioningwizard.TcpIpStep;
import com.tridium.platDaemon.ui.stationtransfer.BStationContentEnum;
import com.tridium.platDaemon.ui.stationtransfer.BStationDispositionEnum;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BModuleContent;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonTimeUtil;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.license.LicenseSync;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.platform.ui.util.BDirectoryTree;
import java.io.InputStream;
import java.util.Properties;
import javax.baja.file.BDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.Size;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.BWbShell;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class CommissioningWizardModel
extends WizardModel
implements ICancelHint,
InstallableFilter {
    BWidget owner;
    BWbShell shell;
    BDaemonSession daemonSession;
    boolean noChanges = false;
    DaemonSessionTaskHandler sessionTaskHandler;
    SolutionParameters solutionParms;
    boolean reconnectOnFinish = false;
    boolean isAdmin = false;
    boolean isNpsdk = false;
    InstallScenario distSolution = null;
    boolean skipDistInstall = false;
    boolean updateTcpIpSettings = false;
    BTcpIpHostSettings tcpIpSettings = null;
    BTcpIpHostSettings originalTcpIpSettings = null;
    boolean hostFileDirty = false;
    boolean skipTcp = false;
    boolean enableTcp = true;
    String authMethod;
    WinNtAccount userGroup = null;
    WinNtAccount adminGroup = null;
    String adminUser = "tridium";
    BPassword adminPassword = null;
    XElem authInfo = null;
    boolean authChanged = false;
    BUsernameAndPassword newCredentials = null;
    boolean stationIsAdmin = true;
    boolean nativeAuthSupported = false;
    boolean skipAuth = false;
    boolean usingDefaultDigestCredentials = false;
    BDirectoryTree.DirectoryTreeModel directoryTreeModel = null;
    BDirectory stationDir = null;
    String targetStationName = null;
    boolean startStation = false;
    boolean autoStart = true;
    boolean autoRestart = true;
    BStationContentEnum stationContent = BStationContentEnum.everything;
    BStationDispositionEnum stationDisposition = BStationDispositionEnum.replaceDuplicates;
    FileLock localStationBogLock = null;
    BDirectory targetStationsRoot = null;
    BStationSurrogate stationSurrogate = null;
    Array stationsToDelete = new Array(class$com$tridium$platform$daemon$BStationSurrogate == null ? (class$com$tridium$platform$daemon$BStationSurrogate = CommissioningWizardModel.class$("com.tridium.platform.daemon.BStationSurrogate")) : class$com$tridium$platform$daemon$BStationSurrogate);
    boolean skipStation = false;
    BModuleContent moduleContent = null;
    boolean moduleContentChanged = false;
    boolean skipModuleContent = false;
    Array lexLocalesToInstall = new Array(class$com$tridium$platDaemon$ui$commissioningwizard$LexiconSourceModel == null ? (class$com$tridium$platDaemon$ui$commissioningwizard$LexiconSourceModel = CommissioningWizardModel.class$("com.tridium.platDaemon.ui.commissioningwizard.LexiconSourceModel")) : class$com$tridium$platDaemon$ui$commissioningwizard$LexiconSourceModel);
    boolean skipLexicon = true;
    LicenseStep licenseStep;
    String brandId = null;
    boolean portalAvailable = false;
    Array currentLicenses = new Array(class$com$tridium$platform$license$LicenseInfo == null ? (class$com$tridium$platform$license$LicenseInfo = CommissioningWizardModel.class$("com.tridium.platform.license.LicenseInfo")) : class$com$tridium$platform$license$LicenseInfo);
    LicenseSync portalLicenseSync = null;
    private LicenseSync fileLicenseSync = null;
    LicenseSync dbLicenseSync = null;
    Version currentLicenseVersion = null;
    private Version newLicenseVersion = null;
    private Version maxCoreVersion = null;
    private int licenseAction = 0;
    boolean skipLicense = false;
    boolean canSkipLicense = true;
    static final int NO_LICENSE_ACTION = 0;
    static final int INSTALL_FROM_FILE_ACTION = 1;
    static final int INSTALL_FROM_ONLINE_ACTION = 2;
    static final int INSTALL_FROM_DB_ACTION = 3;
    Array certsToInstall = new Array(class$com$tridium$platform$license$CertificateInfo == null ? (class$com$tridium$platform$license$CertificateInfo = CommissioningWizardModel.class$("com.tridium.platform.license.CertificateInfo")) : class$com$tridium$platform$license$CertificateInfo);
    InstallScenario initialScenario = null;
    InstallScenario moduleScenario = null;
    boolean moduleScenarioHasDists = false;
    boolean syncLocalTime = false;
    boolean requireSyncLocalTime = false;
    InstallScenario solution = null;
    boolean canceled;
    private CommissioningWizardStep currentStep = null;
    private BAppSurrogate[] surrogates;
    public boolean restartEnabled = true;
    public boolean anyAppHalted = false;
    public boolean anyAppRunning = false;
    public boolean requireDistStep = false;
    public static Lexicon lex = Lexicon.make((String)"platDaemon");
    static final Log log = Log.getLog((String)"platDaemon");
    static /* synthetic */ Class class$com$tridium$platform$daemon$BStationSurrogate;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$commissioningwizard$LexiconSourceModel;
    static /* synthetic */ Class class$com$tridium$platform$license$LicenseInfo;
    static /* synthetic */ Class class$com$tridium$platform$license$CertificateInfo;

    public CommissioningWizardModel(BWidget bWidget, BDaemonSession bDaemonSession, boolean bl) throws Exception {
        boolean bl2;
        Properties properties;
        this.owner = bWidget;
        this.shell = BWbShell.getWbShell((BWidget)this.owner);
        this.sessionTaskHandler = new DaemonSessionTaskHandler(this.owner);
        this.solutionParms = new CommissioningParameters(this.sessionTaskHandler, this);
        this.daemonSession = bDaemonSession;
        this.moduleContent = this.getPlatform().getModuleContent();
        BTimeZone[] bTimeZoneArray = DaemonTimeUtil.getLocalTimeZones((BDaemonSession)this.daemonSession);
        this.isAdmin = this.daemonSession.getHostProperties().hasFullAccess();
        this.restartEnabled = this.daemonSession.getHostProperties().getAllowStationRestart();
        this.isNpsdk = this.daemonSession.getHostProperties().getIsNpsdk();
        this.startStation = this.restartEnabled;
        boolean bl3 = this.requireDistStep = bl || bTimeZoneArray.length == 0;
        if (this.isAdmin) {
            BIFile bIFile = this.daemonSession.getFileSpace().findFile(new FilePath("!lib/system.properties"));
            if (bIFile == null) {
                this.requireSyncLocalTime = true;
                this.syncLocalTime = true;
                this.requireDistStep = true;
            } else {
                properties = new Properties();
                properties.load(bIFile.getInputStream());
                if (properties.getProperty("niagara.timezone", null) == null) {
                    this.requireSyncLocalTime = true;
                    this.syncLocalTime = true;
                }
            }
        }
        if (!(bl2 = this.daemonSession.getHostProperties().getOsName().equalsIgnoreCase("linux"))) {
            if (!this.isAdmin) {
                this.skipTcp = true;
                this.enableTcp = false;
                this.skipAuth = true;
            }
            if (this.getPlatform().getOsPart().getPartName().startsWith("win") && (this.getPlatform().getNrePart().isNull() || this.getPlatform().getNrePart().getVersion().getVendorVersion().compareTo((Object)new Version("3.4")) < 0)) {
                this.skipTcp = true;
                this.enableTcp = false;
            }
        } else {
            this.skipTcp = true;
            properties = this.daemonSession.getHostProperties().getAccessLevel();
            this.skipAuth = properties != BDaemonAccessLevel.restricted && properties != BDaemonAccessLevel.full;
        }
        properties = new BTcpIpHostSettings();
        TcpUtil.loadFromSession((BTcpIpHostSettings)properties, (BDaemonSession)this.daemonSession);
        if (properties.getIsReadonly()) {
            this.skipTcp = true;
        }
        this.licenseStep = new LicenseStep(this);
        FirstStep firstStep = new FirstStep(this);
        this.currentStep = firstStep;
        firstStep.nextStep = this.licenseStep;
        this.licenseStep.priorStep = firstStep;
        CertificateStep certificateStep = new CertificateStep(this);
        this.licenseStep.setStepAfterSection(certificateStep);
        ModuleContentStep moduleContentStep = new ModuleContentStep(this);
        certificateStep.setStepAfterSection(moduleContentStep);
        StationStep stationStep = new StationStep(this);
        moduleContentStep.nextStep = stationStep;
        stationStep.priorStep = moduleContentStep;
        LexiconStep lexiconStep = new LexiconStep(this);
        stationStep.setStepAfterSection(lexiconStep);
        ModuleStep moduleStep = new ModuleStep(this);
        lexiconStep.setStepAfterSection(moduleStep);
        DistStep distStep = new DistStep(this);
        moduleStep.setStepAfterSection(distStep);
        TcpIpStep tcpIpStep = new TcpIpStep(this);
        distStep.nextStep = tcpIpStep;
        tcpIpStep.priorStep = distStep;
        AuthStep authStep = new AuthStep(this);
        tcpIpStep.nextStep = authStep;
        authStep.priorStep = tcpIpStep;
        ReviewStep reviewStep = new ReviewStep(this);
        authStep.setStepAfterSection(reviewStep);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public String getTitle() {
        return lex.getText("CommissioningWizard.title", new Object[]{this.daemonSession.getRemoteHost().getNavDisplayName(null)});
    }

    public boolean cancel() {
        if ((!this.getCurrentStep().showCancelPrompt() || BDialog.confirm((BWidget)this.getWizard(), (String)lex.getText("CommissioningWizard.cancel.title"), (Object)lex.getText("CommissioningWizard.cancel.message")) == 4) && this.getCurrentStep().cancel()) {
            this.sessionTaskHandler.cancelAllTasks();
            return true;
        }
        return false;
    }

    public void setWizard(BWizard bWizard) {
        super.setWizard(bWizard);
        this.sessionTaskHandler.setOwner((BWidget)bWizard);
        this.owner = bWizard;
    }

    public boolean hasNoSteps() {
        CommissioningWizardStep commissioningWizardStep = this.currentStep;
        while (commissioningWizardStep != null && commissioningWizardStep.isSkipped()) {
            commissioningWizardStep = commissioningWizardStep.nextStep;
        }
        return commissioningWizardStep == null;
    }

    public void init() {
        try {
            this.authInfo = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new XmlResponseMessage(){

                public String getMessageString() {
                    return "auth";
                }
            }, "text/xml")).parse();
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
        XElem xElem = this.authInfo.elem("auth");
        this.authMethod = xElem.get("type");
        this.stationIsAdmin = xElem.getb("stationIsAdmin", true);
        try {
            this.nativeAuthSupported = xElem.getb("nativeAuthSupported", this.getPlatform().getOsPart().getPartName().toLowerCase().startsWith("win"));
        }
        catch (Exception exception) {
            this.nativeAuthSupported = false;
        }
        XElem xElem2 = xElem.elem("usergroup");
        if (xElem2 != null) {
            this.userGroup = new WinNtAccount(xElem2.get("name"), xElem2.get("sid", null));
        }
        if ((xElem2 = xElem.elem("admingroup")) != null) {
            this.adminGroup = new WinNtAccount(xElem2.get("name"), xElem2.get("sid", null));
        }
        if ((xElem2 = xElem.elem("user")) != null) {
            this.adminUser = xElem2.get("name");
            this.usingDefaultDigestCredentials = xElem2.getb("default", false);
        }
        CommissioningWizardStep commissioningWizardStep = this.currentStep;
        while (commissioningWizardStep != null && commissioningWizardStep.isSkipped()) {
            commissioningWizardStep = commissioningWizardStep.nextStep;
        }
        this.update(0);
        commissioningWizardStep.enter();
        this.update(commissioningWizardStep);
    }

    public void back() {
        try {
            if (!this.getCurrentStep().checkBack()) {
                return;
            }
            CommissioningWizardStep commissioningWizardStep = this.getCurrentStep().priorStep;
            if (commissioningWizardStep != null && this.getCurrentStep().exit(1)) {
                while (commissioningWizardStep != null && commissioningWizardStep.isSkipped()) {
                    commissioningWizardStep = commissioningWizardStep.priorStep;
                }
                if (commissioningWizardStep != null) {
                    this.update(0);
                    commissioningWizardStep.enter();
                    this.update(commissioningWizardStep);
                }
            }
        }
        catch (Throwable throwable) {
            BDialog.error((BWidget)this.getWizard(), (String)lex.getText("CommissioningWizard.error.dlgTitle"), (Object)lex.getText("CommissioningWizard.error.dlgMessage"), (Throwable)throwable);
        }
    }

    public void next() {
        if (!this.getCurrentStep().checkNext()) {
            return;
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (CommissioningWizardModel.this.owner != null) {
                        CommissioningWizardModel.this.owner.enterBusy();
                    }
                    CommissioningWizardStep commissioningWizardStep = CommissioningWizardModel.this.getCurrentStep().nextStep;
                    log.trace("next step: " + commissioningWizardStep.getStepName());
                    if (commissioningWizardStep != null && CommissioningWizardModel.this.getCurrentStep().exit(2)) {
                        while (commissioningWizardStep != null && commissioningWizardStep.isSkipped()) {
                            log.trace("skipping step: " + commissioningWizardStep.getStepName());
                            commissioningWizardStep = commissioningWizardStep.nextStep;
                        }
                        log.trace("   next step: " + commissioningWizardStep.getStepName());
                        if (commissioningWizardStep != null) {
                            CommissioningWizardModel.this.update(0);
                            commissioningWizardStep.enter();
                            CommissioningWizardModel.this.update(commissioningWizardStep);
                        }
                    }
                }
                catch (Throwable throwable) {
                    BDialog.error((BWidget)CommissioningWizardModel.this.getWizard(), (String)lex.getText("CommissioningWizard.error.dlgTitle"), (Object)lex.getText("CommissioningWizard.error.dlgMessage"), (Throwable)throwable);
                }
                finally {
                    if (CommissioningWizardModel.this.owner != null) {
                        CommissioningWizardModel.this.owner.exitBusy();
                    }
                }
            }
        }.start();
    }

    public boolean finish() {
        if (this.getCurrentStep().exit(4)) {
            if (!this.noChanges) {
                FinishPane.openDialog(this);
            }
            if (this.reconnectOnFinish && this.shell != null) {
                this.shell.hyperlink(BOrd.make((BOrd)this.daemonSession.getAbsoluteOrd(), (String)"view:platDaemon:PlatformAdministration"));
            }
            return true;
        }
        return false;
    }

    public CommissioningWizardStep getCurrentStep() {
        return this.currentStep;
    }

    public void update(CommissioningWizardStep commissioningWizardStep) {
        this.currentStep = commissioningWizardStep;
        this.update(commissioningWizardStep.getWidget(), commissioningWizardStep.getMode());
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(680.0, 480.0);
    }

    public BAppSurrogate[] getSurrogates() {
        if (this.surrogates == null) {
            try {
                this.surrogates = new SessionSurrogates(this.daemonSession).getAll();
                for (int i = 0; i < this.surrogates.length; ++i) {
                    if (this.surrogates[i].getAppStatus() == BStationStatus.failed || this.surrogates[i].getAppStatus() == BStationStatus.halted) {
                        this.anyAppHalted = true;
                        continue;
                    }
                    if (!this.surrogates[i].isAppRunning()) continue;
                    this.anyAppRunning = true;
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
        return this.surrogates;
    }

    public BRemoteDaemonPlatform getPlatform() throws Exception {
        return BRemoteDaemonPlatform.make((BDaemonSession)this.daemonSession, (DaemonSessionTaskListener)this.sessionTaskHandler);
    }

    public int getLicenseAction() {
        return this.licenseAction;
    }

    public void setLicenseAction(int n) {
        if (this.licenseAction != n) {
            this.licenseAction = n;
            this.newLicenseVersion = null;
            this.maxCoreVersion = null;
            this.initialScenario = null;
            this.moduleScenario = null;
            this.moduleScenarioHasDists = false;
            this.solution = null;
        }
    }

    public LicenseSync getFileLicenseSync() {
        return this.fileLicenseSync;
    }

    public void setFileLicenseSync(LicenseSync licenseSync) {
        this.fileLicenseSync = licenseSync;
        this.newLicenseVersion = null;
        this.maxCoreVersion = null;
    }

    public Version getNewLicenseVersion() {
        if (this.newLicenseVersion == null) {
            LicenseInfo licenseInfo;
            int n;
            LicenseSync licenseSync;
            switch (this.licenseAction) {
                case 1: {
                    licenseSync = this.fileLicenseSync;
                    break;
                }
                case 2: {
                    licenseSync = this.portalLicenseSync;
                    break;
                }
                case 3: {
                    licenseSync = this.dbLicenseSync;
                    break;
                }
                default: {
                    return this.currentLicenseVersion;
                }
            }
            for (n = 0; n < licenseSync.toAdd.size(); ++n) {
                licenseInfo = (LicenseInfo)licenseSync.toAdd.get(n);
                if (!licenseInfo.vendorLicense.getVendor().equalsIgnoreCase("tridium")) continue;
                return licenseInfo.vendorLicense.getVersion();
            }
            for (n = 0; n < licenseSync.toUpdate.size(); ++n) {
                licenseInfo = (LicenseInfo)licenseSync.toUpdate.get(n);
                if (!licenseInfo.vendorLicense.getVendor().equalsIgnoreCase("tridium")) continue;
                return licenseInfo.vendorLicense.getVersion();
            }
            this.newLicenseVersion = this.currentLicenseVersion;
        }
        return this.newLicenseVersion;
    }

    public boolean acceptInstallable(BInstallable bInstallable) {
        if ("true".equals(System.getProperty("niagara.commissioning.ignoreLicenseVersion"))) {
            return true;
        }
        try {
            Version version = this.getMaxCoreVersion();
            if (bInstallable.getInstallableName().startsWith("nre-core") || bInstallable.getInstallableName().equals("baja")) {
                if (bInstallable.getVersion().getVendorVersion().compareTo((Object)version) >= 0) {
                    return false;
                }
            } else if (bInstallable instanceof BDistribution && BPart.matchesName((String)bInstallable.getInstallableFileName(), (String)this.getPlatform().getConfigDistFileName())) {
                BDependency[] bDependencyArray = bInstallable.getAllDependencies();
                for (int i = 0; i < bDependencyArray.length; ++i) {
                    if (bDependencyArray[i].getPartType() != BNrePart.TYPE) continue;
                    if (bDependencyArray[i].getVersion().getVendorVersion().compareTo((Object)version) < 0) break;
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public Version getMaxCoreVersion() {
        if (this.maxCoreVersion == null) {
            Version version = this.getNewLicenseVersion();
            this.maxCoreVersion = version == null ? Version.ZERO : new Version(version.major() + "." + (version.minor() + 1));
        }
        return this.maxCoreVersion;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

