/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.acctmgt;

import com.tridium.net.HttpUtil;
import com.tridium.nre.auth.SecurityUtil;
import com.tridium.platDaemon.ui.acctmgt.BUserManager;
import com.tridium.platDaemon.ui.acctmgt.WinNtAccount;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.ui.ShellManager;
import com.tridium.ui.theme.Theme;
import java.io.InputStream;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class BNativeUserTable
extends BTable {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$acctmgt$BNativeUserTable == null ? (class$com$tridium$platDaemon$ui$acctmgt$BNativeUserTable = BNativeUserTable.class$("com.tridium.platDaemon.ui.acctmgt.BNativeUserTable")) : class$com$tridium$platDaemon$ui$acctmgt$BNativeUserTable));
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    private BButtonPane buttons;
    private Command addUserCommand;
    private Command deleteUserCommand;
    private Command changePasswordCommand;
    private Command userDetailsCommand;
    private BDaemonSession session = null;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$acctmgt$BNativeUserTable;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$acctmgt$BNativeUserTable$UserAccount;

    public Type getType() {
        return TYPE;
    }

    public BNativeUserTable() {
        this.setModel(new UserModel());
        this.setController(new UserController());
        this.buttons = new BButtonPane();
        this.addUserCommand = new AddUserCommand();
        this.buttons.add(this.addUserCommand);
        this.deleteUserCommand = new DeleteUserCommand();
        this.buttons.add(this.deleteUserCommand);
        this.changePasswordCommand = new ChangePasswordCommand();
        this.buttons.add(this.changePasswordCommand);
        this.userDetailsCommand = new UserDetailsCommand();
    }

    public BButtonPane getButtonPane() {
        return this.buttons;
    }

    public void loadSession(BDaemonSession bDaemonSession) throws Exception {
        this.session = bDaemonSession;
        this.getUserModel().load();
        this.addUserCommand.setEnabled(this.getUserModel().canModify);
    }

    private UserModel getUserModel() {
        return (UserModel)this.getModel();
    }

    private BDaemonSession getDaemonSession() {
        return this.session;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ChangePasswordMessage
    extends XmlResponseMessage {
        private StringBuffer buf = new StringBuffer("acctmgt?update=changepassword&");

        public ChangePasswordMessage(WinNtAccount winNtAccount, String string, String string2) {
            if (winNtAccount.sid == null) {
                this.buf.append("user=");
                this.buf.append(HttpUtil.encodeUrl((String)winNtAccount.name));
            } else {
                this.buf.append("usersid=");
                this.buf.append(HttpUtil.encodeUrl((String)winNtAccount.sid));
            }
            this.buf.append("&oldpassword=");
            this.buf.append(HttpUtil.encodeUrl((String)string));
            this.buf.append("&newpassword=");
            this.buf.append(HttpUtil.encodeUrl((String)string2));
        }

        public String getMessageString() {
            return this.buf.toString();
        }
    }

    private class ChangePasswordCommand
    extends Command {
        public ChangePasswordCommand() {
            super((BWidget)BNativeUserTable.this, BNativeUserTable.this.getLexicon(), "UserManager.ChangePasswordCommand");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                UserAccount userAccount = BNativeUserTable.this.getUserModel().getUser(BNativeUserTable.this.getSelection().getRow());
                BGridPane bGridPane = new BGridPane(2);
                BWbFieldEditor bWbFieldEditor = BWbFieldEditor.makeFor((BObject)BPassword.DEFAULT);
                bWbFieldEditor.loadValue((BObject)BPassword.DEFAULT);
                BWbFieldEditor bWbFieldEditor2 = BWbFieldEditor.makeFor((BObject)BPassword.DEFAULT);
                bWbFieldEditor2.loadValue((BObject)BPassword.DEFAULT);
                BWbFieldEditor bWbFieldEditor3 = BWbFieldEditor.makeFor((BObject)BPassword.DEFAULT);
                bWbFieldEditor3.loadValue((BObject)BPassword.DEFAULT);
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.ChangePasswordCommand.label.name"), (BWidget)new BLabel(userAccount.name));
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.ChangePasswordCommand.label.oldpassword"), (BWidget)bWbFieldEditor);
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.ChangePasswordCommand.label.newpassword"), (BWidget)bWbFieldEditor2);
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.ChangePasswordCommand.label.newpassword2"), (BWidget)bWbFieldEditor3);
                if (1 == BDialog.open((BWidget)BNativeUserTable.this, (String)BNativeUserTable.this.getLexicon().getText("UserManager.ChangePasswordCommand.dlgTitle", new Object[]{userAccount.name}), (Object)bGridPane, (int)3)) {
                    BPassword bPassword = (BPassword)bWbFieldEditor.saveValue();
                    BPassword bPassword2 = (BPassword)bWbFieldEditor2.saveValue();
                    BPassword bPassword3 = (BPassword)bWbFieldEditor3.saveValue();
                    if (bPassword.getValue().trim().length() == 0 || bPassword2.getValue().trim().length() == 0 || bPassword2.getValue().trim().length() == 0) {
                        BDialog.error((BWidget)BNativeUserTable.this, (Object)BNativeUserTable.this.getLexicon().getText("UserManager.error.fieldRequired"));
                        return null;
                    }
                    if (!SecurityUtil.equals((String)bPassword2.getValue(), (String)bPassword3.getValue())) {
                        BDialog.error((BWidget)BNativeUserTable.this, (Object)BNativeUserTable.this.getLexicon().getText("UserManager.error.passwordMismatch"));
                        return null;
                    }
                    BUserManager.checkStatus((BWidget)BNativeUserTable.this, BNativeUserTable.this.getDaemonSession(), new ChangePasswordMessage(userAccount, bPassword.encodeToString(), bPassword2.encodeToString()));
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class DeleteUserMessage
    extends XmlResponseMessage {
        private StringBuffer buf = new StringBuffer("acctmgt?update=deluser&");

        public DeleteUserMessage(WinNtAccount winNtAccount) {
            if (winNtAccount.sid == null) {
                this.buf.append("user=");
                this.buf.append(HttpUtil.encodeUrl((String)winNtAccount.name));
            } else {
                this.buf.append("usersid=");
                this.buf.append(HttpUtil.encodeUrl((String)winNtAccount.sid));
            }
        }

        public String getMessageString() {
            return this.buf.toString();
        }
    }

    private class DeleteUserCommand
    extends Command {
        public DeleteUserCommand() {
            super((BWidget)BNativeUserTable.this, BNativeUserTable.this.getLexicon(), "UserManager.DeleteUserCommand");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BNativeUserTable.this, (String)BNativeUserTable.this.getLexicon().getText("UserManager.DeleteUserCommand.confirmTitle"), (Object)BNativeUserTable.this.getLexicon().getText("UserManager.DeleteUserCommand.confirmMessage"))) {
                    int[] nArray = BNativeUserTable.this.getSelection().getRows();
                    for (int i = 0; i < nArray.length; ++i) {
                        if (BUserManager.checkStatus((BWidget)BNativeUserTable.this, BNativeUserTable.this.getDaemonSession(), new DeleteUserMessage(BNativeUserTable.this.getUserModel().getUser(nArray[i])))) continue;
                        return null;
                    }
                    BNativeUserTable.this.getUserModel().load();
                    BNativeUserTable.this.getSelection().deselectAll();
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class DetailsMessage
    extends XmlResponseMessage {
        StringBuffer buf = new StringBuffer("acctmgt?usergroups=true&");

        public DetailsMessage(WinNtAccount winNtAccount) {
            if (winNtAccount.sid == null) {
                this.buf.append("user=");
                this.buf.append(HttpUtil.encodeUrl((String)winNtAccount.name));
            } else {
                this.buf.append("usersid=");
                this.buf.append(HttpUtil.encodeUrl((String)winNtAccount.sid));
            }
        }

        public String getMessageString() {
            return this.buf.toString();
        }
    }

    private class UserDetailsCommand
    extends Command {
        public UserDetailsCommand() {
            super((BWidget)BNativeUserTable.this, BNativeUserTable.this.getLexicon(), "UserManager.UserDetailsCommand");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            try {
                int n = BNativeUserTable.this.getSelection().getRow();
                if (n < 0) {
                    return null;
                }
                UserAccount userAccount = BNativeUserTable.this.getUserModel().getUser(n);
                XElem xElem = XParser.make((InputStream)BNativeUserTable.this.getDaemonSession().getInputStream((DaemonMessage)new DetailsMessage(userAccount))).parse();
                BGridPane bGridPane = new BGridPane(2);
                bGridPane.setHalign(BHalign.left);
                bGridPane.setValign(BValign.top);
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.UserDetailsCommand.label.name"), (BWidget)new BLabel(userAccount.name));
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.UserDetailsCommand.label.comment"), (BWidget)new BLabel(userAccount.comment));
                BList bList = new BList();
                XElem[] xElemArray = xElem.elems("group");
                for (int i = 0; i < xElemArray.length; ++i) {
                    bList.addItem((Object)new WinNtAccount(xElemArray[i].get("name"), xElemArray[i].get("sid", null)));
                }
                BFlowPane bFlowPane = new BFlowPane(BHalign.left);
                bFlowPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.UserDetailsCommand.label.groups"), (boolean)true));
                BScrollPane bScrollPane = new BScrollPane((BWidget)bList);
                bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
                BDialog.open((BWidget)BNativeUserTable.this, (String)BNativeUserTable.this.getLexicon().getText("UserManager.UserDetailsCommand.dlgTitle", new Object[]{userAccount.name}), (Object)new BEdgePane((BWidget)new BBorderPane((BWidget)bGridPane, 3.0, 3.0, 0.0, 3.0), null, null, null, (BWidget)new BBorderPane((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bFlowPane, 0.0, 0.0, 3.0, 0.0), (BWidget)new BBox(400.0, 0.0), (BWidget)new BBox(0.0, 200.0), null, (BWidget)new BBorderPane((BWidget)bScrollPane, BBorder.inset, BInsets.DEFAULT)), 3.0, 3.0, 3.0, 3.0)), (int)1);
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class AddUserMessage
    extends XmlResponseMessage {
        private StringBuffer buf = new StringBuffer("acctmgt?update=adduser&user=");

        public AddUserMessage(String string, String string2, String string3) {
            this.buf.append(HttpUtil.encodeUrl((String)string));
            this.buf.append("&comment=");
            this.buf.append(HttpUtil.encodeUrl((String)string2));
            this.buf.append("&password=");
            this.buf.append(HttpUtil.encodeUrl((String)string3));
        }

        public String getMessageString() {
            return this.buf.toString();
        }
    }

    private class AddUserCommand
    extends Command {
        public AddUserCommand() {
            super((BWidget)BNativeUserTable.this, BNativeUserTable.this.getLexicon(), "UserManager.AddUserCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BGridPane bGridPane = new BGridPane(2);
                BTextField bTextField = new BTextField("", 30);
                BTextField bTextField2 = new BTextField("", 30);
                BWbFieldEditor bWbFieldEditor = BWbFieldEditor.makeFor((BObject)BPassword.DEFAULT);
                bWbFieldEditor.loadValue((BObject)BPassword.DEFAULT);
                BWbFieldEditor bWbFieldEditor2 = BWbFieldEditor.makeFor((BObject)BPassword.DEFAULT);
                bWbFieldEditor2.loadValue((BObject)BPassword.DEFAULT);
                BCheckList bCheckList = new BCheckList();
                XElem xElem = XParser.make((InputStream)BNativeUserTable.this.getDaemonSession().getInputStream((DaemonMessage)new XmlResponseMessage(){

                    public String getMessageString() {
                        return "acctmgt";
                    }
                })).parse();
                XElem[] xElemArray = xElem.elems("group");
                for (int i = 0; i < xElemArray.length; ++i) {
                    if (!xElemArray[i].getb("canModify", true)) continue;
                    bCheckList.addItem((Object)new WinNtAccount(xElemArray[i].get("name"), xElemArray[i].get("sid", null)));
                }
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.AddUserCommand.label.name"), (BWidget)bTextField);
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.AddUserCommand.label.comment"), (BWidget)bTextField2);
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.AddUserCommand.label.password"), (BWidget)bWbFieldEditor);
                LabelUtil.addLabelWidgetPair((BGridPane)bGridPane, (LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.AddUserCommand.label.password2"), (BWidget)bWbFieldEditor2);
                BScrollPane bScrollPane = new BScrollPane((BWidget)bCheckList);
                bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
                bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bScrollPane);
                bConstrainedPane.setMaxWidth(300.0);
                bConstrainedPane.setMaxHeight(150.0);
                BFlowPane bFlowPane = new BFlowPane(BHalign.left);
                bFlowPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.AddUserCommand.label.groups"), (boolean)true));
                if (1 == BDialog.open((BWidget)BNativeUserTable.this, (String)BNativeUserTable.this.getLexicon().getText("UserManager.AddUserCommand.dlgTitle"), (Object)new BEdgePane((BWidget)bGridPane, null, null, null, (BWidget)new BBorderPane((BWidget)new BEdgePane((BWidget)bFlowPane, null, null, null, (BWidget)bConstrainedPane), 2.0, 2.0, 2.0, 2.0)), (int)3)) {
                    BPassword bPassword = (BPassword)bWbFieldEditor.saveValue();
                    BPassword bPassword2 = (BPassword)bWbFieldEditor2.saveValue();
                    if (bTextField.getText().trim().length() == 0) {
                        BDialog.error((BWidget)BNativeUserTable.this, (Object)BNativeUserTable.this.getLexicon().getText("UserManager.error.nameRequired"));
                        return null;
                    }
                    if (bPassword.getValue().trim().length() == 0 || bPassword2.getValue().trim().length() == 0) {
                        BDialog.error((BWidget)BNativeUserTable.this, (Object)BNativeUserTable.this.getLexicon().getText("UserManager.error.passwordRequired"));
                        return null;
                    }
                    if (!SecurityUtil.equals((String)bPassword.getValue(), (String)bPassword2.getValue())) {
                        BDialog.error((BWidget)BNativeUserTable.this, (Object)BNativeUserTable.this.getLexicon().getText("UserManager.error.passwordMismatch"));
                        return null;
                    }
                    if (BUserManager.checkStatus((BWidget)BNativeUserTable.this, BNativeUserTable.this.getDaemonSession(), new AddUserMessage(bTextField.getText().trim(), bTextField2.getText().trim(), bPassword.encodeToString()))) {
                        BNativeUserTable.this.getUserModel().load();
                        UserAccount userAccount = BNativeUserTable.this.getUserModel().getUser(bTextField.getText().trim());
                        Object[] objectArray = bCheckList.getSelectedItems();
                        for (int i = 0; i < objectArray.length; ++i) {
                            BUserManager.checkStatus((BWidget)BNativeUserTable.this, BNativeUserTable.this.getDaemonSession(), new BUserManager.AddMemberMessage((WinNtAccount)objectArray[i], userAccount));
                        }
                    }
                    BNativeUserTable.this.getUserModel().load();
                    BNativeUserTable.this.getSelection().deselectAll();
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class UserController
    extends TableController {
        private UserController() {
        }

        protected final void backgroundPressed(BMouseEvent bMouseEvent) {
            super.backgroundPressed(bMouseEvent);
            BNativeUserTable.this.deleteUserCommand.setEnabled(false);
            BNativeUserTable.this.changePasswordCommand.setEnabled(false);
            BNativeUserTable.this.userDetailsCommand.setEnabled(false);
        }

        protected void checkSelection(BMouseEvent bMouseEvent, int n) {
            super.checkSelection(bMouseEvent, n);
            BNativeUserTable.this.changePasswordCommand.setEnabled(((BNativeUserTable)BNativeUserTable.this).getUserModel().canModify && this.getTable().getSelection().getRowCount() == 1);
            BNativeUserTable.this.userDetailsCommand.setEnabled(this.getTable().getSelection().getRowCount() == 1);
            if (!((BNativeUserTable)BNativeUserTable.this).getUserModel().canModify || this.getTable().getSelection().isEmpty()) {
                BNativeUserTable.this.deleteUserCommand.setEnabled(false);
            } else {
                int[] nArray = this.getTable().getSelection().getRows();
                boolean bl = true;
                BUsernameAndPassword bUsernameAndPassword = (BUsernameAndPassword)BNativeUserTable.this.session.getCredentials();
                String string = this.toUserName(bUsernameAndPassword.getUsername());
                for (int i = 0; i < nArray.length; ++i) {
                    String string2 = this.toUserName(((BNativeUserTable)BNativeUserTable.this).getUserModel().getUser((int)nArray[i]).name);
                    if (!string2.equals(string)) continue;
                    bl = false;
                    break;
                }
                BNativeUserTable.this.deleteUserCommand.setEnabled(bl);
            }
        }

        protected String toUserName(String string) {
            String string2 = TextUtil.toLowerCase((String)string);
            int n = string2.indexOf(92);
            if (n >= 0) {
                string2 = string2.substring(n + 1);
            }
            if ((n = string2.indexOf(64)) >= 0) {
                string2 = string2.substring(0, n);
            }
            return string2;
        }

        protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            BNativeUserTable.this.userDetailsCommand.invoke();
        }

        protected void cellDragged(BMouseEvent bMouseEvent, int n, int n2) {
            ShellManager shellManager = (ShellManager)BNativeUserTable.this.widgetSupport(null);
            shellManager.startDragOperation((BTransferWidget)BNativeUserTable.this, bMouseEvent, new TransferContext(null, 16, TransferEnvelope.make((String)BNativeUserTable.this.getUserModel().getUser(n).encode())), (DragRenderer)new SimpleDragRenderer(BImage.make((BIcon)BIcon.std((String)"user.png")), ((BNativeUserTable)BNativeUserTable.this).getUserModel().getUser((int)n).name));
        }
    }

    public class UserAccount
    extends WinNtAccount {
        public String comment;

        public UserAccount(String string, String string2, String string3) {
            super(string, string2);
            this.comment = string3;
        }
    }

    private class UserModel
    extends TableModel {
        private Array rows = new Array(class$com$tridium$platDaemon$ui$acctmgt$BNativeUserTable$UserAccount == null ? (class$com$tridium$platDaemon$ui$acctmgt$BNativeUserTable$UserAccount = BNativeUserTable.class$("com.tridium.platDaemon.ui.acctmgt.BNativeUserTable$UserAccount")) : class$com$tridium$platDaemon$ui$acctmgt$BNativeUserTable$UserAccount);
        public boolean canModify = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load() throws Exception {
            XElem xElem = XParser.make((InputStream)BNativeUserTable.this.getDaemonSession().getInputStream((DaemonMessage)new XmlResponseMessage(){

                public String getMessageString() {
                    return "acctmgt?users=true";
                }
            })).parse();
            this.canModify = BNativeUserTable.this.session.getHostProperties().hasFullAccess() && xElem.getb("canModify", true);
            XElem[] xElemArray = xElem.elems("user");
            Array array = this.rows;
            synchronized (array) {
                this.rows.clear();
                for (int i = 0; i < xElemArray.length; ++i) {
                    if (!xElemArray[i].get("type").equals("local")) continue;
                    this.rows.add((Object)new UserAccount(xElemArray[i].get("name"), xElemArray[i].get("sid", null), xElemArray[i].get("comment")));
                }
            }
            this.updateTable(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            Array array = this.rows;
            synchronized (array) {
                return this.rows.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UserAccount getUser(int n) {
            Array array = this.rows;
            synchronized (array) {
                return (UserAccount)this.rows.get(n);
            }
        }

        public UserAccount getUser(String string) {
            for (int i = 0; i < this.rows.size(); ++i) {
                UserAccount userAccount = this.getUser(i);
                if (!(string.indexOf(92) < 0 ? userAccount.name.endsWith("\\" + string) : userAccount.name.equals(string))) continue;
                return userAccount;
            }
            return null;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return lex.getText("UserManager.utable.col.name");
                }
                case 1: {
                    return lex.getText("UserManager.utable.col.comment");
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.getUser((int)n).name;
                }
                case 1: {
                    return this.getUser((int)n).comment;
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }
    }
}

