/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui.acctmgt;

import com.tridium.net.HttpUtil;
import com.tridium.platDaemon.ui.acctmgt.BNativeGroupMemberTable;
import com.tridium.platDaemon.ui.acctmgt.BUserManager;
import com.tridium.platDaemon.ui.acctmgt.WinNtAccount;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.XmlResponseMessage;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.LabelUtil;
import java.io.InputStream;
import javax.baja.gx.BInsets;
import javax.baja.nre.util.Array;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconText;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class BNativeGroupTable
extends BTable {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$acctmgt$BNativeGroupTable == null ? (class$com$tridium$platDaemon$ui$acctmgt$BNativeGroupTable = BNativeGroupTable.class$("com.tridium.platDaemon.ui.acctmgt.BNativeGroupTable")) : class$com$tridium$platDaemon$ui$acctmgt$BNativeGroupTable));
    private static Lexicon lex = Lexicon.make((String)"platDaemon");
    private BNativeGroupMemberTable mTable;
    private BDaemonSession session;
    private Command addGroupCommand;
    private Command delGroupCommand;
    private BSplitPane split;
    private BLabel membersLabel;
    private BUserManager manager;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$acctmgt$BNativeGroupTable;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$acctmgt$BNativeGroupTable$GroupAccount;

    public Type getType() {
        return TYPE;
    }

    public BNativeGroupTable() {
        throw new UnsupportedOperationException();
    }

    public BNativeGroupTable(BUserManager bUserManager) {
        this.manager = bUserManager;
        this.setModel(new GroupsModel());
        this.setController(new GroupsController());
        BButtonPane bButtonPane = new BButtonPane();
        this.addGroupCommand = new AddGroupCommand();
        bButtonPane.add(this.addGroupCommand);
        this.delGroupCommand = new DelGroupCommand();
        bButtonPane.add(this.delGroupCommand);
        this.split = new BSplitPane(BOrientation.vertical, 60.0);
        BFlowPane bFlowPane = new BFlowPane(BHalign.left);
        bFlowPane.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.label.groups"), (boolean)true));
        this.split.setWidget1((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bFlowPane, 4.0, 0.0, 0.0, 4.0), (BWidget)new BBorderPane((BWidget)bButtonPane, 4.0, 0.0, 4.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)this, BBorder.inset, BInsets.DEFAULT)));
        bFlowPane = new BFlowPane(BHalign.left);
        this.membersLabel = LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"UserManager.label.members.null"), (boolean)true);
        bFlowPane.add(null, (BValue)this.membersLabel);
        this.mTable = new BNativeGroupMemberTable(this);
        this.split.setWidget2((BWidget)new BEdgePane((BWidget)new BBorderPane((BWidget)bFlowPane, 4.0, 0.0, 0.0, 4.0), (BWidget)new BBorderPane((BWidget)this.mTable.getButtonPane(), 4.0, 0.0, 0.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)this.mTable, BBorder.inset, BInsets.DEFAULT)));
    }

    public BSplitPane getSplitPane() {
        return this.split;
    }

    public void loadSession(BDaemonSession bDaemonSession) throws Exception {
        this.session = bDaemonSession;
        this.getGroupsModel().load();
        this.addGroupCommand.setEnabled(this.getGroupsModel().canModify);
    }

    public BUserManager getUserManager() {
        return this.manager;
    }

    public WinNtAccount getSelectedGroup() {
        return this.getGroup(this.getSelection().getRow());
    }

    public BNativeGroupMemberTable getMemberTable() {
        return this.mTable;
    }

    public WinNtAccount[] getSelectedGroups() {
        int[] nArray = this.getSelection().getRows();
        WinNtAccount[] winNtAccountArray = new WinNtAccount[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            winNtAccountArray[i] = this.getGroup(nArray[i]);
        }
        return winNtAccountArray;
    }

    public WinNtAccount getGroup(int n) {
        return this.getGroupsModel().getGroup(n);
    }

    public boolean canDeleteGroup(int n) {
        return this.getGroupsModel().canDeleteGroup(n);
    }

    public boolean canModifyGroup(int n) {
        return this.getGroupsModel().canModifyGroup(n);
    }

    public int dragOver(TransferContext transferContext) {
        WinNtAccount winNtAccount;
        int n = this.getRowAt(transferContext.getY());
        if (transferContext.isCopy() && n >= 0 && transferContext.getEnvelope().supports(TransferFormat.string) && !(winNtAccount = WinNtAccount.decode((String)transferContext.getEnvelope().getData(TransferFormat.string))).equals(this.getGroup(n)) && this.canModifyGroup(n)) {
            return 16;
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        int n = this.getRowAt(transferContext.getY());
        if (transferContext.isCopy() && n >= 0 && transferContext.getEnvelope().supports(TransferFormat.string)) {
            WinNtAccount winNtAccount = WinNtAccount.decode((String)transferContext.getEnvelope().getData(TransferFormat.string));
            if (BUserManager.checkStatus((BWidget)this, this.getDaemonSession(), new BUserManager.AddMemberMessage(this.getGroup(n), winNtAccount))) {
                this.getSelection().select(n, true);
                this.mTable.loadGroup(this.getDaemonSession(), this.getGroup(n), this.canModifyGroup(n));
                this.membersLabel.setText(this.getLexicon().getText("UserManager.label.members", new Object[]{this.getGroup(n)}));
            }
        }
        return null;
    }

    private GroupsModel getGroupsModel() {
        return (GroupsModel)this.getModel();
    }

    private BDaemonSession getDaemonSession() {
        return this.session;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DelGroupMessage
    extends XmlResponseMessage {
        private StringBuffer buf = new StringBuffer("acctmgt?update=delgrp&");

        public DelGroupMessage(WinNtAccount winNtAccount) {
            if (winNtAccount.sid == null) {
                this.buf.append("group=");
                this.buf.append(HttpUtil.encodeUrl((String)winNtAccount.name));
            } else {
                this.buf.append("groupsid=");
                this.buf.append(HttpUtil.encodeUrl((String)winNtAccount.sid));
            }
        }

        public String getMessageString() {
            return this.buf.toString();
        }
    }

    private class DelGroupCommand
    extends Command {
        public DelGroupCommand() {
            super((BWidget)BNativeGroupTable.this, BNativeGroupTable.this.getLexicon(), "UserManager.DelGroupCommand");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() throws Exception {
            try {
                if (4 == BDialog.confirm((BWidget)BNativeGroupTable.this, (String)BNativeGroupTable.this.getLexicon().getText("UserManager.DelGroupCommand.confirmTitle"), (Object)BNativeGroupTable.this.getLexicon().getText("UserManager.DelGroupCommand.confirmMessage"))) {
                    int[] nArray = BNativeGroupTable.this.getSelection().getRows();
                    for (int i = 0; i < nArray.length; ++i) {
                        GroupAccount groupAccount = BNativeGroupTable.this.getGroupsModel().getGroup(nArray[i]);
                        if (!BUserManager.checkStatus((BWidget)BNativeGroupTable.this, BNativeGroupTable.this.getDaemonSession(), new DelGroupMessage(groupAccount))) break;
                    }
                    BNativeGroupTable.this.getGroupsModel().load();
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class AddGroupMessage
    extends XmlResponseMessage {
        StringBuffer buf = new StringBuffer("acctmgt?update=addgrp&group=");

        public AddGroupMessage(String string) {
            this.buf.append(HttpUtil.encodeUrl((String)string));
        }

        public String getMessageString() {
            return this.buf.toString();
        }
    }

    private class AddGroupCommand
    extends Command {
        public AddGroupCommand() {
            super((BWidget)BNativeGroupTable.this, BNativeGroupTable.this.getLexicon(), "UserManager.AddGroupCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BUserManager.MemberSelection memberSelection = BNativeGroupTable.this.getUserManager().makeMemberSelection(true);
                if (1 == BDialog.open((BWidget)BNativeGroupTable.this, (String)BNativeGroupTable.this.getLexicon().getText("UserManager.AddGroupCommand.dlgTitle"), (Object)memberSelection.getContent(), (int)3, null)) {
                    String string = memberSelection.getGroupName();
                    if (string.trim().length() == 0) {
                        BDialog.error((BWidget)BNativeGroupTable.this, (Object)BNativeGroupTable.this.getLexicon().getText("UserManager.error.groupNameRequired"));
                    } else if (BUserManager.checkStatus((BWidget)BNativeGroupTable.this, BNativeGroupTable.this.getDaemonSession(), new AddGroupMessage(string))) {
                        BNativeGroupTable.this.getGroupsModel().load();
                        WinNtAccount[] winNtAccountArray = memberSelection.getMemberAccounts();
                        for (int i = 0; i < winNtAccountArray.length; ++i) {
                            BUserManager.checkStatus((BWidget)BNativeGroupTable.this, BNativeGroupTable.this.getDaemonSession(), new BUserManager.AddMemberMessage(BNativeGroupTable.this.getGroupsModel().getGroup(string), winNtAccountArray[i]));
                        }
                        BNativeGroupTable.this.getGroupsModel().load();
                    }
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class GroupsController
    extends TableController {
        private GroupsController() {
        }

        protected final void backgroundPressed(BMouseEvent bMouseEvent) {
            super.backgroundPressed(bMouseEvent);
            BNativeGroupTable.this.delGroupCommand.setEnabled(false);
            BNativeGroupTable.this.mTable.clear();
            BNativeGroupTable.this.membersLabel.setText(BNativeGroupTable.this.getLexicon().getText("UserManager.label.members.null"));
        }

        protected void checkSelection(BMouseEvent bMouseEvent, int n) {
            super.checkSelection(bMouseEvent, n);
            if (this.getTable().getSelection().getRowCount() == 1) {
                int n2 = this.getTable().getSelection().getRow();
                GroupAccount groupAccount = BNativeGroupTable.this.getGroupsModel().getGroup(n2);
                boolean bl = BNativeGroupTable.this.getGroupsModel().canDeleteGroup(n2);
                boolean bl2 = BNativeGroupTable.this.getGroupsModel().canModifyGroup(n2);
                BNativeGroupTable.this.delGroupCommand.setEnabled(((BNativeGroupTable)BNativeGroupTable.this).getGroupsModel().canModify && bl);
                BNativeGroupTable.this.mTable.loadGroup(BNativeGroupTable.this.getDaemonSession(), groupAccount, bl2);
                BNativeGroupTable.this.membersLabel.setText(BNativeGroupTable.this.getLexicon().getText("UserManager.label.members", new Object[]{groupAccount}));
            } else if (this.getTable().getSelection().getRowCount() > 1) {
                int[] nArray = this.getTable().getSelection().getRows();
                boolean bl = ((BNativeGroupTable)BNativeGroupTable.this).getGroupsModel().canModify;
                if (((BNativeGroupTable)BNativeGroupTable.this).getGroupsModel().canModify) {
                    for (int i = 0; i < nArray.length; ++i) {
                        if (BNativeGroupTable.this.getGroupsModel().canDeleteGroup(nArray[i])) continue;
                        bl = false;
                        break;
                    }
                }
                BNativeGroupTable.this.delGroupCommand.setEnabled(bl);
                BNativeGroupTable.this.mTable.clear();
                BNativeGroupTable.this.membersLabel.setText(BNativeGroupTable.this.getLexicon().getText("UserManager.label.members.null"));
            } else {
                BNativeGroupTable.this.delGroupCommand.setEnabled(false);
                BNativeGroupTable.this.mTable.clear();
                BNativeGroupTable.this.membersLabel.setText(BNativeGroupTable.this.getLexicon().getText("UserManager.label.members.null"));
            }
        }
    }

    public class GroupsModel
    extends TableModel {
        private Array rows = new Array(class$com$tridium$platDaemon$ui$acctmgt$BNativeGroupTable$GroupAccount == null ? (class$com$tridium$platDaemon$ui$acctmgt$BNativeGroupTable$GroupAccount = BNativeGroupTable.class$("com.tridium.platDaemon.ui.acctmgt.BNativeGroupTable$GroupAccount")) : class$com$tridium$platDaemon$ui$acctmgt$BNativeGroupTable$GroupAccount);
        public boolean canModify = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load() throws Exception {
            XElem xElem = XParser.make((InputStream)BNativeGroupTable.this.getDaemonSession().getInputStream((DaemonMessage)new XmlResponseMessage(){

                public String getMessageString() {
                    return "acctmgt";
                }
            })).parse();
            this.canModify = BNativeGroupTable.this.getDaemonSession().getHostProperties().hasFullAccess() && xElem.getb("canModify", true);
            XElem[] xElemArray = xElem.elems("group");
            Array array = this.rows;
            synchronized (array) {
                this.rows.clear();
                for (int i = 0; i < xElemArray.length; ++i) {
                    this.rows.add((Object)new GroupAccount(xElemArray[i].get("name"), xElemArray[i].get("sid", null), xElemArray[i].getb("canDelete", false), xElemArray[i].getb("canModify", false)));
                }
                this.rows.sort();
            }
            this.updateTable(true);
            this.getTable().getSelection().deselectAll();
            BNativeGroupTable.this.mTable.clear();
            BNativeGroupTable.this.membersLabel.setText(BNativeGroupTable.this.getLexicon().getText("UserManager.label.members.null"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            Array array = this.rows;
            synchronized (array) {
                return this.rows.size();
            }
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return lex.getText("UserManager.groupsTable.col.name");
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public boolean canDeleteGroup(int n) {
            return this.canModify && this.getGroup((int)n).canDelete;
        }

        public boolean canModifyGroup(int n) {
            return this.canModify && this.getGroup((int)n).canModify;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GroupAccount getGroup(int n) {
            Array array = this.rows;
            synchronized (array) {
                return (GroupAccount)this.rows.get(n);
            }
        }

        public GroupAccount getGroup(String string) {
            for (int i = 0; i < this.rows.size(); ++i) {
                GroupAccount groupAccount = this.getGroup(i);
                if (!(string.indexOf(92) < 0 ? groupAccount.name.endsWith("\\" + string) : groupAccount.name.equals(string))) continue;
                return groupAccount;
            }
            return null;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.getGroup(n);
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private static class GroupAccount
    extends WinNtAccount {
        public boolean canDelete = false;
        public boolean canModify = false;

        public GroupAccount(String string, String string2, boolean bl, boolean bl2) {
            super(string, string2);
            this.canDelete = bl;
            this.canModify = bl2;
        }
    }
}

