/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.platDaemon.BDaemonSurrogate;
import com.tridium.platDaemon.ConfigDetails;
import com.tridium.platDaemon.ui.BConsoleSelection;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platDaemon.ui.console.BApplicationDirector;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BStationSurrogate;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import javax.baja.file.BExporter;
import javax.baja.file.ExportOp;
import javax.baja.file.types.text.BTextFile;
import javax.baja.registry.TypeInfo;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.workbench.view.BIWbViewExporter;

public class BPlatformTextSummary
extends BExporter
implements BIWbViewExporter {
    public static final Property showPlatformDetails = BPlatformTextSummary.newProperty((int)0, (boolean)true, null);
    public static final Property daemonOutputSelection = BPlatformTextSummary.newProperty((int)0, (BValue)BConsoleSelection.doNotDisplay, null);
    public static final Property daemonOutputLimit = BPlatformTextSummary.newProperty((int)0, (int)4096, null);
    public static final Property appOutputSelection = BPlatformTextSummary.newProperty((int)0, (BValue)BConsoleSelection.doNotDisplay, null);
    public static final Property requestStationThreadDump = BPlatformTextSummary.newProperty((int)0, (boolean)false, null);
    public static final Property appOutputLimit = BPlatformTextSummary.newProperty((int)0, (int)4096, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$BPlatformTextSummary == null ? (class$com$tridium$platDaemon$ui$BPlatformTextSummary = BPlatformTextSummary.class$("com.tridium.platDaemon.ui.BPlatformTextSummary")) : class$com$tridium$platDaemon$ui$BPlatformTextSummary));
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$BPlatformTextSummary;

    public boolean getShowPlatformDetails() {
        return this.getBoolean(showPlatformDetails);
    }

    public void setShowPlatformDetails(boolean bl) {
        this.setBoolean(showPlatformDetails, bl, null);
    }

    public BConsoleSelection getDaemonOutputSelection() {
        return (BConsoleSelection)this.get(daemonOutputSelection);
    }

    public void setDaemonOutputSelection(BConsoleSelection bConsoleSelection) {
        this.set(daemonOutputSelection, (BValue)bConsoleSelection, null);
    }

    public int getDaemonOutputLimit() {
        return this.getInt(daemonOutputLimit);
    }

    public void setDaemonOutputLimit(int n) {
        this.setInt(daemonOutputLimit, n, null);
    }

    public BConsoleSelection getAppOutputSelection() {
        return (BConsoleSelection)this.get(appOutputSelection);
    }

    public void setAppOutputSelection(BConsoleSelection bConsoleSelection) {
        this.set(appOutputSelection, (BValue)bConsoleSelection, null);
    }

    public boolean getRequestStationThreadDump() {
        return this.getBoolean(requestStationThreadDump);
    }

    public void setRequestStationThreadDump(boolean bl) {
        this.setBoolean(requestStationThreadDump, bl, null);
    }

    public int getAppOutputLimit() {
        return this.getInt(appOutputLimit);
    }

    public void setAppOutputLimit(int n) {
        this.setInt(appOutputLimit, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public TypeInfo getFileType() {
        return BTextFile.TYPE.getTypeInfo();
    }

    public String getFileExtension() {
        return "txt";
    }

    public void export(ExportOp exportOp) throws Exception {
        BAppSurrogate bAppSurrogate;
        String string;
        PrintWriter printWriter = new PrintWriter(exportOp.getOutputStream());
        BDaemonSessionView bDaemonSessionView = (BDaemonSessionView)exportOp.get();
        if (this.getShowPlatformDetails()) {
            ConfigDetails.printDetails(bDaemonSessionView.getDaemonPlatform(), bDaemonSessionView.getAppSurrogates(), printWriter);
        }
        if (this.getDaemonOutputSelection() != BConsoleSelection.doNotDisplay) {
            printWriter.println();
            string = this.getLexicon().getText("PlatformTextSummary.daemonOutputHeader");
            printWriter.println(string);
            printWriter.println(BPlatformTextSummary.getDashes(string));
            this.sendConsoleOutput(printWriter, this.getDaemonConsoleOutput(bDaemonSessionView), this.getDaemonOutputSelection(), this.getDaemonOutputLimit());
            printWriter.println();
            printWriter.println(BPlatformTextSummary.getDashes(string));
        }
        if (this.getAppOutputSelection() != BConsoleSelection.doNotDisplay && (bAppSurrogate = this.getSelectedAppSurrogate(bDaemonSessionView)) != null) {
            if (bAppSurrogate instanceof BStationSurrogate && this.getRequestStationThreadDump()) {
                ((BStationSurrogate)bAppSurrogate).dumpThreads();
                Thread.sleep(1000L);
            }
            printWriter.println();
            string = this.getLexicon().getText("PlatformTextSummary.appOutputHeader", new Object[]{bAppSurrogate.toString((Context)exportOp)});
            printWriter.println(string);
            printWriter.println(BPlatformTextSummary.getDashes(string));
            this.sendConsoleOutput(printWriter, this.getAppConsoleOutput(bDaemonSessionView, bAppSurrogate), this.getAppOutputSelection(), this.getAppOutputLimit());
            printWriter.println();
            printWriter.println(BPlatformTextSummary.getDashes(string));
        }
        printWriter.flush();
    }

    protected void sendConsoleOutput(PrintWriter printWriter, Reader reader, BConsoleSelection bConsoleSelection, int n) throws Exception {
        if (bConsoleSelection == BConsoleSelection.allContents) {
            this.pipe(reader, printWriter);
        } else {
            StringWriter stringWriter = new StringWriter();
            this.pipe(reader, stringWriter);
            stringWriter.flush();
            String string = stringWriter.toString();
            if (bConsoleSelection == BConsoleSelection.lastNBytes) {
                if (n <= 0) {
                    throw new IllegalArgumentException();
                }
                if (string.length() > n) {
                    string = string.substring(string.length() - n);
                }
            } else {
                int n2 = string.lastIndexOf("Full thread dump");
                if (n2 > 0) {
                    string = string.substring(n2);
                }
            }
            this.pipe(new StringReader(string), printWriter);
        }
    }

    protected void pipe(Reader reader, Writer writer) throws IOException {
        char[] cArray = new char[1024];
        try {
            int n;
            while ((n = reader.read(cArray, 0, 1024)) >= 0) {
                if (n <= 0) continue;
                writer.write(cArray, 0, n);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private static String getDashes(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append('-');
        }
        return stringBuffer.toString();
    }

    protected BAppSurrogate getSelectedAppSurrogate(BDaemonSessionView bDaemonSessionView) {
        if (bDaemonSessionView instanceof BApplicationDirector) {
            return ((BApplicationDirector)bDaemonSessionView).getSelectedAppSurrogate();
        }
        BAppSurrogate[] bAppSurrogateArray = bDaemonSessionView.getAppSurrogates();
        if (bAppSurrogateArray == null || bAppSurrogateArray.length == 0) {
            return null;
        }
        for (int i = 0; i < bAppSurrogateArray.length; ++i) {
            if (!bAppSurrogateArray[i].isAppRunning()) continue;
            return bAppSurrogateArray[i];
        }
        return bAppSurrogateArray[0];
    }

    protected Reader getAppConsoleOutput(BDaemonSessionView bDaemonSessionView, BAppSurrogate bAppSurrogate) throws ConnectException, AuthenticationException {
        return new InputStreamReader(bAppSurrogate.getAppOutput(false));
    }

    protected Reader getDaemonConsoleOutput(BDaemonSessionView bDaemonSessionView) throws ConnectException, AuthenticationException {
        return new InputStreamReader(new BDaemonSurrogate(bDaemonSessionView.getDaemonSession()).getDaemonOutput(false, false));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

