/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.platDaemon.ui.BOutputPane;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.CommandUtil;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.ConnectException;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.options.BOptions;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;

public class BOutputDialog
extends BFrame {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$BOutputDialog == null ? (class$com$tridium$platDaemon$ui$BOutputDialog = BOutputDialog.class$("com.tridium.platDaemon.ui.BOutputDialog")) : class$com$tridium$platDaemon$ui$BOutputDialog));
    private static Lexicon lex = TYPE.getModule().getLexicon();
    private BOutputPane outputPane;
    private ToggleCommand pauseOutputCommand;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$BOutputDialog;

    public Type getType() {
        return TYPE;
    }

    public BOutputDialog() {
        throw new UnsupportedOperationException();
    }

    public BOutputDialog(BWidget bWidget, BDaemonSession bDaemonSession, BAppSurrogate bAppSurrogate) throws ConnectException, AuthenticationException {
        this(bWidget, bDaemonSession, bAppSurrogate, null);
    }

    public BOutputDialog(BWidget bWidget, BDaemonSession bDaemonSession, BAppSurrogate bAppSurrogate, FilePath filePath) throws ConnectException, AuthenticationException {
        super(lex.getText("OutputDialog.appTitle", new Object[]{bAppSurrogate.toString(null), bDaemonSession.getRemoteAddressString()}));
        this.outputPane = new BOutputPane();
        this.setIconImage(BImage.make((String)lex.getText("OutputDialog.icon")));
        BButtonPane bButtonPane = new BButtonPane();
        if (bAppSurrogate instanceof BStationSurrogate) {
            bButtonPane.add((Command)new DumpThreadsCommand((BStationSurrogate)bAppSurrogate));
        }
        BToggleButton bToggleButton = new BToggleButton();
        bButtonPane.add((BWidget)bToggleButton);
        this.pauseOutputCommand = new PauseOutputCommand((BAbstractButton)bToggleButton);
        bToggleButton.setCommand((Command)this.pauseOutputCommand, true, false);
        bButtonPane.add((Command)new ClearOutputCommand());
        bButtonPane.add((Command)new CloseCommand());
        BOutputPane bOutputPane = null;
        if (filePath == null) {
            bOutputPane = this.outputPane;
        } else {
            BFlowPane bFlowPane = new BFlowPane(BHalign.left);
            bFlowPane.add("capture", (BValue)new BLabel(this.getLexicon().getText("OutputDialog.capture", new Object[]{filePath.getBody()})));
            bOutputPane = new BEdgePane((BWidget)new BBorderPane((BWidget)bFlowPane, 0.0, 0.0, 5.0, 0.0), null, null, null, (BWidget)this.outputPane);
            this.outputPane.setCapturePath(filePath);
        }
        this.setContent((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)bButtonPane, 0.0, 10.0, 10.0, 10.0), null, null, (BWidget)new BBorderPane((BWidget)bOutputPane, 10.0, 10.0, 10.0, 10.0)));
        this.loadBounds();
        this.outputPane.setSession(bDaemonSession);
        this.outputPane.loadApp(bAppSurrogate);
    }

    public BOutputDialog(BWidget bWidget, BDaemonSession bDaemonSession) throws ConnectException, AuthenticationException {
        super(lex.getText("OutputDialog.daemonTitle", new Object[]{bDaemonSession.getRemoteAddressString()}));
        this.outputPane = new BOutputPane();
        this.setIconImage(BImage.make((String)lex.getText("OutputDialog.icon")));
        BButtonPane bButtonPane = new BButtonPane();
        BToggleButton bToggleButton = new BToggleButton();
        bButtonPane.add((BWidget)bToggleButton);
        this.pauseOutputCommand = new PauseOutputCommand((BAbstractButton)bToggleButton);
        bToggleButton.setCommand((Command)this.pauseOutputCommand, true, false);
        bButtonPane.add((Command)new ClearOutputCommand());
        bButtonPane.add((Command)new CloseCommand());
        this.setContent((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)bButtonPane, 0.0, 10.0, 10.0, 10.0), null, null, (BWidget)new BBorderPane((BWidget)this.outputPane, 10.0, 10.0, 10.0, 10.0)));
        this.loadBounds();
        this.outputPane.setSession(bDaemonSession);
        this.outputPane.loadDaemon();
    }

    private void loadBounds() {
        try {
            BOptions bOptions = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            BComponent bComponent = (BComponent)bOptions.get("bounds");
            if (bComponent == null) {
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                this.setPreferredSize((int)(0.9 * dimension.getWidth()), (int)(0.9 * dimension.getHeight()));
                this.setBoundsCenteredOnScreen();
            } else {
                this.setScreenBounds(bComponent.getInt(bComponent.getProperty("x")), bComponent.getInt(bComponent.getProperty("y")), bComponent.getInt(bComponent.getProperty("width")), bComponent.getInt(bComponent.getProperty("height")));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setBoundsCenteredOnScreen() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBoundsCenteredOn(new RectGeom(0.0, 0.0, (double)dimension.width, (double)dimension.height));
    }

    public void setBoundsCenteredOn(RectGeom rectGeom) {
        this.computePreferredSize();
        double d = this.getPreferredWidth() + 8.0;
        double d2 = this.getPreferredHeight() + 27.0;
        double d3 = rectGeom.x + (rectGeom.width - d) / 2.0;
        double d4 = rectGeom.y + (rectGeom.height - d2) / 2.0;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        double d5 = dimension.width;
        double d6 = dimension.height;
        if (d3 + d > d5) {
            d3 = d5 - d;
        }
        if (d4 + d2 > d6) {
            d4 = d6 - d2;
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        if (d4 < 0.0) {
            d4 = 0.0;
        }
        this.setScreenBounds(d3, d4, d, d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.outputPane.stop();
            BOptions bOptions = BOptions.load((String)this.getType().toString(), (Type)BOptions.TYPE);
            BFolder bFolder = new BFolder();
            IRectGeom iRectGeom = this.getScreenBounds();
            bFolder.add("x", (BValue)BInteger.make((int)((int)iRectGeom.x())));
            bFolder.add("y", (BValue)BInteger.make((int)((int)iRectGeom.y())));
            bFolder.add("width", (BValue)BInteger.make((int)((int)iRectGeom.width())));
            bFolder.add("height", (BValue)BInteger.make((int)((int)iRectGeom.height())));
            if (bOptions.get("bounds") == null) {
                bOptions.add("bounds", (BValue)bFolder);
            } else {
                bOptions.set("bounds", (BValue)bFolder);
            }
            bOptions.save();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            super.close();
        }
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.close();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DumpThreadsCommand
    extends Command {
        BStationSurrogate station;

        public DumpThreadsCommand(BStationSurrogate bStationSurrogate) {
            super((BWidget)BOutputDialog.this, TYPE.getModule(), "StationSurrogateView.command.dumpThread");
            this.station = bStationSurrogate;
        }

        public CommandArtifact doInvoke() {
            try {
                this.station.dumpThreads();
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class ClearOutputCommand
    extends Command {
        public ClearOutputCommand() {
            super((BWidget)BOutputDialog.this, TYPE.getModule(), "AppSurrogateView.command.clearOutput");
        }

        public CommandArtifact doInvoke() throws Exception {
            BOutputDialog.this.outputPane.clearText();
            return null;
        }
    }

    private class PauseOutputCommand
    extends ToggleCommand {
        public PauseOutputCommand(BAbstractButton bAbstractButton) {
            super((BWidget)bAbstractButton, TYPE.getModule(), "AppSurrogateView.command.pauseOutput");
        }

        public String getLabel() {
            if (this.isSelected()) {
                return BOutputDialog.this.getLexicon().getText("AppSurrogateView.command.loadOutput.label");
            }
            return BOutputDialog.this.getLexicon().getText("AppSurrogateView.command.pauseOutput.label");
        }

        public CommandArtifact doInvoke() throws Exception {
            try {
                BAbstractButton bAbstractButton = (BAbstractButton)this.getOwner();
                bAbstractButton.setText(this.getLabel());
                if (this.isSelected()) {
                    BOutputDialog.this.outputPane.stopUpdates();
                } else {
                    BOutputDialog.this.outputPane.load();
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class CloseCommand
    extends Command {
        public CloseCommand() {
            super((BWidget)BOutputDialog.this, TYPE.getModule(), "OutputDialog.command.close");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() throws Exception {
            try {
                BOutputDialog.this.outputPane.deactivated();
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            finally {
                BOutputDialog.this.close();
            }
            return null;
        }
    }
}

