/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.platDaemon.BDaemonSurrogate;
import com.tridium.platDaemon.SessionSurrogates;
import com.tridium.platDaemon.ui.DaemonNavListModel;
import com.tridium.platDaemon.ui.DaemonSessionTaskHandler;
import com.tridium.platDaemon.ui.IDaemonSessionView;
import com.tridium.platform.BSessionNavNode;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.workbench.auth.AuthUtil;
import java.net.ConnectException;
import javax.baja.gx.BImage;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.list.ListModel;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Lexicon;
import javax.baja.util.Queue;
import javax.baja.util.QueueFullException;
import javax.baja.util.Worker;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

public abstract class BDaemonSessionView
extends BWbComponentView
implements IDaemonSessionView {
    public static final Action handleDaemonDropDownModified = BDaemonSessionView.newAction((int)4, null);
    public static final Action handleHostPropertiesChanged = BDaemonSessionView.newAction((int)4, null);
    public static final Action refresh = BDaemonSessionView.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$BDaemonSessionView == null ? (class$com$tridium$platDaemon$ui$BDaemonSessionView = BDaemonSessionView.class$("com.tridium.platDaemon.ui.BDaemonSessionView")) : class$com$tridium$platDaemon$ui$BDaemonSessionView));
    private Queue refreshQueue = new CoalesceQueue(10);
    private Worker refreshWorker = null;
    private BDaemonSession session;
    public static Log log = Log.getLog((String)"platDaemon");
    public static Lexicon lexicon = Lexicon.make((String)"platDaemon");
    protected boolean loading = false;
    private BToolBar toolBar = new BToolBar();
    private SessionHomeCommand sessionHomeCommand;
    private BListDropDown daemonDropDown = new BListDropDown();
    private DaemonNavListModel daemonDropDownModel;
    private ValueLoader loader = null;
    protected boolean canceled = false;
    private SessionSurrogates surrogates;
    private DaemonSessionTaskHandler sessionTaskHandler;
    private Clock.Ticket refreshTicket = null;
    private static final long REFRESH_MILLIS = 5000L;
    private static final int MAX_REFRESH_QUEUE_SIZE = 10;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$BDaemonSessionView;

    public void handleDaemonDropDownModified() {
        this.invoke(handleDaemonDropDownModified, null, null);
    }

    public void handleHostPropertiesChanged() {
        this.invoke(handleHostPropertiesChanged, null, null);
    }

    public void refresh() {
        this.invoke(refresh, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDaemonSessionView() {
        this.toolBar.add(null, (BValue)this.daemonDropDown);
        this.sessionHomeCommand = new SessionHomeCommand((BWidget)this.toolBar);
        this.toolBar.add("sessionHome", (Command)this.sessionHomeCommand);
        this.daemonDropDownModel = new DaemonNavListModel();
        this.daemonDropDown.getList().setModel((ListModel)this.daemonDropDownModel);
        this.linkTo("daemonDropDownModified", (BComponent)this.daemonDropDown, (Slot)BDropDown.valueModified, (Slot)handleDaemonDropDownModified);
        this.sessionTaskHandler = new DaemonSessionTaskHandler((BWidget)this);
    }

    protected final void doLoadValue(BObject bObject, Context context) throws Exception {
        this.canceled = false;
        if (bObject instanceof BDaemonSession) {
            this.session = (BDaemonSession)bObject;
        } else {
            BSessionNavNode bSessionNavNode = (BSessionNavNode)bObject;
            this.session = (BDaemonSession)bSessionNavNode.getNavSession();
        }
        this.surrogates = new SessionSurrogates(this.session);
        this.linkTo(null, (BComponent)this.session.getHostProperties(), (Slot)BHostProperties.hostPropertiesChanged, (Slot)handleHostPropertiesChanged);
        this.loading = true;
        this.daemonDropDown.setSelectedItem((Object)this.session.getRemoteAddressString());
        this.sessionHomeCommand.setSession(this.session);
        if (this.loader != null && this.loader.isAlive()) {
            this.loader.interrupt();
        }
        this.loader = new ValueLoader(context);
        this.loader.start();
    }

    public void doHandleHostPropertiesChanged() {
    }

    protected void doLoadSession(BDaemonSession bDaemonSession, Context context) {
    }

    public BToolBar getViewToolBar() {
        return this.toolBar;
    }

    public void deactivated() {
        super.deactivated();
        this.canceled = true;
        if (this.loader != null && this.loader.isAlive()) {
            this.loader.interrupt();
        }
    }

    public BDaemonSession getDaemonSession() {
        return this.session;
    }

    public BDaemonPlatform getDaemonPlatform() throws AuthenticationException, ConnectException {
        try {
            return BRemoteDaemonPlatform.make((BDaemonSession)this.getDaemonSession(), (DaemonSessionTaskListener)this);
        }
        catch (ConnectException connectException) {
            return null;
        }
    }

    protected boolean isViewLoading() {
        return this.loading;
    }

    public BDaemonSurrogate getDaemonSurrogate(boolean bl) throws AuthenticationException {
        try {
            return this.surrogates.getDaemonSurrogate(bl);
        }
        catch (ConnectException connectException) {
            return null;
        }
    }

    public BVector getAppSurrogateVector(boolean bl) throws AuthenticationException {
        try {
            return this.surrogates.getVector(bl);
        }
        catch (ConnectException connectException) {
            return null;
        }
    }

    public boolean areAppsRunning() throws AuthenticationException {
        try {
            return this.surrogates.areAppsRunning();
        }
        catch (ConnectException connectException) {
            return false;
        }
    }

    public BAppSurrogate[] getAppSurrogates() throws AuthenticationException {
        try {
            return this.getAppSurrogatesWithExceptions();
        }
        catch (ConnectException connectException) {
            return null;
        }
    }

    public BAppSurrogate[] getAppSurrogatesWithExceptions() throws ConnectException, AuthenticationException {
        return this.surrogates.getAll();
    }

    public BStationSurrogate getStationSurrogate(String string, boolean bl) throws AuthenticationException {
        try {
            return (BStationSurrogate)this.surrogates.get(BStationSurrogate.TYPE, string, bl);
        }
        catch (ConnectException connectException) {
            return null;
        }
    }

    public void resetAppSurrogates() throws AuthenticationException {
        try {
            this.surrogates.reset();
        }
        catch (ConnectException connectException) {
            // empty catch block
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void resetCanceled() {
        this.canceled = false;
    }

    public void cancel() {
        this.canceled = true;
    }

    protected void promptForReboot(boolean bl) {
        if (bl && !this.session.usesLocalNiagaraEnvironment() && 4 != BDialog.confirm((BWidget)this, (String)this.getLexicon().getText("DaemonSessionView.reboot.promptTitle", new Object[]{this.session.getRemoteAddressString()}), (Object)this.getLexicon().getText("DaemonSessionView.reboot.promptMessage", new Object[]{this.session.getRemoteAddressString()}), (int)12)) {
            return;
        }
        if (this.session.usesLocalNiagaraEnvironment()) {
            BDialog.message((BWidget)this, (String)this.getLexicon().getText("DaemonSessionView.rebootLocal.title", new Object[]{this.session.getRemoteAddressString()}), (Object)this.getLexicon().getText("DaemonSessionView.rebootLocal.message", new Object[]{this.session.getRemoteAddressString()}));
            return;
        }
        try {
            BWidgetShell bWidgetShell = this.getShell();
            this.getDaemonSession().sendRebootRequest();
            if (bWidgetShell != null) {
                BDialog.message((BWidget)bWidgetShell, (String)this.getLexicon().getText("DaemonSessionView.reboot.notifyTitle", new Object[]{this.session.getRemoteAddressString()}), (Object)this.getLexicon().getText("DaemonSessionView.reboot.notifyMessage", new Object[]{this.session.getRemoteAddressString()}));
            }
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public boolean reauthenticate(AuthenticationException authenticationException) {
        return AuthUtil.challenge((BWidget)this.getWbShell(), (AuthenticationException)authenticationException);
    }

    public void startRefreshTimer() {
        if (this.isRunning()) {
            this.refresh();
            if (this.refreshWorker == null) {
                this.refreshWorker = new Worker((Worker.ITodo)this.refreshQueue);
            }
            if (!this.refreshWorker.isRunning()) {
                this.refreshWorker.start(this.getClass().getSimpleName() + ":refreshWorker");
            }
            if (this.refreshTicket == null && this.isRunning()) {
                this.refreshTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)5000L), (Action)refresh, null);
            }
        }
    }

    public void stopRefreshTimer() {
        if (this.refreshTicket != null) {
            if (this.refreshWorker != null && this.refreshWorker.isRunning()) {
                this.refreshWorker.stop();
                this.refreshWorker = null;
            }
            this.refreshTicket.cancel();
            this.refreshTicket = null;
        }
    }

    public boolean isRefreshTimerRunning() {
        return this.refreshTicket != null;
    }

    public void doHandleDaemonDropDownModified() {
        if (this.isViewLoading()) {
            return;
        }
        BDaemonSession bDaemonSession = this.daemonDropDownModel.getSession(this.daemonDropDown.getSelectedIndex());
        this.getWbShell().hyperlink(BOrd.make((BOrd)bDaemonSession.getAbsoluteOrd(), (OrdQuery)new ViewQuery(this.getType().toString())));
    }

    public void doRefresh() throws Exception {
    }

    public void taskStarted(DaemonSessionTask daemonSessionTask) {
        this.sessionTaskHandler.taskStarted(daemonSessionTask);
    }

    public void taskUpdated(DaemonSessionTask daemonSessionTask) {
        this.sessionTaskHandler.taskUpdated(daemonSessionTask);
    }

    public void taskFinished(DaemonSessionTask daemonSessionTask) {
        this.sessionTaskHandler.taskFinished(daemonSessionTask);
    }

    public boolean isCancelEnabled() {
        return this.sessionTaskHandler.isCancelEnabled();
    }

    public void setCancelEnabled(boolean bl) {
        this.sessionTaskHandler.setCancelEnabled(bl);
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals(refresh)) {
            try {
                this.refreshQueue.enqueue((Object)new Runnable(){

                    public void run() {
                        try {
                            BDaemonSessionView.this.doRefresh();
                        }
                        catch (Exception exception) {
                            log.error("Error refreshing daemonSessionView: " + exception != null ? exception.getMessage() : "");
                        }
                    }
                });
            }
            catch (QueueFullException queueFullException) {
                // empty catch block
            }
            return null;
        }
        return super.post(action, bValue, context);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ValueLoader
    extends Thread {
        private Context cx;
        private BWbShell shell;

        public ValueLoader(Context context) {
            this.cx = context;
            this.shell = BDaemonSessionView.this.getWbShell();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl = true;
            while (bl) {
                bl = false;
                try {
                    if (this.shell != null) {
                        this.shell.enterBusy();
                    }
                    BDaemonSessionView.this.doLoadSession(BDaemonSessionView.this.session, this.cx);
                }
                catch (AuthenticationException authenticationException) {
                    if (!BDaemonSessionView.this.reauthenticate(authenticationException)) continue;
                    bl = true;
                }
                catch (Exception exception) {
                    if (this.shell != null) {
                        BDialog.error((BWidget)this.shell, (String)BDaemonSessionView.this.getLexicon().getText("DaemonSessionView.loadError.dlgTitle"), (Object)BDaemonSessionView.this.getLexicon().getText("DaemonSessionView.loadError.dlgMessage"), (Throwable)exception);
                        continue;
                    }
                    exception.printStackTrace();
                }
                finally {
                    BDaemonSessionView.this.loading = false;
                    if (this.shell == null) continue;
                    this.shell.exitBusy();
                }
            }
        }
    }

    public class SessionHomeCommand
    extends Command {
        BOrd ord;

        SessionHomeCommand(BWidget bWidget) {
            super(bWidget, null);
        }

        public CommandArtifact doInvoke() {
            BDaemonSessionView.this.getWbShell().hyperlink(this.ord);
            return null;
        }

        public void setSession(BDaemonSession bDaemonSession) {
            this.ord = bDaemonSession.getAbsoluteOrd();
        }

        public BImage getIcon() {
            return BImage.make((BIcon)BIcon.std((String)"platform.png"));
        }
    }
}

