/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.platDaemon.BDaemonSSLStatus;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.platform.ui.util.PortConfigController;
import com.tridium.ui.theme.Theme;
import java.io.InputStream;
import java.util.ArrayList;
import javax.baja.security.AuthenticationException;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.DefaultListModel;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.TextController;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.LexiconText;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class BDaemonSSLSettingsView
extends BDaemonSessionView {
    public static final Action settingModified = BDaemonSSLSettingsView.newAction((int)4, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$BDaemonSSLSettingsView == null ? (class$com$tridium$platDaemon$ui$BDaemonSSLSettingsView = BDaemonSSLSettingsView.class$("com.tridium.platDaemon.ui.BDaemonSSLSettingsView")) : class$com$tridium$platDaemon$ui$BDaemonSSLSettingsView));
    private DialogCommand saveCommand;
    private BGridPane grid = new BGridPane(2);
    private BPlatformSSLSettings settings = null;
    private BHostProperties hostProperties = null;
    private BListDropDown sslStatusDd;
    private BTextField sslPortTextField;
    private BTextDropDown sslAliasTextDd;
    private BListDropDown sslAlgTypeDd;
    public static BIcon ICON = BIcon.std((String)"daemon.png");
    private static final boolean EDITABLE = true;
    private static final int MAX_ALIAS_DISPLAY_WIDTH = 25;
    private static final int MIN_ALIAS_DISPLAY_WIDTH = 8;
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$BDaemonSSLSettingsView;

    public void settingModified(BWidgetEvent bWidgetEvent) {
        this.invoke(settingModified, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDaemonSSLSettingsView() {
        this.grid.setRowGap(5.0);
        this.grid.setHalign(BHalign.center);
        this.grid.setValign(BValign.center);
        BScrollPane bScrollPane = new BScrollPane((BWidget)this.grid);
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bScrollPane);
        bConstrainedPane.setMinSize(225.0, 130.0);
        this.setContent((BWidget)bConstrainedPane);
        this.saveCommand = new SaveCommand();
    }

    public void doLoadSession(BDaemonSession bDaemonSession, Context context) throws AuthenticationException {
        if (bDaemonSession.getHostProperties().getSslSupported()) {
            this.hostProperties = bDaemonSession.getHostProperties();
            BPlatformSSLSettings bPlatformSSLSettings = this.hostProperties.getSslSettings();
            this.settings = new BPlatformSSLSettings(bPlatformSSLSettings);
            this.createSSLEnabledDropDown(bPlatformSSLSettings);
            this.createSSLPortTextField(bPlatformSSLSettings);
            if (this.hostProperties.hasFullAccess()) {
                BDaemonSSLSettingsView.loadAliases(bDaemonSession, bPlatformSSLSettings);
            }
            this.createKeyAlias(bPlatformSSLSettings);
            this.createAlgTypeDropDown(bPlatformSSLSettings);
        }
    }

    private void createSSLEnabledDropDown(BPlatformSSLSettings bPlatformSSLSettings) {
        int n;
        this.sslStatusDd = new BListDropDown();
        LabelUtil.addLabelWidgetPair((BGridPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.sslStatus"), (BWidget)this.sslStatusDd);
        DefaultListModel defaultListModel = (DefaultListModel)this.sslStatusDd.getList().getModel();
        int[] nArray = BDaemonSSLStatus.make(0).getRange().getOrdinals();
        for (n = 0; n < nArray.length; ++n) {
            if (n == 3) continue;
            defaultListModel.addItem(null, (Object)BDaemonSSLStatus.make(nArray[n]));
        }
        n = 0;
        if (bPlatformSSLSettings.getSslEnabled()) {
            n = bPlatformSSLSettings.getSslOnly() ? 2 : 1;
        }
        this.sslStatusDd.getList().setSelectedIndex(n);
        this.linkTo((BComponent)this.sslStatusDd, (Slot)BListDropDown.valueModified, (Slot)settingModified);
        this.sslStatusDd.setEnabled(this.hostProperties.hasFullAccess());
    }

    private void createSSLPortTextField(BPlatformSSLSettings bPlatformSSLSettings) {
        String string = bPlatformSSLSettings.getSslPort() < 0 ? "" : String.valueOf(bPlatformSSLSettings.getSslPort());
        this.sslPortTextField = new BTextField(string, 5);
        LabelUtil.addLabelWidgetPair((BGridPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.sslSettings.sslPort"), (BWidget)this.sslPortTextField);
        this.sslPortTextField.setController((TextController)new PortConfigController());
        this.linkTo((BComponent)this.sslPortTextField, (Slot)BTextField.textModified, (Slot)settingModified);
        this.sslPortTextField.setEnabled(this.hostProperties.hasFullAccess());
    }

    private void createKeyAlias(BPlatformSSLSettings bPlatformSSLSettings) {
        String string = bPlatformSSLSettings.getKeyAlias();
        ArrayList<String> arrayList = bPlatformSSLSettings.getAliases();
        int n = 8;
        boolean bl = false;
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = (String)arrayList.get(i);
                if (string2.equalsIgnoreCase(string)) {
                    bl = true;
                }
                if (string2.length() <= n) continue;
                if (string2.length() < 25) {
                    n = string2.length();
                    continue;
                }
                n = 25;
                break;
            }
        } else {
            arrayList = new ArrayList<String>(0);
        }
        if (!bl) {
            arrayList.add(string);
        }
        this.sslAliasTextDd = new BTextDropDown(arrayList, n, true);
        BList bList = this.sslAliasTextDd.getList();
        for (int i = 0; i < bList.getItemCount(); ++i) {
            String string3 = (String)bList.getItem(i);
            if (!string3.equalsIgnoreCase(string)) continue;
            bList.setSelectedIndex(i);
            this.sslAliasTextDd.setText((String)bList.getSelectedItem());
            break;
        }
        LabelUtil.addLabelWidgetPair((BGridPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.sslSettings.sslKeyAlias"), (BWidget)this.sslAliasTextDd);
        this.linkTo((BComponent)this.sslAliasTextDd, (Slot)BTextDropDown.valueModified, (Slot)settingModified);
        this.sslAliasTextDd.setEnabled(this.hostProperties.hasFullAccess());
    }

    private static void loadAliases(BDaemonSession bDaemonSession, BPlatformSSLSettings bPlatformSSLSettings) {
        BHostProperties bHostProperties = bDaemonSession.getHostProperties();
        if (bHostProperties.getSslSupported() && bHostProperties.supportsServlet("crypto")) {
            try {
                InputStream inputStream = bDaemonSession.getInputStream("crypto", BDaemonSession.DEFAULT_TIMEOUT, null, null);
                XElem xElem = XParser.make((InputStream)inputStream).parse();
                bPlatformSSLSettings.loadAliases(xElem);
            }
            catch (Exception exception) {
                log.trace("Exception loading aliases.");
            }
        }
    }

    private void createAlgTypeDropDown(BPlatformSSLSettings bPlatformSSLSettings) {
        this.sslAlgTypeDd = new BListDropDown();
        LabelUtil.addLabelWidgetPair((BGridPane)this.grid, (LexiconText)LexiconText.make((Type)TYPE, (String)"PlatformAdministration.command.sslSettings.sslAlgType"), (BWidget)this.sslAlgTypeDd);
        DefaultListModel defaultListModel = (DefaultListModel)this.sslAlgTypeDd.getList().getModel();
        int[] nArray = BSslTlsEnum.make((int)2).getRange().getOrdinals();
        for (int i = 0; i < nArray.length; ++i) {
            BSslTlsEnum bSslTlsEnum = BSslTlsEnum.make((int)nArray[i]);
            defaultListModel.addItem(null, (Object)bSslTlsEnum);
            if (bSslTlsEnum != bPlatformSSLSettings.getSslAlgType()) continue;
            this.sslAlgTypeDd.getList().setSelectedIndex(i);
        }
        this.linkTo((BComponent)this.sslAlgTypeDd, (Slot)BListDropDown.valueModified, (Slot)settingModified);
        if (bPlatformSSLSettings.getFipsMode()) {
            this.sslAlgTypeDd.setEnabled(false);
            this.sslAlgTypeDd.getList().setSelectedItem((Object)BSslTlsEnum.tlsv1);
        } else {
            this.sslAlgTypeDd.setEnabled(this.hostProperties.hasFullAccess());
        }
    }

    public DialogCommand getSaveCommand() {
        return this.saveCommand;
    }

    public BPlatformSSLSettings getSettings() {
        return this.settings;
    }

    public void doSettingModified(BWidgetEvent bWidgetEvent) {
        if (this.hostProperties.hasFullAccess()) {
            this.saveCommand.setEnabled(true);
            this.settings.setKeyAlias(this.sslAliasTextDd.getText());
            this.settings.setSslAlgType((BSslTlsEnum)this.sslAlgTypeDd.getSelectedItem());
            this.settings.setSslPort(Integer.valueOf(this.sslPortTextField.getText()).intValue());
            this.settings.setSslEnabled(this.sslStatusDd.getSelectedIndex() == 1 || this.sslStatusDd.getSelectedIndex() == 2);
            this.settings.setSslOnly(this.sslStatusDd.getSelectedIndex() == 2);
        }
    }

    public BIcon getIcon() {
        return ICON;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SaveCommand
    extends DialogCommand {
        public SaveCommand() {
            super((BWidget)BDaemonSSLSettingsView.this, 1, UiLexicon.bajaui.getText("commands.save.label"), null, null, null);
            this.setEnabled(false);
        }
    }
}

