/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.ui;

import com.tridium.platDaemon.BDaemonLogLevel;
import com.tridium.platDaemon.BDaemonSurrogate;
import com.tridium.platDaemon.ui.BDaemonSessionView;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.ui.util.LabelUtil;
import com.tridium.ui.theme.Theme;
import javax.baja.naming.SlotPath;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.DefaultListModel;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.LexiconText;

public class BDaemonLogSettingsView
extends BDaemonSessionView {
    public static final Action handleListSelectionModified = BDaemonLogSettingsView.newAction((int)4, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$ui$BDaemonLogSettingsView == null ? (class$com$tridium$platDaemon$ui$BDaemonLogSettingsView = BDaemonLogSettingsView.class$("com.tridium.platDaemon.ui.BDaemonLogSettingsView")) : class$com$tridium$platDaemon$ui$BDaemonLogSettingsView));
    public static BIcon ICON = BIcon.std((String)"daemon.png");
    private boolean isActivated = false;
    private BDaemonSurrogate surrogate;
    private BGridPane grid = new BGridPane(2);
    static /* synthetic */ Class class$com$tridium$platDaemon$ui$BDaemonLogSettingsView;

    public void handleListSelectionModified(BWidgetEvent bWidgetEvent) {
        this.invoke(handleListSelectionModified, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDaemonLogSettingsView() {
        this.autoRegisterForComponentEvents = false;
        this.grid.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"DaemonLogSettingsView.log"), (boolean)true));
        this.grid.add(null, (BValue)LabelUtil.makeLabel((LexiconText)LexiconText.make((Type)TYPE, (String)"DaemonLogSettingsView.value"), (boolean)true));
        BScrollPane bScrollPane = new BScrollPane((BWidget)this.grid);
        bScrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane bConstrainedPane = new BConstrainedPane((BWidget)bScrollPane);
        bConstrainedPane.setMinSize(200.0, 250.0);
        this.setContent((BWidget)bConstrainedPane);
    }

    public void activated() {
        super.activated();
        if (this.isRunning() && this.getCurrentValue() != null) {
            this.startRefreshTimer();
        }
        this.isActivated = true;
    }

    public void deactivated() {
        super.deactivated();
        this.stopRefreshTimer();
        this.isActivated = false;
    }

    protected void doLoadSession(BDaemonSession bDaemonSession, Context context) throws AuthenticationException {
        this.surrogate = this.getDaemonSurrogate(true);
        this.registerForComponentEvents(this.surrogate, 3);
        SlotCursor slotCursor = this.surrogate.getLogLevels().getProperties();
        while (slotCursor.next()) {
            String string = slotCursor.property().getName();
            this.grid.add(string + "lbl", (BValue)new BLabel(SlotPath.unescape((String)string)));
            this.grid.add(string, (BValue)this.makeDaemonLogLevelWidget(slotCursor.get()));
        }
        this.startRefreshTimer();
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (this.loading) {
            return;
        }
        if (bComponentEvent.getSourceComponent() == this.surrogate.getLogLevels()) {
            if (bComponentEvent.getId() == 0) {
                BListDropDown bListDropDown = (BListDropDown)this.grid.get(bComponentEvent.getSlotName());
                bListDropDown.setSelectedItem((Object)bComponentEvent.getValue());
            } else if (bComponentEvent.getId() == 2) {
                this.grid.remove(bComponentEvent.getSlotName() + "lbl");
                this.grid.remove(bComponentEvent.getSlotName());
            } else if (bComponentEvent.getId() == 1) {
                this.grid.add(bComponentEvent.getSlotName() + "lbl", (BValue)new BLabel(SlotPath.unescape((String)bComponentEvent.getSlotName())));
                this.grid.add(bComponentEvent.getSlotName(), (BValue)this.makeDaemonLogLevelWidget((BObject)bComponentEvent.getValue()));
            }
        }
    }

    public void doRefresh() throws Exception {
        this.surrogate.poll();
    }

    public void doHandleListSelectionModified(BWidgetEvent bWidgetEvent) throws Exception {
        BListDropDown bListDropDown = (BListDropDown)bWidgetEvent.getWidget();
        this.surrogate.setLogLevel(SlotPath.unescape((String)bListDropDown.getPropertyInParent().getName()), (BDaemonLogLevel)((Object)bListDropDown.getSelectedItem()));
    }

    public void started() throws Exception {
        super.started();
        if (this.isActivated && this.getCurrentValue() != null && !this.isRefreshTimerRunning()) {
            this.startRefreshTimer();
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.stopRefreshTimer();
    }

    public BIcon getIcon() {
        return ICON;
    }

    private BListDropDown makeDaemonLogLevelWidget(BObject bObject) {
        BListDropDown bListDropDown = new BListDropDown();
        DefaultListModel defaultListModel = (DefaultListModel)bListDropDown.getList().getModel();
        int[] nArray = BDaemonLogLevel.make(0).getRange().getOrdinals();
        for (int i = 0; i < nArray.length; ++i) {
            defaultListModel.addItem(null, (Object)BDaemonLogLevel.make(nArray[i]));
        }
        bListDropDown.getList().setSelectedItem((Object)bObject);
        this.linkTo((BComponent)bListDropDown, (Slot)BListDropDown.valueModified, (Slot)handleListSelectionModified);
        return bListDropDown;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

