/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platDaemon.BDaemonSurrogate;
import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.util.CommandLineArguments;
import java.io.EOFException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import javax.baja.log.Log;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BWatchStationCommand
extends BDaemonSessionCommand {
    public static final BWatchStationCommand INSTANCE = new BWatchStationCommand();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$command$BWatchStationCommand == null ? (class$com$tridium$platDaemon$command$BWatchStationCommand = BWatchStationCommand.class$("com.tridium.platDaemon.command.BWatchStationCommand")) : class$com$tridium$platDaemon$command$BWatchStationCommand));
    private static Log log = Log.getLog((String)"watchstation");
    static /* synthetic */ Class class$com$tridium$platDaemon$command$BWatchStationCommand;

    public Type getType() {
        return TYPE;
    }

    protected BWatchStationCommand() {
    }

    public String getCommandName() {
        return "watchstation";
    }

    public String getCommandDescription() {
        return "monitor the output of a Niagara station";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BWatchStationCommand.println((String)"");
        BWatchStationCommand.println((String)"usage:");
        BWatchStationCommand.println((String)"  plat watchstation <flags> [stationname]");
        BWatchStationCommand.println((String)"parameters:");
        BWatchStationCommand.println((String)"  stationname        name of the station to view, or \"daemon\"");
        BWatchStationCommand.println((String)"                       if the daemon's output is to be watched.");
        BWatchStationCommand.println((String)"                       If omitted, the first/only station will be used");
        BWatchStationCommand.println((String)"required flags:");
        BWatchStationCommand.println((String)"  -h:<hostord>       host's ORD");
        BWatchStationCommand.println((String)"optional flags:");
        BWatchStationCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon");
        BWatchStationCommand.println((String)"  -pwd:<password>    password for the host's platform daemon");
        BWatchStationCommand.println((String)"  -noinput           if given, command will fail when username");
        BWatchStationCommand.println((String)"                       and password are missing or incorrect,");
        BWatchStationCommand.println((String)"                       instead of prompting and reading them");
        BWatchStationCommand.println((String)"                       from stdin");
        BWatchStationCommand.println((String)"  -p:<port>          port for the host's platform daemon");
        BWatchStationCommand.println((String)"                       if omitted, default port 3011 is used");
        BWatchStationCommand.println((String)"  -follow            if specified, the command will execute until");
        BWatchStationCommand.println((String)"                       it is killed (ctrl-c), and will continue");
        BWatchStationCommand.println((String)"                       to display output as the station produces it");
        BWatchStationCommand.println((String)"  -f                 same as -follow");
        BWatchStationCommand.println((String)"  -locale:<x>        set the default locale (en_US)");
        BWatchStationCommand.println((String)"  -@<option>         pass option to Java VM");
        BWatchStationCommand.println((String)"  -buildreg          force rebuild of the registry");
        BWatchStationCommand.println((String)"");
    }

    public int invoke(CommandLineArguments commandLineArguments) throws Exception {
        InputStream inputStream;
        if (commandLineArguments.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession bDaemonSession = this.getSession(commandLineArguments);
        if (bDaemonSession == null) {
            this.usage();
            return 2;
        }
        boolean bl = commandLineArguments.hasOption("follow") || commandLineArguments.hasOption("f");
        byte[] byArray = new byte[1024];
        BStationSurrogate bStationSurrogate = null;
        if (commandLineArguments.parameters.length != 0) {
            if (commandLineArguments.parameters[0].equals("daemon")) {
                System.out.println();
                if (bl) {
                    System.out.println("Output will be followed, use control-c to exit");
                }
                System.out.println("------------------ Output of Niagara platform daemon on " + bDaemonSession.getHost() + " ------------------");
                inputStream = new BDaemonSurrogate(bDaemonSession).getDaemonOutput();
            } else {
                bStationSurrogate = BStationSurrogate.make((BDaemonSession)bDaemonSession, (String)commandLineArguments.parameters[0]);
                if (bStationSurrogate == null) {
                    log.warning("Station " + commandLineArguments.parameters[0] + " not found");
                    return 4;
                }
                System.out.println();
                if (bl) {
                    System.out.println("Output will be followed, use control-c to exit");
                }
                System.out.println("------------------ Output of station " + bStationSurrogate.getStationName() + " on " + bDaemonSession.getHost() + " ------------------");
                inputStream = bStationSurrogate.getStationOutput(bl);
            }
        } else {
            BStationSurrogate[] bStationSurrogateArray = BStationSurrogate.makeAll((BDaemonSession)bDaemonSession);
            if (bStationSurrogateArray.length == 0) {
                log.warning("No stations on remote host");
                return 4;
            }
            bStationSurrogate = bStationSurrogateArray[0];
            System.out.println();
            if (bl) {
                System.out.println("Output will be followed, use control-c to exit");
            }
            System.out.println("------------------ Output of station " + bStationSurrogate.getStationName() + " on " + bDaemonSession.getHost() + " ------------------");
            inputStream = bStationSurrogate.getStationOutput(bl);
        }
        while (true) {
            int n;
            try {
                n = inputStream.read(byArray, 0, 1024);
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            catch (EOFException eOFException) {
                return 0;
            }
            if (n <= 0) break;
            System.out.write(byArray, 0, n);
        }
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

