/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.util.CommandLineArguments;
import javax.baja.log.Log;
import javax.baja.platform.BStationStatus;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BStopStationCommand
extends BDaemonSessionCommand {
    public static final BStopStationCommand INSTANCE = new BStopStationCommand();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$command$BStopStationCommand == null ? (class$com$tridium$platDaemon$command$BStopStationCommand = BStopStationCommand.class$("com.tridium.platDaemon.command.BStopStationCommand")) : class$com$tridium$platDaemon$command$BStopStationCommand));
    private static Log log = Log.getLog((String)"stopstation");
    static /* synthetic */ Class class$com$tridium$platDaemon$command$BStopStationCommand;

    public Type getType() {
        return TYPE;
    }

    protected BStopStationCommand() {
    }

    public String getCommandName() {
        return "stopstation";
    }

    public String getCommandDescription() {
        return "request that a Niagara Platform Daemon stop a station";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BStopStationCommand.println((String)"");
        BStopStationCommand.println((String)"usage:");
        BStopStationCommand.println((String)"  plat stopstation <flags> [stationname]");
        BStopStationCommand.println((String)"parameters:");
        BStopStationCommand.println((String)"  stationname        name of the station to stop.   If omitted,");
        BStopStationCommand.println((String)"                       the first/only station will be stopped");
        BStopStationCommand.println((String)"required flags:");
        BStopStationCommand.println((String)"  -h:<hostord>       host's ORD");
        BStopStationCommand.println((String)"optional flags:");
        BStopStationCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon");
        BStopStationCommand.println((String)"  -pwd:<password>    password for the host's platform daemon");
        BStopStationCommand.println((String)"  -noinput           if given, command will fail when username");
        BStopStationCommand.println((String)"                       and password are missing or incorrect,");
        BStopStationCommand.println((String)"                       instead of prompting and reading them");
        BStopStationCommand.println((String)"                       from stdin");
        BStopStationCommand.println((String)"  -p:<port>          port for the host's platform daemon");
        BStopStationCommand.println((String)"                       if omitted, default port 3011 is used");
        BStopStationCommand.println((String)"  -restart           if provided, the station will be restarted");
        BStopStationCommand.println((String)"                       after it terminates");
        BStopStationCommand.println((String)"  -kill              kill the station immediately, instead of allowing");
        BStopStationCommand.println((String)"                       it to gracefully terminate");
        BStopStationCommand.println((String)"  -locale:<x>        set the default locale (en_US)");
        BStopStationCommand.println((String)"  -@<option>         pass option to Java VM");
        BStopStationCommand.println((String)"  -buildreg          force rebuild of the registry");
        BStopStationCommand.println((String)"");
    }

    public int invoke(CommandLineArguments commandLineArguments) throws Exception {
        String string;
        BStationSurrogate bStationSurrogate;
        if (commandLineArguments.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession bDaemonSession = this.getSession(commandLineArguments);
        if (bDaemonSession == null) {
            this.usage();
            return 2;
        }
        boolean bl = commandLineArguments.hasOption("restart");
        boolean bl2 = commandLineArguments.hasOption("kill");
        if (commandLineArguments.parameters.length == 0) {
            bStationSurrogate = BStationSurrogate.makeAll((BDaemonSession)bDaemonSession);
            if (((BStationSurrogate[])bStationSurrogate).length == 0) {
                log.warning("No stations on remote host");
                return 4;
            }
            string = bStationSurrogate[0].getStationName();
        } else {
            string = commandLineArguments.parameters[0];
        }
        bStationSurrogate = BStationSurrogate.make((BDaemonSession)bDaemonSession, (String)string);
        if (bStationSurrogate.getStationStatus() == BStationStatus.unknown) {
            log.error("Station " + string + " not found");
            return 1;
        }
        if (bStationSurrogate.getStationStatus() == BStationStatus.idle || bStationSurrogate.getStationStatus() == BStationStatus.failed) {
            log.warning("Station " + string + " is not running");
            return 4;
        }
        if (bl2) {
            bStationSurrogate.killStationAsync();
            log.message("Station " + string + " killed");
        } else if (bl) {
            bStationSurrogate.restartStationAsync();
            log.message("Station " + string + " restarted");
        } else {
            bStationSurrogate.stopStation(null, null);
            log.message("Station " + string + " stopped");
        }
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

