/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.util.CommandLineArguments;
import javax.baja.log.Log;
import javax.baja.platform.BStationStatus;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BStartStationCommand
extends BDaemonSessionCommand {
    public static final BStartStationCommand INSTANCE = new BStartStationCommand();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$command$BStartStationCommand == null ? (class$com$tridium$platDaemon$command$BStartStationCommand = BStartStationCommand.class$("com.tridium.platDaemon.command.BStartStationCommand")) : class$com$tridium$platDaemon$command$BStartStationCommand));
    private static Log log = Log.getLog((String)"startstation");
    static /* synthetic */ Class class$com$tridium$platDaemon$command$BStartStationCommand;

    public Type getType() {
        return TYPE;
    }

    protected BStartStationCommand() {
    }

    public String getCommandName() {
        return "startstation";
    }

    public String getCommandDescription() {
        return "request that a Niagara Platform Daemon start a station";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BStartStationCommand.println((String)"");
        BStartStationCommand.println((String)"usage:");
        BStartStationCommand.println((String)"  plat startstation <flags> [stationname]");
        BStartStationCommand.println((String)"parameters:");
        BStartStationCommand.println((String)"  stationname        name of the station to start.   If omitted,");
        BStartStationCommand.println((String)"                       the first/only station will be started");
        BStartStationCommand.println((String)"required flags:");
        BStartStationCommand.println((String)"  -h:<hostord>       host's ORD");
        BStartStationCommand.println((String)"optional flags:");
        BStartStationCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon");
        BStartStationCommand.println((String)"  -pwd:<password>    password for the host's platform daemon");
        BStartStationCommand.println((String)"  -noinput           if given, command will fail when username");
        BStartStationCommand.println((String)"                       and password are missing or incorrect,");
        BStartStationCommand.println((String)"                       instead of prompting and reading them");
        BStartStationCommand.println((String)"                       from stdin");
        BStartStationCommand.println((String)"  -p:<port>          port for the host's platform daemon");
        BStartStationCommand.println((String)"                       if omitted, default port 3011 is used");
        BStartStationCommand.println((String)"  -locale:<x>        set the default locale (en_US)");
        BStartStationCommand.println((String)"  -@<option>         pass option to Java VM");
        BStartStationCommand.println((String)"  -buildreg          force rebuild of the registry");
        BStartStationCommand.println((String)"");
    }

    public int invoke(CommandLineArguments commandLineArguments) throws Exception {
        String string;
        BStationSurrogate bStationSurrogate;
        if (commandLineArguments.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession bDaemonSession = this.getSession(commandLineArguments);
        if (bDaemonSession == null) {
            this.usage();
            return 2;
        }
        if (commandLineArguments.parameters.length == 0) {
            bStationSurrogate = BStationSurrogate.makeAll((BDaemonSession)bDaemonSession);
            if (((BStationSurrogate[])bStationSurrogate).length == 0) {
                log.warning("No stations on remote host");
                return 4;
            }
            string = bStationSurrogate[0].getStationName();
        } else {
            string = commandLineArguments.parameters[0];
        }
        bStationSurrogate = BStationSurrogate.make((BDaemonSession)bDaemonSession, (String)string);
        if (bStationSurrogate.getStationStatus() == BStationStatus.unknown) {
            log.error("Station " + string + " not found");
            return 1;
        }
        if (bStationSurrogate.getStationStatus() == BStationStatus.running || bStationSurrogate.getStationStatus() == BStationStatus.starting || bStationSurrogate.getStationStatus() == BStationStatus.stopping) {
            log.warning("Station " + string + " is already running");
            return 4;
        }
        bStationSurrogate.startStationAsync();
        log.message("Station " + string + " started");
        return 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

