/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.InstallScenario;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.util.CommandLineArguments;
import javax.baja.log.Log;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BModuleInstallCommand
extends BDaemonSessionCommand {
    public static final BModuleInstallCommand INSTANCE = new BModuleInstallCommand();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$command$BModuleInstallCommand == null ? (class$com$tridium$platDaemon$command$BModuleInstallCommand = BModuleInstallCommand.class$("com.tridium.platDaemon.command.BModuleInstallCommand")) : class$com$tridium$platDaemon$command$BModuleInstallCommand));
    private static Log log = Log.getLog((String)"moduleinstall");
    static /* synthetic */ Class class$com$tridium$platDaemon$command$BModuleInstallCommand;

    public Type getType() {
        return TYPE;
    }

    protected BModuleInstallCommand() {
    }

    public String getCommandName() {
        return "moduleinstall";
    }

    public String getCommandDescription() {
        return "install Niagara modules to a remote host";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BModuleInstallCommand.println((String)"");
        BModuleInstallCommand.println((String)"usage:");
        BModuleInstallCommand.println((String)"  plat moduleinstall <flags> [modulename]*");
        BModuleInstallCommand.println((String)"parameters:");
        BModuleInstallCommand.println((String)"  modulename         names of a module to install to the remote host");
        BModuleInstallCommand.println((String)"required flags:");
        BModuleInstallCommand.println((String)"  -h:<hostord>       ORD for the remote host");
        BModuleInstallCommand.println((String)"optional flags:");
        BModuleInstallCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon");
        BModuleInstallCommand.println((String)"  -pwd:<password>    password for the host's platform daemon");
        BModuleInstallCommand.println((String)"  -noinput           if given, command will fail when username");
        BModuleInstallCommand.println((String)"                       and password are missing or incorrect,");
        BModuleInstallCommand.println((String)"                       instead of prompting and reading them");
        BModuleInstallCommand.println((String)"                       from stdin");
        BModuleInstallCommand.println((String)"  -p:<port>          port for the remote host's platform daemon");
        BModuleInstallCommand.println((String)"                       if omitted, default port 3011 is used");
        BModuleInstallCommand.println((String)"  -ood               all out-of-date modules are to be upgraded");
        BModuleInstallCommand.println((String)"  -locale:<x>        set the default locale (en_US)");
        BModuleInstallCommand.println((String)"  -@<option>         pass option to Java VM");
        BModuleInstallCommand.println((String)"  -buildreg          force rebuild of the registry");
        BModuleInstallCommand.println((String)"");
    }

    public int invoke(CommandLineArguments commandLineArguments) throws Exception {
        UnmeetableDependency[] unmeetableDependencyArray;
        if (commandLineArguments.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession bDaemonSession = this.getSession(commandLineArguments);
        if (bDaemonSession == null) {
            this.usage();
            return 2;
        }
        boolean bl = commandLineArguments.hasOption("ood");
        if (!bl && commandLineArguments.parameters.length == 0) {
            this.usage();
            return 2;
        }
        int n = 0;
        BRemoteDaemonPlatform bRemoteDaemonPlatform = BRemoteDaemonPlatform.make((BDaemonSession)bDaemonSession, null);
        bRemoteDaemonPlatform.checkSession();
        BDependency[] bDependencyArray = new BDependency[commandLineArguments.parameters.length];
        for (int i = 0; i < commandLineArguments.parameters.length; ++i) {
            bDependencyArray[i] = BDependency.forModule((String)commandLineArguments.parameters[i]);
        }
        Listener listener = new Listener();
        InstallScenario installScenario = InstallScenario.solve((BDaemonPlatform)bRemoteDaemonPlatform, (DaemonSessionTaskListener)listener, null, (BDependency[])bDependencyArray, null, (InstallableRegistry)LocalInstallableRegistry.getInstance());
        if (installScenario.canCommit() && bl) {
            installScenario = InstallScenario.upgradeOutOfDate((InstallScenario)installScenario, (InstallableRegistry)LocalInstallableRegistry.getInstance());
        }
        if ((unmeetableDependencyArray = installScenario.getUnmeetableDependencies()).length > 0) {
            log.error("The following dependencies cannot be met");
            for (int i = 0; i < unmeetableDependencyArray.length; ++i) {
                System.out.println("  " + unmeetableDependencyArray[i]);
            }
            return 1;
        }
        if (installScenario.getToInstall().length == 0) {
            log.message("All remote modules are already up to date.");
            return n;
        }
        if (!installScenario.canCommit()) {
            log.error("cannot commit installation");
            return 1;
        }
        log.message("Stopping stations on " + bDaemonSession.getHost().getNavDisplayName(null));
        BAppSurrogate[] bAppSurrogateArray = BAppSurrogate.stopAllApps((BDaemonSession)bDaemonSession, null, null, null);
        installScenario.commit((DaemonSessionTaskListener)listener, (ICancelHint)null);
        log.message("Installation complete.");
        if (bAppSurrogateArray.length > 0) {
            for (int i = 0; i < bAppSurrogateArray.length; ++i) {
                if (!bAppSurrogateArray[i].isRestartEnabled()) continue;
                bAppSurrogateArray[i].startAppAsync();
                log.message("Started " + bAppSurrogateArray[i].toString(null));
            }
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Listener
    implements DaemonSessionTaskListener {
        String lastText = null;

        private Listener() {
        }

        public void taskStarted(DaemonSessionTask daemonSessionTask) {
            if (!daemonSessionTask.getMessage().equals(this.lastText)) {
                System.out.println(daemonSessionTask.getMessage());
                this.lastText = daemonSessionTask.getMessage();
            }
        }

        public void taskUpdated(DaemonSessionTask daemonSessionTask) {
            this.taskStarted(daemonSessionTask);
        }

        public void taskFinished(DaemonSessionTask daemonSessionTask) {
        }

        public boolean isCancelEnabled() {
            return false;
        }
    }
}

