/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.util.CommandLineArguments;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.BStationStatus;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BListStationsCommand
extends BDaemonSessionCommand {
    public static final BListStationsCommand INSTANCE = new BListStationsCommand();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$command$BListStationsCommand == null ? (class$com$tridium$platDaemon$command$BListStationsCommand = BListStationsCommand.class$("com.tridium.platDaemon.command.BListStationsCommand")) : class$com$tridium$platDaemon$command$BListStationsCommand));
    private static final int NAME_WIDTH = 19;
    private static final int STATUS_WIDTH = 8;
    private static final int FOX_PORT_WIDTH = 8;
    private static final int HTTP_PORT_WIDTH = 9;
    private static final int AUTO_START_WIDTH = 12;
    private static final int AUTO_RESTART_WIDTH = 18;
    static /* synthetic */ Class class$com$tridium$platDaemon$command$BListStationsCommand;

    public Type getType() {
        return TYPE;
    }

    protected BListStationsCommand() {
    }

    public String getCommandName() {
        return "liststations";
    }

    public String getCommandDescription() {
        return "list stations managed by the Niagara platform daemon";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BListStationsCommand.println((String)"");
        BListStationsCommand.println((String)"usage:");
        BListStationsCommand.println((String)"  plat liststations <flags> [stationname]");
        BListStationsCommand.println((String)"required flags:");
        BListStationsCommand.println((String)"  -h:<hostord>       host's ORD");
        BListStationsCommand.println((String)"optional flags:");
        BListStationsCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon");
        BListStationsCommand.println((String)"  -pwd:<password>    password for the host's platform daemon");
        BListStationsCommand.println((String)"  -noinput           if given, command will fail when username");
        BListStationsCommand.println((String)"                       and password are missing or incorrect,");
        BListStationsCommand.println((String)"                       instead of prompting and reading them");
        BListStationsCommand.println((String)"                       from stdin");
        BListStationsCommand.println((String)"  -p:<port>          port for the host's platform daemon");
        BListStationsCommand.println((String)"                       if omitted, default port 3011 is used");
        BListStationsCommand.println((String)"  -running           limit listing to running stations");
        BListStationsCommand.println((String)"  -locale:<x>        set the default locale (en_US)");
        BListStationsCommand.println((String)"  -@<option>         pass option to Java VM");
        BListStationsCommand.println((String)"  -buildreg          force rebuild of the registry");
        BListStationsCommand.println((String)"");
    }

    public int invoke(CommandLineArguments commandLineArguments) throws Exception {
        if (commandLineArguments.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession bDaemonSession = this.getSession(commandLineArguments);
        if (bDaemonSession == null) {
            this.usage();
            return 2;
        }
        boolean bl = commandLineArguments.hasOption("running");
        BStationSurrogate[] bStationSurrogateArray = BStationSurrogate.makeAll((BDaemonSession)bDaemonSession);
        this.printHeaders();
        boolean bl2 = false;
        for (int i = 0; i < bStationSurrogateArray.length; ++i) {
            if (bl && bStationSurrogateArray[i].getStationStatus() != BStationStatus.running) continue;
            this.printStationLine(bStationSurrogateArray[i]);
            bl2 = true;
        }
        return bl2 ? 0 : 4;
    }

    private void printHeaders() {
        System.out.print(TextUtil.padRight((String)"Name", (int)19));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)"Status", (int)8));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)"Fox Port", (int)8));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)"HTTP Port", (int)9));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)"Auto-Start", (int)12));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)"Restart on Failure", (int)18));
        System.out.println();
        this.printDashes(19);
        System.out.print(" ");
        this.printDashes(8);
        System.out.print(" ");
        this.printDashes(8);
        System.out.print(" ");
        this.printDashes(9);
        System.out.print(" ");
        this.printDashes(12);
        System.out.print(" ");
        this.printDashes(18);
        System.out.println();
    }

    private void printStationLine(BStationSurrogate bStationSurrogate) {
        System.out.print(TextUtil.padRight((String)bStationSurrogate.getStationName(), (int)19));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)bStationSurrogate.getStationStatus().getTag(), (int)8));
        System.out.print(" ");
        if (bStationSurrogate.getFoxPort() > 0) {
            System.out.print(TextUtil.padRight((String)String.valueOf(bStationSurrogate.getFoxPort()), (int)8));
        } else {
            System.out.print(TextUtil.padRight((String)"n/a", (int)8));
        }
        System.out.print(" ");
        if (bStationSurrogate.getHttpPort() > 0) {
            System.out.print(TextUtil.padRight((String)String.valueOf(bStationSurrogate.getHttpPort()), (int)9));
        } else {
            System.out.print(TextUtil.padRight((String)"n/a", (int)9));
        }
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)String.valueOf(bStationSurrogate.getIsAutoStart()), (int)12));
        System.out.print(" ");
        System.out.print(TextUtil.padRight((String)String.valueOf(bStationSurrogate.getIsAutoRestart()), (int)18));
        System.out.println();
    }

    private void printDashes(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print('-');
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

