/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.tcpip.BTcpIpAdapterSettings;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.util.CommandLineArguments;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BIpConfigCommand
extends BDaemonSessionCommand {
    public static final BIpConfigCommand INSTANCE = new BIpConfigCommand();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$command$BIpConfigCommand == null ? (class$com$tridium$platDaemon$command$BIpConfigCommand = BIpConfigCommand.class$("com.tridium.platDaemon.command.BIpConfigCommand")) : class$com$tridium$platDaemon$command$BIpConfigCommand));
    private static final int LABEL_WIDTH = 32;
    static /* synthetic */ Class class$com$tridium$platDaemon$command$BIpConfigCommand;

    public Type getType() {
        return TYPE;
    }

    protected BIpConfigCommand() {
    }

    public String getCommandName() {
        return "ipconfig";
    }

    public String getCommandDescription() {
        return "display the TCP/IP configuration for a remote host";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BIpConfigCommand.println((String)"");
        BIpConfigCommand.println((String)"usage:");
        BIpConfigCommand.println((String)"  plat ipconfig <flags>");
        BIpConfigCommand.println((String)"required flags:");
        BIpConfigCommand.println((String)"  -h:<hostord>       host's ORD");
        BIpConfigCommand.println((String)"optional flags:");
        BIpConfigCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon");
        BIpConfigCommand.println((String)"  -pwd:<password>    password for the host's platform daemon");
        BIpConfigCommand.println((String)"  -noinput           if given, command will fail when username");
        BIpConfigCommand.println((String)"                       and password are missing or incorrect,");
        BIpConfigCommand.println((String)"                       instead of prompting and reading them");
        BIpConfigCommand.println((String)"                       from stdin");
        BIpConfigCommand.println((String)"  -p:<port>          port for the host's platform daemon");
        BIpConfigCommand.println((String)"                       if omitted, default port 3011 is used");
        BIpConfigCommand.println((String)"  -locale:<x>        set the default locale (en_US)");
        BIpConfigCommand.println((String)"  -@<option>         pass option to Java VM");
        BIpConfigCommand.println((String)"  -buildreg          force rebuild of the registry");
        BIpConfigCommand.println((String)"");
    }

    public int invoke(CommandLineArguments commandLineArguments) throws Exception {
        SlotCursor slotCursor;
        if (commandLineArguments.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession bDaemonSession = this.getSession(commandLineArguments);
        if (bDaemonSession == null) {
            this.usage();
            return 2;
        }
        BTcpIpHostSettings bTcpIpHostSettings = new BTcpIpHostSettings();
        TcpUtil.loadFromSession((BTcpIpHostSettings)bTcpIpHostSettings, (BDaemonSession)bDaemonSession);
        System.out.println("\nTCP/IP summary for " + bDaemonSession.getHost() + ":");
        System.out.println();
        this.printLabel("Host name");
        System.out.println(bTcpIpHostSettings.getHostName());
        if (!bTcpIpHostSettings.getUsesAdapterLevelSettings()) {
            this.printLabel("Domain");
            System.out.println(bTcpIpHostSettings.getDomain());
            System.out.println();
            this.printLabel("IPv4 default gateway");
            System.out.println(bTcpIpHostSettings.getDefaultGateway());
            this.printLabel("IPv4 DNS hosts");
            slotCursor = bTcpIpHostSettings.getDnsHosts().loadSlots().getProperties();
            while (slotCursor.next()) {
                System.out.print(slotCursor.get().toString());
                System.out.print(" ");
            }
            System.out.println();
            slotCursor = null;
            boolean bl = false;
            SlotCursor slotCursor2 = bTcpIpHostSettings.getAdapters().loadSlots().getProperties();
            while (slotCursor2.next()) {
                slotCursor = (BTcpIpAdapterSettings)slotCursor2.get();
                if (!slotCursor.getIsIpv6Supported()) continue;
                bl = true;
                break;
            }
            if (bl) {
                System.out.println();
                this.printLabel("IPv6 default gateway");
                System.out.println(bTcpIpHostSettings.getIpv6DefaultGateway());
                this.printLabel("IPv6 DNS hosts");
                slotCursor2 = bTcpIpHostSettings.getIpv6DnsHosts().loadSlots().getProperties();
                while (slotCursor2.next()) {
                    System.out.print(slotCursor2.get().toString());
                    System.out.print(" ");
                }
                System.out.println();
            }
        }
        slotCursor = bTcpIpHostSettings.getAdapters().loadSlots().getProperties();
        while (slotCursor.next()) {
            this.printAdapterSettings((BTcpIpAdapterSettings)slotCursor.get());
        }
        return 0;
    }

    private void printLabel(String string) {
        System.out.print(TextUtil.padRight((String)(string + ":"), (int)32));
    }

    private void printAdapterSettings(BTcpIpAdapterSettings bTcpIpAdapterSettings) {
        SlotCursor slotCursor;
        System.out.print("\nAdapter " + bTcpIpAdapterSettings.getAdapterId());
        if (bTcpIpAdapterSettings.getDescription().trim().length() > 0) {
            System.out.println(" (" + bTcpIpAdapterSettings.getDescription() + ")");
        } else {
            System.out.println();
        }
        this.printLabel("  Adapter Enabled");
        System.out.println(bTcpIpAdapterSettings.getIsAdapterEnabled());
        this.printLabel("  MAC Address");
        System.out.println(bTcpIpAdapterSettings.getMediaAccessControlAddress());
        System.out.println();
        if (bTcpIpAdapterSettings.getUsesAdapterLevelSettings()) {
            this.printLabel("  Domain");
            System.out.println(bTcpIpAdapterSettings.getDomain());
        }
        this.printLabel("  IPv4 address");
        System.out.println(bTcpIpAdapterSettings.getIpAddress());
        this.printLabel("  IPv4 subnet mask");
        System.out.println(bTcpIpAdapterSettings.getSubnetMask());
        if (bTcpIpAdapterSettings.getUsesAdapterLevelSettings()) {
            this.printLabel("  IPv4 default gateway");
            System.out.println(bTcpIpAdapterSettings.getDefaultGateway());
        }
        this.printLabel("  IPv4 DHCP");
        if (bTcpIpAdapterSettings.getIsDhcpEnabled()) {
            BIpConfigCommand.println((String)"enabled");
            this.printLabel("    DHCP host");
            System.out.println(bTcpIpAdapterSettings.getDhcpHost());
            this.printLabel("    DHCP lease granted");
            System.out.println(bTcpIpAdapterSettings.getDhcpLeaseGranted());
            this.printLabel("    DHCP lease expires");
            System.out.println(bTcpIpAdapterSettings.getDhcpLeaseExpires());
        } else {
            System.out.println("disabled");
        }
        if (bTcpIpAdapterSettings.getUsesAdapterLevelSettings()) {
            this.printLabel("  IPv4 DNS hosts");
            slotCursor = bTcpIpAdapterSettings.getDnsHosts().loadSlots().getProperties();
            while (slotCursor.next()) {
                System.out.print(slotCursor.get().toString());
                System.out.print(" ");
            }
            System.out.println();
        }
        System.out.println();
        this.printLabel("  IPv6 supported");
        System.out.println(bTcpIpAdapterSettings.getIsIpv6Supported());
        if (bTcpIpAdapterSettings.getIsIpv6Supported()) {
            this.printLabel("  IPv6 enabled");
            System.out.println(bTcpIpAdapterSettings.getIsIpv6Enabled());
            if (bTcpIpAdapterSettings.getIsIpv6Enabled()) {
                this.printLabel("  IPv6 address");
                System.out.println(bTcpIpAdapterSettings.getIpv6Address());
                this.printLabel("  IPv6 subnet prefix length");
                System.out.println(bTcpIpAdapterSettings.getIpv6SubnetPrefixLength());
                if (bTcpIpAdapterSettings.getUsesAdapterLevelSettings()) {
                    this.printLabel("  IPv6 default gateway");
                    System.out.println(bTcpIpAdapterSettings.getIpv6DefaultGateway());
                }
                this.printLabel("  IPv6 DHCP");
                if (bTcpIpAdapterSettings.getIsIpv6DhcpEnabled()) {
                    BIpConfigCommand.println((String)"enabled");
                    this.printLabel("    DHCP host");
                    System.out.println(bTcpIpAdapterSettings.getIpv6DhcpHost());
                    this.printLabel("    DHCP lease granted");
                    System.out.println(bTcpIpAdapterSettings.getIpv6DhcpLeaseGranted());
                    this.printLabel("    DHCP lease expires");
                    System.out.println(bTcpIpAdapterSettings.getIpv6DhcpLeaseExpires());
                } else {
                    System.out.println("disabled");
                }
                if (bTcpIpAdapterSettings.getUsesAdapterLevelSettings()) {
                    this.printLabel("  IPv6 DNS hosts");
                    slotCursor = bTcpIpAdapterSettings.getIpv6DnsHosts().loadSlots().getProperties();
                    while (slotCursor.next()) {
                        System.out.print(slotCursor.get().toString());
                        System.out.print(" ");
                    }
                    System.out.println();
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

