/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platDaemon.util.DaemonGlob;
import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.FileCache;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.OSUpdateMessage;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.util.CommandLineArguments;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.log.Log;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFilePutCommand
extends BDaemonSessionCommand {
    public static final BFilePutCommand INSTANCE = new BFilePutCommand();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$command$BFilePutCommand == null ? (class$com$tridium$platDaemon$command$BFilePutCommand = BFilePutCommand.class$("com.tridium.platDaemon.command.BFilePutCommand")) : class$com$tridium$platDaemon$command$BFilePutCommand));
    private static Log log = Log.getLog((String)"fput");
    static /* synthetic */ Class class$com$tridium$platDaemon$command$BFilePutCommand;

    public Type getType() {
        return TYPE;
    }

    protected BFilePutCommand() {
    }

    public String getCommandName() {
        return "fput";
    }

    public boolean includeInCommandListing() {
        return false;
    }

    public String getCommandDescription() {
        return "send one or more files to a remote host";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BFilePutCommand.println((String)"");
        BFilePutCommand.println((String)"usage:");
        BFilePutCommand.println((String)"  plat fput <flags> <srcPath>* <destPath>");
        BFilePutCommand.println((String)"parameters:");
        BFilePutCommand.println((String)"  srcPath            path of a file on the local computer to be copied");
        BFilePutCommand.println((String)"  destPath           path of a directory to which the files are to be");
        BFilePutCommand.println((String)"                       copied");
        BFilePutCommand.println((String)"required flags:");
        BFilePutCommand.println((String)"  -h:<hostord>       ORD for the remote host");
        BFilePutCommand.println((String)"optional flags:");
        BFilePutCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon");
        BFilePutCommand.println((String)"  -pwd:<password>    password for the host's platform daemon");
        BFilePutCommand.println((String)"  -noinput           if given, command will fail when username");
        BFilePutCommand.println((String)"                       and password are missing or incorrect,");
        BFilePutCommand.println((String)"                       instead of prompting and reading them");
        BFilePutCommand.println((String)"                       from stdin");
        BFilePutCommand.println((String)"  -recurse           copy children of the directories identified by");
        BFilePutCommand.println((String)"                       <srcPath> recursively");
        BFilePutCommand.println((String)"  -r                 same as -recurse");
        BFilePutCommand.println((String)"  -overwrite:<opt>   overwrite option, default is 'prompt', values are:");
        BFilePutCommand.println((String)"                       'all'    unconditionally overwrite");
        BFilePutCommand.println((String)"                       'prompt' prompt for each overwrite");
        BFilePutCommand.println((String)"                       'none'   never overwrite");
        BFilePutCommand.println((String)"                       'crc'    overwrite only if crc is different");
        BFilePutCommand.println((String)"  -o:<opt>           same as -overwrite");
        BFilePutCommand.println((String)"  -notransact        by default, files are written to a temporary");
        BFilePutCommand.println((String)"                       location, then copied by the niagarad to");
        BFilePutCommand.println((String)"                       their final location once all transmission");
        BFilePutCommand.println((String)"                       is successful.  -notransact disables this");
        BFilePutCommand.println((String)"                       feature. WARNING: using this option increases");
        BFilePutCommand.println((String)"                       the chance of file corruption, and can result");
        BFilePutCommand.println((String)"                       in a Jace that is not remotely servicable");
        BFilePutCommand.println((String)"  -nt                same as -notransact");
        BFilePutCommand.println((String)"  -p:<port>          port for the remote host's platform daemon");
        BFilePutCommand.println((String)"                       if omitted, default port 3011 is used");
        BFilePutCommand.println((String)"  -locale:<x>        set the default locale (en_US)");
        BFilePutCommand.println((String)"  -@<option>         pass option to Java VM");
        BFilePutCommand.println((String)"  -buildreg          force rebuild of the registry");
        BFilePutCommand.println((String)"");
    }

    public int invoke(CommandLineArguments commandLineArguments) throws Exception {
        if (commandLineArguments.hasHelpOption()) {
            this.usage();
            return 2;
        }
        BDaemonSession bDaemonSession = this.getSession(commandLineArguments);
        if (bDaemonSession == null) {
            this.usage();
            return 2;
        }
        boolean bl = commandLineArguments.hasOption("notransact") || commandLineArguments.hasOption("nt");
        String string = "prompt";
        if (commandLineArguments.hasOption("o")) {
            string = commandLineArguments.getOption("o");
        } else if (commandLineArguments.hasOption("overwrite")) {
            string = commandLineArguments.getOption("overwrite");
        }
        if (!(string.equals("all") || string.equals("prompt") || string.equals("crc") || string.equals("none"))) {
            this.usage();
            return 2;
        }
        boolean bl2 = commandLineArguments.hasOption("r") || commandLineArguments.hasOption("recurse");
        boolean bl3 = commandLineArguments.hasOption("osupdate");
        if (commandLineArguments.parameters.length < 2) {
            this.usage();
            return 2;
        }
        FileCache fileCache = new FileCache((BFileSpace)bDaemonSession.getFileSpace());
        FileTransferMessage fileTransferMessage = new FileTransferMessage(bl, (StoreCache)fileCache, (BDaemonFileSpace)bDaemonSession.getFileSpace());
        FilePath filePath = new FilePath(commandLineArguments.parameters[commandLineArguments.parameters.length - 1]);
        BIFile bIFile = DaemonFileUtil.findFile((BFileSpace)bDaemonSession.getFileSpace(), (FilePath)filePath, (FileCache)fileCache);
        if (bIFile != null && !bIFile.isDirectory()) {
            if (commandLineArguments.parameters.length > 2) {
                log.error("Multiple file sources with one file target");
                return 2;
            }
            filePath = filePath.getParent();
        }
        for (int i = 0; i < commandLineArguments.parameters.length - 1; ++i) {
            FilePath[] filePathArray = DaemonGlob.expandPathString((BFileSpace)BFileSystem.INSTANCE, DaemonGlob.makeFilePathString(commandLineArguments.parameters[i]));
            for (int j = 0; j < filePathArray.length; ++j) {
                BIFile bIFile2 = BFileSystem.INSTANCE.findFile(filePathArray[j]);
                if (bIFile2.isDirectory()) {
                    this.addDirectoryContents(fileTransferMessage, (BDirectory)bIFile2, filePath, bl2, string, fileCache);
                    continue;
                }
                this.addFile(fileTransferMessage, bIFile2, filePath, string, fileCache);
            }
        }
        DaemonFileUtil.transfer((BDaemonSession)bDaemonSession, (FileTransferMessage)fileTransferMessage, null, (DaemonSessionTaskListener)new Listener());
        if (bl3 && (string.equals("all") || this.promptBoolean("Apply OS Update (y/n)? "))) {
            bDaemonSession.sendMessage((DaemonMessage)OSUpdateMessage.getInstance(), 20000);
            log.message("OS update requested");
        }
        return 0;
    }

    private void addFile(FileTransferMessage fileTransferMessage, BIFile bIFile, FilePath filePath, String string, FileCache fileCache) throws Exception {
        FilePath filePath2 = filePath.merge(bIFile.getFileName());
        if (string.equals("all")) {
            fileTransferMessage.addFile(bIFile, filePath2);
        } else {
            BIFile bIFile2 = DaemonFileUtil.findFile((BFileSpace)fileTransferMessage.getTargetFileSpace(), (FilePath)filePath2, (FileCache)fileCache);
            if (bIFile2 == null || string.equals("all")) {
                fileTransferMessage.addFile(bIFile, filePath2);
            } else if (string.equals("crc")) {
                if (DaemonFileUtil.getCrc((BIFile)bIFile) == DaemonFileUtil.getCrc((BIFile)bIFile2)) {
                    log.message(filePath2.getBody() + " not overwritten");
                } else {
                    fileTransferMessage.addFile(bIFile, filePath2);
                }
            } else if (string.equals("prompt")) {
                if (this.promptBoolean("Replace \"" + filePath2.getBody() + "\" (y/n)? ")) {
                    fileTransferMessage.addFile(bIFile, filePath2);
                }
            } else if (string.equals("none")) {
                log.message(filePath2.getBody() + " not overwritten");
            }
        }
    }

    private void addDirectoryContents(FileTransferMessage fileTransferMessage, BDirectory bDirectory, FilePath filePath, boolean bl, String string, FileCache fileCache) throws Exception {
        BIFile[] bIFileArray = bDirectory.listFiles();
        for (int i = 0; i < bIFileArray.length; ++i) {
            if (bIFileArray[i].isDirectory()) {
                if (!bl) continue;
                this.addDirectoryContents(fileTransferMessage, (BDirectory)bIFileArray[i], filePath.merge(bIFileArray[i].getFileName()), bl, string, fileCache);
                continue;
            }
            this.addFile(fileTransferMessage, bIFileArray[i], filePath.merge(bIFileArray[i].getFileName()), string, fileCache);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Listener
    implements DaemonSessionTaskListener {
        String lastText = null;

        private Listener() {
        }

        public void taskStarted(DaemonSessionTask daemonSessionTask) {
            if (!daemonSessionTask.getMessage().equals(this.lastText)) {
                System.out.println(daemonSessionTask.getMessage());
                this.lastText = daemonSessionTask.getMessage();
            }
        }

        public void taskUpdated(DaemonSessionTask daemonSessionTask) {
            this.taskStarted(daemonSessionTask);
        }

        public void taskFinished(DaemonSessionTask daemonSessionTask) {
        }

        public boolean isCancelEnabled() {
            return false;
        }
    }
}

