/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.DaemonPlatformUtil;
import com.tridium.install.InstallScenario;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BPart;
import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.OSUpdateMessage;
import com.tridium.platform.daemon.message.RefreshDaemonBinariesMessage;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.util.CommandLineArguments;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.log.Log;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BDistInstallCommand
extends BDaemonSessionCommand {
    public static final BDistInstallCommand INSTANCE = new BDistInstallCommand();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$command$BDistInstallCommand == null ? (class$com$tridium$platDaemon$command$BDistInstallCommand = BDistInstallCommand.class$("com.tridium.platDaemon.command.BDistInstallCommand")) : class$com$tridium$platDaemon$command$BDistInstallCommand));
    private static Log log = Log.getLog((String)"distinstall");
    static /* synthetic */ Class class$com$tridium$platDaemon$command$BDistInstallCommand;

    public Type getType() {
        return TYPE;
    }

    protected BDistInstallCommand() {
    }

    public String getCommandName() {
        return "distinstall";
    }

    public String getCommandDescription() {
        return "install distribution files to a remote host";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BDistInstallCommand.println((String)"");
        BDistInstallCommand.println((String)"usage:");
        BDistInstallCommand.println((String)"  plat distinstall <flags> <distfilepath>");
        BDistInstallCommand.println((String)"parameters:");
        BDistInstallCommand.println((String)"  distfilepath        FilePath for the distribution file to install");
        BDistInstallCommand.println((String)"required flags:");
        BDistInstallCommand.println((String)"  -h:<hostord>        ORD for the remote host");
        BDistInstallCommand.println((String)"optional flags:");
        BDistInstallCommand.println((String)"  -usr:<userName>     user name for the host's platform daemon");
        BDistInstallCommand.println((String)"  -pwd:<password>     password for the host's platform daemon");
        BDistInstallCommand.println((String)"  -noinput            if given, command will fail when username");
        BDistInstallCommand.println((String)"                        and password are missing or incorrect,");
        BDistInstallCommand.println((String)"                        instead of prompting and reading them");
        BDistInstallCommand.println((String)"                        from stdin");
        BDistInstallCommand.println((String)"  -p:<port>           port for the remote host's platform daemon");
        BDistInstallCommand.println((String)"                        if omitted, default port 3011 is used");
        BDistInstallCommand.println((String)"  -ood                all out-of-date modules are to be upgraded");
        BDistInstallCommand.println((String)"  -locale:<x>         set the default locale (en_US)");
        BDistInstallCommand.println((String)"  -@<option>          pass option to Java VM");
        BDistInstallCommand.println((String)"  -buildreg           force rebuild of the registry");
        BDistInstallCommand.println((String)"  -notcp              if present, the install will not change the");
        BDistInstallCommand.println((String)"                        remote host's TCP/IP settings");
        BDistInstallCommand.println((String)"  -tcp                if present, the install will change the");
        BDistInstallCommand.println((String)"                        remote host's TCP/IP settings");
        BDistInstallCommand.println((String)"");
    }

    public int invoke(CommandLineArguments commandLineArguments) throws Exception {
        boolean bl = commandLineArguments.hasOption("ood");
        boolean bl2 = commandLineArguments.hasOption("notcp");
        boolean bl3 = commandLineArguments.hasOption("tcp");
        if (commandLineArguments.hasHelpOption() || commandLineArguments.parameters.length != 1) {
            this.usage();
            return 2;
        }
        String string = commandLineArguments.parameters[0];
        BDaemonSession bDaemonSession = this.getSession(commandLineArguments);
        if (bDaemonSession == null) {
            this.usage();
            return 2;
        }
        int n = 0;
        BIFile bIFile = BFileSystem.INSTANCE.findFile(new FilePath(string));
        if (bIFile == null) {
            log.error(string + " not found");
            return 1;
        }
        BRemoteDaemonPlatform bRemoteDaemonPlatform = BRemoteDaemonPlatform.make((BDaemonSession)bDaemonSession, null);
        bRemoteDaemonPlatform.checkSession();
        bRemoteDaemonPlatform.getModuleList().init();
        InstallScenario installScenario = InstallScenario.solve((BDaemonPlatform)bRemoteDaemonPlatform, null, null, null, (BInstallable[])new BInstallable[]{new BDistribution(bIFile)}, (InstallableRegistry)LocalInstallableRegistry.getInstance());
        if (installScenario.getExcludedInstallables().length > 0) {
            log.error("One or more of the file's exclusions failed");
            return 1;
        }
        UnmeetableDependency[] unmeetableDependencyArray = installScenario.getUnmeetableDependencies();
        if (unmeetableDependencyArray.length == 0 && bl) {
            installScenario = InstallScenario.upgradeOutOfDate((InstallScenario)installScenario, (InstallableRegistry)LocalInstallableRegistry.getInstance()).solve();
        }
        if (unmeetableDependencyArray.length > 0) {
            log.error("The following dependencies cannot be met");
            for (int i = 0; i < unmeetableDependencyArray.length; ++i) {
                System.out.println("  " + unmeetableDependencyArray[i]);
            }
            return 1;
        }
        if (installScenario.getToInstall().length == 0) {
            log.message("All remote software is already up to date.");
            return n;
        }
        long l = installScenario.getProcessingFlags();
        if ((l & 0x80000L) > 0L) {
            if (bl2) {
                l &= 0xFFFFFFFFFFF7FFFFL;
            } else if (!bl3) {
                if (commandLineArguments.hasOption("noinput")) {
                    log.error("Distribution contains TCP/IP changes, must provide -tcp or -notcp option");
                    return 1;
                }
                if (!this.promptBoolean("Apply TCP/IP changes (y/n)?")) {
                    l &= 0xFFFFFFFFFFF7FFFFL;
                }
            }
        }
        BAppSurrogate[] bAppSurrogateArray = new BAppSurrogate[]{};
        Listener listener = new Listener();
        if ((l & 1L) > 0L || (l & 2L) > 0L) {
            log.message("Stopping apps on " + bDaemonSession.getHost().getNavDisplayName(null));
            bAppSurrogateArray = BAppSurrogate.stopAllApps((BDaemonSession)bDaemonSession, (Type)((l & 1L) > 0L ? null : BStationSurrogate.TYPE), null, null);
            BStationSurrogate[] bStationSurrogateArray = BStationSurrogate.makeAll((BDaemonSession)bDaemonSession);
            block1: for (int i = 0; i < bStationSurrogateArray.length; ++i) {
                if (bStationSurrogateArray[i].getStationStatus() == BStationStatus.idle) continue;
                BInstallable[] bInstallableArray = installScenario.getToInstall();
                for (int j = 0; j < bInstallableArray.length; ++j) {
                    BPart bPart = bInstallableArray[j].getPart();
                    if (bPart == null || !(bPart instanceof BNrePart)) continue;
                    DaemonPlatformUtil.doExtraStationShutdownTasks((BDaemonPlatform)bRemoteDaemonPlatform, (DaemonSessionTaskListener)listener, null);
                    break block1;
                }
                break;
            }
        }
        installScenario.commit((DaemonSessionTaskListener)listener, new StoreCache(), (ICancelHint)null);
        if ((l & 0x80000L) > 0L) {
            log.message("Installing TCP/IP changes");
            TcpUtil.saveToSession((BTcpIpHostSettings)installScenario.getTcpIpChanges(), (BDaemonSession)bDaemonSession, (boolean)false);
        }
        if ((l & 0x20000L) > 0L) {
            log.message("Installing OS Image.");
            bDaemonSession.sendMessage((DaemonMessage)OSUpdateMessage.getInstance());
        }
        if ((l & 0x10000L) > 0L) {
            log.message("Rebooting remote host.");
            bDaemonSession.sendRebootRequest();
            log.message("Installation complete.");
        } else if ((l & 0x40000L) > 0L) {
            log.message("Updating daemon binaries");
            bDaemonSession.sendMessage((DaemonMessage)RefreshDaemonBinariesMessage.getInstance());
            log.message("Installation complete.");
        } else {
            log.message("Installation complete.");
            if (bAppSurrogateArray.length > 0) {
                for (int i = 0; i < bAppSurrogateArray.length; ++i) {
                    if (!bAppSurrogateArray[i].isRestartEnabled()) continue;
                    bAppSurrogateArray[i].startAppAsync();
                    log.message("Started " + bAppSurrogateArray[i].getAppName());
                }
            }
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Listener
    implements DaemonSessionTaskListener {
        String lastText = null;

        private Listener() {
        }

        public void taskStarted(DaemonSessionTask daemonSessionTask) {
            if (!daemonSessionTask.getMessage().equals(this.lastText)) {
                System.out.println(daemonSessionTask.getMessage());
                this.lastText = daemonSessionTask.getMessage();
            }
        }

        public void taskUpdated(DaemonSessionTask daemonSessionTask) {
            this.taskStarted(daemonSessionTask);
        }

        public void taskFinished(DaemonSessionTask daemonSessionTask) {
        }

        public boolean isCancelEnabled() {
            return false;
        }
    }
}

