/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon.command;

import com.tridium.platform.command.BDaemonSessionCommand;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.util.CommandLineArguments;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.baja.file.FilePath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBigFilesCommand
extends BDaemonSessionCommand {
    public static final BBigFilesCommand INSTANCE = new BBigFilesCommand();
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$platDaemon$command$BBigFilesCommand == null ? (class$com$tridium$platDaemon$command$BBigFilesCommand = BBigFilesCommand.class$("com.tridium.platDaemon.command.BBigFilesCommand")) : class$com$tridium$platDaemon$command$BBigFilesCommand));
    static /* synthetic */ Class class$com$tridium$platDaemon$command$BBigFilesCommand;

    public Type getType() {
        return TYPE;
    }

    protected BBigFilesCommand() {
    }

    public String getCommandName() {
        return "bigfiles";
    }

    public String getCommandDescription() {
        return "display a list of the largest files on a remote host";
    }

    public String getLicenseVendor() {
        return "tridium";
    }

    public String getLicenseFeature() {
        return "workbench";
    }

    public void usage() {
        BBigFilesCommand.println((String)"");
        BBigFilesCommand.println((String)"usage:");
        BBigFilesCommand.println((String)"  plat bigfiles <flags> <dir>");
        BBigFilesCommand.println((String)"required flags:");
        BBigFilesCommand.println((String)"  -h:<hostord>       host's ORD");
        BBigFilesCommand.println((String)"  <dir>              directory to look under");
        BBigFilesCommand.println((String)"optional flags:");
        BBigFilesCommand.println((String)"  -usr:<userName>    user name for the host's platform daemon");
        BBigFilesCommand.println((String)"  -pwd:<password>    password for the host's platform daemon");
        BBigFilesCommand.println((String)"  -size:<size>       size of the listing, default 10");
        BBigFilesCommand.println((String)"  -noinput           if given, command will fail when username");
        BBigFilesCommand.println((String)"                       and password are missing or incorrect,");
        BBigFilesCommand.println((String)"                       instead of prompting and reading them");
        BBigFilesCommand.println((String)"                       from stdin");
        BBigFilesCommand.println((String)"  -p:<port>          port for the host's platform daemon");
        BBigFilesCommand.println((String)"                       if omitted, default port 3011 is used");
        BBigFilesCommand.println((String)"  -locale:<x>        set the default locale (en_US)");
        BBigFilesCommand.println((String)"  -@<option>         pass option to Java VM");
        BBigFilesCommand.println((String)"  -buildreg          force rebuild of the registry");
        BBigFilesCommand.println((String)"");
    }

    public int invoke(CommandLineArguments commandLineArguments) throws Exception {
        Item item;
        int n;
        if (commandLineArguments.hasHelpOption() || commandLineArguments.parameters.length != 1) {
            this.usage();
            return 2;
        }
        BDaemonSession bDaemonSession = this.getSession(commandLineArguments);
        if (bDaemonSession == null) {
            this.usage();
            return 2;
        }
        TreeSet treeSet = new TreeSet();
        this.accum(treeSet, BDaemonDirectoryStore.make((BDaemonFileSpace)bDaemonSession.getFileSpace(), (FilePath)new FilePath(commandLineArguments.parameters[0]), (boolean)true, (boolean)false, (boolean)false, (StoreCache)new StoreCache()));
        int n2 = commandLineArguments.getIntOption("size", 10);
        int n3 = 0;
        int n4 = 0;
        Iterator iterator = treeSet.iterator();
        for (n = 0; n < n2 && iterator.hasNext(); ++n) {
            item = (Item)iterator.next();
            n3 = Math.max(n3, item.getPath().length());
            n4 = Math.max(n4, item.getSize().length());
        }
        iterator = treeSet.iterator();
        for (n = 0; n < n2 && iterator.hasNext(); ++n) {
            item = (Item)iterator.next();
            System.out.print(TextUtil.pad((String)item.getPath(), (int)n3));
            System.out.print("  ");
            System.out.println(TextUtil.padLeft((String)item.getSize(), (int)n4));
        }
        return 0;
    }

    private void accum(Set set, BDaemonDirectoryStore bDaemonDirectoryStore) throws Exception {
        Array array = bDaemonDirectoryStore.getChildren();
        for (int i = 0; i < array.size(); ++i) {
            if (array.get(i) instanceof BDaemonFileStore) {
                set.add(new Item((BDaemonFileStore)array.get(i)));
                continue;
            }
            if (!(array.get(i) instanceof BDaemonDirectoryStore)) continue;
            this.accum(set, (BDaemonDirectoryStore)array.get(i));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class Item
    implements Comparable {
        private BDaemonFileStore fileStore;

        public Item(BDaemonFileStore bDaemonFileStore) {
            this.fileStore = bDaemonFileStore;
        }

        public int compareTo(Object object) {
            long l;
            long l2 = this.fileStore.getSize();
            if (l2 < (l = ((Item)object).fileStore.getSize())) {
                return 1;
            }
            if (l2 > l) {
                return -1;
            }
            String string = this.fileStore.getFilePath().getBody();
            String string2 = ((Item)object).fileStore.getFilePath().getBody();
            return string.compareTo(string2);
        }

        public String getPath() {
            return this.fileStore.getFilePath().getBody();
        }

        public String getSize() {
            return DaemonFileUtil.fileSize((long)this.fileStore.getSize());
        }
    }
}

