/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.messages;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import com.tridium.videoDriver.videoStream.IVideoDestination;
import com.tridium.videoDriver.videoStream.IVideoStream;
import java.io.IOException;
import java.io.InputStream;
import javax.baja.log.Log;
import javax.baja.rtsp.RtspConnection;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;

public class AxisRtspVideoStreamRequest
extends NHttpRequest {
    private static final String LOW_RES_DEFAULT = "320x240";
    private static final String MEDIUM_RES_DEFAULT = "640x480";
    private static final String HIGH_RES_DEFAULT = "704x480";
    private static final String MPEG4_CODEC = "mpeg4";
    private static final String H264_CODEC = "h264";
    private static final String MJPEG_CODEC = "jpeg";
    private static final Log log = Log.getLog((String)"naxisVideo.AxisRtspVideoStreamRequest");
    BAxisVideoCamera camera;
    BPlaybackParams playbackParams;
    public RtspConnection videoConnection;
    protected IVideoDestination videoDestination;
    protected BIVideoSource videoSource;

    public int getResponseTimeOut() {
        return 30000;
    }

    public int getRetryCount() {
        return 0;
    }

    public String getMethod() {
        return "GET";
    }

    public String getUri() {
        return "";
    }

    public boolean processRtspStream(InputStream inputStream) {
        return false;
    }

    public IVideoStream makeVideoStream() {
        try {
            if (this.videoConnection != null) {
                this.videoConnection.stop();
                this.videoConnection = null;
            }
            if (this.camera.getHostName() != "" && this.camera.getControlPort() != 0 && this.camera.getDataPort() != 0) {
                this.videoConnection = new RtspConnection(this.camera.getHostName(), this.camera.getControlPort(), this.camera.getDataPort(), this.camera.getUseTcpTransport());
            }
            if (this.videoConnection == null) {
                throw new LocalizableRuntimeException("naxisVideo", "Please fill all the credentials");
            }
            this.videoConnection.setAuthorization(this.camera.getRtspUsername(), this.camera.getRtspPassword().getString());
            this.videoConnection.connect(this.getParameterString());
            this.videoConnection.play();
        }
        catch (Exception exception) {
            if (log.isTraceOn()) {
                log.trace("Exception in makeVideoStream()", (Throwable)exception);
            }
            return null;
        }
        return new IVideoStream(){

            public final void closeVideoStream() throws IOException {
                try {
                    if (AxisRtspVideoStreamRequest.this.videoConnection != null) {
                        AxisRtspVideoStreamRequest.this.videoConnection.stop();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }

            public final InputStream getInputStream() {
                try {
                    return AxisRtspVideoStreamRequest.this.videoConnection.getInputStream();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    throw new BajaRuntimeException((Throwable)iOException);
                }
            }

            public final BPlaybackParams getPlaybackParams() {
                return AxisRtspVideoStreamRequest.this.playbackParams;
            }
        };
    }

    public void setPlaybackParams(BPlaybackParams bPlaybackParams) {
        this.playbackParams = bPlaybackParams;
    }

    public void setVideoDestination(IVideoDestination iVideoDestination) {
        this.videoDestination = iVideoDestination;
    }

    public IVideoDestination getVideoDestination() {
        return this.videoDestination;
    }

    public BIVideoSource getVideoSource() {
        return this.videoSource;
    }

    public void setVideoSource(BIVideoSource bIVideoSource) {
        this.videoSource = bIVideoSource;
    }

    public String getParameterString() {
        String string = "";
        BAxisVideoCamera bAxisVideoCamera = (BAxisVideoCamera)this.getVideoSource();
        String string2 = "resolution=";
        switch (bAxisVideoCamera.getPreferredResolution().getOrdinal()) {
            case 2: {
                String string3 = bAxisVideoCamera.getResolutionSettings().getHigh();
                string2 = string2 + (!string3.equals("") ? string3 : HIGH_RES_DEFAULT);
                break;
            }
            case 1: {
                String string3 = bAxisVideoCamera.getResolutionSettings().getMedium();
                string2 = string2 + (!string3.equals("") ? string3 : MEDIUM_RES_DEFAULT);
                break;
            }
            case 0: {
                String string3 = bAxisVideoCamera.getResolutionSettings().getLow();
                string2 = string2 + (!string3.equals("") ? string3 : LOW_RES_DEFAULT);
                break;
            }
            default: {
                string2 = string2 + MEDIUM_RES_DEFAULT;
            }
        }
        int n = bAxisVideoCamera.getPreferredCompression().getOrdinal();
        String string4 = "compression=";
        string4 = n == 0 ? string4 + "15" : string4 + n * 33;
        int n2 = bAxisVideoCamera.getPreferredFrameRate().getOrdinal();
        String string5 = "fps=" + n2 * 10;
        String string6 = "videocodec=";
        switch (bAxisVideoCamera.getHighCompressionCodec().getOrdinal()) {
            case 13: {
                string6 = string6 + MPEG4_CODEC;
                break;
            }
            case 28: {
                string6 = string6 + H264_CODEC;
                break;
            }
            default: {
                string6 = string6 + MJPEG_CODEC;
            }
        }
        string = string2 + '&' + string4 + '&' + string5 + '&' + string6;
        return string;
    }

    public AxisRtspVideoStreamRequest(BIpAddress bIpAddress, BAxisVideoCamera bAxisVideoCamera, BPlaybackParams bPlaybackParams) {
        super(bIpAddress);
        this.camera = bAxisVideoCamera;
        this.playbackParams = bPlaybackParams;
    }
}

