/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.event.enableEvents;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.naxisVideo.identify.BAxisVideoCameraDeviceId;
import com.tridium.naxisVideo.messages.AxisVideoReadParameterGroupReq;
import com.tridium.naxisVideo.util.AxisHttpUtil;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.datatypes.BIpAddress;
import org.apache.oro.text.perl.Perl5Util;

public class AxisParameterUtil {
    public static final Perl5Util REGULAR_EXPRESSION_UTIL = new Perl5Util();

    public static String queryGroup(BAxisVideoCamera bAxisVideoCamera, String string, String string2) throws ReadGroupException, ParameterNotFoundException {
        String string3 = AxisParameterUtil.readGroup(bAxisVideoCamera, string);
        String string4 = AxisHttpUtil.inspectRightHtml(string2, string3);
        if (string4 == null) {
            throw new ParameterNotFoundException(string, string2);
        }
        return string4;
    }

    public static String readGroup(BAxisVideoCamera bAxisVideoCamera, String string) throws ReadGroupException {
        AxisVideoReadParameterGroupReq axisVideoReadParameterGroupReq = new AxisVideoReadParameterGroupReq(new BIpAddress(((BAxisVideoCameraDeviceId)bAxisVideoCamera.getVideoDeviceId()).getUrlAddress(), 80), bAxisVideoCamera, string);
        axisVideoReadParameterGroupReq.addBasicAuthorization(bAxisVideoCamera.getCredentials().getUsername(), bAxisVideoCamera.getCredentials().getPassword().getString());
        axisVideoReadParameterGroupReq.setRetryCount(5);
        axisVideoReadParameterGroupReq.setResponseTimeOut(20000);
        byte[] byArray = null;
        try {
            byArray = bAxisVideoCamera.getAxisVideoNetwork().hcomm().sendRequest((NHttpRequest)axisVideoReadParameterGroupReq).getData();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (byArray == null) {
            throw new ReadGroupException(string);
        }
        return new String(byArray);
    }

    public static void updateParameter(BAxisVideoCamera bAxisVideoCamera, String string, String string2) throws UnableToUpdateParameterException {
        AxisVideoReadParameterGroupReq axisVideoReadParameterGroupReq = new AxisVideoReadParameterGroupReq(new BIpAddress(((BAxisVideoCameraDeviceId)bAxisVideoCamera.getVideoDeviceId()).getUrlAddress(), 80), bAxisVideoCamera, "update", string + '=' + string2, false);
        axisVideoReadParameterGroupReq.addBasicAuthorization(bAxisVideoCamera.getCredentials().getUsername(), bAxisVideoCamera.getCredentials().getPassword().getString());
        axisVideoReadParameterGroupReq.setRetryCount(5);
        axisVideoReadParameterGroupReq.setResponseTimeOut(20000);
        byte[] byArray = null;
        try {
            byArray = bAxisVideoCamera.getAxisVideoNetwork().hcomm().sendRequest((NHttpRequest)axisVideoReadParameterGroupReq).getData();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (byArray == null) {
            throw new UnableToUpdateParameterException(string + '=' + string2);
        }
    }

    public static String addParameterGroup(BAxisVideoCamera bAxisVideoCamera, String string) throws UnableToAddGroupException {
        string = REGULAR_EXPRESSION_UTIL.substitute("s/\\s+/\\+/g", string);
        AxisVideoReadParameterGroupReq axisVideoReadParameterGroupReq = new AxisVideoReadParameterGroupReq(new BIpAddress(((BAxisVideoCameraDeviceId)bAxisVideoCamera.getVideoDeviceId()).getUrlAddress(), 80), bAxisVideoCamera, "add", string);
        axisVideoReadParameterGroupReq.addBasicAuthorization(bAxisVideoCamera.getCredentials().getUsername(), bAxisVideoCamera.getCredentials().getPassword().getString());
        axisVideoReadParameterGroupReq.setRetryCount(5);
        axisVideoReadParameterGroupReq.setResponseTimeOut(20000);
        byte[] byArray = null;
        try {
            byArray = bAxisVideoCamera.getAxisVideoNetwork().hcomm().sendRequest((NHttpRequest)axisVideoReadParameterGroupReq).getData();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (byArray == null) {
            throw new UnableToAddGroupException(string);
        }
        String[] stringArray = AxisHttpUtil.inspectHtml("(.*) OK", 1, new String(byArray));
        if (stringArray == null) {
            throw new UnableToAddGroupException(string);
        }
        return stringArray[1];
    }

    public static class ReadGroupException
    extends Exception {
        private static final long serialVersionUID = 8396045021478203669L;
        public String description;

        public String toString() {
            return "Unable to Read Parameter Group (" + this.description + ')';
        }

        public ReadGroupException(String string) {
            this.description = string;
        }
    }

    public static class ParameterNotFoundException
    extends Exception {
        private static final long serialVersionUID = -7044805487676950461L;
        public String groupPatternWithWildCards;
        public String queryForString;

        public String toString() {
            return "ParameterNotFound (" + this.groupPatternWithWildCards + '=' + this.queryForString + ')';
        }

        public ParameterNotFoundException(String string, String string2) {
            this.groupPatternWithWildCards = string;
            this.queryForString = string2;
        }
    }

    public static class UnableToUpdateParameterException
    extends Exception {
        private static final long serialVersionUID = 5843623516875115467L;
        public String updateParameterCmd;

        public String toString() {
            return "Unable to Update Parameter (" + this.updateParameterCmd + ')';
        }

        public UnableToUpdateParameterException(String string) {
            this.updateParameterCmd = string;
        }
    }

    public static class UnableToAddGroupException
    extends Exception {
        private static final long serialVersionUID = -1552455867965853046L;
        public String addGroupCmd;

        public String toString() {
            return "Unable to Add Parameter Group (" + this.addGroupCmd + ")\nThe maximum number of event server entries permitted by the camera may have been exceeded. Check the camera's 'Event' configuration page.";
        }

        public UnableToAddGroupException(String string) {
            this.addGroupCmd = string;
        }
    }
}

