/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.discover.dns;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;

public class DnsQuestion {
    private static final int PTR_TYPE = 12;
    private static final int SRV_TYPE = 33;
    private static final int IN_CLASS = 1;
    private String qName;
    private int qType;
    private int qClass;

    public static DnsQuestion readQuestion(DataInput dataInput) throws IOException {
        DnsQuestion dnsQuestion = new DnsQuestion();
        dnsQuestion.read(dataInput);
        return dnsQuestion;
    }

    public static DnsQuestion makeQuestion(String string, int n, int n2) {
        DnsQuestion dnsQuestion = new DnsQuestion(string, n, n2);
        return dnsQuestion;
    }

    public static DnsQuestion make_PTR_Question(String string) {
        return DnsQuestion.makeQuestion(string, 12, 1);
    }

    public static DnsQuestion make_SRV_Question(String string) {
        return DnsQuestion.makeQuestion(string, 33, 1);
    }

    public void read(DataInput dataInput) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = dataInput.readUnsignedByte()) != 0) {
            int n2 = n;
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append((char)dataInput.readUnsignedByte());
                ++n3;
            }
            stringBuffer.append(".");
        }
        this.qName = stringBuffer.toString();
        this.qType = dataInput.readUnsignedShort();
        this.qClass = dataInput.readUnsignedShort();
    }

    public void write(DataOutput dataOutput) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(this.qName, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            dataOutput.writeByte(string.length());
            dataOutput.writeBytes(string);
        }
        dataOutput.writeByte(0);
        dataOutput.writeShort(this.qType);
        dataOutput.writeShort(this.qClass);
    }

    public void read(ByteArrayInputStream byteArrayInputStream) throws IOException {
        this.read(new DataInputStream(byteArrayInputStream));
    }

    public void read(byte[] byArray) throws IOException {
        this.read(new ByteArrayInputStream(byArray));
    }

    public String geDomainName() {
        return this.qName;
    }

    public int getQueryType() {
        return this.qType;
    }

    public int getQueryClass() {
        return this.qClass;
    }

    private DnsQuestion() {
        this.qName = "";
        this.qType = 255;
        this.qClass = 255;
    }

    private DnsQuestion(String string, int n, int n2) {
        this.qName = string;
        this.qType = n;
        this.qClass = n2;
    }
}

