/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.naxisVideo.comm;

import com.tridium.naxisVideo.BAxisVideoCamera;
import com.tridium.naxisVideo.BAxisVideoNetwork;
import com.tridium.naxisVideo.event.BAxisVideoEventCameraExt;
import com.tridium.naxisVideo.event.BAxisVideoEventPointId;
import com.tridium.naxisVideo.event.BAxisVideoEventProxyExt;
import com.tridium.naxisVideo.identify.BAxisVideoCameraDeviceId;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.nvideo.event.BVideoEventStatus;
import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import com.tridium.videoDriver.event.BVideoEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.baja.control.BControlPoint;
import javax.baja.driver.BDevice;
import javax.baja.log.Log;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BMonth;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BAxisVideoEventsReceiver
extends BComponent {
    public static final Property enabled = BAxisVideoEventsReceiver.newProperty((int)0, (boolean)true, null);
    public static final Property tcpIpPort = BAxisVideoEventsReceiver.newProperty((int)0, (int)9797, null);
    public static final Property socketTimeout = BAxisVideoEventsReceiver.newProperty((int)0, (int)60000, null);
    public static final Type TYPE;
    protected ConnectionAcceptor rxEventsConnectionAcceptor;
    static /* synthetic */ Class class$com$tridium$naxisVideo$comm$BAxisVideoEventsReceiver;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public int getTcpIpPort() {
        return this.getInt(tcpIpPort);
    }

    public void setTcpIpPort(int n) {
        this.setInt(tcpIpPort, n, null);
    }

    public int getSocketTimeout() {
        return this.getInt(socketTimeout);
    }

    public void setSocketTimeout(int n) {
        this.setInt(socketTimeout, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    boolean isCommEnabled() {
        BAxisVideoNetwork bAxisVideoNetwork = (BAxisVideoNetwork)this.getParent();
        boolean bl = false;
        if (!bAxisVideoNetwork.isDisabled() && !bAxisVideoNetwork.isFault() && this.getEnabled()) {
            bl = true;
        }
        return bl;
    }

    public void started() throws Exception {
        this.rxEventsConnectionAcceptor = new ConnectionAcceptor();
        this.rxEventsConnectionAcceptor.startAcceptor();
        super.started();
    }

    public void stopped() throws Exception {
        this.rxEventsConnectionAcceptor.stopAcceptor();
        super.stopped();
    }

    public Log getLog() {
        return Log.getLog((String)("axisVideo.cameraEvents." + this.getTcpIpPort()));
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$naxisVideo$comm$BAxisVideoEventsReceiver;
        if (clazz == null) {
            clazz = class$com$tridium$naxisVideo$comm$BAxisVideoEventsReceiver = BAxisVideoEventsReceiver.class("[Lcom.tridium.naxisVideo.comm.BAxisVideoEventsReceiver;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ConnectionAcceptor
    extends Thread {
        protected boolean started;
        protected ServerSocket tcpServer;

        public void startAcceptor() {
            this.started = true;
            this.start();
        }

        public void stopAcceptor() {
            block3: {
                this.started = false;
                this.interrupt();
                if (this.tcpServer != null) {
                    try {
                        this.tcpServer.close();
                    }
                    catch (IOException iOException) {
                        if (!BAxisVideoEventsReceiver.this.getLog().isTraceOn()) break block3;
                        BAxisVideoEventsReceiver.this.getLog().trace(iOException.toString(), (Throwable)iOException);
                    }
                }
            }
        }

        public void run() {
            while (this.started) {
                try {
                    if (BAxisVideoEventsReceiver.this.isCommEnabled()) {
                        this.tryAcceptEvent();
                        continue;
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Exception exception) {
                    BAxisVideoEventsReceiver.this.getLog().error(exception.toString(), (Throwable)exception);
                }
            }
        }

        protected void tryAcceptEvent() {
            try {
                this.acceptEvent();
            }
            catch (IOException iOException) {
                if (BAxisVideoEventsReceiver.this.getLog().isTraceOn()) {
                    BAxisVideoEventsReceiver.this.getLog().trace(iOException.toString(), (Throwable)iOException);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void acceptEvent() throws IOException {
            this.tcpServer = new ServerSocket(BAxisVideoEventsReceiver.this.getTcpIpPort());
            try {
                this.tcpServer.setSoTimeout(BAxisVideoEventsReceiver.this.getSocketTimeout());
                if (BAxisVideoEventsReceiver.this.getLog().isTraceOn()) {
                    BAxisVideoEventsReceiver.this.getLog().trace("Waiting for an Axis Video Camera to connect...");
                }
                Socket socket = this.tcpServer.accept();
                if (BAxisVideoEventsReceiver.this.getLog().isTraceOn()) {
                    BAxisVideoEventsReceiver.this.getLog().trace("Axis Video Camera Connection Established...processing in background");
                }
                BAxisVideoNetwork bAxisVideoNetwork = (BAxisVideoNetwork)BAxisVideoEventsReceiver.this.getParent();
                bAxisVideoNetwork.postAsync(new ConnectionProcessor(socket));
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                this.tcpServer.close();
                throw throwable;
            }
            {
                Object var2_5 = null;
            }
            this.tcpServer.close();
        }

        private final /* synthetic */ void this() {
            this.started = false;
        }

        public ConnectionAcceptor() {
            super("axis.AcceptEvents");
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ConnectionProcessor
    implements Runnable {
        protected Socket clientSocket;
        protected InputStream eventInput;
        protected String clientIpAddress;

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    this.readEvent();
                }
                catch (IOException iOException) {
                    if (BAxisVideoEventsReceiver.this.getLog().isTraceOn()) {
                        BAxisVideoEventsReceiver.this.getLog().trace(iOException.toString(), (Throwable)iOException);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                try {
                    this.clientSocket.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    if (!BAxisVideoEventsReceiver.this.getLog().isTraceOn()) throw throwable;
                    BAxisVideoEventsReceiver.this.getLog().trace(iOException.toString(), (Throwable)iOException);
                }
                throw throwable;
            }
            {
                Object var2_4 = null;
            }
            try {}
            catch (IOException iOException) {
                if (!BAxisVideoEventsReceiver.this.getLog().isTraceOn()) return;
                BAxisVideoEventsReceiver.this.getLog().trace(iOException.toString(), (Throwable)iOException);
                return;
            }
            this.clientSocket.close();
        }

        public void readEvent() throws IOException {
            String string;
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = this.eventInput.read();
            while (n2 != -1) {
                if (n2 > 48 || n2 == 32) {
                    stringBuffer.append((char)n2);
                }
                n2 = this.eventInput.read();
            }
            if (n2 > 48 || n2 == 32) {
                stringBuffer.append((char)n2);
            }
            if ((n = (string = stringBuffer.toString()).length()) > 1 && string.charAt(0) == '\"' && string.charAt(n - 1) == '\"') {
                string = string.substring(1, n - 1);
            }
            if (string.length() > 0) {
                if (BAxisVideoEventsReceiver.this.getLog().isTraceOn()) {
                    BAxisVideoEventsReceiver.this.getLog().trace("Received action message: " + string + " from Axis camera " + this.clientIpAddress);
                }
                this.processCameraEvent(string);
            } else if (BAxisVideoEventsReceiver.this.getLog().isTraceOn()) {
                BAxisVideoEventsReceiver.this.getLog().trace("Receieved empty action message from Axis camera " + this.clientIpAddress);
            }
        }

        protected BAbsTime constructEventTime(String string) {
            int n = Integer.parseInt(string.substring(0, 2));
            int n2 = Integer.parseInt(string.substring(3, 5));
            int n3 = Integer.parseInt(string.substring(6, 8));
            int n4 = Integer.parseInt(string.substring(12, 14));
            int n5 = Integer.parseInt(string.substring(15, 17));
            int n6 = Integer.parseInt(string.substring(18, 22));
            return BAbsTime.make((int)n6, (BMonth)BMonth.make((int)(n5 - 1)), (int)n4, (int)n, (int)n2, (int)n3, (int)0, (BTimeZone)BTimeZone.GMT);
        }

        protected String getDvrIpAddressFromIpAddressBytes(BIpAddress bIpAddress) {
            try {
                byte[] byArray = bIpAddress.getInetAddress().getAddress();
                String string = Integer.toString(byArray[0] & 0xFF) + '.' + Integer.toString(byArray[1] & 0xFF) + '.' + Integer.toString(byArray[2] & 0xFF) + '.' + Integer.toString(byArray[3] & 0xFF);
                return string;
            }
            catch (Exception exception) {
                return "UnknownHostException-&*^&^Y)&*(*(&*(&*^&TYJKHJKHJKHJKGHJTGdjkfhadjskf";
            }
        }

        protected boolean compareCameraIpAddress(BAxisVideoCamera bAxisVideoCamera) {
            BAxisVideoCameraDeviceId bAxisVideoCameraDeviceId = (BAxisVideoCameraDeviceId)bAxisVideoCamera.getVideoDeviceId();
            String string = bAxisVideoCameraDeviceId.getUrlAddress();
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (Exception exception) {
                inetAddress = null;
            }
            InetAddress inetAddress2 = this.clientSocket.getInetAddress();
            return inetAddress != null && inetAddress.equals(inetAddress2);
        }

        protected void updateEventPointsForCamera(BAxisVideoCamera bAxisVideoCamera, String string) {
            BAxisVideoEventCameraExt bAxisVideoEventCameraExt = bAxisVideoCamera.getEvents();
            BControlPoint[] bControlPointArray = bAxisVideoEventCameraExt.getPoints();
            int n = 0;
            while (n < bControlPointArray.length) {
                BVideoEvent bVideoEvent;
                BAxisVideoEventProxyExt bAxisVideoEventProxyExt = (BAxisVideoEventProxyExt)bControlPointArray[n].getProxyExt();
                BAxisVideoEventPointId bAxisVideoEventPointId = bAxisVideoEventProxyExt.getPointId();
                String string2 = bAxisVideoEventPointId.getActionStart();
                String string3 = bAxisVideoEventPointId.getActionStop();
                if (string.equals(string2)) {
                    if (bAxisVideoEventPointId.getNiagaraEventType() == BVideoEventTypesEnum.motionStarted) {
                        bVideoEvent = BVideoEvent.makeMotionStarted();
                    } else if (bAxisVideoEventPointId.getNiagaraEventType() == BVideoEventTypesEnum.motionStopped) {
                        bVideoEvent = BVideoEvent.makeMotionStopped();
                    } else {
                        bVideoEvent = BVideoEvent.makeOffNormalEvent();
                        bVideoEvent.setDescription(string);
                    }
                    bAxisVideoEventProxyExt.readOk((BStatusValue)new BVideoEventStatus(bVideoEvent));
                } else if (string.equals(string3)) {
                    if (bAxisVideoEventPointId.getNiagaraEventType() == BVideoEventTypesEnum.motionStarted) {
                        bVideoEvent = BVideoEvent.makeMotionStopped();
                    } else if (bAxisVideoEventPointId.getNiagaraEventType() == BVideoEventTypesEnum.motionStopped) {
                        bVideoEvent = BVideoEvent.makeMotionStarted();
                    } else {
                        bVideoEvent = BVideoEvent.makeNormalEvent();
                        bVideoEvent.setDescription(string);
                    }
                    bAxisVideoEventProxyExt.readOk((BStatusValue)new BVideoEventStatus(bVideoEvent));
                }
                ++n;
            }
        }

        protected void updateEventPoint(String string) {
            BAxisVideoNetwork bAxisVideoNetwork = (BAxisVideoNetwork)BAxisVideoEventsReceiver.this.getParent();
            BDevice[] bDeviceArray = bAxisVideoNetwork.getDevices();
            int n = 0;
            while (n < bDeviceArray.length) {
                if (bDeviceArray[n] instanceof BAxisVideoCamera && this.compareCameraIpAddress((BAxisVideoCamera)bDeviceArray[n])) {
                    bDeviceArray[n].pingOk();
                    this.updateEventPointsForCamera((BAxisVideoCamera)bDeviceArray[n], string);
                }
                ++n;
            }
        }

        protected void processCameraEvent(String string) {
            this.updateEventPoint(string);
        }

        public ConnectionProcessor(Socket socket) throws IOException {
            this.eventInput = socket.getInputStream();
            this.clientSocket = socket;
            this.clientIpAddress = socket.getInetAddress().getHostAddress();
        }
    }
}

