/*
 * Decompiled with CFR 0.152.
 */
package org.baja.ffmpeg.videoDriver;

import com.tridium.videoDriver.ui.BIVideoPlayer;
import com.tridium.videoDriver.ui.BVideoPlayer;
import com.tridium.videoDriver.videoStream.BIVideoSource;
import com.tridium.videoDriver.videoStream.IVideoSession;
import com.tridium.videoDriver.videoStream.WaitForStopDecoding;
import com.tridium.videoDriver.videoStream.decoder.IVideoImagePainter;
import com.tridium.videoDriver.videoStream.decoder.VidFrame;
import com.tridium.videoDriver.videoStream.decoder.VideoDecoder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.Size;
import javax.baja.log.Log;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.ui.BWidget;
import org.baja.ffmpeg.FfmpegLexicon;
import org.baja.ffmpeg.enums.BCodecIdEnum;
import org.baja.ffmpeg.enums.BFfmpegLogLevel;
import org.baja.ffmpeg.enums.BPixelFormatEnum;
import org.baja.ffmpeg.libavcodec.FfmpegAVCodec;
import org.baja.ffmpeg.libavcodec.FfmpegAVCodecContext;
import org.baja.ffmpeg.libavcodec.FfmpegAVFrame;
import org.baja.ffmpeg.libavcodec.FfmpegAvCodecUtil;
import org.baja.ffmpeg.swscale.FfmpegSwScaleUtil;
import org.baja.ffmpeg.swscale.FfmpegSwsContext;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class FfmpegVideoDecoder
extends VideoDecoder
implements IVideoImagePainter {
    public static final int SHOW_FFMPEG_LOGO_WITHOUT_FADE_DURATION = 2000;
    public static final int SHOW_FFMPEG_LOGO_WITH_FADE_DURATION = 2000;
    public static final int FF_INPUT_BUFFER_PADDING_SIZE = 8;
    public static final byte[] FF_INPUT_BUFFER_PADDING = new byte[8];
    public static final Log log = Log.getLog((String)"ffmpeg.videoDecoder");
    public static final Log nativeLog = Log.getLog((String)"ffmpeg.nativeDecoder");
    public static final BImage FFMPEG_DISCONNECTED_IMAGE = BImage.make((String)"module://ffmpeg/images/VideoStreamDisconnected.png");
    public static final int FFMPEG_LOGO_BACKGROUND_RED = 50;
    public static final int FFMPEG_LOGO_FOREGROUND_RED = 255;
    public static final int FFMPEG_LOGO_BACKGROUND_GREEN = 50;
    public static final int FFMPEG_LOGO_FOREGROUND_GREEN = 255;
    public static final int FFMPEG_LOGO_BACKGROUND_BLUE = 50;
    public static final int FFMPEG_LOGO_FOREGROUND_BLUE = 255;
    public static final int FFMPEG_LOGO_INITIAL_BACKGROUND_ALPHA = 50;
    public static final int FFMPEG_LOGO_INITIAL_FOREGROUND_ALPHA = 50;
    protected long ticksWhenFfmpegLogoFirstShown;
    protected FfmpegAVCodecContext avDecoderContext;
    protected FfmpegAVCodec avDecoderCodec;
    protected FfmpegAVFrame mostRecentRawDecodedFfmpegFrame;
    protected FfmpegSwsContext swsContext;
    protected int[] pixelBufferData;
    protected BCodecIdEnum decoderCodecToUse;
    protected BPixelFormatEnum destPixelFmt;
    protected int videoWidth;
    protected int videoHeight;
    private Object lock;

    protected void padBufferPerFfmpegDocumentationBeforeCallingAvCodecDecodeVideo(ByteBuffer byteBuffer) {
        byteBuffer.write(FF_INPUT_BUFFER_PADDING);
    }

    protected void autoDetermineVideoWidthAndHeight() {
        Size size = FfmpegAvCodecUtil.avcodec_get_dimensions(this.avDecoderContext);
        this.videoWidth = (int)size.width();
        this.videoHeight = (int)size.height();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void decodeFrame(VidFrame vidFrame) throws Exception {
        boolean[] blArray = new boolean[1];
        ByteBuffer byteBuffer = vidFrame.rawData;
        int n = byteBuffer.getLength();
        this.padBufferPerFfmpegDocumentationBeforeCallingAvCodecDecodeVideo(byteBuffer);
        Object object = this.lock;
        synchronized (object) {
            if (this.avDecoderContext.isNull() || this.mostRecentRawDecodedFfmpegFrame.isNull()) {
                vidFrame.image = BImage.DEFAULT;
                return;
            }
            int n2 = FfmpegAvCodecUtil.avcodec_decode_video(this.avDecoderContext, this.mostRecentRawDecodedFfmpegFrame, blArray, byteBuffer.getBytes(), n);
            if (log.isTraceOn()) {
                log.trace("retVal = " + n2 + " frameFinished = " + blArray[0]);
            }
            if (this.videoWidth == -1 || this.videoHeight == -1) {
                this.finishInitializing();
            }
            if (this.swsContext.isNull() || this.mostRecentRawDecodedFfmpegFrame.isNull() || this.pixelBufferData == null) {
                vidFrame.image = BImage.DEFAULT;
                return;
            }
            n2 = FfmpegSwScaleUtil.sws_Scale(this.swsContext, this.mostRecentRawDecodedFfmpegFrame, this.pixelBufferData, this.videoWidth, this.videoHeight, this.destPixelFmt);
            if (n2 < 0) {
                throw new IllegalStateException("Unable to convert frame to " + (Object)((Object)this.destPixelFmt) + " retVal=" + n2 + ").");
            }
            if (log.isTraceOn()) {
                log.trace("Got image pixels!!!");
            }
        }
        if (blArray[0]) {
            BImage bImage = BImage.make((double)this.videoWidth, (double)this.videoHeight);
            bImage.setPixels(this.pixelBufferData);
            vidFrame.image = bImage;
            return;
        }
        if (log.isTraceOn()) {
            log.trace("!frameFinished");
        }
        vidFrame.image = null;
    }

    protected void initDecoder() {
        if (nativeLog.isTraceOn()) {
            FfmpegAvCodecUtil.setLogLevel(BFfmpegLogLevel.debug);
        } else {
            FfmpegAvCodecUtil.setLogLevel(BFfmpegLogLevel.quiet);
        }
        this.avDecoderContext = FfmpegAvCodecUtil.avcodec_alloc_context();
        if (this.avDecoderContext.isNull()) {
            throw new IllegalStateException("Unable to allocate FFmpeg decoder codec context.");
        }
        this.avDecoderCodec = FfmpegAvCodecUtil.avcodec_find_decoder(this.decoderCodecToUse);
        if (this.avDecoderCodec.isNull()) {
            throw new IllegalStateException("Unable to allocate FFmpeg decoder codec.");
        }
        int n = FfmpegAvCodecUtil.avcodec_open(this.avDecoderContext, this.avDecoderCodec);
        if (n < 0) {
            throw new IllegalStateException("Unable to open decoder codec " + (Object)((Object)this.decoderCodecToUse) + ". Return code " + n);
        }
    }

    protected void initSwsContext() {
        this.swsContext = FfmpegSwScaleUtil.sws_getContext(this.videoWidth, this.videoHeight, BPixelFormatEnum.ffmpeg_PIX_FMT_YUV420P, this.videoWidth, this.videoHeight, this.destPixelFmt);
        if (this.swsContext == null || this.swsContext.isNull()) {
            throw new IllegalStateException("Unable to initialize FFmpeg swsContext.");
        }
    }

    protected void initRawDecodedFfmpegFrame() {
        this.mostRecentRawDecodedFfmpegFrame = FfmpegAvCodecUtil.avcodec_alloc_frame();
        if (this.mostRecentRawDecodedFfmpegFrame.isNull()) {
            throw new IllegalStateException("Unable to allocate FFmpeg raw decode frame.");
        }
    }

    protected void finishInitializing() {
        this.autoDetermineVideoWidthAndHeight();
        this.initSwsContext();
        this.initPixelBuffer();
    }

    protected void initPixelBuffer() {
        int n = this.videoWidth * this.videoHeight;
        this.pixelBufferData = new int[n];
    }

    public void init(BIVideoSource bIVideoSource, BIVideoPlayer bIVideoPlayer, BRelTime bRelTime, IVideoSession iVideoSession) {
        super.init(bIVideoSource, bIVideoPlayer, bRelTime, iVideoSession);
        FfmpegAvCodecUtil.av_register_all();
        if (this.decoderCodecToUse != null) {
            this.initDecoder();
        }
        this.initRawDecodedFfmpegFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopDecoding(WaitForStopDecoding waitForStopDecoding) {
        super.stopDecoding(waitForStopDecoding);
        Object object = this.lock;
        synchronized (object) {
            if (!this.avDecoderContext.isNull()) {
                FfmpegAvCodecUtil.avcodec_close(this.avDecoderContext);
                FfmpegAvCodecUtil.av_free(this.avDecoderContext);
            }
            if (!this.mostRecentRawDecodedFfmpegFrame.isNull()) {
                FfmpegAvCodecUtil.av_free(this.mostRecentRawDecodedFfmpegFrame);
            }
            if (!this.swsContext.isNull()) {
                FfmpegSwScaleUtil.sws_freeContext(this.swsContext);
            }
            return;
        }
    }

    public static void readBytesFromInputStream(Log log, InputStream inputStream, byte[] byArray, int n, Object object) throws IOException {
        if (log.isTraceOn()) {
            log.trace("Reading " + n + " data bytes");
        }
        int n2 = 0;
        int n3 = n;
        while (n3 > 0) {
            int n4 = n3 < byArray.length ? n3 : byArray.length;
            int n5 = inputStream.read(byArray, 0, n4);
            if (n5 == -1) {
                throw new EOFException();
            }
            if (n5 == 0) continue;
            n2 += n5;
            if (n != Integer.MAX_VALUE) {
                n3 -= n5;
            }
            if (log.isTraceOn()) {
                log.trace("<HexDump - Follows>");
                ByteArrayUtil.hexDump((byte[])byArray, (int)0, (int)n5);
            }
            if (object == null) continue;
            if (object instanceof ByteBuffer) {
                ((ByteBuffer)object).write(byArray, 0, n5);
                continue;
            }
            if (object instanceof OutputStream) {
                ((OutputStream)object).write(byArray, 0, n5);
                ((OutputStream)object).flush();
                continue;
            }
            if (!(object instanceof PrintWriter)) continue;
            ByteArrayUtil.hexDump((PrintWriter)((PrintWriter)object), (byte[])byArray, (int)0, (int)n5);
        }
        if (log.isTraceOn()) {
            log.trace("Finished reading " + n2 + " data bytes.");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paintImage(Graphics graphics, BWidget bWidget) {
        String string;
        boolean bl = false;
        int n = 50;
        int n2 = 50;
        Property property = bWidget.getProperty("hasPaintedFfmpegLogoOnVideoPlayer");
        if (property == null) {
            property = bWidget.add("hasPaintedFfmpegLogoOnVideoPlayer", (BValue)BBoolean.TRUE);
            bl = true;
            n = 50;
            n2 = 50;
        } else {
            long l = Clock.ticks();
            if (this.ticksWhenFfmpegLogoFirstShown == (long)-1) {
                this.ticksWhenFfmpegLogoFirstShown = 0L;
                bl = false;
            } else if (l - this.ticksWhenFfmpegLogoFirstShown > 4000L) {
                bl = false;
            } else if (l - this.ticksWhenFfmpegLogoFirstShown > 2000L) {
                bl = true;
                long l2 = this.ticksWhenFfmpegLogoFirstShown + 2000L + 2000L - l;
                double d = (double)l2 / 2000.0;
                n = (int)(d * 50.0);
                n2 = (int)(d * 50.0);
            } else {
                bl = true;
                n = 50;
                n2 = 50;
            }
        }
        double d = bWidget.getWidth();
        double d2 = bWidget.getHeight();
        if (!bl) return;
        BBrush bBrush = BBrush.makeSolid((BColor)BColor.make((int)50, (int)50, (int)50, (int)n));
        BBrush bBrush2 = BBrush.makeSolid((BColor)BColor.make((int)255, (int)255, (int)255, (int)n2));
        if (this.ticksWhenFfmpegLogoFirstShown == (long)-1) {
            this.ticksWhenFfmpegLogoFirstShown = Clock.ticks();
        }
        if ((string = FfmpegLexicon.LEX.get("decodingComplimentsOfFfmpeg", null)) == null) return;
        if (string.length() <= 0) return;
        try {
            graphics.push();
            BVideoPlayer.paintMessage((Graphics)graphics, (String)string, (int)Integer.MIN_VALUE, (int)80, (double)d, (double)d2, (BBrush)bBrush, (BBrush)bBrush2);
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            graphics.pop();
            throw throwable;
        }
        {
            Object var15_17 = null;
        }
        graphics.pop();
    }

    private final /* synthetic */ void this() {
        this.ticksWhenFfmpegLogoFirstShown = -1;
        this.decoderCodecToUse = null;
        this.destPixelFmt = BPixelFormatEnum.ffmpeg_PIX_FMT_BGRA;
        this.videoWidth = -1;
        this.videoHeight = -1;
        this.lock = new Object();
    }

    protected FfmpegVideoDecoder() {
        this.this();
        this.decoderCodecToUse = null;
    }

    protected FfmpegVideoDecoder(BCodecIdEnum bCodecIdEnum) {
        this.this();
        this.decoderCodecToUse = bCodecIdEnum;
    }
}

