/*
 * Decompiled with CFR 0.152.
 */
package obix.ui.views;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import obix.net.SessionWatch;
import obix.ui.Command;
import obix.ui.Form;
import obix.ui.Shell;
import obix.ui.UiSession;
import obix.ui.Utils;
import obix.ui.View;

public class WatchServiceView
extends View {
    static int counter = 0;
    static int lastPollPeriod = 500;
    JTable table;
    Model model;
    Row[] rows;

    public WatchServiceView(Shell shell, UiSession.Response response) {
        super(shell, "Watches", response);
        SessionWatch[] sessionWatchArray = response.session.getWatches();
        this.rows = new Row[sessionWatchArray.length];
        for (int i = 0; i < this.rows.length; ++i) {
            this.rows[i] = new Row(sessionWatchArray[i]);
        }
        this.model = new Model();
        this.table = new JTable(this.model);
        this.table.setSelectionMode(0);
        this.table.addMouseListener(new Controller());
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(new JButton(new Command(shell, "Make"){

            public void doInvoke() throws Exception {
                WatchServiceView.this.doMake();
            }
        }));
        jPanel.add(new JButton(new Command(shell, "Poll Changes"){

            public void doInvoke() throws Exception {
                WatchServiceView.this.doPollChanges();
            }
        }));
        jPanel.add(new JButton(new Command(shell, "Poll Refresh"){

            public void doInvoke() throws Exception {
                WatchServiceView.this.doPollRefresh();
            }
        }));
        jPanel.add(new JButton(new Command(shell, "Dispose"){

            public void doInvoke() throws Exception {
                WatchServiceView.this.doDispose();
            }
        }));
        this.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)jPanel, "South");
    }

    public void animate() {
        this.model.fireTableRowsUpdated(0, this.rows.length);
    }

    public void doMake() throws Exception {
        MakePrompt makePrompt = new MakePrompt();
        makePrompt.name = "Watch-" + (char)(65 + counter++);
        makePrompt.pollPeriod = lastPollPeriod;
        if ((makePrompt = (MakePrompt)Form.prompt(this, "Make Watch", makePrompt)) == null) {
            return;
        }
        lastPollPeriod = makePrompt.pollPeriod;
        this.session.makeWatch(makePrompt.name, lastPollPeriod);
        this.shell.refresh();
    }

    public void doPollChanges() throws Exception {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        SessionWatch sessionWatch = this.rows[n].watch;
        sessionWatch.pollChanges();
    }

    public void doPollRefresh() throws Exception {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        SessionWatch sessionWatch = this.rows[n].watch;
        sessionWatch.pollRefresh();
    }

    public void doDispose() {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        SessionWatch sessionWatch = this.rows[n].watch;
        sessionWatch.delete();
        this.shell.refresh();
    }

    public static class MakePrompt {
        public String name;
        public int pollPeriod;
    }

    static class Row {
        UiSession session;
        SessionWatch watch;

        Row(SessionWatch sessionWatch) {
            this.session = (UiSession)sessionWatch.getSession();
            this.watch = sessionWatch;
        }

        public Object get(int n) {
            switch (n) {
                case 0: {
                    return this.session.getAuthority();
                }
                case 1: {
                    return this.watch.getName();
                }
                case 2: {
                    return "" + this.watch.size();
                }
                case 3: {
                    return Utils.duration(this.watch.getLease());
                }
                case 4: {
                    return Utils.duration(this.watch.getPollPeriod());
                }
                case 5: {
                    return Utils.millisAgo(this.watch.lastPollAttempt());
                }
                case 6: {
                    return Utils.millisAgo(this.watch.lastPollSuccess());
                }
            }
            return "?";
        }
    }

    class Model
    extends AbstractTableModel {
        Model() {
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Session";
                }
                case 1: {
                    return "Name";
                }
                case 2: {
                    return "Size";
                }
                case 3: {
                    return "Lease";
                }
                case 4: {
                    return "Poll Period";
                }
                case 5: {
                    return "Last Attempt";
                }
                case 6: {
                    return "Last Success";
                }
            }
            return "?";
        }

        public int getColumnCount() {
            return 7;
        }

        public int getRowCount() {
            return WatchServiceView.this.rows.length;
        }

        public Object getValueAt(int n, int n2) {
            return WatchServiceView.this.rows[n].get(n2);
        }
    }

    class Controller
    extends MouseAdapter {
        Controller() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }
    }
}

