/*
 * Decompiled with CFR 0.152.
 */
package obix.ui.views;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import obix.Abstime;
import obix.Feed;
import obix.Obj;
import obix.Op;
import obix.Uri;
import obix.io.ObixEncoder;
import obix.net.BatchIn;
import obix.ui.Command;
import obix.ui.Shell;
import obix.ui.UiSession;
import obix.ui.View;

public class AlarmConsoleView
extends View {
    JTable table;
    Model model;
    ArrayList rows = new ArrayList();

    public AlarmConsoleView(Shell shell, UiSession.Response response) throws Exception {
        super(shell, "AlarmConsole", response);
        this.model = new Model();
        this.table = new JTable(this.model);
        this.table.setAutoResizeMode(0);
        this.table.setSelectionMode(1);
        this.table.addMouseListener(new Controller());
        this.add((Component)new JScrollPane(this.table), "Center");
        Feed feed = (Feed)response.obj.get("feed");
        feed = (Feed)this.watch().add(feed.getNormalizedHref());
        Obj[] objArray = feed.list();
        for (int i = 0; i < objArray.length; ++i) {
            this.rows.add(new Row(objArray[i]));
        }
    }

    public void changed(Obj obj) {
        Feed feed = (Feed)obj;
        Obj[] objArray = feed.list();
        for (int i = 0; i < objArray.length; ++i) {
            this.mergeIntoModel(objArray[i]);
        }
        int[] nArray = this.table.getSelectedRows();
        this.model.fireTableDataChanged();
        if (nArray != null && nArray.length > 0) {
            this.table.getSelectionModel().setSelectionInterval(nArray[0], nArray[nArray.length - 1]);
        }
    }

    public void mergeIntoModel(Obj obj) {
        Uri uri = obj.getHref();
        for (int i = 0; i < this.rows.size(); ++i) {
            Row row = (Row)this.rows.get(i);
            Obj obj2 = row.alarm;
            if (!obj2.getHref().equals(uri)) continue;
            row.alarm = obj;
            return;
        }
        this.rows.add(new Row(obj));
    }

    void doubleClicked(Obj obj) {
        String string = ObixEncoder.toString(obj);
        JTextArea jTextArea = new JTextArea(string, 20, 100);
        JOptionPane.showMessageDialog(this, new JScrollPane(jTextArea));
    }

    void popup(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new Ack());
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    void ackSelected() throws Exception {
        Obj[] objArray = this.getSelectedAlarms();
        BatchIn batchIn = this.session.makeBatch();
        for (int i = 0; i < objArray.length; ++i) {
            Op op = (Op)objArray[i].get("ack");
            if (op == null) continue;
            batchIn.invoke(op, null);
        }
        if (batchIn.size() > 0) {
            batchIn.commit();
        }
    }

    Obj[] getSelectedAlarms() {
        int[] nArray = this.table.getSelectedRows();
        Obj[] objArray = new Obj[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objArray[i] = ((Row)this.rows.get((int)nArray[i])).alarm;
        }
        return objArray;
    }

    static class Row {
        Obj alarm;

        Row(Obj obj) {
            this.alarm = obj;
        }

        public Object format(int n) {
            Object object = this.get(n);
            if (object == null) {
                return "";
            }
            if (object instanceof Abstime) {
                return ((Abstime)object).format();
            }
            return object.toString();
        }

        public Object get(int n) {
            switch (n) {
                case 0: {
                    return this.alarm.get("timestamp");
                }
                case 1: {
                    return this.alarm.get("source");
                }
                case 2: {
                    return this.alarm.get("normalTimestamp");
                }
                case 3: {
                    return this.alarm.get("ackTimestamp");
                }
                case 4: {
                    return this.alarm.get("ackUser");
                }
                case 5: {
                    return this.alarm.get("alarmValue");
                }
                case 6: {
                    return this.alarm.getIs();
                }
            }
            return "?";
        }
    }

    class Model
    extends AbstractTableModel {
        Model() {
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Timestamp";
                }
                case 1: {
                    return "Source";
                }
                case 2: {
                    return "Normal Timestamp";
                }
                case 3: {
                    return "Ack Timestamp";
                }
                case 4: {
                    return "Ack User";
                }
                case 5: {
                    return "Alarm Value";
                }
                case 6: {
                    return "Contracts";
                }
            }
            return "?";
        }

        public int getColumnCount() {
            return 7;
        }

        public int getRowCount() {
            return AlarmConsoleView.this.rows.size();
        }

        public Object getValueAt(int n, int n2) {
            return ((Row)AlarmConsoleView.this.rows.get(n)).format(n2);
        }
    }

    public class Ack
    extends Command {
        Ack() {
            super(AlarmConsoleView.this.shell, "Ack", null, null);
        }

        public void doInvoke() throws Exception {
            AlarmConsoleView.this.ackSelected();
        }
    }

    class Controller
    extends MouseAdapter {
        Controller() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                AlarmConsoleView.this.popup(mouseEvent);
                return;
            }
            int n = AlarmConsoleView.this.table.rowAtPoint(mouseEvent.getPoint());
            if (n != -1) {
                Obj obj = ((Row)AlarmConsoleView.this.rows.get((int)n)).alarm;
                if (mouseEvent.getClickCount() == 2) {
                    AlarmConsoleView.this.doubleClicked(obj);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                AlarmConsoleView.this.popup(mouseEvent);
                return;
            }
        }
    }
}

