/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import obix.Contract;
import obix.ContractRegistry;
import obix.Obj;
import obix.Op;
import obix.Uri;
import obix.io.ObixDecoder;
import obix.net.ObixSession;
import obix.ui.Form;
import obix.ui.ObjSheet;
import obix.ui.Shell;
import obix.ui.Utils;

public class UiSession
extends ObixSession {
    static HashMap sessions = new HashMap();
    static final ImageIcon iconDefault = Utils.icon("x16/object.png");
    static final ImageIcon iconOp = Utils.icon("x16/exclaim.png");
    static final ImageIcon iconInfo = Utils.icon("x16/info.png");
    static final ImageIcon iconGlasses = Utils.icon("x16/glasses.png");
    static final ImageIcon iconHistory = Utils.icon("x16/history.png");
    static final ImageIcon iconAlarm = Utils.icon("x16/alarm.png");
    Object iconLock = new Object();
    IconLoader iconLoader = new IconLoader();
    HashMap iconCache = new HashMap();
    ArrayList iconQueue = new ArrayList();
    static /* synthetic */ Class class$obix$Obj;

    public static UiSession[] list() {
        return sessions.values().toArray(new UiSession[sessions.size()]);
    }

    public static UiSession make(Shell shell, Uri uri) throws Exception {
        uri.checkAbsolute();
        String string = uri.getAuthority();
        UiSession uiSession = (UiSession)sessions.get(string);
        if (uiSession != null) {
            return uiSession;
        }
        Ask ask = new Ask();
        ask.lobby = uri.getAuthority() + "obix/";
        ask = (Ask)Form.prompt(shell.getRootPane(), "Open New Session", ask);
        if (ask == null) {
            return null;
        }
        uiSession = new UiSession(new Uri(ask.lobby), ask.userName, ask.password);
        uiSession.open();
        sessions.put(string, uiSession);
        shell.sessionCreated(uiSession);
        return uiSession;
    }

    private UiSession(Uri uri, String string, String string2) {
        super(uri, string, string2);
    }

    public void open() throws Exception {
        super.open();
        this.iconLoader = new IconLoader();
        this.iconLoader.start();
    }

    public void close() {
        super.close();
        this.iconLoader.kill();
        this.iconLoader = null;
    }

    public Response request(Uri uri) throws Exception {
        int n;
        Response response = new Response();
        response.session = this;
        InputStream inputStream = this.open(uri);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) >= 0) {
            byteArrayOutputStream.write(n);
        }
        inputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            n = byArray[i];
            if (n == 10 || 32 <= n && n <= 127) {
                stringBuffer.append((char)n);
                continue;
            }
            stringBuffer.append('.');
        }
        response.source = stringBuffer.toString();
        try {
            response.obj = new ObixDecoder(new ByteArrayInputStream(byArray)).decodeDocument();
        }
        catch (Throwable throwable) {
            response.objError = throwable;
        }
        return response;
    }

    public Obj invoke(Shell shell, Op op) throws Exception {
        Uri uri = op.getNormalizedHref();
        if (uri == null) {
            throw new Exception("Missing href for op");
        }
        Obj obj = this.getInvokeIn(op);
        if (obj != null) {
            obj.setWritable(true, true);
            obj = ObjSheet.prompt(shell, "Invoke " + op.getName(), this, obj);
            if (obj == null) {
                return null;
            }
        } else {
            obj = new Obj("in");
        }
        return this.invoke(uri, obj);
    }

    public Obj getInvokeIn(Op op) throws Exception {
        Contract contract = op.getIn();
        if (contract.containsOnlyObj()) {
            return null;
        }
        System.out.println("getInvokeIn: " + contract);
        Object object = null;
        if (contract.primary().get().startsWith("obix:")) {
            object = ContractRegistry.toObj(class$obix$Obj == null ? (class$obix$Obj = UiSession.class$("obix.Obj")) : class$obix$Obj, contract);
            System.out.println("  reg: " + object);
            if (object != null) {
                ((Obj)object).setName("in");
            }
        }
        if (object != null && object.getClass() != (class$obix$Obj == null ? (class$obix$Obj = UiSession.class$("obix.Obj")) : class$obix$Obj)) {
            return object;
        }
        Uri uri = contract.primary().normalize(op.getNormalizedHref());
        return this.read(uri);
    }

    public Icon loadIcon(Obj obj) {
        ImageIcon imageIcon = this.getDefaultIcon(obj);
        Uri uri = obj.getIcon();
        if (uri == null) {
            return imageIcon;
        }
        return this.loadIcon(uri, imageIcon);
    }

    public ImageIcon getDefaultIcon(Obj obj) {
        if (obj instanceof Op) {
            return iconOp;
        }
        if (obj.getIs() == null) {
            return iconDefault;
        }
        Uri[] uriArray = obj.getIs().list();
        for (int i = 0; i < uriArray.length; ++i) {
            String string = uriArray[i].toString();
            if (string.equals("obix:About")) {
                return iconInfo;
            }
            if (string.equals("obix:WatchService")) {
                return iconGlasses;
            }
            if (string.equals("obix:Alarm")) {
                return iconAlarm;
            }
            if (!string.equals("obix:History")) continue;
            return iconHistory;
        }
        return iconDefault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon loadIcon(Uri uri, ImageIcon imageIcon) {
        if (uri == null) {
            return imageIcon;
        }
        Object object = this.iconLock;
        synchronized (object) {
            String string = uri.toString();
            RemoteIcon remoteIcon = (RemoteIcon)this.iconCache.get(string);
            if (remoteIcon != null) {
                return remoteIcon;
            }
            remoteIcon = new RemoteIcon(uri, imageIcon);
            this.iconCache.put(string, remoteIcon);
            this.iconQueue.add(remoteIcon);
            this.iconLock.notifyAll();
            return remoteIcon;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Response {
        public UiSession session;
        public String source;
        public Obj obj;
        public Throwable objError;
    }

    class IconLoader
    extends Thread {
        boolean alive = true;

        IconLoader() {
            super("IconLoader");
        }

        public void kill() {
            this.alive = false;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.alive) {
                try {
                    int n;
                    RemoteIcon remoteIcon = null;
                    Object object = UiSession.this.iconLock;
                    synchronized (object) {
                        while (UiSession.this.iconQueue.size() == 0) {
                            UiSession.this.iconLock.wait();
                        }
                        remoteIcon = (RemoteIcon)UiSession.this.iconQueue.remove(0);
                    }
                    object = UiSession.this.open(remoteIcon.href);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] byArray = new byte[1024];
                    while ((n = ((InputStream)object).read(byArray)) >= 0) {
                        byteArrayOutputStream.write(byArray, 0, n);
                    }
                    byte[] byArray2 = byteArrayOutputStream.toByteArray();
                    Image image = Toolkit.getDefaultToolkit().createImage(byArray2);
                    if (image == null) continue;
                    remoteIcon.image = Utils.sync(image);
                    remoteIcon.w = image.getWidth(null);
                    remoteIcon.h = image.getHeight(null);
                    Shell.theShell.repaint();
                }
                catch (Exception exception) {
                    if (!this.alive) break;
                    exception.printStackTrace();
                }
            }
        }
    }

    static class RemoteIcon
    implements Icon {
        int w = 16;
        int h = 16;
        Image image;
        Uri href;

        RemoteIcon(Uri uri, ImageIcon imageIcon) {
            this.href = uri;
            this.image = imageIcon.getImage();
        }

        public int getIconHeight() {
            return this.h;
        }

        public int getIconWidth() {
            return this.w;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.image != null) {
                graphics.drawImage(this.image, n, n2, component);
            }
        }
    }

    static class Ask {
        public String lobby = "";
        public String userName = "admin";
        public String password = "";

        Ask() {
        }
    }
}

