/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import obix.Uri;
import obix.ui.Commands;
import obix.ui.History;
import obix.ui.HyperlinkInfo;
import obix.ui.Locator;
import obix.ui.Pane;
import obix.ui.Tree;
import obix.ui.UiSession;
import obix.ui.Utils;
import obix.ui.View;
import obix.ui.ViewPane;

public class Shell
extends JFrame {
    public final Commands commands = new Commands(this);
    public final Locator locator = new Locator(this);
    public final History history = new History();
    public static Shell theShell;
    String uri;
    ViewPane views;
    HashMap state = new HashMap();
    JLabel status = new JLabel(" ");
    JSplitPane splitter = new JSplitPane(1);
    Tree tree = new Tree(this);

    public Shell() {
        super("Obix Spy");
        this.setIconImage(Utils.img("x16/obix.png"));
        this.enableEvents(64L);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.commands.makeToolBar(), "West");
        jPanel.add((Component)this.locator, "Center");
        this.splitter.setDividerLocation(180);
        this.splitter.setLeftComponent(new JScrollPane(this.tree));
        this.splitter.setRightComponent(new JLabel("content"));
        this.setJMenuBar(this.commands.makeMenuBar());
        this.getContentPane().add((Component)jPanel, "North");
        this.getContentPane().add((Component)this.splitter, "Center");
        this.getContentPane().add((Component)new Pane(this.status, 2), "South");
        new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Shell.this.animate();
            }
        }).start();
    }

    public String uri() {
        return this.uri;
    }

    public View activeView() {
        return this.views.activeView();
    }

    public void hyperlink(String string) {
        this.hyperlink(new HyperlinkInfo(string));
    }

    public void hyperlink(Uri uri) {
        this.hyperlink(new HyperlinkInfo(uri.toString()));
    }

    public void hyperlink(HyperlinkInfo hyperlinkInfo) {
        try {
            hyperlinkInfo.hyperlink(this);
            this.uri = hyperlinkInfo.uriStr;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void refresh() {
        this.hyperlink(this.uri());
    }

    public void status(String string) {
        if (string == null || string.length() == 0) {
            string = " ";
        }
        this.status.setText(string);
    }

    public void animate() {
        if (this.views != null) {
            this.views.activeView().animate();
        }
    }

    void setViewPane(ViewPane viewPane) {
        ViewPane viewPane2 = this.views;
        if (viewPane2 != null) {
            this.splitter.remove(viewPane2);
        }
        if (viewPane2 != null) {
            viewPane.syncFrom(viewPane2);
        }
        this.views = viewPane;
        int n = this.splitter.getDividerLocation();
        this.splitter.setRightComponent(viewPane);
        this.splitter.setDividerLocation(n);
        this.invalidate();
        this.validate();
    }

    public void savePrefs() {
        try {
            Rectangle rectangle = this.getBounds();
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            preferences.putInt("shell.x", rectangle.x);
            preferences.putInt("shell.y", rectangle.y);
            preferences.putInt("shell.w", rectangle.width);
            preferences.putInt("shell.h", rectangle.height);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void loadPrefs() {
        try {
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            int n = preferences.getInt("shell.x", 50);
            int n2 = preferences.getInt("shell.y", 50);
            int n3 = preferences.getInt("shell.w", 500);
            int n4 = preferences.getInt("shell.h", 400);
            this.setBounds(n, n2, n3, n4);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    void sessionCreated(UiSession uiSession) {
        this.tree.sessionCreated(uiSession);
    }

    public void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.commands.exit.invoke();
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray.length > 0 ? stringArray[0] : "spy:splash";
        Utils.initDefaults();
        Shell shell = theShell = new Shell();
        shell.loadPrefs();
        shell.hyperlink(string);
        shell.setVisible(true);
    }
}

