/*
 * Decompiled with CFR 0.152.
 */
package obix.ui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import obix.Obj;

public abstract class Editor
extends JPanel {
    ArrayList listeners = new ArrayList();
    boolean editable = true;
    boolean suppressChanged = false;

    public Editor() {
        super(new BorderLayout());
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final void setEditable(boolean bl) {
        if (this.editable == bl) {
            return;
        }
        this.editable = bl;
        this.doSetEditable(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(Obj obj) {
        this.suppressChanged = true;
        try {
            this.doLoad(obj);
        }
        finally {
            this.suppressChanged = false;
        }
    }

    public final void save(Obj obj) throws Exception {
        this.doSave(obj);
    }

    protected abstract void doSetEditable(boolean var1);

    protected abstract void doLoad(Obj var1);

    protected abstract void doSave(Obj var1) throws Exception;

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void fireChanged() {
        if (this.suppressChanged) {
            return;
        }
        Listener[] listenerArray = this.listeners.toArray(new Listener[this.listeners.size()]);
        for (int i = 0; i < listenerArray.length; ++i) {
            listenerArray[i].changed(this);
        }
    }

    public void registerForChanged(AbstractButton abstractButton) {
        abstractButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Editor.this.fireChanged();
            }
        });
    }

    public void registerForChanged(JTextComponent jTextComponent) {
        jTextComponent.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                Editor.this.fireChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                Editor.this.fireChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                Editor.this.fireChanged();
            }
        });
    }

    public void registerForChanged(JComboBox jComboBox) {
        this.registerForChanged((JTextComponent)jComboBox.getEditor().getEditorComponent());
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Editor.this.fireChanged();
            }
        });
    }

    public static interface Listener {
        public void changed(Editor var1);
    }
}

