/*
 * Decompiled with CFR 0.152.
 */
package obix.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import obix.Contract;
import obix.Obj;
import obix.Ref;
import obix.Uri;
import obix.io.ObixDecoder;
import obix.io.ObixEncoder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Obixc {
    static boolean verbose;
    File destDir;
    String packageName;
    String href;
    PrintWriter out;
    Type[] types;
    ArrayList contractHrefs;
    ArrayList contractClasses;

    public void compile(InputStream inputStream) throws Exception {
        ObixDecoder obixDecoder = new ObixDecoder(inputStream);
        obixDecoder.setUseContracts(false);
        Obj obj = obixDecoder.decodeDocument();
        this.map(obj);
        int n = 0;
        while (n < this.types.length) {
            this.writeInterface(this.types[n]);
            ++n;
        }
        this.writeContractInit();
    }

    public void map(Obj obj) throws Exception {
        ArrayList arrayList = new ArrayList();
        this.map(obj, arrayList);
        this.types = arrayList.toArray(new Type[arrayList.size()]);
        int n = 0;
        while (n < this.types.length) {
            this.mapContracts(this.types[n]);
            ++n;
        }
        n = 0;
        while (n < this.types.length) {
            this.mapChildren(this.types[n]);
            ++n;
        }
        n = 0;
        while (n < this.types.length) {
            this.mapChildren(this.types[n]);
            ++n;
        }
    }

    private final void map(Obj obj, ArrayList arrayList) {
        Uri uri = obj.getHref();
        if (uri != null && !uri.isFragment()) {
            arrayList.add(this.toType(obj));
        }
        Obj[] objArray = obj.list();
        int n = 0;
        while (n < objArray.length) {
            this.map(objArray[n], arrayList);
            ++n;
        }
    }

    private final Type toType(Obj obj) {
        Object object;
        String string = obj.getName();
        if (string == null) {
            object = obj.getHref().toString();
            int n = ((String)object).lastIndexOf(47);
            if (n < 0) {
                n = ((String)object).lastIndexOf(58);
            }
            string = ((String)object).substring(n + 1);
        }
        object = new Type();
        ((Type)object).name = string;
        ((Type)object).proto = obj;
        ((Type)object).href = obj.getHref();
        return object;
    }

    private final void mapContracts(Type type) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        arrayList.add(type);
        Contract contract = type.proto.getIs();
        if (contract == null) {
            contract = new Contract("");
        }
        Uri[] uriArray = contract.list();
        int n = 0;
        while (n < uriArray.length) {
            Type type2 = this.hrefToType(uriArray[n]);
            if (type2 != null) {
                arrayList.add(type2);
            }
            ++n;
        }
        type.contracts = arrayList.toArray(new Type[arrayList.size()]);
    }

    private final void mapChildren(Type type) {
        ArrayList<Child> arrayList = new ArrayList<Child>();
        Obj[] objArray = type.proto.list();
        int n = 0;
        while (n < objArray.length) {
            Obj obj = objArray[n];
            if (obj.getName() != null) {
                arrayList.add(this.mapChild(type, objArray[n]));
            }
            ++n;
        }
        type.children = arrayList.toArray(new Child[arrayList.size()]);
    }

    private final Child mapChild(Type type, Obj obj) {
        Child child = new Child();
        child.parent = type;
        child.name = obj.getName();
        child.obj = obj;
        child.className = this.toClassName(obj, false);
        child.implClassName = this.toClassName(obj, true);
        child.retClassName = child.className;
        return child;
    }

    private final Type hrefToType(Uri uri) {
        int n = 0;
        while (n < this.types.length) {
            if (this.types[n].href.equals(uri)) {
                return this.types[n];
            }
            ++n;
        }
        return null;
    }

    public void writeInterface(Type type) throws Exception {
        String string = type.name;
        this.openFile(string);
        this.wheader("interface", string);
        this.w("  extends IObj");
        int n = 1;
        while (n < type.contracts.length) {
            this.w(", ").w(type.contracts[n].name);
            ++n;
        }
        this.w("\n");
        this.w("{\n").flush();
        n = 0;
        while (n < type.children.length) {
            Child child = type.children[n];
            this.w("\n");
            if (this.needsContractField(child.obj)) {
                this.w("  public static final String ").w(child.name).w("Contract = \"").w(this.toContract(child.obj)).w("\";\n");
            }
            this.w("  public ").w(child.className).w(" ").w(child.name).w("();\n");
            ++n;
        }
        this.w("\n");
        this.w("}\n");
        this.closeFile();
    }

    boolean needsContractField(Obj obj) {
        Obj obj2 = Obj.toObj(obj.getElement());
        obj2.setName(obj.getName());
        String string = this.toContract(obj);
        String string2 = this.toContract(obj2);
        return string.equals(string2) ^ true;
    }

    String toContract(Obj obj) {
        String string = ObixEncoder.toString(obj);
        string = string.replace('\"', '\'');
        string = string.replace('\n', ' ');
        string = string.replace('\r', ' ');
        return string.trim();
    }

    public void writeContractInit() throws Exception {
        String string = "ContractInit";
        this.openFile(string);
        this.wheader("class", string);
        this.w("{\n");
        this.w("\n");
        this.w("  public static void init()\n");
        this.w("  {\n");
        int n = 0;
        while (n < this.types.length) {
            Type type = this.types[n];
            this.w("    ContractRegistry.put(\"").w(type.href.get()).w("\", \"").w(this.packageName).w(".").w(type.name).w("\");\n");
            ++n;
        }
        this.w("  }\n");
        this.w("\n");
        this.w("}\n");
        this.closeFile();
    }

    String toClassName(Obj obj, boolean bl) {
        Type type;
        if (obj instanceof Ref) {
            return "Ref";
        }
        Contract contract = obj.getIs();
        if (contract != null && contract.size() > 0 && (type = this.hrefToType(contract.primary())) != null) {
            return type.name;
        }
        return this.capitalize(obj.getElement());
    }

    String capitalize(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    Obixc w(String string) {
        this.out.print(string);
        return this;
    }

    Obixc wdate() {
        return this.w(new SimpleDateFormat("dd MMM yy").format(new Date()));
    }

    void openFile(String string) throws Exception {
        File file = new File(this.destDir, string + ".java");
        System.out.println("Compile " + string + " -> " + file);
        this.out = new PrintWriter(new FileOutputStream(file));
    }

    void closeFile() throws Exception {
        this.out.flush();
        this.out.close();
    }

    void wheader(String string, String string2) {
        this.w("package ").w(this.packageName).w(";\n");
        this.w("\n");
        this.w("import obix.*;");
        this.w("\n");
        this.w("\n");
        this.w("/**\n");
        this.w(" * ").w(string2).w("\n");
        this.w(" *\n");
        this.w(" * @author    obix.tools.Obixc\n");
        this.w(" * @creation  ").wdate().w("\n");
        this.w(" * @version   $Revision$ $Date$\n");
        this.w(" */\n");
        this.w("public ").w(string).w(" ").w(string2).w("\n");
    }

    Obixc flush() {
        this.out.flush();
        return null;
    }

    Exception err(String string) {
        return new Exception(string);
    }

    public static void usage() {
        System.out.println("usage: obixc <src> <destDir> <package>");
        System.out.println("  Compiles obix prototypes into Java source files");
        System.out.println("Params:");
        System.out.println("  <src>      URI or file name for prototype XML file");
        System.out.println("  <destDir>  Directory to output .java files");
        System.out.println("  <package>  Package name for .java files");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 3) {
            Obixc.usage();
            return;
        }
        String string = stringArray[0];
        File file = new File(stringArray[1]);
        file.mkdirs();
        String string2 = stringArray[2];
        File file2 = new File(string);
        BufferedInputStream bufferedInputStream = file2.exists() ? new BufferedInputStream(new FileInputStream(file2)) : new BufferedInputStream(new URL(string).openStream());
        Obixc obixc = new Obixc(file, string2);
        obixc.compile(bufferedInputStream);
    }

    private final /* synthetic */ void this() {
        this.contractHrefs = new ArrayList();
        this.contractClasses = new ArrayList();
    }

    public Obixc(File file, String string) {
        this.this();
        this.destDir = file;
        this.packageName = string;
    }

    static class Type {
        Obj proto;
        Uri href;
        String name;
        Type[] contracts;
        Child[] children;

        public String toString() {
            return this.name;
        }

        Type() {
        }
    }

    static class Child {
        Type parent;
        String name;
        Obj obj;
        String className;
        String implClassName;
        String retClassName;

        Child() {
        }
    }
}

