/*
 * Decompiled with CFR 0.152.
 */
package obix.test;

import obix.Uri;
import obix.test.Test;

public class UriTest
extends Test {
    public void run() throws Exception {
        this.verifyAbs("http://foo/", "http", "foo", -1, "/");
        this.verifyAbs("http://foo:81/", "http", "foo", 81, "/");
        this.verifyAbs("https://foo/", "https", "foo", -1, "/");
        this.verifyAbs("http://foo.com/", "http", "foo.com", -1, "/");
        this.verifyAbs("http://foo/x", "http", "foo", -1, "/x");
        this.verifyAbs("http://foo/x#f", "http", "foo", -1, "/x", null, "f");
        this.verifyAbs("http://foo/x?q", "http", "foo", -1, "/x", "q", null);
        this.verifyAbs("http://foo/x?q#f", "http", "foo", -1, "/x", "q", "f");
        this.verifyAbs("http://foo/x#f?q", "http", "foo", -1, "/x", null, "f?q");
        this.verifyRel("/", "/", null, null);
        this.verifyRel("/x", "/x", null, null);
        this.verifyRel("", "", null, null);
        this.verifyRel("x", "x", null, null);
        this.verifyRel("/x?q", "/x", "q", null);
        this.verifyRel("x?q", "x", "q", null);
        this.verifyRel("?q", "", "q", null);
        this.verifyRel("#f", "", null, "f");
        this.verifyRel("/x?q#f", "/x", "q", "f");
        this.verifyRel("x?q#f", "x", "q", "f");
        this.verifyRel("?q#f", "", "q", "f");
        this.verifyRel(".", ".", null, null);
        this.verifyRel("..", "..", null, null);
        this.verifyRel("../x", "../x", null, null);
        this.verifyRel("../..", "../..", null, null);
        this.verifyRel("../../x", "../../x", null, null);
        this.verifyNorm("http://foo/", "/", "http://foo/");
        this.verifyNorm("http://foo/", "/x", "http://foo/x");
        this.verifyNorm("http://foo/x", "/y", "http://foo/y");
        this.verifyNorm("http://foo/x", "y", "http://foo/y");
        this.verifyNorm("http://foo/x/", "y", "http://foo/x/y");
        this.verifyNorm("http://foo/x/y", "/z", "http://foo/z");
        this.verifyNorm("http://foo/x/y", "z", "http://foo/x/z");
        this.verifyNorm("http://foo/x/y/", "z", "http://foo/x/y/z");
        this.verifyNorm("http://foo/", "#f", "http://foo/#f");
        this.verifyNorm("http://foo/x", "#f", "http://foo/x#f");
        this.verifyNorm("http://foo/x", "/y#f", "http://foo/y#f");
        this.verifyNorm("http://foo/x", "y#f", "http://foo/y#f");
        this.verifyNorm("http://foo/x/", "y#f", "http://foo/x/y#f");
        this.verifyNorm("http://foo/x/", "..", "http://foo/");
        this.verifyNorm("http://foo/x/y", "..", "http://foo/");
        this.verifyNorm("http://foo/x/y/", "..", "http://foo/x/");
        this.verifyNorm("http://foo/x/y", "../z", "http://foo/z");
        this.verifyNorm("http://foo/x/y/", "../z", "http://foo/x/z");
        this.verifyNorm("http://foo/x/y/", "../..", "http://foo/");
        this.verifyNorm("http://foo/x/y/", "../../z", "http://foo/z");
        this.verifyNorm("http://foo/", "obix:obj", "obix:obj");
        this.verifyAuth("http://foo/", "http://foo/");
        this.verifyAuth("http://foo/file", "http://foo/");
        this.verifyAuth("http://foo/bar#frag", "http://foo/");
        this.verifyAuth("http://foo/bar?query", "http://foo/");
        this.verifyAuth("http://foo:81/", "http://foo:81/");
        this.verifyAuth("http://foo:81/x", "http://foo:81/");
        this.verifyAuth("http://www.acme.com/x", "http://www.acme.com/");
        this.verifyAuth("ftp://www.acme.com/x", "ftp://www.acme.com/");
        this.verify(this.contains("http://foo/", "http://foo/"));
        this.verify(this.contains("http://foo/", "http://foox/") ^ true);
        this.verify(this.contains("http://foo:81/", "http://foo:81/"));
        this.verify(this.contains("http://foo/", "http://foo:81/") ^ true);
        this.verify(this.contains("http://foo/", "http://foo/x"));
        this.verify(this.contains("http://foo/", "http://foo/x#frag"));
        this.verify(this.contains("http://foo/", "http://foo/x/y.txt"));
        this.verify(this.contains("http://foo:81/", "http://foox/x") ^ true);
        this.verify(this.contains("http://foo/", "http://foox/x") ^ true);
        this.verify(this.contains("http://foo/", "http://foo:81/x") ^ true);
        this.verify(this.contains("http://foo/", ""));
        this.verify(this.contains("http://foo/", ".."));
        this.verify(this.contains("http://foo/", "/"));
        this.verify(this.contains("http://foo/", "/x"));
        this.verify(this.contains("http://foo/", "x"));
        this.verify(this.contains("http://foo/", "x#frag"));
        this.verifyParent("http://foo/", null);
        this.verifyParent("http://foo/x", "http://foo/");
        this.verifyParent("http://foo/x/", "http://foo/");
        this.verifyParent("http://foo/x/y", "http://foo/x");
        this.verifyParent("http://foo/x/y/", "http://foo/x");
        this.verifyParent("http://foo/x/y/z?query", "http://foo/x/y");
        this.verifyParent("/foo/x/y/", "/foo/x");
        this.verifyParent("/foo", null);
        this.verifyQuery("k=v", new String[]{"k", "v"});
        this.verifyQuery("a=b&c=d", new String[]{"a", "b", "c", "d"});
        this.verifyQuery("foo=bar&darn=cat&rock=roll", new String[]{"foo", "bar", "darn", "cat", "rock", "roll"});
        this.verifyQuery("v", new String[]{"v", "true"});
        this.verifyQuery("v=false", new String[]{"v", "false"});
        this.verifyQuery("a&b=false&c", new String[]{"a", "true", "b", "false", "c", "true"});
        this.verifyAddQuery("http://foo/", "v", "true", "http://foo/?v=true");
        this.verifyAddQuery("http://foo/obix", "v", "true", "http://foo/obix?v=true");
        this.verifyAddQuery("http://foo/obix?a=b", "v", "true", "http://foo/obix?a=b&v=true");
        this.verifyAddQuery("http://foo/obix?a=b&c", "v", "true", "http://foo/obix?a=b&c=true&v=true");
        this.verifyAddQuery("http://foo/obix?v=false", "v", "true", "http://foo/obix?v=true");
        this.verifyAddQuery("http://foo/obix?v", "v", "foo", "http://foo/obix?v=foo");
        this.verifyAddQuery("http://foo/obix?a=b&v=x", "v", "foo", "http://foo/obix?a=b&v=foo");
        this.verifyAddQuery("http://foo/obix?v=x&a=b", "v", "foo", "http://foo/obix?v=foo&a=b");
        this.verifyAddQuery("http://foo/obix", "v", null, "http://foo/obix");
        this.verifyAddQuery("http://foo/obix?v=x", "v", null, "http://foo/obix");
        this.verifyAddQuery("http://foo/obix?a=b", "v", null, "http://foo/obix?a=b");
        this.verifyAddQuery("http://foo/obix?a=b&v=x", "v", null, "http://foo/obix?a=b");
        this.verifyAddQuery("http://foo/obix?v=x&a=b", "v", null, "http://foo/obix?a=b");
    }

    public void verifyAbs(String string, String string2, String string3, int n, String string4) throws Exception {
        this.verifyAbs(string, string2, string3, n, string4, null, null);
    }

    public void verifyAbs(String string, String string2, String string3, int n, String string4, String string5, String string6) throws Exception {
        Uri uri = new Uri(string);
        this.verify(uri.isAbsolute());
        this.verify(uri.isRelative() ^ true);
        this.verify(uri.getScheme().equals(string2));
        this.verify(uri.getHost().equals(string3));
        boolean bl = false;
        if (uri.getPort() == n) {
            bl = true;
        }
        this.verify(bl);
        if (n == -1) {
            this.verify(uri.getAddress().equals(string3));
        } else {
            this.verify(uri.getAddress().equals(string3 + ':' + n));
        }
        this.verify(uri.getPath().equals(string4));
        Uri.Query query = uri.getQuery();
        if (query == null) {
            boolean bl2 = false;
            if (string5 == null) {
                bl2 = true;
            }
            this.verify(bl2);
        } else {
            this.verify(query.toString(), (Object)string5);
        }
        this.verify(uri.getFragment(), (Object)string6);
    }

    public void verifyRel(String string, String string2, String string3, String string4) throws Exception {
        Uri uri = new Uri(string);
        this.verify(uri.isAbsolute() ^ true);
        this.verify(uri.isRelative());
        boolean bl = false;
        if (uri.getScheme() == null) {
            bl = true;
        }
        this.verify(bl);
        boolean bl2 = false;
        if (uri.getHost() == null) {
            bl2 = true;
        }
        this.verify(bl2);
        boolean bl3 = false;
        if (uri.getPort() == -1) {
            bl3 = true;
        }
        this.verify(bl3);
        boolean bl4 = false;
        if (uri.getAuthority() == null) {
            bl4 = true;
        }
        this.verify(bl4);
        this.verify(uri.getPath().equals(string2));
        Uri.Query query = uri.getQuery();
        if (query == null) {
            boolean bl5 = false;
            if (string3 == null) {
                bl5 = true;
            }
            this.verify(bl5);
        } else {
            this.verify(query.toString(), (Object)string3);
        }
        this.verify(uri.getFragment(), (Object)string4);
    }

    public void verifyNorm(String string, String string2, String string3) throws Exception {
        Uri uri = new Uri(string2).normalize(new Uri(string));
        this.verify(uri.toString().equals(string3));
    }

    public void verifyAuth(String string, String string2) throws Exception {
        Uri uri = new Uri(string);
        Uri uri2 = uri.getAuthorityUri();
        this.verify(uri.getAuthority().equals(string2));
        this.verify(uri2.toString().equals(string2));
    }

    public boolean contains(String string, String string2) {
        return new Uri(string).contains(new Uri(string2));
    }

    public void verifyParent(String string, String string2) {
        Uri uri = new Uri(string).parent();
        if (uri == null) {
            boolean bl = false;
            if (string2 == null) {
                bl = true;
            }
            this.verify(bl);
        } else {
            this.verify(uri.toString().equals(string2));
        }
    }

    public void verifyQuery(String string, String[] stringArray) {
        Uri.Query query = new Uri("http://foo/?" + string).getQuery();
        this.verify(query.toString().equals(string));
        String[] stringArray2 = query.keys();
        boolean bl = false;
        if (stringArray2.length == stringArray.length / 2) {
            bl = true;
        }
        this.verify(bl);
        int n = 0;
        while (n < stringArray2.length) {
            String string2 = stringArray2[n];
            this.verify(string2.equals(stringArray[n * 2]));
            this.verify(query.get(string2, null).equals(stringArray[n * 2 + 1]));
            ++n;
        }
    }

    public void verifyAddQuery(String string, String string2, String string3, String string4) {
        Uri uri = new Uri(string).addQueryParam(string2, string3);
        this.verify(uri.toString().equals(string4));
    }
}

