/*
 * Decompiled with CFR 0.152.
 */
package obix.test;

import obix.Reltime;
import obix.test.Test;

public class ReltimeTest
extends Test {
    public static final long S = 1000L;
    public static final long M = 60000L;
    public static final long H = 3600000L;
    public static final long D = 86400000L;

    public void run() throws Exception {
        this.verify("P0D", 0L);
        this.verify("P2D", 172800000L);
        this.verify("-P2D", -172800000L);
        this.verify("P12D", 1036800000L);
        this.verify("-P12D", -1036800000L);
        this.verify("+P5432D", 469324800000L);
        this.verify("-P5432D", -469324800000L);
        this.verify("PT0H", 0L);
        this.verify("PT2H", 0x6DDD00L);
        this.verify("-PT2H", -7200000L);
        this.verify("PT12H", 43200000L);
        this.verify("-PT12H", -43200000L);
        this.verify("+PT5432H", 19555200000L);
        this.verify("-PT5432H", -19555200000L);
        this.verify("PT0M", 0L);
        this.verify("PT2M", 120000L);
        this.verify("-PT2M", -120000L);
        this.verify("PT12M", 720000L);
        this.verify("-PT12M", -720000L);
        this.verify("+PT5432M", 325920000L);
        this.verify("-PT5432M", -325920000L);
        this.verify("PT0S", 0L);
        this.verify("PT2S", 2000L);
        this.verify("-PT2S", -2000L);
        this.verify("PT12S", 12000L);
        this.verify("-PT12S", -12000L);
        this.verify("+PT5432S", 5432000L);
        this.verify("-PT5432S", -5432000L);
        this.verify("PT1.2S", 1200L);
        this.verify("PT1.23S", 1230L);
        this.verify("PT1.234S", 1234L);
        this.verify("PT1.2345S", 1234L);
        this.verify("PT1.23456S", 1234L);
        this.verify("P1DT2H3M4.5S", 93784500L);
        this.verify("-P1DT2H3M4.5S", -93784500L);
        this.verifyInvalid("P");
        this.verifyInvalid("P2Y");
        this.verifyInvalid("P2M");
        this.verifyInvalid("P3H");
        this.verifyInvalid("P3M");
        this.verifyInvalid("P4S");
        this.verifyInvalid("PH");
        this.verifyInvalid("PxH");
        this.verifyInvalid("P2Dx");
    }

    public void verify(String string, long l) throws Exception {
        Reltime reltime = new Reltime();
        reltime.decodeVal(string);
        boolean bl = false;
        if (reltime.getMillis() == l) {
            bl = true;
        }
        this.verify(bl);
        Reltime reltime2 = new Reltime();
        reltime2.decodeVal(reltime.encodeVal());
        this.verify(reltime2.equals(reltime));
        boolean bl2 = false;
        if (reltime2.getMillis() == l) {
            bl2 = true;
        }
        this.verify(bl2);
    }

    public void verifyInvalid(String string) throws Exception {
        Exception exception = null;
        Reltime reltime = new Reltime();
        try {
            reltime.decodeVal(string);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        boolean bl = false;
        if (exception != null) {
            bl = true;
        }
        this.verify(bl);
    }
}

