/*
 * Decompiled with CFR 0.152.
 */
package obix.test;

import obix.Date;
import obix.test.Test;

public class DateTest
extends Test {
    public void run() throws Exception {
        Date date = new Date(2009, 10, 21);
        this.verify(date.getYear(), 2009L);
        this.verify(date.getMonth(), 10L);
        this.verify(date.getDay(), 21L);
        this.verify(date.equals(new Date(2009, 10, 21)));
        this.verify(date.equals(new Date(2009, 10, 22)) ^ true);
        this.verify(date.equals(new Date(2009, 11, 21)) ^ true);
        this.verify(date.equals(new Date(2010, 10, 21)) ^ true);
        boolean bl = false;
        if (new Date(2009, 2, 3).compareTo(new Date(2009, 2, 3)) == 0) {
            bl = true;
        }
        this.verify(bl);
        boolean bl2 = false;
        if (new Date(2008, 2, 3).compareTo(new Date(2009, 2, 3)) < 0) {
            bl2 = true;
        }
        this.verify(bl2);
        boolean bl3 = false;
        if (new Date(2019, 2, 3).compareTo(new Date(2009, 2, 3)) > 0) {
            bl3 = true;
        }
        this.verify(bl3);
        boolean bl4 = false;
        if (new Date(2009, 12, 3).compareTo(new Date(2009, 2, 3)) > 0) {
            bl4 = true;
        }
        this.verify(bl4);
        boolean bl5 = false;
        if (new Date(2009, 2, 3).compareTo(new Date(2009, 2, 8)) < 0) {
            bl5 = true;
        }
        this.verify(bl5);
        this.verify("2009-10-21", 2009, 10, 21);
        this.verify("2000-01-02", 2000, 1, 2);
        this.verify("1972-06-30", 1972, 6, 30);
        this.verifyInvalid("2009-10-2");
        this.verifyInvalid("2009-1-21");
        this.verifyInvalid("2009.10-21");
        this.verifyInvalid("2009-10.21");
    }

    public void verify(String string, int n, int n2, int n3) throws Exception {
        Date date = new Date();
        date.decodeVal(string);
        boolean bl = false;
        if (date.getYear() == n) {
            bl = true;
        }
        this.verify(bl);
        boolean bl2 = false;
        if (date.getMonth() == n2) {
            bl2 = true;
        }
        this.verify(bl2);
        boolean bl3 = false;
        if (date.getDay() == n3) {
            bl3 = true;
        }
        this.verify(bl3);
        this.verify(date, new Date(n, n2, n3));
        Date date2 = new Date();
        date2.decodeVal(date.encodeVal());
        this.verify(date2, date);
    }

    public void verifyInvalid(String string) throws Exception {
        Exception exception = null;
        Date date = new Date();
        try {
            date.decodeVal(string);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        boolean bl = false;
        if (exception != null) {
            bl = true;
        }
        this.verify(bl);
    }
}

