/*
 * Decompiled with CFR 0.152.
 */
package obix.net;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.HashMap;
import javax.net.ssl.HttpsURLConnection;
import obix.Err;
import obix.Obj;
import obix.Op;
import obix.Uri;
import obix.io.Base64;
import obix.io.ObixDecoder;
import obix.io.ObixEncoder;
import obix.net.BatchIn;
import obix.net.ErrException;
import obix.net.HttpConnection;
import obix.net.SessionWatch;
import obix.net.WatchListener;

public class ObixSession {
    Uri authority;
    Uri lobbyUri;
    Uri batchUri;
    Obj lobby;
    Obj about;
    Obj watchService;
    String username;
    String password;
    String authHeader;
    HashMap watches = new HashMap();
    boolean testHttps = true;
    boolean useHttpURLConnection = true;
    boolean canSetConnectTimeout = true;
    boolean canSetReadTimeout = true;
    int timeout = 15000;
    static /* synthetic */ Class class$java$net$URLConnection;

    public ObixSession(Uri uri, String string, String string2) {
        this.authority = uri.getAuthorityUri();
        this.lobbyUri = uri;
        this.username = string;
        this.password = string2;
        this.authHeader = "Basic " + Base64.encode(string + ":" + string2);
    }

    public ObixSession(Uri uri, String string, String string2, int n) {
        this.authority = uri.getAuthorityUri();
        this.lobbyUri = uri;
        this.username = string;
        this.password = string2;
        this.authHeader = "Basic " + Base64.encode(string + ":" + string2);
        this.timeout = n;
    }

    public Uri getAuthority() {
        return this.authority;
    }

    public boolean contains(Uri uri) {
        return this.authority.contains(uri);
    }

    public Uri getLobbyUri() {
        return this.lobbyUri;
    }

    public Obj getLobby() {
        if (this.lobby == null) {
            throw new IllegalStateException("Session not open");
        }
        return this.lobby;
    }

    public String getUsername() {
        return this.username;
    }

    public String toString() {
        return this.authority.toString();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void open() throws Exception {
        Obj obj;
        this.lobby = this.read(this.lobbyUri);
        this.batchUri = this.lobby.get("batch").getNormalizedHref();
        Obj obj2 = this.lobby.get("about");
        if (obj2 != null && obj2.getHref() != null) {
            this.about = this.read(obj2.getNormalizedHref());
        }
        if ((obj = this.lobby.get("watchService")) != null && obj.getHref() != null) {
            this.watchService = this.read(obj.getNormalizedHref());
        }
    }

    public void close() {
    }

    public Obj ping() throws Exception {
        return this.read(this.about.getNormalizedHref());
    }

    public Obj read(Uri uri) throws Exception {
        return new ObixDecoder(this.open(uri)).decodeDocument();
    }

    public Obj write(Obj obj) throws Exception {
        Uri uri = obj.getNormalizedHref();
        if (uri == null) {
            throw new Exception("obj.href is null");
        }
        return this.send(uri, "PUT", obj);
    }

    public Obj invoke(Op op, Obj obj) throws Exception {
        Uri uri = op.getNormalizedHref();
        if (uri == null) {
            throw new Exception("op.href is null");
        }
        return this.invoke(uri, obj);
    }

    public Obj invoke(Uri uri, Obj obj) throws Exception {
        if (obj == null) {
            obj = new Obj();
            obj.setNull(true);
        }
        return this.send(uri, "POST", obj);
    }

    public BatchIn makeBatch() throws Exception {
        if (this.batchUri == null) {
            throw new Exception("Lobby missing batch op");
        }
        return new BatchIn(this);
    }

    public InputStream open(Uri uri) throws Exception {
        if (this.useHttpURLConnection) {
            HttpURLConnection httpURLConnection = this.setupHttpURLConnection(uri, null);
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            if (n / 100 > 2) {
                throw new IOException("HTTP connection failed resp code=" + n);
            }
            return httpURLConnection.getInputStream();
        }
        HttpConnection httpConnection = this.setupHttpConnection(uri);
        httpConnection.connect();
        int n = httpConnection.getStatusCode();
        if (n / 100 > 2) {
            throw new IOException("HTTP connection failed resp code=" + n);
        }
        return httpConnection.getInputStream();
    }

    public SessionWatch[] getWatches() {
        return this.watches.values().toArray(new SessionWatch[this.watches.size()]);
    }

    public SessionWatch getWatch(String string) {
        return (SessionWatch)this.watches.get(string);
    }

    public SessionWatch makeWatch(String string, long l) throws Exception {
        return this.makeWatch(string, l, null);
    }

    public SessionWatch makeWatch(String string, long l, WatchListener watchListener) throws Exception {
        if (this.watches.get(string) != null) {
            throw new IllegalArgumentException("Duplicate watch name: " + string);
        }
        SessionWatch sessionWatch = SessionWatch.make(this, string, l);
        this.watches.put(string, sessionWatch);
        if (watchListener != null) {
            sessionWatch.addListener(watchListener);
        }
        return sessionWatch;
    }

    private boolean setTimeout(URLConnection uRLConnection, String string, int n) {
        try {
            Class<?> clazz = uRLConnection.getClass();
            Method method = clazz.getMethod("set" + string + "Timeout", Integer.TYPE);
            method.invoke((Object)uRLConnection, new Integer(n));
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    protected HttpURLConnection setupHttpURLConnection(Uri uri, String string) throws Exception {
        Uri uri2 = uri.normalize(this.lobbyUri);
        if (!this.contains(uri2)) {
            throw new IllegalArgumentException("Uri not contained by this session: " + uri2);
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)uri2.toURL().openConnection();
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setRequestProperty("Authorization", this.authHeader);
        if (this.canSetConnectTimeout) {
            this.canSetConnectTimeout = this.setTimeout(httpURLConnection, "Connect", this.timeout);
        }
        if (this.canSetReadTimeout) {
            this.canSetReadTimeout = this.setTimeout(httpURLConnection, "Read", this.timeout);
        }
        if (string != null && !string.equalsIgnoreCase("GET")) {
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestMethod(string);
            httpURLConnection.setRequestProperty("Content-Type", "text/xml");
        }
        if (this.testHttps) {
            this.testHttps = false;
            try {
                if (httpURLConnection instanceof HttpsURLConnection) {
                    Class<?> clazz = Class.forName("obix.net.AnonymousVerifier");
                    Constructor<?> constructor = clazz.getConstructor(class$java$net$URLConnection == null ? (class$java$net$URLConnection = ObixSession.class$("java.net.URLConnection")) : class$java$net$URLConnection);
                    constructor.newInstance(httpURLConnection);
                }
                this.testHttps = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return httpURLConnection;
    }

    protected HttpConnection setupHttpConnection(Uri uri) throws Exception {
        Uri uri2 = uri.normalize(this.lobbyUri);
        if (!this.contains(uri2)) {
            throw new IllegalArgumentException("Uri not contained by this session: " + uri2);
        }
        String string = uri.get();
        string = string.substring(string.indexOf(uri.getPath()));
        HttpConnection httpConnection = new HttpConnection(uri.getHost(), uri.getPort(), string);
        httpConnection.setFollowRedirects(false);
        httpConnection.setRequestHeader("Authorization", this.authHeader);
        httpConnection.setTimeout(this.timeout);
        return httpConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Obj send(Uri uri, String string, Obj obj) throws Exception {
        if (this.useHttpURLConnection) {
            HttpURLConnection httpURLConnection = this.setupHttpURLConnection(uri, string);
            httpURLConnection.connect();
            OutputStream outputStream = httpURLConnection.getOutputStream();
            try {
                new ObixEncoder(outputStream).encodeDocument(obj);
                outputStream.flush();
                int n = httpURLConnection.getResponseCode();
                if (n / 200 != 1) {
                    throw new Exception("Invalid response code " + n);
                }
                InputStream inputStream = httpURLConnection.getInputStream();
                Obj obj2 = new ObixDecoder(inputStream).decodeDocument();
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (obj2 instanceof Err) {
                    throw new ErrException((Err)obj2);
                }
                if (obj2.getHref() == null) {
                    obj2.setHref(this.authority);
                }
                Obj obj3 = obj2;
                return obj3;
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        OutputStream outputStream = null;
        int n = -1;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new ObixEncoder(byteArrayOutputStream).encodeDocument(obj);
            HttpConnection httpConnection = this.setupHttpConnection(uri);
            n = string.equalsIgnoreCase("PUT") ? httpConnection.put(uri.get(), "text/xml", byteArrayOutputStream.toByteArray()) : httpConnection.post(uri.get(), "text/xml", byteArrayOutputStream.toByteArray());
            if (n / 200 != 1) {
                throw new Exception("Invalid response code " + n);
            }
            InputStream inputStream = httpConnection.getInputStream();
            Obj obj4 = new ObixDecoder(inputStream).decodeDocument();
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (obj4 instanceof Err) {
                throw new ErrException((Err)obj4);
            }
            if (obj4.getHref() == null) {
                obj4.setHref(this.authority);
            }
            Obj obj5 = obj4;
            return obj5;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 3) {
            System.out.println("usage: ObixSession <addr> <user> <pass>");
            System.out.println("  Iterative utility to read and dump obix objects");
            System.out.println("Params:");
            System.out.println("  <addr>   URL of the obix server's lobby object");
            System.out.println("  <user>   Username to use for HTTP basic authentication");
            System.out.println("  <pass>   Password to use for HTTP basic authentication");
            return;
        }
        Uri uri = new Uri(stringArray[0]);
        String string = stringArray[1];
        String string2 = stringArray[2];
        ObixSession obixSession = new ObixSession(uri, string, string2);
        Obj obj = ObixSession.dumpObj(obixSession, uri);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.println();
            System.out.print("" + obj.getHref().get() + "> ");
            String string3 = bufferedReader.readLine().trim();
            if (string3.equals("")) continue;
            if (string3.equals("quit") || string3.equals("bye")) break;
            Uri uri2 = new Uri(string3).normalize(obj.getHref());
            try {
                obj = ObixSession.dumpObj(obixSession, uri2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static void dumpContent(ObixSession obixSession, Uri uri) throws Exception {
        int n;
        InputStream inputStream = obixSession.open(uri);
        while ((n = inputStream.read()) >= 0) {
            System.out.print((char)n);
        }
        System.out.println();
    }

    static Obj dumpObj(ObixSession obixSession, Uri uri) throws Exception {
        System.out.println("-- Read [" + uri + "]");
        long l = System.currentTimeMillis();
        Obj obj = obixSession.read(uri);
        long l2 = System.currentTimeMillis();
        ObixEncoder.dump(obj);
        System.out.println("-- Success [Read " + (l2 - l) + "ms]");
        return obj;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

