/*
 * Decompiled with CFR 0.152.
 */
package obix.net;

import java.io.IOException;
import java.io.InputStream;
import obix.net.HttpHeader;

public class ChunkedInputStream
extends InputStream {
    private InputStream in;
    private byte[] chunk;
    private int chunkOffset;
    private HttpHeader entityHeaders;

    public ChunkedInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public int read() throws IOException {
        return this.chunkRead();
    }

    protected int chunkRead() throws IOException {
        if (this.chunk == null) {
            StringBuffer stringBuffer = new StringBuffer(8);
            int n = this.in.read();
            while (n != -1 && n != 13 && n != 32) {
                stringBuffer.append((char)n);
                n = this.in.read();
            }
            while (n == 32) {
                n = this.in.read();
            }
            n = this.match(n, 13);
            this.check(n, 10);
            int n2 = Integer.parseInt(stringBuffer.toString(), 16);
            this.chunk = new byte[n2];
            this.chunkOffset = 0;
            if (n2 != 0) {
                int n3 = 0;
                int n4 = 0;
                do {
                    if ((n4 = this.in.read(this.chunk, n3, this.chunk.length - n3)) == -1) continue;
                    n3 += n4;
                } while (n4 != -1 && n3 < this.chunk.length);
                n = this.in.read();
                n = this.match(n, 13);
                this.check(n, 10);
            } else {
                this.readFooter();
            }
        }
        if (this.chunkOffset == this.chunk.length) {
            return -1;
        }
        byte by = this.chunk[this.chunkOffset++];
        if (this.chunk.length != 0 && this.chunkOffset == this.chunk.length) {
            this.chunk = null;
        }
        return by;
    }

    protected void readFooter() throws IOException {
        this.entityHeaders = new HttpHeader();
        this.entityHeaders.read(this.in);
    }

    protected int match(int n, int n2) throws IOException {
        if (n != n2) {
            throw new IOException("Expecting " + this.charToString(n2) + ".");
        }
        return this.in.read();
    }

    protected void check(int n, int n2) throws IOException {
        if (n != n2) {
            throw new IOException("Expecting " + this.charToString(n2) + ".");
        }
    }

    private String charToString(int n) {
        if (n == 13) {
            return "\\n";
        }
        if (n == 10) {
            return "\\r";
        }
        return "" + (char)n;
    }

    public HttpHeader getEntityHeaders() {
        return this.entityHeaders;
    }
}

